/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jfig.gui.JStateButton;
import jfig.gui.StatusMessage;
import jfig.utils.MouseMapper;
import jfig.utils.SetupManager;

public class JNumericStateButton
extends JStateButton
implements MouseListener {
    int minValue = 0;
    int maxValue = 1000;
    int[] steps = null;
    Font labelFont = null;
    SelectValueDialog selectDialog;

    public void setState(int n) {
        if (n < this.minValue) {
            n = this.minValue;
        }
        if (n > this.maxValue) {
            n = this.maxValue;
        }
        this.state = n;
        this.repaint();
    }

    public void setMinValue(int n) {
        this.minValue = n;
    }

    public void setMaxValue(int n) {
        this.maxValue = n;
    }

    public void setSteps(int[] nArray) {
        this.steps = nArray;
        this.setMinValue(nArray[0]);
        this.setMaxValue(nArray[nArray.length - 1]);
    }

    public void incrementStepValue() {
        if (this.steps == null) {
            if (this.state < this.maxValue) {
                ++this.state;
            }
        } else {
            int n = 0;
            while (n < this.steps.length && this.state >= this.steps[n]) {
                ++n;
            }
            this.state = n < this.steps.length ? this.steps[n] : this.steps[0];
        }
    }

    public void decrementStepValue() {
        if (this.steps == null) {
            if (this.state > this.minValue) {
                --this.state;
            }
        } else {
            int n = this.steps.length - 1;
            while (n >= 0 && this.state <= this.steps[n]) {
                --n;
            }
            this.state = n >= 0 ? this.steps[n] : this.steps[this.steps.length - 1];
        }
    }

    public void calculateSize() {
        this.width = 50;
        this.height = 22;
        this.setSize(new Dimension(this.width, this.height));
    }

    public Dialog getDialog() {
        return this.selectDialog;
    }

    public void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.width, this.height);
        if (this.mouseInside) {
            graphics.draw3DRect(0, 0, this.width - 1, this.height - 1, true);
        } else {
            graphics.drawRect(0, 0, this.width - 1, this.height - 1);
        }
        int n = 5;
        graphics.setColor(Color.black);
        graphics.setFont(this.labelFont);
        graphics.drawString("" + this.state, 10, 17);
        if (this.updateMode) {
            if (this.updateStatus) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(1, 1, n + 1, this.height - 2);
                graphics.setColor(Color.black);
                graphics.fillRect(1, 1, n + 1, n + 1);
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(1, 1, n + 1, this.height - 2);
                graphics.setColor(Color.black);
                graphics.drawRect(1, 1, n, n);
            }
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(1, 1, n + 1, this.height - 2);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (MouseMapper.isMiddleClick(mouseEvent)) {
            this.decrementStepValue();
            this.createActionEvent();
            this.repaint();
        } else if (MouseMapper.isRightClick(mouseEvent)) {
            this.incrementStepValue();
            this.createActionEvent();
            this.repaint();
        } else if (this.updateMode && mouseEvent.getX() <= 7) {
            this.updateStatus = !this.updateStatus;
            this.repaint();
        } else {
            if (this.selectDialog == null) {
                JNumericStateButton jNumericStateButton = this;
                if (jNumericStateButton == null) {
                    throw null;
                }
                this.selectDialog = jNumericStateButton.new SelectValueDialog(this.findParentFrame());
                this.selectDialog.setModal(true);
            }
            this.selectDialog.pack();
            this.selectDialog.setLocation(Math.max(0, this.getLocationOnScreen().x - 50), Math.max(0, this.getLocationOnScreen().y - this.selectDialog.getBounds().height));
            this.disableToolTip();
            this.selectDialog.setVisible(true);
        }
    }

    public String toString() {
        String string = "JNumericStateButton" + this.helpMessage;
        return string;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JNumericStateButton selftest");
        jFrame.setSize(300, 100);
        jFrame.show();
        JNumericStateButton jNumericStateButton = new JNumericStateButton((Component)jFrame, "Set layer", null, "Select layer");
        int[] nArray = new int[]{5, 6, 8, 9, 10, 11, 12, 14, 15, 17, 18, 20, 22, 24, 27, 30, 35, 40, 50, 60, 70};
        jNumericStateButton.setSteps(nArray);
        JNumericStateButton jNumericStateButton2 = new JNumericStateButton((Component)jFrame, "Set font size", null, "Set font size");
        jNumericStateButton2.setMinValue(-2);
        jNumericStateButton2.setMaxValue(13);
        jFrame.getContentPane().add("Center", jNumericStateButton);
        jFrame.getContentPane().add("South", jNumericStateButton2);
        jFrame.pack();
    }

    public JNumericStateButton(Component component, String string, StatusMessage statusMessage, String string2) {
        super(component, string, null, null, statusMessage, string2);
        this.calculateSize();
        this.setToolTipText(string2);
        this.state = 0;
        try {
            String string3 = "jfig.gui.JNumericStateButton";
            String string4 = SetupManager.getProperty(string3 + ".FontName", "SansSerif");
            int n = SetupManager.getInteger(string3 + ".FontSize", 11);
            this.labelFont = new Font(string4, 0, n);
        }
        catch (Throwable throwable) {
            this.labelFont = new Font("SansSerif", 0, 11);
        }
    }

    class SelectValueDialog
    extends JDialog
    implements ActionListener {
        private JButton cancelButton = new JButton("Cancel");
        private JButton okButton;
        private JTextField valueField;
        private JPanel ibuttonPanel;
        private JPanel buttonPanel;

        public void setVisible(boolean bl) {
            this.valueField.setText("" + JNumericStateButton.this.state);
            super.setVisible(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("Cancel".equals(string)) {
                this.setVisible(false);
                JNumericStateButton.this.reEnableToolTip();
                JNumericStateButton.this.repaint();
            } else {
                String string2 = this.valueField.getText().trim();
                try {
                    JNumericStateButton.this.state = Integer.parseInt(string2);
                    if (JNumericStateButton.this.state > JNumericStateButton.this.maxValue) {
                        JNumericStateButton.this.state = JNumericStateButton.this.maxValue;
                    }
                    if (JNumericStateButton.this.state < JNumericStateButton.this.minValue) {
                        JNumericStateButton.this.state = JNumericStateButton.this.minValue;
                    }
                    this.setVisible(false);
                    JNumericStateButton.this.reEnableToolTip();
                    JNumericStateButton.this.repaint();
                }
                catch (Exception exception) {
                    System.err.println("-E- SelectValueDialog: invalid value: " + string2);
                }
            }
        }

        public SelectValueDialog(Frame frame) {
            super(frame, "Select value:");
            this.cancelButton.addActionListener(this);
            this.okButton = new JButton("Set");
            this.okButton.addActionListener(this);
            this.buttonPanel = new JPanel(new FlowLayout(1));
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(this.okButton);
            JLabel jLabel = new JLabel(JNumericStateButton.this.getLabel());
            this.valueField = new JTextField("" + JNumericStateButton.this.state, 5);
            this.valueField.addActionListener(this);
            this.ibuttonPanel = new JPanel(new FlowLayout(1));
            this.ibuttonPanel.add(jLabel);
            this.ibuttonPanel.add(this.valueField);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", this.ibuttonPanel);
            this.getContentPane().add("South", this.buttonPanel);
            this.pack();
        }
    }
}

