/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigCanvasListener;
import jfig.canvas.FigDrawable;
import jfig.canvas.FigDrawableEnumerator;
import jfig.canvas.FigSwingCanvas;
import jfig.canvas.FigTrafo2D;
import jfig.commands.AlignObjectsCommand;
import jfig.commands.BreakCompoundCommand;
import jfig.commands.Command;
import jfig.commands.ConvertObjectCommand;
import jfig.commands.CopyObjectCommand;
import jfig.commands.CopyToClipboardCommand;
import jfig.commands.CreateArcCommand;
import jfig.commands.CreateBezierCommand;
import jfig.commands.CreateBulletCommand;
import jfig.commands.CreateCircleCommand;
import jfig.commands.CreateClosedBezierCommand;
import jfig.commands.CreateClosedSplineCommand;
import jfig.commands.CreateCompoundCommand;
import jfig.commands.CreateDimensioningCommand;
import jfig.commands.CreateEllipseCommand;
import jfig.commands.CreatePolygonCommand;
import jfig.commands.CreatePolylineCommand;
import jfig.commands.CreateRectangleCommand;
import jfig.commands.CreateRoundedRectangleCommand;
import jfig.commands.CreateSplineCommand;
import jfig.commands.CreateTextCommand;
import jfig.commands.CreateTriggerCommand;
import jfig.commands.CutPointCommand;
import jfig.commands.CutToClipboardCommand;
import jfig.commands.DeleteObjectCommand;
import jfig.commands.EditCommentCommand;
import jfig.commands.FigBasicEditor;
import jfig.commands.InsertPointCommand;
import jfig.commands.JCreateImageCommand;
import jfig.commands.JEditObjectCommand;
import jfig.commands.JOpenCompoundCommand;
import jfig.commands.JoinSplitLinesCommand;
import jfig.commands.MirrorXCommand;
import jfig.commands.MirrorYCommand;
import jfig.commands.MoveObjectCommand;
import jfig.commands.MovePointCommand;
import jfig.commands.PasteFromClipboardCommand;
import jfig.commands.ResizeTextCommand;
import jfig.commands.RotateObjectCommand;
import jfig.commands.ScaleObjectCommand;
import jfig.commands.SelectLibraryObjectCommand;
import jfig.commands.SnapToGridCommand;
import jfig.commands.UndoStack;
import jfig.commands.UpdateCommand;
import jfig.commands.ZoomRegionCommand;
import jfig.gui.ColorCache;
import jfig.gui.ImageHelper;
import jfig.gui.JAboutDialog;
import jfig.gui.JAttribsButtonPanel;
import jfig.gui.JConfirmDialog;
import jfig.gui.JConsole;
import jfig.gui.JEditGlobalAttributesDialog;
import jfig.gui.JEditorMenuBar;
import jfig.gui.JEditorStatusPanel;
import jfig.gui.JExportOptionsDialog;
import jfig.gui.JFigFileFilter;
import jfig.gui.JFontConfigurationDialog;
import jfig.gui.JLayerManager;
import jfig.gui.JModeButtonPanel;
import jfig.gui.JPdfExportOptionsDialog;
import jfig.gui.JPropertiesViewer;
import jfig.gui.JStringDialog;
import jfig.gui.JTextViewer;
import jfig.gui.JTextViewerDialog;
import jfig.gui.KeyHandler;
import jfig.gui.ModularEditorState;
import jfig.gui.PrintManager;
import jfig.gui.StatusMessage;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;
import jfig.objects.FigGlobalAttributes;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;
import jfig.objects.FigParser;
import jfig.objects.FigPolyline;
import jfig.objects.FigText;
import jfig.objects.FigTrigger;
import jfig.objects.FigWriter;
import jfig.objects.ListNode;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;
import jfig.utils.JRecentFileManager;
import jfig.utils.MouseMapper;
import jfig.utils.RegistrationKeyManager;
import jfig.utils.SetupManager;
import jfig.utils.ShellSort;

public class JModularEditor
implements FigBasicEditor,
FigDrawableEnumerator,
FigCanvasListener,
KeyListener,
ItemListener,
ActionListener {
    private static boolean debug = false;
    private static boolean enableWindowsWorkarounds = false;
    private static boolean enableSolarisWorkarounds = false;
    private static boolean enableLinuxWorkarounds = false;
    private static boolean enableNetscapeWorkarounds = false;
    private static String[][] _callbackArray = new String[][]{{"Cancel", "doCancel"}, {"Undo", "doUndo"}, {"Redo", "doRedo"}, {"Flush undo stack", "doFlushUndoStack"}, {"Redraw", "doRedraw"}, {"Show properties", "doShowProperties"}, {"Show messages", "doShowMessages"}, {"Delete all objects", "doDeleteAll"}, {"Circle", "doCreateCircle"}, {"Ellipse", "doCreateEllipse"}, {"Rectangle", "doCreateRectangle"}, {"roundRect", "doCreateRoundRectangle"}, {"Polyline", "doCreatePolyline"}, {"Polygon", "doCreatePolygon"}, {"Bezier", "doCreateBezier"}, {"c.Bezier", "doCreateClosedBezier"}, {"Spline", "doCreateSpline"}, {"c.Spline", "doCreateClosedSpline"}, {"Arc", "doCreateArc"}, {"Image", "doCreateImage"}, {"Link", "doCreateLink"}, {"Text", "doCreateText"}, {"Library object", "doSelectLibraryObject"}, {"Open [@]", "doOpenCompound"}, {"Create [@]", "doCreateCompound"}, {"Break [@]", "doBreakCompound"}, {"Move", "doMoveObject"}, {"Copy", "doCopyObject"}, {"Delete", "doDeleteObject"}, {"Move point", "doMovePoint"}, {"Add point", "doInsertPoint"}, {"Cut point", "doCutPoint"}, {"Update", "doUpdateObject"}, {"Edit", "doEditObject"}, {"Mirror X", "doMirrorXObject"}, {"Mirror Y", "doMirrorYObject"}, {"Align", "doAlignObjects"}, {"Scale", "doScaleObject"}, {"Convert", "doConvertObject"}, {"Text size", "doResizeText"}, {"Rotate CW", "doRotateCWObject"}, {"Rotate CCW", "doRotateCCWObject"}, {"Join or split lines", "doJoinSplitLines"}, {"Zoom Fit", "doZoomFit"}, {"Zoom Region", "doZoomRegion"}, {"Zoom In", "doZoomIn"}, {"Zoom Out", "doZoomOut"}, {"Zoom 1:1", "doZoom11"}, {"Pan Origin", "doPanHome"}, {"Pan home", "doPanHome"}, {"Pan Left", "doPanLeft"}, {"Pan Right", "doPanRight"}, {"Pan Up", "doPanUp"}, {"Pan Down", "doPanDown"}, {"Set Snapping", "doSetCursorSnapping"}, {"no grid", "doSetGridNone"}, {"coarse grid", "doSetGridCoarse"}, {"medium grid", "doSetGridMedium"}, {"fine grid", "doSetGridFine"}, {"1:5 grid", "doSetGridTen"}, {"no magnetic grid", "doSetNoSnap"}, {"any position", "doSetNoSnap"}, {"1/2 grid", "doSetSnap12"}, {"1/4 grid", "doSetSnap14"}, {"1/8 grid", "doSetSnap18"}, {"1/10 grid", "doSetSnap110"}, {"inches", "doSetUnitsInches"}, {"millimeter", "doSetUnitsMillimeter"}, {"xfig millimeter", "doSetUnitsXfigMillimeter"}, {"Inches", "doSetUnitsInches"}, {"Metric", "doSetUnitsXfigMillimeter"}, {"UpdateAll", "enableUpdateAll"}, {"UpdateNone", "enableUpdateNone"}, {"UpdateInvert", "enableUpdateInvert"}, {"New...", "doStartNewDrawing"}, {"Open File...", "doSelectFile"}, {"Open URL...", "doSelectURL"}, {"Merge File...", "doMergeFile"}, {"Merge URL...", "doMergeURL"}, {"Save", "doSaveFile"}, {"Save As...", "doSaveFileAs"}, {"Write to console", "doSaveToConsole"}, {"Quit", "doQuit"}, {"Print (Java native)", "doPrintViaAWT"}, {"Display links", "doToggleDisplayLinks"}, {"About...", "doShowAboutDialog"}, {"How to participate...", "doShowParticipateDialog"}, {"JVM compatibility...", "doShowJvmDialog"}, {"License...", "doShowLicenseDialog"}, {"Registration...", "doShowRegistrationDialog"}, {"Documentation...", "doShowHelpDialog"}, {"News and Changes...", "doShowChangesDialog"}, {"Mouse Buttons...", "doShowMouseButtonDialog"}, {"Shortcut Keys...", "doShowShortcutKeysDialog"}, {"Export and fig2dev...", "doShowExportFaqDialog"}, {"Creating polylines...", "doShowPolylineHelpDialog"}, {"README...", "doShowReadmeDialog"}, {"FAQ...", "doShowFaqDialog"}, {"Embedding jfig...", "doShowEmbeddingJfigDialog"}, {"TeX and LaTeX support...", "doShowTexSupportDialog"}, {"welcome", "doShowDemoWelcome"}, {"gold", "doShowDemoGold"}, {"house", "doShowDemoHouse"}, {"watch", "doShowDemoWatch"}, {"circuit", "doShowDemoCircuit"}, {"layout", "doShowDemoLayout"}, {"biohazard", "doShowDemoBiohazard"}, {"pictures", "doShowDemoPictures"}, {"rotated", "doShowDemoRotated"}, {"fonts", "doShowDemoFonts"}, {"unicode", "doShowDemoUnicode"}, {"TeX demo", "doShowDemoTeX"}, {"Print objects", "doPrintObjects"}, {"Print undo stack", "doPrintUndoStack"}, {"Print clipboard", "doPrintClipboard"}, {"Snap to grid", "doSnapObjectToGrid"}, {"Add attributes to cache", "doAddToAttributeCache"}, {"Clear attribute cache", "doClearAttributeCache"}, {"Next attributes", "doNextAttributeCache"}, {"Create bullet point", "doCreateBullet"}, {"Create dimensioning", "doCreateDimensioning"}, {"Add user color", "doAddUserColor"}, {"Clear user colors", "doClearUserColors"}, {"Write HADES resource", "doWriteHadesResource"}, {"Edit object comments...", "doEditObjectComments"}, {"Edit global attributes...", "doEditGlobalAttributes"}, {"Font configuration...", "doShowFontConfigurationDialog"}, {"Command is ready", "handleCommandCallback"}, {"ParserCallback:load", "handleParserCallback"}, {"ParserCallback:merge", "handleParserMergeCallback"}, {"Copy (to clipboard)", "doCopyToClipboard"}, {"Cut (to clipboard)", "doCutToClipboard"}, {"Paste (from clipboard)", "doPasteFromClipboard"}, {"Postscript...", "doExportPS"}, {"EPS...", "doExportEPS"}, {"Print (Postscript/fig2dev)", "doExportPrintPS"}, {"Export Options...", "doExportSettings"}, {"PPM...", "doExportNativePPM"}, {"GIF...", "doExportNativeGIF"}, {"PNG...", "doExportNativePNG"}, {"PDF...", "doExportPDF"}};
    protected static Hashtable _callbackTable = new Hashtable();
    static String demoURL;
    String versionString = "jfig 2.22 (16.09.04)";
    FigAttribs attribs;
    FigObjectList objectList;
    FigObjectList tmpObjectList;
    FigObject tmpObject;
    FigParser parser;
    FigWriter writer;
    JExportOptionsDialog exportOptionsDialog;
    JPdfExportOptionsDialog pdfExportOptionsDialog;
    JFrame frame;
    FigCanvas objectCanvas;
    JModeButtonPanel modeButtonPanel;
    JAttribsButtonPanel attribsButtonPanel;
    JEditorMenuBar editorMenuBar;
    JEditorStatusPanel statusPanel;
    JConsole console;
    JLayerManager layerManager;
    JAboutDialog aboutDialog;
    StatusMessage statusField;
    JConfirmDialog okToQuit;
    private int answer;
    private int CANCEL = 1;
    private int SAVE = 2;
    private int QUIT = 3;
    JColorChooser colorChooser;
    JFileChooser fileChooser;
    JEditGlobalAttributesDialog globalAttributesDialog;
    String filename;
    String tmpfilename;
    String filetype;
    String tmpfiletype;
    JStringDialog getUrlDialog;
    KeyHandler keyHandler;
    JRecentFileManager recentFileManager;
    Hashtable activeFrames;
    Object mouseWheelZoomPanHandler;
    Font menuFont;
    Command command;
    UndoStack undoStack;
    boolean displayTriggerFlag;
    boolean saveFileEnable = true;
    public final int FIG_31;
    public final int FIG_32;
    public final String TypeFILE;
    public final String TypeURL;
    public final String TypeRESOURCE;
    private int n_operations = 0;
    private int n_saves = 0;
    private int n_reads = 0;
    private long t_start = 0L;
    private long t_last_reminder = 0L;
    private int n_reminders = 0;
    private ListNode lastNode = null;
    private Vector _attributeCache;
    private int _attributeIndex;
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljfig$commands$FigBasicEditor;
    private static /* synthetic */ Class class$Ljfig$canvas$FigCanvas;
    private static /* synthetic */ Class class$Ljava$lang$Boolean;

    private void getDefaultFigVersion() {
        this.setFigVersion(SetupManager.getInteger("jfig.FIG.Version", 31));
    }

    public void setFigVersion(int n) {
        this.attribs.setDefaultFigVersion(n);
        this.attribs.setFigVersion(n);
        if (this.editorMenuBar != null) {
            this.editorMenuBar.setFigVersion(this.attribs.figVersion, this);
        }
    }

    private void getDefaultFonts() {
        String string = SetupManager.getProperty("jfig.gui.Editor.MenuFontName", "");
        int n = SetupManager.getInteger("jfig.gui.Editor.MenuFontSize", 12);
        int n2 = 0;
        if (string != null && string.length() > 1) {
            this.menuFont = new Font(string, n2, n);
        }
    }

    public void getUserPreferences() {
        String string = SetupManager.getProperty("jfig.units", "Inches");
        this._call(string, null);
        string = SetupManager.getProperty("jfig.grid", "medium grid");
        this._call(string, null);
        string = SetupManager.getProperty("jfig.cursorSnapping", "1/4 grid");
        this._call(string, null);
        FigAttribs.initializeFromProperties(SetupManager.getProperties());
    }

    private void waitUntilVisible(int n) {
        int n2 = 100;
        int n3 = 0;
        while (!this.frame.isVisible() && n3 < n) {
            try {
                Thread.sleep(n2);
                n3 += n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ExceptionTracer.message("-W- waitUntilVisible: " + n3 + " msec.");
    }

    public UndoStack getUndoStack() {
        return this.undoStack;
    }

    public Command getCurrentCommand() {
        return this.command;
    }

    public FigCanvas getObjectCanvas() {
        return this.objectCanvas;
    }

    public FigAttribs getCurrentAttribs() {
        this.attribsButtonPanel.getValues(this.attribs);
        return this.attribs;
    }

    public void setCurrentAttribs(FigAttribs figAttribs) {
        this.attribs = figAttribs;
        this.attribsButtonPanel.showValues(figAttribs);
    }

    public void insertIntoObjectList(FigObject figObject) {
        this.objectList.insert(figObject);
    }

    public void deleteFromObjectList(FigObject figObject) {
        this.objectList.delete(figObject);
    }

    public boolean isInObjectList(FigObject figObject) {
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            if (figObject != enumeration.nextElement()) continue;
            return true;
        }
        return false;
    }

    public FigObject findObjectAt(Point point) {
        return this.findObjectAtNew(point);
    }

    public FigObject findObjectAtNew(Point point) {
        double d = 2.0 * (double)this.objectCanvas.getTrafo().getSnapRelative();
        double d2 = Double.MAX_VALUE;
        boolean bl = SetupManager.getBoolean("jfig.gui.Editor.DebugFindObjectMessages", false);
        if (bl) {
            this.msg("-#- JME.findObjectAt: " + point + " " + " 2*snap: " + d);
        }
        FigObject figObject = null;
        FigObject figObject2 = null;
        Enumeration enumeration = this.objectList.reverseElements();
        while (enumeration.hasMoreElements()) {
            figObject2 = (FigObject)enumeration.nextElement();
            if (!figObject2.isVisible()) continue;
            double d3 = figObject2.minDistance(point);
            if (d3 <= d) {
                if (bl) {
                    this.msg("... candidate: " + d3 + " " + figObject2.getClass().getName());
                }
                if (figObject2 instanceof FigPolyline) {
                    d3 = figObject2.minDistanceEuclid(point);
                    if (bl) {
                        this.msg("... euclidean: " + d3 + " ");
                    }
                }
                if (!(d3 <= d2)) continue;
                d2 = d3;
                figObject = figObject2;
                continue;
            }
            if (!bl) continue;
            this.msg("...    reject: " + d3 + " " + figObject2.getClass().getName());
        }
        return figObject;
    }

    public FigObject findObjectAtOld(Point point) {
        int n = this.objectCanvas.getTrafo().getSnapRelative();
        this.lastNode = this.objectList.search(point, n);
        if (this.lastNode != null) {
            return this.lastNode.obj;
        }
        return this.findObjectNearOrOver(point);
    }

    protected FigObject findObjectNearOrOver(Point point) {
        double d = 1.5 * (double)this.objectCanvas.getTrafo().getSnapRelative();
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            double d2 = figObject instanceof FigText ? figObject.minDistance(point) : figObject.minDistance(point);
            if (!(d2 < d)) continue;
            return figObject;
        }
        return null;
    }

    public FigObject findNextObjectAt(Point point, FigObject figObject) {
        int n = this.objectCanvas.getTrafo().getSnapRelative();
        Enumeration enumeration = this.objectList.elements();
        if (figObject != null) {
            while (enumeration.hasMoreElements()) {
                if (figObject == enumeration.nextElement()) break;
            }
        }
        while (enumeration.hasMoreElements()) {
            FigObject figObject2 = (FigObject)enumeration.nextElement();
            double d = figObject2.getBbox().minDistance(point);
            if (!(d < (double)n)) continue;
            figObject2.select();
            return figObject2;
        }
        return null;
    }

    public FigObject[] findAllObjectsAt(Point point) {
        FigObject[] figObjectArray = new FigObject[]{};
        return figObjectArray;
    }

    public Enumeration getObjects() {
        return this.objectList.elements();
    }

    public void showAllObjectCorners() {
        this.dbg("-#- showAllObjectCorners...");
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            ((FigObject)enumeration.nextElement()).showPoints();
        }
        this.doRedraw();
    }

    public void hideAllObjectCorners() {
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            ((FigObject)enumeration.nextElement()).deselect();
        }
        this.doRedraw();
    }

    public void showObjectCorners(FigObject figObject) {
        figObject.showPoints();
        this.doRedraw();
    }

    public void addTmpObject(FigObject figObject) {
        this.tmpObject = figObject;
    }

    public void deleteTmpObject(FigObject figObject) {
        this.tmpObject = null;
    }

    public FigObject[] getTmpObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.tmpObject};
        return figObjectArray;
    }

    public StatusMessage getStatusMessage() {
        return this.statusField;
    }

    public int getSmartLinksMode() {
        return this.attribsButtonPanel.getSmartLinksMode();
    }

    public int getGeometryMode() {
        return this.attribsButtonPanel.getGeometryMode();
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Enumeration getActiveFrames() {
        return this.activeFrames.keys();
    }

    public Hashtable getCallbackTable() {
        return _callbackTable;
    }

    public void addCallback(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string2 == null) {
            return;
        }
        _callbackTable.put(string, string2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.dbg("-I- JModularEditor.actionPerformed: " + actionEvent);
        ++this.n_operations;
        this.checkRegistrationReminder();
        String string = actionEvent.getActionCommand();
        if (string == null) {
            if (actionEvent.getSource() instanceof MenuItem) {
                this.dbg("-W- actionPerformed emergency: " + actionEvent);
                string = ((MenuItem)actionEvent.getSource()).getLabel();
                if (string == null) {
                    this.message("-E- Unknown action event: " + actionEvent);
                    return;
                }
            } else {
                this.message("-E- Unknown action event: " + actionEvent);
                return;
            }
        }
        if (_callbackTable.containsKey(string)) {
            this._call(string, actionEvent);
        } else if (string.startsWith("Undo")) {
            this.doUndo(actionEvent);
        } else if (string.startsWith("Redo")) {
            this.doRedo(actionEvent);
        } else {
            this.message("-W- No callback defined for action command: " + string);
        }
    }

    private void _call(String string, Object object) {
        String string2 = (String)_callbackTable.get(string);
        if (string2 != null) {
            this.call(string2, object);
        } else {
            this.message("-E- JModularEditor._call: No method for key #" + string + "#");
        }
    }

    public void call(String string, Object object) {
        if (debug) {
            this.message("-E- ModularEditor.call: #" + string + "# #" + object + "#");
        }
        String string2 = string;
        try {
            Class[] classArray = new Class[]{class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = JModularEditor.class$("java.lang.Object"))};
            Method method = this.getClass().getMethod(string2, classArray);
            Object[] objectArray = new Object[]{object};
            method.invoke((Object)this, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            this.message("-E- actionPerformed: " + throwable);
            throwable.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.message("-E- actionPerformed: " + noSuchMethodException + ":" + string2);
            noSuchMethodException.printStackTrace();
        }
        catch (Exception exception) {
            this.message("-E- actionPerformed: " + exception + " for command: " + string);
            exception.printStackTrace();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (debug) {
            this.message("-I- itemStateChanged: " + itemEvent);
        }
        if (itemEvent.getSource() == this.editorMenuBar.writeFig31MI) {
            this.setFigVersion(31);
        } else if (itemEvent.getSource() == this.editorMenuBar.writeFig32MI) {
            this.setFigVersion(32);
        } else if (itemEvent.getSource() == this.editorMenuBar.optionsRemapMouseMI) {
            MouseMapper.setRemap(this.editorMenuBar.optionsRemapMouseMI.getState());
        } else if (itemEvent.getSource() == this.editorMenuBar.antialiasMI) {
            this.objectCanvas.requestAntiAliasing(this.editorMenuBar.antialiasMI.getState());
        } else if (itemEvent.getSource() == this.editorMenuBar.qualityMI) {
            this.objectCanvas.requestRenderQuality(this.editorMenuBar.qualityMI.getState());
        } else if (itemEvent.getSource() == this.editorMenuBar.mouseWheelScrollingMI) {
            boolean bl = this.editorMenuBar.mouseWheelScrollingMI.getState();
            this.enableMouseWheelZoomPanHandler(bl);
        } else if (itemEvent.getSource() == this.editorMenuBar.tripleBufferMI) {
            try {
                boolean bl = this.editorMenuBar.tripleBufferMI.getState();
                FigSwingCanvas figSwingCanvas = (FigSwingCanvas)this.objectCanvas;
                figSwingCanvas.setTripleBuffering(bl);
            }
            catch (Exception exception) {
                this.message("-E- internal in itemStateChanged: " + exception);
            }
        } else if (itemEvent.getSource() == this.editorMenuBar.showLineLengthsMI) {
            this.objectCanvas.setRubberbandShowLineLengths(this.editorMenuBar.showLineLengthsMI.getState());
        } else if (itemEvent.getSource() == this.editorMenuBar.showTeXStringsMI) {
            boolean bl = this.editorMenuBar.showTeXStringsMI.getState();
            String string = bl ? "true" : "false";
            SetupManager.setProperty("jfig.showTeXStrings", string);
            this.message("-I- Show LaTeX mode: " + string);
            this.doRedraw();
        } else if (itemEvent.getSource() == this.editorMenuBar.showLayerManagerMI) {
            boolean bl = this.editorMenuBar.showLayerManagerMI.getState();
            this.layerManager.getPanel().setVisible(bl);
            this.frame.repaint();
        }
    }

    public boolean isIdle() {
        if (this.command != null) {
            return this.command.isReady();
        }
        return true;
    }

    public boolean checkIsIdle() {
        if (!this.isIdle()) {
            this.message("-I- Please finish the current operation first (" + this.command.getDescription() + ")");
        }
        return this.isIdle();
    }

    public boolean checkCanCancel() {
        if (this.command != null) {
            this.command.cancel();
        }
        return true;
    }

    public void doCancel(Object object) {
        if (this.command != null) {
            this.command.cancel();
        }
        this.command = new Command(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(null);
        this.attribsButtonPanel.hideAllControls();
        this.hideAllObjectCorners();
        this.tmpObject = null;
        this.objectCanvas.changeRubberbandMode(1);
        this.objectCanvas.doFullRedraw();
        this.statusMessage("Ready. Select a command.");
    }

    public void doUndo(Object object) {
        if (!this.isIdle()) {
            this.doCancel(null);
        }
        this.undoStack.undo();
    }

    public void doRedo(Object object) {
        if (!this.isIdle()) {
            this.message("-E- Please cancel any ongoing operations (ESC) \nbefore trying to redo something.");
            return;
        }
        this.undoStack.redo();
    }

    public void doFlushUndoStack(Object object) {
        this.clearUndoStack();
    }

    public void doDeleteAll(Object object) {
        this.message("-#- doDeleteAll...");
    }

    public void doCopyToClipboard(Object object) {
        this.dbg("-#- doCopyToClipboard...");
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CopyToClipboardCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(null);
    }

    public void doCutToClipboard(Object object) {
        this.dbg("-#- doCutToClipboard...");
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CutToClipboardCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(null);
    }

    public void doPasteFromClipboard(Object object) {
        this.dbg("-#- doPasteFromClipboard...");
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new PasteFromClipboardCommand(this, this.objectCanvas, this.console);
        this.modeButtonPanel.selectModeButton(null);
    }

    private void checkCreateExportOptionsDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            this.msg("-E- JModularEditor.checkCreateExportOptionsDialog internal error: This is not the Swing event dispatch thread: " + Thread.currentThread());
        }
        if (this.exportOptionsDialog == null) {
            this.exportOptionsDialog = new JExportOptionsDialog(this.getFrame());
            this.exportOptionsDialog.setEditor(this);
            this.exportOptionsDialog.setConsole(this.console);
            this.dbg("-#- cCEOD: created: " + this.exportOptionsDialog);
        }
    }

    public void doExportSettings(Object object) {
        this.doCancel(null);
        if (this.undoStack.hasChanges()) {
            this.doSaveFile(null);
        }
        this.checkCreateExportOptionsDialog();
        this.exportOptionsDialog.updateFigObjectsBoundingBox();
        this.exportOptionsDialog.updateOutFilenameFromFigFilename();
        this.exportOptionsDialog.updateCommandLine();
        this.exportOptionsDialog.show();
    }

    public void doExportPS(Object object) {
        this.doCancel(null);
        if (this.undoStack.hasChanges()) {
            this.doSaveFile(null);
        }
        this.checkCreateExportOptionsDialog();
        this.exportOptionsDialog.updateFigObjectsBoundingBox();
        this.exportOptionsDialog.updateOutFilenameFromFigFilename();
        this.exportOptionsDialog.doExportPS();
    }

    public void doExportEPS(Object object) {
        this.doCancel(null);
        if (this.undoStack.hasChanges()) {
            this.doSaveFile(null);
        }
        this.checkCreateExportOptionsDialog();
        this.exportOptionsDialog.updateFigObjectsBoundingBox();
        this.exportOptionsDialog.updateOutFilenameFromFigFilename();
        this.exportOptionsDialog.doExportEPS();
    }

    public void doExportPrintPS(Object object) {
        this.doCancel(null);
        if (this.undoStack.hasChanges()) {
            this.doSaveFile(null);
        }
        this.checkCreateExportOptionsDialog();
        this.exportOptionsDialog.updateFigObjectsBoundingBox();
        this.exportOptionsDialog.updateOutFilenameFromFigFilename();
        this.exportOptionsDialog.doExportPrintPS();
    }

    public void doExportNativeGIF(Object object) {
        this.doCancel(null);
        if (this.undoStack.hasChanges()) {
            this.doSaveFile(null);
        }
        this.checkCreateExportOptionsDialog();
        this.exportOptionsDialog.updateFigObjectsBoundingBox();
        this.exportOptionsDialog.updateOutFilenameFromFigFilename();
        this.exportOptionsDialog.requestAntiAliasing(this.editorMenuBar.antialiasMI.getState());
        this.exportOptionsDialog.doExportNativeGIF();
    }

    public void doExportNativePNG(Object object) {
        this.doCancel(null);
        if (this.undoStack.hasChanges()) {
            this.doSaveFile(null);
        }
        this.checkCreateExportOptionsDialog();
        this.exportOptionsDialog.updateFigObjectsBoundingBox();
        this.exportOptionsDialog.updateOutFilenameFromFigFilename();
        this.exportOptionsDialog.requestAntiAliasing(this.editorMenuBar.antialiasMI.getState());
        this.exportOptionsDialog.doExportNativePNG();
    }

    public void doExportNativePPM(Object object) {
        this.doCancel(null);
        if (this.undoStack.hasChanges()) {
            this.doSaveFile(null);
        }
        this.checkCreateExportOptionsDialog();
        this.exportOptionsDialog.updateFigObjectsBoundingBox();
        this.exportOptionsDialog.updateOutFilenameFromFigFilename();
        this.exportOptionsDialog.requestAntiAliasing(this.editorMenuBar.antialiasMI.getState());
        this.exportOptionsDialog.doExportNativePPM();
    }

    public void doExportPDF(Object object) {
        if (this.pdfExportOptionsDialog == null) {
            this.pdfExportOptionsDialog = new JPdfExportOptionsDialog(this.getFrame());
            this.pdfExportOptionsDialog.setEditor(this);
            this.pdfExportOptionsDialog.setConsole(this.console);
        }
        this.pdfExportOptionsDialog.updateOutFilenameFromFigFilename();
        this.pdfExportOptionsDialog.show();
    }

    public void doCreateCircle(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreateCircleCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCreateEllipseControls();
    }

    public void doCreateEllipse(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreateEllipseCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCreateEllipseControls();
    }

    public void doCreateBullet(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreateBulletCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(null);
        this.attribsButtonPanel.showCreateEllipseControls();
    }

    public void doCreateDimensioning(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreateDimensioningCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(null);
        this.attribsButtonPanel.showCreatePolylineControls();
    }

    public void doCreateRectangle(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreateRectangleCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCreateRectangleControls();
    }

    public void doCreateRoundRectangle(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreateRoundedRectangleCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCreateRoundRectangleControls();
    }

    public void doCreatePolyline(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreatePolylineCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCreatePolylineControls();
    }

    public void doCreatePolygon(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreatePolygonCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCreatePolylineControls();
    }

    public void doCreateSpline(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreateSplineCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCreateSplineControls();
    }

    public void doCreateClosedSpline(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreateClosedSplineCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCreateSplineControls();
    }

    public void doCreateBezier(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreateBezierCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCreateSplineControls();
    }

    public void doCreateClosedBezier(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreateClosedBezierCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCreateSplineControls();
    }

    public void doCreateArc(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreateArcCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCreateSplineControls();
    }

    public void doCreateImage(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new JCreateImageCommand(this, this.objectCanvas);
        ((JCreateImageCommand)this.command).setFrame(this.frame);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCreateImageControls();
    }

    public void doCreateText(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreateTextCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCreateTextControls();
    }

    public void doCreateLink(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        if (this.displayTriggerFlag) {
            this.displayTriggerFlag = false;
            this.hideAllTriggers();
            this.modeButtonPanel.setLinkMessage("Hyperlinks (inactive): click again to show links");
        } else {
            this.displayTriggerFlag = true;
            this.showAllTriggers();
            this.modeButtonPanel.setLinkMessage("Create hyperlinks: click again to hide links | L: new link");
            this.command = new CreateTriggerCommand(this, this.objectCanvas);
        }
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doSelectLibraryObject(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new SelectLibraryObjectCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doOpenCompound(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new JOpenCompoundCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doCreateCompound(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CreateCompoundCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doBreakCompound(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new BreakCompoundCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doMoveObject(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new MoveObjectCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showMoveControls();
    }

    public void doCopyObject(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CopyObjectCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showCopyControls();
    }

    public void doDeleteObject(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new DeleteObjectCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doMovePoint(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new MovePointCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doInsertPoint(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new InsertPointCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doCutPoint(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new CutPointCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doMirrorXObject(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new MirrorXCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doMirrorYObject(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new MirrorYCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doRotateCWObject(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        RotateObjectCommand.setDirection(true);
        this.command = new RotateObjectCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showRotateControls();
    }

    public void doRotateCCWObject(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        RotateObjectCommand.setDirection(false);
        this.command = new RotateObjectCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showRotateControls();
    }

    public void doScaleObject(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new ScaleObjectCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doAlignObjects(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new AlignObjectsCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showAlignControls();
    }

    public int getObjectAlignmentModeX() {
        return this.attribsButtonPanel.getObjectAlignmentModeX();
    }

    public int getObjectAlignmentModeY() {
        return this.attribsButtonPanel.getObjectAlignmentModeY();
    }

    public void doSnapObjectToGrid(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new SnapToGridCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doConvertObject(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new ConvertObjectCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doJoinSplitLines(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new JoinSplitLinesCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doResizeText(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new ResizeTextCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doUpdateObject(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.attribsButtonPanel.setUpdateMode(true);
        this.command = new UpdateCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.showAllControls();
    }

    public void doCancelUpdate(Object object) {
        this.attribsButtonPanel.setUpdateMode(false);
        this.attribsButtonPanel.hideAllControls();
    }

    public void enableUpdateAll(Object object) {
        this.attribsButtonPanel.setUpdateStatusAll();
    }

    public void enableUpdateNone(Object object) {
        this.attribsButtonPanel.setUpdateStatusNone();
    }

    public void enableUpdateInvert(Object object) {
        this.attribsButtonPanel.invertUpdateStatus();
    }

    public void doEditObject(Object object) {
        this.dbg("-#- doEditObject...");
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new JEditObjectCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(object);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doEditObjectComments(Object object) {
        this.dbg("-#- doEditObjectComments...");
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new EditCommentCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(null);
        this.attribsButtonPanel.hideAllControls();
    }

    public void doEditGlobalAttributes(Object object) {
        this.dbg("-#- doEditGlobalAttributes...");
        if (this.globalAttributesDialog == null) {
            this.globalAttributesDialog = new JEditGlobalAttributesDialog(this.attribs, this, this.frame);
        }
        this.globalAttributesDialog.setAttributes(this.attribs);
        this.globalAttributesDialog.setVisible(true);
    }

    public void doShowFontConfigurationDialog(Object object) {
        this.msg("-#- doShowFontConfigurationDialog...");
        JFontConfigurationDialog jFontConfigurationDialog = new JFontConfigurationDialog(this.frame);
        jFontConfigurationDialog.setSize(700, 500);
        jFontConfigurationDialog.show();
    }

    public void doZoomRegion(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.command = new ZoomRegionCommand(this, this.objectCanvas);
        this.modeButtonPanel.selectModeButton(null);
    }

    public void doZoomRegion(int n, int n2, int n3, int n4) {
        this.objectCanvas.doZoomRegion(n, n2, n3, n4);
        this.setZoomMessage();
    }

    public void doZoomFactor(double d) {
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        Dimension dimension = this.objectCanvas.getSize();
        int n = figTrafo2D.screen_to_wc(dimension.width);
        int n2 = figTrafo2D.screen_to_wc(dimension.height);
        double d2 = figTrafo2D.getZoom();
        Point point = figTrafo2D.getAnchor();
        figTrafo2D.set_zoom(d * d2);
        figTrafo2D.setAnchor(new Point(point.x + (int)(0.5 * (1.0 - 1.0 / d) * (double)n), point.y + (int)(0.5 * (1.0 - 1.0 / d) * (double)n2)));
        this.doRedraw();
    }

    public void doZoomFit(Object object) {
        this.objectCanvas.doZoomFit();
        this.setZoomMessage();
    }

    public void doZoomIn(Object object) {
        this.doZoomFactor(1.4142);
        this.setZoomMessage();
    }

    public void doZoomOut(Object object) {
        this.doZoomFactor(0.7071);
        this.setZoomMessage();
    }

    public void doZoom11(Object object) {
        this.objectCanvas.doZoomFull();
        this.objectCanvas.doPanning(0, false);
        this.setZoomMessage();
    }

    public void setZoomMessage() {
        int n = (int)Math.round(this.objectCanvas.getTrafo().getZoomFactor() * 100.0);
        String string = "" + n + "%";
        this.statusPanel.setZoomMessage(string);
    }

    public void doPanHome(Object object) {
        this.objectCanvas.doPanning(0, false);
        this.setZoomMessage();
    }

    public void doPanLeft(Object object) {
        boolean bl = false;
        if (object instanceof KeyEvent) {
            bl = ((KeyEvent)object).isShiftDown();
        }
        this.objectCanvas.doPanning(1, bl);
    }

    public void doPanRight(Object object) {
        boolean bl = false;
        if (object instanceof KeyEvent) {
            bl = ((KeyEvent)object).isShiftDown();
        }
        this.objectCanvas.doPanning(2, bl);
    }

    public void doPanUp(Object object) {
        boolean bl = false;
        if (object instanceof KeyEvent) {
            bl = ((KeyEvent)object).isShiftDown();
        }
        this.objectCanvas.doPanning(3, bl);
    }

    public void doPanDown(Object object) {
        boolean bl = false;
        if (object instanceof KeyEvent) {
            bl = ((KeyEvent)object).isShiftDown();
        }
        this.objectCanvas.doPanning(4, bl);
    }

    public void doSetGridNone(Object object) {
        this.objectCanvas.getTrafo().setGridMode(0);
        this.doRedraw();
    }

    public void doSetGridCoarse(Object object) {
        this.objectCanvas.getTrafo().setGridMode(960);
        this.doRedraw();
    }

    public void doSetGridMedium(Object object) {
        this.objectCanvas.getTrafo().setGridMode(480);
        this.doRedraw();
    }

    public void doSetGridFine(Object object) {
        this.objectCanvas.getTrafo().setGridMode(240);
        this.doRedraw();
    }

    public void doSetGridTen(Object object) {
        this.objectCanvas.getTrafo().setGridMode(961);
        this.doRedraw();
    }

    public void doSetNoSnap(Object object) {
        this.dbg("-#- doSetNoSnap");
        this.objectCanvas.getTrafo().setSnapRelative(1);
        this.doRedraw();
    }

    public void doSetSnap12(Object object) {
        this.dbg("-#- doSetSnap12 (1/2)");
        this.objectCanvas.getTrafo().setSnapRelative(2);
        this.doRedraw();
    }

    public void doSetSnap14(Object object) {
        this.dbg("-#- doSetSnap14 (1/4)");
        this.objectCanvas.getTrafo().setSnapRelative(3);
        this.doRedraw();
    }

    public void doSetSnap18(Object object) {
        this.dbg("-#- doSetSnap18 (1/8)");
        this.objectCanvas.getTrafo().setSnapRelative(4);
        this.doRedraw();
    }

    public void doSetSnap110(Object object) {
        this.dbg("-#- doSetSnap110 (1/10)");
        this.objectCanvas.getTrafo().setSnapRelative(10);
        this.doRedraw();
    }

    public void doSetUnitsInches(Object object) {
        this.objectCanvas.getTrafo().units = 2;
        this.updateSnap();
        this.doRedraw();
    }

    public void doSetUnitsMillimeter(Object object) {
        this.objectCanvas.getTrafo().units = 1;
        this.updateSnap();
        this.doRedraw();
    }

    public void doSetUnitsXfigMillimeter(Object object) {
        this.objectCanvas.getTrafo().units = 3;
        this.updateSnap();
        this.doRedraw();
    }

    public void doToggleShowTeXStringsMode(Object object) {
        boolean bl = this.editorMenuBar.showTeXStringsMI.getState();
        bl = !bl;
        String string = bl ? "true" : "false";
        SetupManager.setProperty("jfig.showTeXStrings", string);
        this.dbg("-#- Toggle Show TeX mode: " + string);
        this.editorMenuBar.showTeXStringsMI.setState(bl);
        this.doRedraw();
    }

    private void updateSnap() {
        this.dbg("-#- updateSnap(): ignored");
    }

    public void doSnapAllObjectsToGrid(Object object) {
        this.message("-E- function 'snap to grid' not yet implemented, sorry!");
    }

    public void doClearUserColors(Object object) {
        this.message("-W- clearing all user defined colors");
        ColorCache.getColorCache().clearUserColors();
    }

    public void doAddUserColor(Object object) {
        Color color;
        if (this.colorChooser == null) {
            this.colorChooser = new JColorChooser();
        }
        if ((color = JColorChooser.showDialog(this.getFrame(), "Select new color", Color.red)) != null) {
            ColorCache.getColorCache().registerUserColor(color);
        }
    }

    public void doWriteHadesResource(Object object) {
        this.message("-W- writing current objects in HADES resource format to '/tmp/hades.txt'");
        if (!this.isSaveFileEnabled()) {
            return;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter("/tmp/hades.txt")));
            FigWriter figWriter = new FigWriter();
            Enumeration enumeration = this.objectList.elements();
            while (enumeration.hasMoreElements()) {
                figWriter.writeAsResource(printWriter, (FigObject)enumeration.nextElement());
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            this.message("-E- got: " + iOException);
        }
    }

    public void checkCreateAttributeCache() {
        if (this._attributeCache == null) {
            this._attributeCache = new Vector();
            this._attributeIndex = 0;
        }
    }

    public void doAddToAttributeCache(Object object) {
        this.checkCreateAttributeCache();
        this._attributeCache.add(this.getCurrentAttribs().getClone());
    }

    public void doClearAttributeCache(Object object) {
        this.checkCreateAttributeCache();
        this._attributeCache.removeAllElements();
    }

    public void doNextAttributeCache(Object object) {
        if (!this.checkCanCancel()) {
            return;
        }
        this.checkCreateAttributeCache();
        if (this._attributeCache.size() == 0) {
            return;
        }
        ++this._attributeIndex;
        if (this._attributeIndex >= this._attributeCache.size()) {
            this._attributeIndex = 0;
        }
        this.setCurrentAttribs((FigAttribs)this._attributeCache.elementAt(this._attributeIndex));
    }

    public void doRedraw() {
        this.objectCanvas.doFullRedraw();
    }

    public void doRedraw(Object object) {
        this.doRedraw();
    }

    public void checkUpdateLayerManager() {
        if (debug) {
            this.msg("-#- checkUpdateLayerManager...");
        }
        if (this.layerManager == null) {
            return;
        }
        if (!this.layerManager.getPanel().isVisible()) {
            return;
        }
        this.layerManager.doReloadLayers();
    }

    public JLayerManager getLayerManager() {
        return this.layerManager;
    }

    public void doStartNewDrawing(Object object) {
        if (!"IGNORE_UNSAVED_CHANGES".equals(object)) {
            this.answer = this.checkUnsavedChanges();
            if (this.answer == this.CANCEL) {
                return;
            }
        }
        this.filename = null;
        this.filetype = "FILE";
        this.tmpfilename = null;
        this.tmpfiletype = "FILE";
        this.statusPanel.setFilename("no file");
        this.objectList = new FigObjectList();
        this.clearUndoStack();
        AntiDeadlock.sleep(100L);
        this.doRedraw();
    }

    public void setCurrentFigDirectory(JFileChooser jFileChooser) {
        try {
            String string = SetupManager.getProperty("jfig.gui.CurrentFigFileDirectory", ".");
            if (string != null) {
                jFileChooser.setCurrentDirectory(new File(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateCurrentFigDirectory(String string) {
        if (string != null) {
            SetupManager.setProperty("jfig.gui.CurrentFigFileDirectory", string);
        }
    }

    public void doSelectFile(Object object) {
        int n = this.checkUnsavedChanges();
        if (n == this.CANCEL) {
            this.statusMessage("Canceled!");
            return;
        }
        try {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setFileFilter(new JFigFileFilter());
            }
            this.setCurrentFigDirectory(this.fileChooser);
            this.fileChooser.setDialogTitle("Load a FIG file:");
            int n2 = this.fileChooser.showOpenDialog(this.frame);
            if (n2 == 0) {
                File file = this.fileChooser.getSelectedFile();
                String string = file.getPath();
                this.message("-#- JME.doSelectFile: " + string);
                String string2 = file.getParent();
                this.updateCurrentFigDirectory(string2);
                this.dbg("-I- trying to parse file '" + string + "'");
                this.doParseFile(string, false);
            }
        }
        catch (Exception exception) {
            this.message("-E- JModularEditor:doSelectFile() got an Exception: " + exception);
            this.message("-W- Please check the file name and try again!");
        }
    }

    public void doOpenRecentFile(Object object) {
        this.dbg("-#- doOpenRecentFile: " + object);
        int n = this.checkUnsavedChanges();
        if (n == this.CANCEL) {
            this.statusMessage("Canceled!");
            return;
        }
        String string = null;
        try {
            ActionEvent actionEvent = (ActionEvent)object;
            string = this.recentFileManager.get(actionEvent);
            this.doParseFile(string, false);
        }
        catch (Exception exception) {
            this.dbg("-E- internal error: " + exception + " " + object + " " + string);
            return;
        }
    }

    public void doMergeFile(Object object) {
        try {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
            }
            this.setCurrentFigDirectory(this.fileChooser);
            this.fileChooser.setDialogTitle("Merge a FIG file:");
            int n = this.fileChooser.showOpenDialog(this.frame);
            if (n == 0) {
                File file = this.fileChooser.getSelectedFile();
                String string = file.getPath();
                this.message("-#- JME.doMergeFile: " + string);
                String string2 = file.getParent();
                this.updateCurrentFigDirectory(string2);
                this.dbg("-I- trying to parse file '" + string + "' for merging");
                FigGlobalAttributes figGlobalAttributes = new FigGlobalAttributes();
                figGlobalAttributes.extractGlobalAttributes(this.getCurrentAttribs());
                this.doParseFile(string, true);
                figGlobalAttributes.restoreGlobalAttributes(this.getCurrentAttribs());
            }
        }
        catch (Exception exception) {
            this.message("-E- Viewer:doMergeFile() got an Exception: " + exception);
            this.message("-W- Please check the file name and try again!");
        }
    }

    public void doBrowseOpenNextFile() {
        if (this.n_reminders != 0) {
            this.message("-E- 'open next file' disabled now (shareware restriction)");
            return;
        }
        this.doBrowseNextNotPreviousFile(true);
    }

    public void doBrowseOpenPreviousFile() {
        if (this.n_reminders != 0) {
            this.message("-E- 'open previous file' disabled now (shareware restriction)");
            return;
        }
        this.doBrowseNextNotPreviousFile(false);
    }

    private void doBrowseNextNotPreviousFile(boolean bl) {
        int n = this.checkUnsavedChanges();
        if (n == this.CANCEL) {
            this.statusMessage("Canceled!");
            return;
        }
        try {
            this.dbg("-#- current filename: '" + this.filename + "'");
            String string = new File(this.filename).getCanonicalPath();
            File file = new File(string);
            File file2 = new File(file.getParent());
            JModularEditor jModularEditor = this;
            if (jModularEditor == null) {
                throw null;
            }
            String[] stringArray = file2.list(new FilenameFilter(jModularEditor){
                private final /* synthetic */ JModularEditor this$0;

                public boolean accept(File file, String string) {
                    return string.endsWith(".fig");
                }
                {
                    this.this$0 = jModularEditor;
                    this.constructor$0(jModularEditor);
                }

                private final void constructor$0(JModularEditor jModularEditor) {
                }
            });
            if (stringArray == null || stringArray.length < 2) {
                return;
            }
            ShellSort.shellSort(stringArray);
            String string2 = file.getName();
            int n2 = -1;
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (string2.equals(stringArray[n3])) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            n2 = bl ? (n2 + 1) % stringArray.length : (n2 > 0 ? n2 - 1 : stringArray.length - 1);
            String string3 = file.getParent() + File.separator + stringArray[n2 % stringArray.length];
            this.dbg("-#- next file: '" + string3 + "'");
            this.doParseFile(string3, false);
        }
        catch (Exception exception) {
            this.dbg("-E- JModularEditor:doBrowseOpenNextFile(): " + exception);
        }
    }

    public void doSelectURL(Object object) {
        int n = this.checkUnsavedChanges();
        if (n == this.CANCEL) {
            this.statusMessage("Canceled!");
            return;
        }
        String string = this.getUrlDialog != null ? this.getUrlDialog.getText() : demoURL;
        this.getUrlDialog = new JStringDialog(this.frame, "Enter the URL to open as a FIG file:", string, 40);
        JModularEditor jModularEditor = this;
        if (jModularEditor == null) {
            throw null;
        }
        this.getUrlDialog.addActionListener(jModularEditor.new UrlDialogListener(false));
        this.getUrlDialog.setVisible(true);
    }

    public void doMergeURL(Object object) {
        String string = this.getUrlDialog != null ? this.getUrlDialog.getText() : demoURL;
        this.getUrlDialog = new JStringDialog(this.frame, "Enter the URL to open as a FIG file and merge:", string, 40);
        JModularEditor jModularEditor = this;
        if (jModularEditor == null) {
            throw null;
        }
        this.getUrlDialog.addActionListener(jModularEditor.new UrlDialogListener(true));
        this.getUrlDialog.setVisible(true);
    }

    public void doParseURL(String string, boolean bl) {
        URL uRL = null;
        try {
            this.tmpfilename = string;
            this.tmpfiletype = "URL";
            uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            this.statusMessage("...parsing: " + this.tmpfilename);
            AntiDeadlock.sleep(100L);
            this.parse(dataInputStream, bl);
            inputStream.close();
        }
        catch (SecurityException securityException) {
            this.message("-F- Oops: got a SecurityException: " + securityException);
            this.message("    while trying to read from URL " + uRL.toString());
            this.message("-I- Unsigned applets can only open files from the applet server!");
            this.statusMessage("file/URL access denied for: " + uRL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.statusMessage("file/URL not found: " + uRL);
            this.message("-W- Please check the URL " + uRL + " and try again!");
        }
        catch (Exception exception) {
            this.statusMessage("got an Exception while parsing URL: " + uRL);
            this.message("-W- Please check the URL " + uRL + " and try again!");
        }
    }

    public void doParseResource(String string) {
        try {
            this.tmpfilename = string;
            this.tmpfiletype = "RESOURCE";
            InputStream inputStream = this.getClass().getResourceAsStream(this.tmpfilename);
            if (inputStream != null) {
                this.parse(inputStream, false);
                inputStream.close();
            } else {
                this.statusMessage("Resource not found: " + this.tmpfilename);
            }
        }
        catch (Exception exception) {
            this.message("-E- error in doParseResource: " + exception);
        }
    }

    public void doParseFile(String string, boolean bl) {
        try {
            this.tmpfilename = string;
            this.tmpfiletype = "FILE";
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            this.statusMessage("...parsing: " + this.tmpfilename);
            this.parse(bufferedInputStream, bl);
            ((InputStream)bufferedInputStream).close();
        }
        catch (SecurityException securityException) {
            this.message("-F- doParseFile: got a SecurityException: " + securityException);
            this.message("-W- Don't try to read files from an unsigned applet!");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.statusMessage("file not found: " + this.tmpfilename);
            this.message("-W- Please check the name " + this.tmpfilename + " and try again!");
        }
        catch (IOException iOException) {
            this.message("-E- Internal error in doParseFile: Could not close file '" + string + "'");
        }
    }

    public void parse(InputStream inputStream, boolean bl) {
        ++this.n_reads;
        this.checkRegistrationReminder();
        this.tmpObjectList = new FigObjectList();
        try {
            this.parser.setFilenameAndType(this.tmpfilename, this.tmpfiletype);
            this.parser.parse_fig_file_not_threaded(inputStream, true, false, bl, this.attribs, this.objectCanvas.getTrafo(), this.tmpObjectList);
        }
        catch (Exception exception) {
            this.message("-E- internal error in parse: " + exception);
            ExceptionTracer.trace(exception);
        }
    }

    public void handleParserCallback(Object object) {
        this.dbg("-I- handleParserCallback...");
        if (this.tmpObjectList != null && !this.tmpObjectList.empty()) {
            this.objectList = this.tmpObjectList;
            this.filename = this.tmpfilename;
            this.filetype = this.tmpfiletype;
            this.tmpfilename = null;
            this.tmpfiletype = null;
            this.clearUndoStack();
            this.statusPanel.setFilename(this.filename);
            this.statusMessage("FIG file loaded. Please select a command.");
            this.recentFileManager.add(this.filename);
            if (SetupManager.getBoolean("jfig.gui.Editor.DebugRedrawMessages", false)) {
                System.out.println("-#- handleParserCallback: calling doRedraw...");
            }
            this.doRedraw();
            this.checkUpdateLayerManager();
        } else {
            this.message("-E- Internal error in handleParserCallback: olist empty!");
        }
    }

    public void handleParserMergeCallback(Object object) {
        this.dbg("-I- handleParserMergeCallback...");
        if (this.tmpObjectList != null && !this.tmpObjectList.empty()) {
            FigCompound figCompound = new FigCompound();
            figCompound.setTrafo(this.objectCanvas.getTrafo());
            Enumeration enumeration = this.tmpObjectList.elements();
            while (enumeration.hasMoreElements()) {
                figCompound.fastAddMember((FigObject)enumeration.nextElement());
            }
            figCompound.update_bbox();
            this.objectList.insert(figCompound);
            this.tmpObjectList = null;
            this.tmpfilename = null;
            this.tmpfiletype = null;
            this.statusMessage("FIG file merged. Please select a command.");
            this.doRedraw();
        } else {
            this.message("-E- Internal error in handleParserMergeCallback: olist empty!");
        }
    }

    public void handleCommandCallback(Object object) {
        Class<?> clazz = null;
        Constructor<?> constructor = null;
        try {
            clazz = ((ActionEvent)object).getSource().getClass();
            Class[] classArray = new Class[]{class$Ljfig$commands$FigBasicEditor != null ? class$Ljfig$commands$FigBasicEditor : (class$Ljfig$commands$FigBasicEditor = JModularEditor.class$("jfig.commands.FigBasicEditor")), class$Ljfig$canvas$FigCanvas != null ? class$Ljfig$canvas$FigCanvas : (class$Ljfig$canvas$FigCanvas = JModularEditor.class$("jfig.canvas.FigCanvas"))};
            constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this, this.objectCanvas};
            this.command = (Command)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            this.message("-E- internal error in handleCommandCallback: " + exception);
            exception.printStackTrace();
        }
    }

    public int checkUnsavedChanges() {
        this.doCancel(null);
        if (this.undoStack.hasChanges()) {
            if (this.okToQuit == null) {
                this.okToQuit = new JConfirmDialog(this.frame, "Unsaved Changes", "Unsaved Changes! OK to discard them?", "Cancel", "Save", "Discard edits");
                this.okToQuit.setLocation(new Point(100, 100));
                JModularEditor jModularEditor = this;
                if (jModularEditor == null) {
                    throw null;
                }
                this.okToQuit.setActionListener(new ActionListener(jModularEditor){
                    private final /* synthetic */ JModularEditor this$0;

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = actionEvent.getActionCommand();
                        if (string.equals("Cancel")) {
                            JModularEditor.access$2(this.this$0, JModularEditor.access$1(this.this$0));
                            this.this$0.okToQuit.setVisible(false);
                            AntiDeadlock.sleep(30L);
                        } else if (string.equals("Save")) {
                            JModularEditor.access$2(this.this$0, JModularEditor.access$3(this.this$0));
                            this.this$0.doSaveFile(null);
                            this.this$0.okToQuit.setVisible(false);
                            AntiDeadlock.sleep(30L);
                        } else if (string.equals("Discard edits")) {
                            JModularEditor.access$2(this.this$0, JModularEditor.access$4(this.this$0));
                            this.this$0.okToQuit.setVisible(false);
                            AntiDeadlock.sleep(30L);
                        }
                    }
                    {
                        this.this$0 = jModularEditor;
                        this.constructor$0(jModularEditor);
                    }

                    private final void constructor$0(JModularEditor jModularEditor) {
                    }
                });
                this.okToQuit.pack();
                this.okToQuit.setModal(true);
            }
            this.okToQuit.show();
        } else {
            this.answer = this.QUIT;
        }
        return this.answer;
    }

    public void doQuit(Object object) {
        this.answer = this.checkUnsavedChanges();
        if (this.answer == this.CANCEL) {
            return;
        }
        if (this.answer == this.SAVE) {
            this.doSaveFile(null);
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String string = System.getProperty("user.home") + File.separator + ".jfig-recent-files";
            this.recentFileManager.saveToFile(string);
        }
        catch (SecurityException securityException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = SetupManager.getBoolean("jfig.exitOnClose", true);
        if (bl) {
            System.exit(0);
        } else {
            this.getFrame().setVisible(false);
        }
    }

    public void doSaveFile(Object object) {
        this.doCancel(null);
        try {
            if (this.filename == null || this.filetype == null || this.filetype != "FILE") {
                this.doSelectOutputFile();
                if (this.filename == null) {
                    return;
                }
            }
            this.tmpfilename = this.filename;
            this.tmpfiletype = "FILE";
            if (this.isSaveFileEnabled()) {
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.filename)));
                this.writer.write_fig31_file(dataOutputStream, true, this.objectList);
                dataOutputStream.flush();
                dataOutputStream.close();
                this.clearUndoStack();
                this.message("-I- wrote FIG file " + this.filename);
                this.statusMessage("wrote FIG file: " + this.filename);
            } else {
                this.message("-W- could not write FIG file, save is disabled!");
                this.statusMessage("WARNING: save file is disabled!");
            }
            ++this.n_saves;
            this.checkRegistrationReminder();
        }
        catch (Exception exception) {
            this.message("-E- Editor: got an Exception in doSaveFile: " + exception);
            this.message("-W- Please check the file name and try again!");
        }
    }

    public void doSaveFileAs(Object object) {
        this.doSelectOutputFile();
        this.doSaveFile(null);
        this.statusPanel.setFilename(this.filename);
    }

    public void doSelectOutputFile() {
        try {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
            }
            this.setCurrentFigDirectory(this.fileChooser);
            this.fileChooser.setDialogTitle("Save FIG file:");
            int n = this.fileChooser.showSaveDialog(this.frame);
            if (n == 0) {
                File file = this.fileChooser.getSelectedFile();
                String string = file.getPath();
                this.dbg("-#- JME.doSaveFileAs: " + string);
                String string2 = file.getParent();
                this.updateCurrentFigDirectory(string2);
                this.filename = string;
                this.filetype = "FILE";
            }
        }
        catch (Exception exception) {
            this.message("-E- internal error in doSelectOutputFile: " + exception);
            this.filename = null;
            this.filetype = "FILE";
        }
    }

    public boolean isSaveFileEnabled() {
        return this.saveFileEnable;
    }

    public void setSaveFileEnable(boolean bl) {
        this.saveFileEnable = bl;
    }

    public String getFilename() {
        return this.filename;
    }

    private void clearUndoStack() {
        this.undoStack = new UndoStack();
        this.undoStack.setMenuItems(this.editorMenuBar.getUndoMenuItem(), this.editorMenuBar.getRedoMenuItem());
    }

    public void doSaveToConsole(Object object) {
        this.statusMessage("Writing figure to internal buffer --- please wait...");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.writer.write_fig31_file(dataOutputStream, true, this.objectList);
        JConsole jConsole = new JConsole("FIG: " + this.getBaseFileName());
        jConsole.setIconImage(this.frame.getIconImage());
        jConsole.setText(byteArrayOutputStream.toString());
        this.activeFrames.put(jConsole, jConsole);
        this.statusMessage("Wrote FIG file to console window");
    }

    public void writeFigObjects(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.writer.write_fig31_file(dataOutputStream, true, this.objectList);
        dataOutputStream.flush();
        dataOutputStream.close();
    }

    public void doPrintViaAWT(Object object) {
        this.statusMessage("Select print options...");
        PrintManager printManager = new PrintManager(this.frame, this.objectCanvas);
        String string = this.getBaseFileName();
        printManager.setBannerString("jfig " + string);
        this.statusMessage("Printing, please wait...");
        printManager.doPrint();
        this.statusMessage("Printed " + string);
    }

    public String getBaseFileName() {
        int n = 0;
        String string = this.filename == null ? "noname.fig" : (this.filetype == "FILE" ? ((n = this.filename.lastIndexOf(System.getProperty("file.separator"))) > 0 ? this.filename.substring(n + 1, this.filename.length()) : this.filename) : (this.filetype == "URL" ? ((n = this.filename.lastIndexOf(47)) > 0 ? this.filename.substring(n + 1, this.filename.length()) : this.filename) : ((n = this.filename.lastIndexOf(47)) > 0 ? this.filename.substring(n + 1, this.filename.length()) : this.filename)));
        return string;
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        this.dbg("-#- JModularEditor.mousePressed(FigCanvasEvent): " + figCanvasEvent);
        if (this.command != null && !this.command.isReady()) {
            this.command.mousePressed(figCanvasEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.dbg("-I- JModularEditor: keyPressed()..." + keyEvent);
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        if (c == '\u001b' || n == 27) {
            this.dbg("-W- got an ESCAPE key...");
            this.doCancel(null);
            return;
        }
        if (this.command instanceof CreateTextCommand) {
            CreateTextCommand createTextCommand = (CreateTextCommand)this.command;
            if (keyEvent.isActionKey()) {
                switch (n) {
                    case 37: {
                        createTextCommand.keyTyped(keyEvent);
                        break;
                    }
                    case 39: {
                        createTextCommand.keyTyped(keyEvent);
                        break;
                    }
                }
            } else {
                this.dbg("-#- JModularEditor.keyPressed.CTC.normalKey: <" + c + "/" + n + ">");
                if (enableWindowsWorkarounds && n == 127) {
                    createTextCommand.keyTyped(keyEvent);
                }
            }
        } else if (keyEvent.isActionKey()) {
            boolean bl = keyEvent.isShiftDown();
            switch (n) {
                case 40: {
                    this.doPanDown(keyEvent);
                    break;
                }
                case 38: {
                    this.doPanUp(keyEvent);
                    break;
                }
                case 37: {
                    this.doPanLeft(keyEvent);
                    break;
                }
                case 39: {
                    this.doPanRight(keyEvent);
                    break;
                }
                case 36: {
                    this.doPanHome(keyEvent);
                    break;
                }
                case 34: {
                    this.doBrowseOpenNextFile();
                    break;
                }
                case 33: {
                    this.doBrowseOpenPreviousFile();
                    break;
                }
                default: {
                    this.message("-I- Unhandled action key: " + c);
                    break;
                }
            }
        } else if (keyEvent.isActionKey()) {
            this.keyHandler.keyPressed(keyEvent);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.dbg("-I- JModularEditor: keyTyped()..." + keyEvent);
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        if (c == '\u001b' || n == 27) {
            this.dbg("-W- got an ESCAPE key...");
            this.doCancel(null);
            return;
        }
        if (this.command instanceof CreateTextCommand) {
            ((CreateTextCommand)this.command).keyTyped(keyEvent);
        } else {
            this.keyHandler.keyPressed(keyEvent);
        }
    }

    public void statusMessage(String string) {
        this.statusField.setStatusMessage(string);
    }

    public void setInitialWindowSize() {
        int n = SetupManager.getInteger("jfig.gui.Editor.WindowWidth", 800);
        int n2 = SetupManager.getInteger("jfig.gui.Editor.WindowHeight", 600);
        this.frame.setSize(new Dimension(n, n2));
    }

    public JMenuBar getMenuBar() {
        return this.editorMenuBar.getJMenuBar();
    }

    public void checkCreateMouseWheelZoomPanHandler() {
        boolean bl = FigAttribs.enableJava2D && SetupManager.getBoolean("jfig.gui.Editor.MouseWheelPanning", false);
        try {
            Class<?> clazz = Class.forName("jfig.gui.MouseWheelZoomPanHandler");
            Class[] classArray = new Class[]{class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = JModularEditor.class$("java.lang.Object")), class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = JModularEditor.class$("java.lang.Object"))};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this, this.objectCanvas};
            Object obj = constructor.newInstance(objectArray);
            this.mouseWheelZoomPanHandler = obj;
            this.enableMouseWheelZoomPanHandler(bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void enableMouseWheelZoomPanHandler(boolean bl) {
        if (this.mouseWheelZoomPanHandler == null) {
            return;
        }
        Object object = this.mouseWheelZoomPanHandler;
        try {
            Class[] classArray = new Class[]{class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = JModularEditor.class$("java.lang.Boolean"))};
            Object[] objectArray = new Object[]{new Boolean(bl)};
            Method method = object.getClass().getMethod("setEnabled", classArray);
            method.invoke(object, objectArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void hideAllTriggers() {
        Enumeration enumeration = this.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof FigTrigger)) continue;
            ((FigTrigger)e).setVisible(false);
        }
        this.objectCanvas.doFullRedraw();
    }

    public void showAllTriggers() {
        Enumeration enumeration = this.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof FigTrigger)) continue;
            ((FigTrigger)e).setVisible(true);
        }
        this.objectCanvas.doFullRedraw();
    }

    public Enumeration getDrawableObjects() {
        return this.objectList.elements();
    }

    public FigDrawable getTmpObject() {
        return this.tmpObject;
    }

    public void message(String string) {
        if (this.console != null) {
            this.console.message(string);
        } else {
            System.out.println(string);
        }
    }

    public void msg(String string) {
        System.out.println(string);
    }

    public void dbg(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public ModularEditorState getEditorState() {
        ModularEditorState modularEditorState = new ModularEditorState();
        modularEditorState.objectList = this.objectList;
        modularEditorState.attribs = this.getCurrentAttribs().getClone();
        modularEditorState.filename = this.filename;
        modularEditorState.filetype = this.filetype;
        modularEditorState.tmpfilename = this.tmpfilename;
        modularEditorState.tmpfiletype = this.tmpfiletype;
        return modularEditorState;
    }

    public void setEditorState(ModularEditorState modularEditorState) {
        this.filename = modularEditorState.filename;
        this.filetype = modularEditorState.filetype;
        this.tmpfilename = modularEditorState.tmpfilename;
        this.tmpfiletype = modularEditorState.tmpfiletype;
        this.setCurrentAttribs(modularEditorState.attribs);
        this.objectList = modularEditorState.objectList;
        this.statusPanel.setFilename(this.filename);
    }

    public void clearEditorState() {
        this.filename = null;
        this.filetype = "FILE";
        this.tmpfilename = null;
        this.tmpfiletype = "FILE";
        this.statusPanel.setFilename("no file");
        this.objectList = new FigObjectList();
        this.clearUndoStack();
    }

    public void doPrintUndoStack(Object object) {
        this.message(this.undoStack.toString());
    }

    public void doPrintClipboard(Object object) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            this.message(string);
        }
        catch (Exception exception) {
            this.message("-E- Clipboard empty (or not supported)");
        }
    }

    public void doPrintObjects(Object object) {
        this.message("-I- the current objects: ");
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            this.message("" + enumeration.nextElement().toString());
        }
    }

    public void doShowMessages(Object object) {
        if (this.console != null) {
            this.console.setVisible(true);
            this.console.toFront();
        }
    }

    public void doShowProperties(Object object) {
        JPropertiesViewer jPropertiesViewer = new JPropertiesViewer(null);
        jPropertiesViewer.setTitle("jfig global/user/local properties");
        jPropertiesViewer.setIconImage(this.frame.getIconImage());
        jPropertiesViewer.setProperties(SetupManager.getProperties());
        jPropertiesViewer.showProperties();
        jPropertiesViewer.show();
        this.activeFrames.put(jPropertiesViewer, jPropertiesViewer);
    }

    public void doShowAboutDialog(Object object) {
        if (this.aboutDialog == null) {
            this.aboutDialog = new JAboutDialog(this.frame, this.versionString);
            this.aboutDialog.pack();
        }
        this.aboutDialog.show();
    }

    public void doShowLicenseDialog(Object object) {
        String string = this.versionString + " License:";
        this.showTextViewer(string, 20, 80, "/jfig/doc/LICENSE");
    }

    public void doShowReminderDialog(Object object) {
        String string = this.versionString + " Registration Reminder:";
        String string2 = "/jfig/doc/reminder.txt";
        int n = 5000;
        long l = System.currentTimeMillis() - this.t_start;
        n = l > 1800000L ? 60000 : (l > 1200000L ? 40000 : 20000);
        JTextViewerDialog jTextViewerDialog = new JTextViewerDialog(this.getFrame(), 25, 80);
        jTextViewerDialog.parseResource(string2);
        jTextViewerDialog.setCaretPosition(0);
        jTextViewerDialog.setModal(true);
        jTextViewerDialog.setTimeoutToEnableClosing(n);
        jTextViewerDialog.show();
    }

    public void doShowRegistrationDialog(Object object) {
        String string = this.versionString + " Registration:";
        this.showTextViewer(string, 20, 80, "/jfig/doc/registration.txt");
    }

    public void doShowParticipateDialog(Object object) {
        String string = this.versionString + " how to participate";
        this.showTextViewer(string, 20, 80, "/jfig/doc/how-to-participate.txt");
    }

    public void doShowJvmDialog(Object object) {
        String string = this.versionString + " JVM compatibility:";
        this.showTextViewer(string, 20, 80, "/jfig/doc/jvm-compatibility.txt");
    }

    public void doShowChangesDialog(Object object) {
        String string = this.versionString + " Changes:";
        this.showTextViewer(string, 20, 80, "/jfig/doc/CHANGES");
    }

    public void doShowMouseButtonDialog(Object object) {
        String string = this.versionString + " buttons:";
        this.showTextViewer(string, 20, 80, "/jfig/doc/mouse-buttons.txt");
    }

    public void doShowShortcutKeysDialog(Object object) {
        String string = this.versionString + " shortcut keys:";
        this.showTextViewer(string, 20, 80, "/jfig/doc/shortcut-keys.txt");
    }

    public void doShowEmbeddingJfigDialog(Object object) {
        String string = this.versionString + " Embedding jfig FAQ:";
        this.showTextViewer(string, 20, 80, "/jfig/doc/embedding.txt");
    }

    public void doShowTexSupportDialog(Object object) {
        String string = this.versionString + " TeX and LaTeX support:";
        this.showTextViewer(string, 20, 80, "/jfig/doc/TeX-support.txt");
    }

    public void doShowFaqDialog(Object object) {
        String string = this.versionString + " FAQ:";
        this.showTextViewer(string, 20, 80, "/jfig/doc/FAQ");
    }

    public void doShowReadmeDialog(Object object) {
        String string = this.versionString + " help";
        this.showTextViewer(string, 20, 80, "/jfig/doc/README");
    }

    public void doShowPolylineHelpDialog(Object object) {
        String string = this.versionString + " help";
        this.showTextViewer(string, 20, 80, "/jfig/doc/creating-polylines.txt");
    }

    public void doShowExportFaqDialog(Object object) {
        String string = this.versionString + " export FAQ:";
        this.showTextViewer(string, 20, 80, "/jfig/doc/export-fig2dev.txt");
    }

    public void doShowHelpDialog(Object object) {
        String string = this.versionString + " help";
        this.showTextViewer(string, 20, 80, "/jfig/doc/help.txt");
    }

    private void showTextViewer(String string, int n, int n2, String string2) {
        JTextViewer jTextViewer = new JTextViewer(string, n, n2);
        jTextViewer.setIconImage(this.frame.getIconImage());
        jTextViewer.parseResource(string2);
        jTextViewer.setCaretPosition(0);
        jTextViewer.show();
        this.activeFrames.put(jTextViewer, jTextViewer);
    }

    public void doShowDemo(String string) {
        int n = this.checkUnsavedChanges();
        if (n == this.CANCEL) {
            this.statusMessage("Canceled!");
            return;
        }
        this.doParseResource(string);
    }

    public void doShowDemoGold(Object object) {
        this.doShowDemo("/jfig/examples/gold.fig");
    }

    public void doShowDemoHouse(Object object) {
        this.doShowDemo("/jfig/examples/house.fig");
    }

    public void doShowDemoWatch(Object object) {
        this.doShowDemo("/jfig/examples/watch.fig");
    }

    public void doShowDemoCircuit(Object object) {
        this.doShowDemo("/jfig/examples/circuit.fig");
    }

    public void doShowDemoBiohazard(Object object) {
        this.doShowDemo("/jfig/examples/biohazard.fig");
    }

    public void doShowDemoLayout(Object object) {
        this.doShowDemo("/jfig/examples/layout.fig");
    }

    public void doShowDemoPictures(Object object) {
        this.doShowDemo("/jfig/examples/pictures.fig");
    }

    public void doShowDemoRotated(Object object) {
        this.doShowDemo("/jfig/examples/rotated.fig");
    }

    public void doShowDemoFonts(Object object) {
        this.doShowDemo("/jfig/examples/font-menu.fig");
    }

    public void doShowDemoTeX(Object object) {
        this.doShowDemo("/jfig/examples/TeXdemo.fig");
    }

    public void doShowDemoUnicode(Object object) {
        this.doShowDemo("/jfig/examples/unicode.fig");
    }

    public void doShowDemoWelcome(Object object) {
        this.doShowDemo("/jfig/examples/welcome.fig");
    }

    private void checkRegistrationReminder() {
        boolean bl;
        if (RegistrationKeyManager.getRegistrationKeyManager().isValid()) {
            return;
        }
        long l = 600000L;
        long l2 = System.currentTimeMillis();
        long l3 = l2 - this.t_last_reminder;
        boolean bl2 = bl = l3 > l;
        if (bl && (this.n_saves > 10 || this.n_reads > 50 || this.n_operations > 200)) {
            this.t_last_reminder = l2;
            ++this.n_reminders;
            this.doShowReminderDialog(null);
        }
    }

    private boolean registered() {
        int n = SetupManager.getInteger("jfig.RegistrationCode", 0);
        return n != 0;
    }

    private void doProfiling() {
        this.msg("-#- doProfiling started...");
        AntiDeadlock.sleep(2000L);
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        int n = 0;
        while (n < 20) {
            System.out.println("    iteration= " + n);
            Point point = figTrafo2D.getAnchor();
            Point point2 = new Point(point.x + 5, point.y + 5);
            figTrafo2D.setAnchor(point2);
            Graphics graphics = this.objectCanvas.getComponent().getGraphics();
            ((FigSwingCanvas)this.objectCanvas).paintAllObjects(graphics);
            this.objectCanvas.paint(graphics);
            ++n;
        }
        System.exit(0);
    }

    public static void initializeSetupManagerProperties() {
        if (SetupManager.getProperty("jfig.gui.Editor.Icon") == null) {
            SetupManager.loadGlobalProperties("jfig/jfig.cnf");
            String string = "0000-0000-0000-0000-0000-0000";
            String string2 = SetupManager.getProperty("jfig.gui.Editor.RegistrationKey");
            if (!string.equals(string2)) {
                RegistrationKeyManager.getRegistrationKeyManager().setKey(string);
            }
            SetupManager.loadUserProperties("jfig.cnf");
            SetupManager.loadUserProperties(".jfigrc");
            RegistrationKeyManager.getRegistrationKeyManager().setKey(SetupManager.getProperty("jfig.gui.Editor.RegistrationKey"));
            if (RegistrationKeyManager.getRegistrationKeyManager().isValid()) {
                System.out.println("-I- Found a valid registration code...");
            }
            SetupManager.loadLocalProperties("jfig.cnf");
            SetupManager.loadLocalProperties(".jfigrc");
            SetupManager.setProperty("jfig.UseSwing", "true");
        }
    }

    public static void usage() {
        System.out.println("Usage: java jfig.gui.JModularEditor [options] [filename.fig]\nwhere options include:\n-help              print this help message and exit\n-v                 verbose error messages to stdout\n-vv                even more verbose error messages to stdout\n-awt               use AWT instead of Java2D object rendering\n-old               use FIG3.1 splines instead of FIG3.2 X-splines\n-profile           enable some profiling\nMany other settings can be selected or changed by properties\nin the .jfigrc configuration file(s). For more help, please start\nthe editor and read the online help pages.\nExample: java jfig.gui.JModularEditor -awt welcome.fig\n");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        String string = null;
        boolean bl = false;
        ExceptionTracer.setEnabled(false);
        JModularEditor.initializeSetupManagerProperties();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-help")) {
                JModularEditor.usage();
            } else if (stringArray[n].equals("-v")) {
                ExceptionTracer.setEnabled(true);
            } else if (stringArray[n].equals("-vv")) {
                ExceptionTracer.setEnabled(true);
                debug = true;
            } else if (stringArray[n].equals("-awt")) {
                SetupManager.setProperty("jfig.allowJava2D", "false");
                FigAttribs.enableJava2D = false;
            } else if (stringArray[n].equals("-old")) {
                SetupManager.setProperty("jfig.enableXSplines", "false");
            } else if (stringArray[n].equals("-profile")) {
                bl = true;
            } else {
                string = stringArray[n];
            }
            ++n;
        }
        String string2 = null;
        try {
            string2 = SetupManager.getProperty("jfig.LookAndFeelClassName", null);
            if (string2 != null) {
                UIManager.setLookAndFeel(string2);
            }
        }
        catch (Throwable throwable) {
            System.err.println("-W- could not set look&feel: " + string2);
            ExceptionTracer.trace(throwable);
        }
        JModularEditor jModularEditor = new JModularEditor();
        if (string != null) {
            try {
                String string3 = new File(string).getCanonicalPath();
                String string4 = new File(string3).getParent();
                jModularEditor.updateCurrentFigDirectory(string4);
                jModularEditor.doParseFile(string, false);
                if (bl) {
                    jModularEditor.doProfiling();
                }
            }
            catch (Exception exception) {
                jModularEditor.message("-E- could not find or parse file '" + string + "'");
            }
        }
    }

    static /* synthetic */ int access$0(JModularEditor jModularEditor) {
        return jModularEditor.answer;
    }

    static /* synthetic */ int access$1(JModularEditor jModularEditor) {
        return jModularEditor.CANCEL;
    }

    static /* synthetic */ void access$2(JModularEditor jModularEditor, int n) {
        jModularEditor.answer = n;
    }

    static /* synthetic */ int access$3(JModularEditor jModularEditor) {
        return jModularEditor.SAVE;
    }

    static /* synthetic */ int access$4(JModularEditor jModularEditor) {
        return jModularEditor.QUIT;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JModularEditor() {
        Object object;
        Object object2;
        this.FIG_31 = 31;
        this.FIG_32 = 32;
        this.TypeFILE = "FILE";
        this.TypeURL = "URL";
        this.TypeRESOURCE = "RESOURCE";
        this.dbg("JModularEditor init<> started...");
        this.t_last_reminder = this.t_start = System.currentTimeMillis();
        this.attribs = new FigAttribs();
        this.objectList = new FigObjectList();
        this.undoStack = new UndoStack();
        this.tmpObject = null;
        JModularEditor.initializeSetupManagerProperties();
        this.getDefaultFigVersion();
        this.dbg("... got the setup and properties...");
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("windows") >= 0) {
            enableWindowsWorkarounds = true;
            this.dbg("-I- Windows detected, Windows workarounds enabled...");
        } else if (string.indexOf("sunos") >= 0) {
            enableSolarisWorkarounds = true;
            this.dbg("-I- Solaris detected, Solaris workarounds enabled...");
        } else if (string.indexOf("linux") >= 0) {
            enableLinuxWorkarounds = true;
            this.dbg("-I- Linux detected, Linux workarounds enabled...");
        } else if (string.indexOf("netscape") >= 0) {
            enableNetscapeWorkarounds = true;
            this.dbg("-I- Netscape detected, Netscape workarounds enabled...");
        } else {
            this.dbg("-I- os.name: " + string);
        }
        this.console = JConsole.getConsole();
        this.parser = new FigParser();
        this.parser.setConsole(this.console);
        this.parser.addActionListener(this);
        this.writer = new FigWriter();
        this.displayTriggerFlag = false;
        this.filename = null;
        this.tmpfilename = null;
        this.frame = new JFrame(this.versionString);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setSize(new Dimension(100, 100));
        this.frame.getContentPane().setLayout(new BorderLayout());
        try {
            object2 = SetupManager.getColor("jfig.gui.Editor.BackgroundColor", null);
            if (object2 != null) {
                this.frame.setBackground((Color)object2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getDefaultFonts();
        if (this.menuFont != null) {
            this.frame.setFont(this.menuFont);
        }
        this.dbg("... frame constructed...");
        try {
            ImageHelper.setVisibleParent(this.frame);
            object2 = ImageHelper.loadResourceImage(SetupManager.getProperty("jfig.gui.Editor.Icon", "/jfig/images/icon.gif"));
            if (object2 != null) {
                this.frame.setIconImage((Image)object2);
            }
            if (object2 != null) {
                this.console.setIconImage(this.frame.getIconImage());
            }
            this.dbg("... ImageHelper initialized, got the icon");
        }
        catch (Throwable throwable) {
            this.message("failed to load the editor icon, sorry!");
        }
        this.statusPanel = new JEditorStatusPanel();
        this.statusField = this.statusPanel.getStatusMessage();
        this.attribsButtonPanel = new JAttribsButtonPanel(this, this.statusField, this.attribs);
        this.attribsButtonPanel.showCreatePolylineControls();
        this.modeButtonPanel = new JModeButtonPanel(this.statusField);
        this.editorMenuBar = new JEditorMenuBar();
        this.objectCanvas = new FigSwingCanvas();
        this.layerManager = new JLayerManager();
        this.layerManager.setEditor(this);
        this.layerManager.setEditorLayerButton(this.attribsButtonPanel.depthButton);
        this.objectCanvas.setConsole(this.console);
        this.dbg("... objectCanvas and GUI components initialized...");
        this.parser.setStatusMessage(this.statusField);
        this.parser.setObjectPainter(this.objectCanvas);
        this.undoStack.setMenuItems(this.editorMenuBar.getUndoMenuItem(), this.editorMenuBar.getRedoMenuItem());
        this.recentFileManager = new JRecentFileManager(4);
        this.editorMenuBar.setRecentFileManager(this.recentFileManager, this);
        int n = 0;
        while (n < this.recentFileManager.getSize()) {
            this.addCallback("RecentFile" + n, "doOpenRecentFile");
            ++n;
        }
        try {
            object = System.getProperty("user.home") + File.separator + ".jfig-recent-files";
            this.recentFileManager.loadFromFile((String)object);
        }
        catch (SecurityException securityException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.objectCanvas.setObjectEnumerator(this);
        this.objectCanvas.addCanvasListener(this);
        ((Component)((Object)this.objectCanvas)).addKeyListener(this);
        this.modeButtonPanel.addActionListener(this);
        this.attribsButtonPanel.addUpdateModeButtonListener(this);
        this.editorMenuBar.addActionListener(this);
        this.editorMenuBar.addItemListener(this);
        this.editorMenuBar.setFigVersion(this.attribs.figVersion, this);
        this.editorMenuBar.addExportListener(this);
        JModularEditor jModularEditor = this;
        if (jModularEditor == null) {
            throw null;
        }
        this.frame.addWindowListener(new WindowAdapter(jModularEditor){
            private final /* synthetic */ JModularEditor this$0;

            public void windowClosing(WindowEvent windowEvent) {
                this.this$0.doQuit(null);
            }
            {
                this.this$0 = jModularEditor;
                this.constructor$0(jModularEditor);
            }

            private final void constructor$0(JModularEditor jModularEditor) {
            }
        });
        this.dbg("... EventListeners for objectCanvas and frame ok...");
        this.attribs = this.attribsButtonPanel.getValues(this.attribs);
        this.objectCanvas.getTrafo().setSnapRelative(3);
        this.objectCanvas.requestAntiAliasing(this.editorMenuBar.antialiasMI.getState());
        this.objectCanvas.requestRenderQuality(this.editorMenuBar.qualityMI.getState());
        this.frame.getContentPane().add("North", this.statusPanel);
        this.frame.getContentPane().add("West", this.modeButtonPanel);
        this.frame.getContentPane().add("East", this.layerManager.getPanel());
        this.layerManager.getPanel().setVisible(SetupManager.getBoolean("jfig.showLayerManager", true));
        if (SetupManager.getBoolean("jfig.gui.Editor.AttribsScrollPaneEnable", false)) {
            object = new ScrollPane();
            ((Component)object).setSize(300, 60);
            ((Container)object).add(this.attribsButtonPanel);
            this.frame.getContentPane().add("South", (Component)object);
        } else {
            this.frame.getContentPane().add("South", this.attribsButtonPanel);
        }
        this.frame.getContentPane().add("Center", (Component)((Object)this.objectCanvas));
        this.frame.setJMenuBar(this.editorMenuBar.getJMenuBar());
        this.keyHandler = new KeyHandler(this);
        boolean bl = SetupManager.getBoolean("jfig.gui.Editor.EnableToolTipManager", true);
        ToolTipManager.sharedInstance().setEnabled(bl);
        ToolTipManager.sharedInstance().setInitialDelay(1000);
        if (!bl) {
            this.msg("-I- disabled the Swing ToolTipManager...");
        }
        this.checkCreateMouseWheelZoomPanHandler();
        this.activeFrames = new Hashtable();
        this.activeFrames.put(this.frame, this.frame);
        this.activeFrames.put(this.console, this);
        this.setInitialWindowSize();
        this.statusMessage("Ready. Please select a command.");
        this.getUserPreferences();
        this.dbg("... frame validated, init<> ok.");
        this.frame.validate();
        this.frame.setVisible(true);
    }

    static {
        int n = 0;
        while (n < _callbackArray.length) {
            _callbackTable.put(_callbackArray[n][0], _callbackArray[n][1]);
            ++n;
        }
        demoURL = "http://tech-www.informatik.uni-hamburg.de/applets/jfig/examples/houseA.fig";
    }

    class UrlDialogListener
    implements ActionListener {
        boolean merge = false;

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Cancel")) {
                JModularEditor.this.getUrlDialog.setVisible(false);
            } else if (string.equals("OK")) {
                String string2 = JModularEditor.this.getUrlDialog.getText();
                JModularEditor.this.getUrlDialog.setVisible(false);
                JModularEditor.this.doParseURL(string2, this.merge);
            }
        }

        UrlDialogListener(boolean bl) {
            this.merge = bl;
        }
    }
}

