/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import jfig.gui.FontCache;
import jfig.gui.ImageHelper;
import jfig.utils.RegistrationKeyManager;
import jfig.utils.SetupManager;

public class JFontConfigurationDialog
extends JDialog
implements ActionListener {
    static RenderingHints hints = null;
    boolean debug = false;
    Image[] fontIconImages;
    Font[] availableFonts;
    Font[] scaledFonts;
    String[] psFontNames;
    float[] psFontMetrics;
    String qbf = "The quick brown fox jumps over the lazy dog.";
    JLabel[] fontNameLabels;
    JComboBox[] fontComboBoxes;
    JLabel[] widthLabels;
    JButton cancelButton;
    JButton applyButton;
    JPanel mainPanel;
    JPanel labelPanel;
    JPanel comboPanel;
    JPanel buttonPanel;
    JPanel deltaPanel;
    JScrollPane scroller;

    public void createRenderingHints() {
        hints = new RenderingHints(null);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public void loadFontIconImages() {
        try {
            Image image = ImageHelper.loadResourceImage("/jfig/images/fontmenu.gif");
            this.fontIconImages = new Image[35];
            int n = 0;
            while (n < this.fontIconImages.length) {
                this.fontIconImages[n] = ImageHelper.createImage(220, 20);
                Graphics graphics = this.fontIconImages[n].getGraphics();
                graphics.setColor(Color.yellow);
                graphics.fillRect(0, 0, 221, 21);
                int n2 = n + 1;
                int n3 = (n2 & 1) * 220;
                int n4 = (n2 >>> 1) * 20;
                if (image != null) {
                    graphics.drawImage(image, 0, 0, 220, 20, n3, n4, n3 + 220, n4 + 20, null);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.err.println("-#- internal error: " + exception);
            exception.printStackTrace();
        }
    }

    public void listAllFonts() {
        try {
            this.availableFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            JFontConfigurationDialog.msg("-I- found " + this.availableFonts.length + " fonts:");
            int n = 0;
            while (n < this.availableFonts.length) {
                Font font = this.availableFonts[n];
                JFontConfigurationDialog.msg("font_" + n + ": name= " + font.getFontName());
                ++n;
            }
            this.scaledFonts = new Font[this.availableFonts.length];
            n = 0;
            while (n < this.availableFonts.length) {
                this.scaledFonts[n] = this.availableFonts[n].deriveFont(12.0f);
                ++n;
            }
            JFontConfigurationDialog.msg("-I- scaled fonts ok.");
        }
        catch (Throwable throwable) {
            JFontConfigurationDialog.msg("-E- internal error in listAllFonts: " + throwable);
            throwable.printStackTrace();
        }
    }

    public void buildGUI() {
        int n;
        Object object;
        JFontConfigurationDialog.msg("-I- creating the GUI components...");
        int n2 = this.psFontNames.length;
        this.labelPanel = new JPanel(new GridLayout(n2 + 1, 0, 2, 2));
        this.labelPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.labelPanel.add(new JLabel("FIG font names:", 0));
        this.fontNameLabels = new JLabel[n2];
        int n3 = 0;
        while (n3 < n2) {
            object = this.psFontNames[n3];
            if (this.fontIconImages[n3] != null) {
                this.fontNameLabels[n3] = new JLabel(new ImageIcon(this.fontIconImages[n3]));
                this.fontNameLabels[n3].setBackground(new Color(223, 223, 223));
                this.fontNameLabels[n3].setOpaque(true);
            } else {
                this.fontNameLabels[n3] = new JLabel((String)object, 4);
            }
            this.labelPanel.add(this.fontNameLabels[n3]);
            ++n3;
        }
        this.comboPanel = new JPanel(new GridLayout(n2 + 1, 0, 2, 2));
        this.comboPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.comboPanel.add(new JLabel("Available fonts:", 2));
        this.fontComboBoxes = new JComboBox[n2];
        n3 = 0;
        while (n3 < n2) {
            JFontConfigurationDialog jFontConfigurationDialog = this;
            if (jFontConfigurationDialog == null) {
                throw null;
            }
            object = jFontConfigurationDialog.new AntiAliasComboBox();
            ((JComponent)object).setFont(this.scaledFonts[n3]);
            n = 0;
            while (n < this.availableFonts.length) {
                ((JComboBox)object).addItem(this.availableFonts[n].getName());
                ++n;
            }
            JFontConfigurationDialog jFontConfigurationDialog2 = this;
            if (jFontConfigurationDialog2 == null) {
                throw null;
            }
            ((JComboBox)object).setRenderer(jFontConfigurationDialog2.new ComboBoxRenderer());
            ((JComboBox)object).setMaximumRowCount(12);
            ((JComboBox)object).setSelectedIndex(n3);
            ((JComponent)object).setToolTipText(this.availableFonts[n3].getFontName());
            JFontConfigurationDialog jFontConfigurationDialog3 = this;
            if (jFontConfigurationDialog3 == null) {
                throw null;
            }
            ((JComboBox)object).addItemListener(jFontConfigurationDialog3.new FontChanger((JComboBox)object, n3));
            this.comboPanel.add((Component)object);
            this.fontComboBoxes[n3] = object;
            ++n3;
        }
        String string = "width of selected vs. Postscript font, ideally 1.00";
        object = new JLabel("Width ratio", 2);
        ((JComponent)object).setToolTipText(string);
        this.deltaPanel = new JPanel(new GridLayout(n2 + 1, 0, 2, 2));
        this.deltaPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.deltaPanel.add((Component)object);
        this.widthLabels = new JLabel[n2];
        n = 0;
        while (n < n2) {
            this.widthLabels[n] = new JLabel("0000.0%", 2);
            this.widthLabels[n].setToolTipText(string);
            this.deltaPanel.add(this.widthLabels[n]);
            ++n;
        }
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add("West", this.labelPanel);
        this.mainPanel.add("Center", this.comboPanel);
        this.mainPanel.add("East", this.deltaPanel);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setToolTipText("Close this dialog window");
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.applyButton.setToolTipText("Apply selected font mapping to jfig");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(1));
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.applyButton);
        this.scroller = new JScrollPane(this.mainPanel);
        this.getContentPane().add("Center", this.scroller);
        this.getContentPane().add("South", this.buttonPanel);
        this.pack();
        this.setDefaultCloseOperation(2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.cancelButton.equals(object)) {
            this.dispose();
        } else if (this.applyButton.equals(object)) {
            this.doApplySelectedMapping();
        } else {
            JFontConfigurationDialog.msg("-E- JFCD.actionPerformed: unknown event source: " + actionEvent);
        }
    }

    public float getFoxScaleFactor(int n) {
        int n2 = this.fontComboBoxes[n].getSelectedIndex();
        Graphics2D graphics2D = (Graphics2D)((Component)this).getGraphics();
        graphics2D.setRenderingHints(hints);
        Font font = this.scaledFonts[n2];
        Rectangle2D rectangle2D = font.getStringBounds(this.qbf, graphics2D.getFontRenderContext());
        float f = (float)rectangle2D.getWidth();
        float f2 = this.psFontMetrics[n] * 28.346457f;
        return f / f2;
    }

    public float getFoxScaleFactor1(int n) {
        int n2 = this.fontComboBoxes[n].getSelectedIndex();
        Graphics graphics = ((Component)this).getGraphics();
        Font font = this.scaledFonts[n2];
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        float f = fontMetrics.stringWidth(this.qbf);
        float f2 = this.psFontMetrics[n] * 28.346457f;
        return f / f2;
    }

    public void doApplySelectedMapping() {
        JFontConfigurationDialog.msg("-E_ doApplySelectedMapping NOT YET!!!");
        int n = this.psFontNames.length;
        int n2 = 0;
        while (n2 < n) {
            System.out.print("" + n2 + " " + this.psFontNames[n2] + "   ->   ");
            int n3 = this.fontComboBoxes[n2].getSelectedIndex();
            System.out.print(this.availableFonts[n3].getFontName());
            System.out.println();
            String string = FontCache.defaultFontMapping[n2][0];
            String string2 = this.availableFonts[n3].getFontName();
            SetupManager.setProperty(string, string2);
            ++n2;
        }
        FontCache.getFontCache().flushFontCache();
        FontCache.getFontCache().initializeFontDescriptions();
        FontCache.getFontCache().parseFontDescriptions();
    }

    public void doInitializeFontMappingFromFontCache() {
        int n = this.psFontNames.length;
        int n2 = 0;
        while (n2 < n) {
            Font font = FontCache.getFontCache().getFont(n2, 12);
            String string = font.getFontName();
            System.out.print("" + n2 + " " + this.psFontNames[n2] + " / " + string + " / ");
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.availableFonts.length) {
                String string2 = this.availableFonts[n4].getFontName();
                if (string2.equals(string)) {
                    n3 = n4;
                }
                ++n4;
            }
            System.out.println("match=" + n3);
            if (n3 != -1) {
                this.fontComboBoxes[n2].setSelectedIndex(n3);
            }
            ++n2;
        }
    }

    public static void msg(String string) {
        System.out.println(string);
    }

    public static void usage() {
        JFontConfigurationDialog.msg("Usage: java jfig.gui.JFontConfigurationDialog regi-stra-tion-key");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length == 0) {
            JFontConfigurationDialog.usage();
        } else {
            object = RegistrationKeyManager.getRegistrationKeyManager();
            ((RegistrationKeyManager)object).setKey(stringArray[0]);
            if (!((RegistrationKeyManager)object).isValid()) {
                JFontConfigurationDialog.usage();
            }
        }
        object = new JFrame();
        JFontConfigurationDialog jFontConfigurationDialog = new JFontConfigurationDialog((Frame)object);
        jFontConfigurationDialog.setSize(800, 500);
        jFontConfigurationDialog.show();
    }

    public JFontConfigurationDialog(Frame frame) {
        super(frame);
        if (!RegistrationKeyManager.getRegistrationKeyManager().isValid()) {
            return;
        }
        this.createRenderingHints();
        this.loadFontIconImages();
        this.psFontNames = FontCache.postscriptFontNames;
        this.psFontMetrics = FontCache.postscriptFontMetrics;
        this.listAllFonts();
        this.buildGUI();
        this.doInitializeFontMappingFromFontCache();
    }

    class FontChanger
    implements ItemListener {
        JComboBox target;
        int index;

        public void itemStateChanged(ItemEvent itemEvent) {
            int n = this.target.getSelectedIndex();
            this.target.setFont(JFontConfigurationDialog.this.scaledFonts[n]);
            this.target.setToolTipText(JFontConfigurationDialog.this.scaledFonts[n].getFontName());
            JFontConfigurationDialog.this.widthLabels[this.index].setText("" + JFontConfigurationDialog.this.getFoxScaleFactor(this.index));
            if (JFontConfigurationDialog.this.debug) {
                System.out.println("### " + JFontConfigurationDialog.this.getFoxScaleFactor(this.index));
            }
        }

        public FontChanger(JComboBox jComboBox, int n) {
            this.target = jComboBox;
            this.index = n;
        }
    }

    class AntiAliasComboBox
    extends JComboBox {
        Random generator = new Random();
        Color[] colors = new Color[]{Color.white, new Color(240, 240, 240), new Color(250, 230, 220)};

        public void paintComponent(Graphics graphics) {
            JFontConfigurationDialog.msg("-#- AntiAliasComboBox: paintComponent: " + graphics);
            try {
                ((Graphics2D)graphics).setRenderingHints(hints);
                super.setBackground(this.colors[this.generator.nextInt(this.colors.length)]);
                super.paintComponent(graphics);
            }
            catch (Throwable throwable) {
                JFontConfigurationDialog.msg("-E- internal in AntiAliasComboBox.paintComponent: " + throwable);
            }
        }

        AntiAliasComboBox() {
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (n == -1) {
                n = jList.getSelectedIndex();
            }
            this.setFont(JFontConfigurationDialog.this.scaledFonts[n]);
            this.setText("\"" + JFontConfigurationDialog.this.scaledFonts[n].getName() + "\"");
            this.setAlignmentX(2.0f);
            return this;
        }

        public void paintComponent(Graphics graphics) {
            try {
                if (hints != null) {
                    ((Graphics2D)graphics).setRenderingHints(hints);
                }
                super.paintComponent(graphics);
            }
            catch (Throwable throwable) {
                JFontConfigurationDialog.msg("-E- internal in ComboBoxRenderer.paintComponent: " + throwable);
            }
        }

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }
    }
}

