/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jfig.gui.JStatusCanvas;
import jfig.gui.StatusMessage;
import jfig.utils.AntiDeadlock;
import jfig.utils.SetupManager;

public class JEditorStatusPanel
extends JPanel {
    ActionListener parent;
    JPanel leftPanel;
    JPanel messagePanel;
    JTextField filenameField;
    JTextField zoomField;
    JStatusCanvas messageField;

    public void setFilename(String string) {
        this.filenameField.setText(string);
    }

    public void setZoomMessage(String string) {
        this.zoomField.setText(string);
    }

    public void statusMessage(String string) {
        this.messageField.setStatusMessage(string);
    }

    public StatusMessage getStatusMessage() {
        return this.messageField;
    }

    public static void main(String[] stringArray) {
        System.out.println("JEditorStatusPanel selftest...");
        JFrame jFrame = new JFrame("JEditorStatusPanel");
        JEditorStatusPanel jEditorStatusPanel = new JEditorStatusPanel();
        jFrame.getContentPane().add("South", jEditorStatusPanel);
        jFrame.setSize(new Dimension(600, 300));
        jFrame.setVisible(true);
        int n = 0;
        while (n < 1000) {
            jEditorStatusPanel.setFilename("file_" + Math.random());
            jEditorStatusPanel.statusMessage("reactor temperature is " + 3000.0 * Math.random());
            AntiDeadlock.sleep(500L);
            ++n;
        }
    }

    public JEditorStatusPanel() {
        try {
            Color color = SetupManager.getColor("jfig.gui.Editor.BackgroundColor", null);
            if (color != null) {
                this.setBackground(color);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.filenameField = new JTextField("no filename", 20);
        this.filenameField.setEditable(false);
        this.filenameField.setBackground(this.getBackground());
        this.zoomField = new JTextField("  100%", 6);
        this.zoomField.setEditable(false);
        this.zoomField.setBackground(this.getBackground());
        this.messageField = new JStatusCanvas("status messages will appear here");
        this.leftPanel = new JPanel(new FlowLayout(0));
        this.leftPanel.setBackground(this.getBackground());
        this.leftPanel.add(this.filenameField);
        this.leftPanel.add(this.zoomField);
        this.messagePanel = new JPanel(new BorderLayout(2, 2));
        this.messagePanel.setBackground(this.getBackground());
        this.messagePanel.add("West", new JLabel(" "));
        this.messagePanel.add("Center", this.messageField);
        this.setLayout(new BorderLayout());
        this.add("West", this.leftPanel);
        this.add("Center", this.messagePanel);
    }
}

