/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jfig.canvas.FigCanvas;
import jfig.objects.FigXSpline;

public class JEditVertexDialog
extends JDialog
implements ActionListener,
ChangeListener {
    JSlider slider;
    JButton okButton;
    JButton approxButton;
    JButton interpButton;
    JButton cornerButton;
    FigCanvas canvas;
    FigXSpline xspline;
    int index;

    public void setXSpline(FigXSpline figXSpline) {
        this.xspline = figXSpline;
    }

    public void setVertexIndex(int n) {
        this.index = n;
        if (this.xspline != null) {
            double d = this.xspline.getSFactors()[n];
            this.slider.setValue((int)(d * 100.0));
        }
    }

    public void setPosition(Point point) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.okButton == object) {
            ((Component)this).setVisible(false);
        } else if (this.approxButton == object) {
            this.slider.setValue(100);
        } else if (this.interpButton == object) {
            this.slider.setValue(-100);
        } else if (this.cornerButton == object) {
            this.slider.setValue(0);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        double d = (double)this.slider.getValue() / 100.0;
        if (this.xspline != null) {
            this.xspline.getSFactors()[this.index] = d;
            this.xspline.rebuild();
            this.canvas.doFullRedraw();
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(300, 300);
        jFrame.show();
        JEditVertexDialog jEditVertexDialog = new JEditVertexDialog((Component)jFrame);
        jEditVertexDialog.setPosition(new Point(100, 200));
        jEditVertexDialog.show();
    }

    public JEditVertexDialog(Component component) {
        this.setTitle("x-spline parameter");
        if (component instanceof FigCanvas) {
            this.canvas = (FigCanvas)((Object)component);
        }
        this.approxButton = new JButton("approximated");
        this.interpButton = new JButton("interpolated");
        this.cornerButton = new JButton("angular");
        this.okButton = new JButton("OK");
        this.slider = new JSlider(0, -100, 100, 0);
        this.slider.addChangeListener(this);
        this.slider.setMajorTickSpacing(100);
        this.slider.setMinorTickSpacing(10);
        this.slider.setPaintTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(-100), new JLabel("-1.0"));
        hashtable.put(new Integer(100), new JLabel("1.0"));
        hashtable.put(new Integer(0), new JLabel("0.0"));
        this.slider.setLabelTable(hashtable);
        this.slider.setPaintLabels(true);
        this.approxButton.addActionListener(this);
        this.cornerButton.addActionListener(this);
        this.interpButton.addActionListener(this);
        this.okButton.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.okButton);
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        jPanel2.add(this.approxButton);
        jPanel2.add(this.cornerButton);
        jPanel2.add(this.interpButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("North", this.slider);
        this.getContentPane().add("Center", jPanel2);
        this.getContentPane().add("South", jPanel);
        this.pack();
        this.setDefaultCloseOperation(1);
    }
}

