/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import jfig.commands.FigBasicEditor;
import jfig.gui.ImageHelper;
import jfig.gui.JEditBaseobjectDialog;
import jfig.objects.FigAttribs;
import jfig.objects.FigRectangle;
import jfig.objects.FigTrigger;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class JEditTriggerDialog
extends JEditBaseobjectDialog
implements ActionListener,
KeyListener,
WindowListener {
    FigTrigger trigger;
    FigRectangle rectangle;

    public void setTriggerObject(FigTrigger figTrigger) {
        throw new Error("-E- JEditTriggerDialog NOT IMPLEMENTED YET!");
    }

    public JPanel buildLabelsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.lineColorLabel);
        jPanel.add(this.lineWidthLabel);
        jPanel.add(this.fillColorLabel);
        jPanel.add(this.depthLabel);
        jPanel.add(this.cornerRadiusLabel);
        return jPanel;
    }

    public JPanel buildAttribsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.buildLineColorPanel());
        jPanel.add(this.buildLineStylePanel());
        jPanel.add(this.buildFillStylePanel());
        jPanel.add(this.buildDepthPanel());
        jPanel.add(this.buildCornerRadiusPanel());
        this.dbg("-#- buildAttribsPanel ok.");
        return jPanel;
    }

    public void retrieveAttribs(FigAttribs figAttribs) {
        this.AC.setLineStyle(figAttribs, this.lineStyleButton);
        this.AC.setLineWidth(figAttribs, this.lineWidthButton);
        this.AC.setLineColor(figAttribs, this.lineColorButton);
        this.AC.setDashLength(figAttribs, this.dashLengthField);
        this.AC.setFillColor(figAttribs, this.fillColorButton);
        this.AC.setFillPattern(figAttribs, this.fillPatternButton);
        this.AC.setCornerRadius(figAttribs, this.cornerRadiusButton);
        this.AC.setDepth(figAttribs, this.depthButton);
        this.dbg("new attribs= " + figAttribs);
    }

    public void showAttribs(FigAttribs figAttribs) {
        this.AC.showLineStyle(figAttribs, this.lineStyleButton);
        this.AC.showLineWidth(figAttribs, this.lineWidthButton);
        this.AC.showLineColor(figAttribs, this.lineColorButton);
        this.AC.showDashLength(figAttribs, this.dashLengthField);
        this.AC.showFillColor(figAttribs, this.fillColorButton);
        this.AC.showFillPattern(figAttribs, this.fillPatternButton);
        this.AC.showCornerRadius(figAttribs, this.cornerRadiusButton);
        this.AC.showDepth(figAttribs, this.depthButton);
        this.dbg("existing attribs= " + figAttribs);
    }

    public void retrievePoints(FigRectangle figRectangle, JTextArea jTextArea) {
        Point[] pointArray = this.AC.getCoords(jTextArea.getText());
        if (pointArray != null) {
            figRectangle.setPoints(pointArray);
        }
    }

    public void restorePoints(FigRectangle figRectangle) {
        this.coordsTextArea.setText(this.savedCoords);
        this.retrievePoints(figRectangle, this.coordsTextArea);
    }

    public void doCancel() {
        this.dbg("-#- EditRectangleDialog.Cancel");
        this.rectangle.setAttributes(this.savedAttribs);
        this.restorePoints(this.rectangle);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public void doApply() {
        this.dbg("-#- EditRectangleDialog.Apply");
        this.retrieveAttribs(this.currentAttribs);
        this.rectangle.update(this.currentAttribs);
        this.retrievePoints(this.rectangle, this.coordsTextArea);
        this.editor.deleteFromObjectList(this.rectangle);
        this.editor.insertIntoObjectList(this.rectangle);
        this.doRedraw();
    }

    public void doOK() {
        this.dbg("-#- EditRectangleDialog.OK...");
        this.retrieveAttribs(this.currentAttribs);
        this.rectangle.update(this.currentAttribs);
        this.retrievePoints(this.rectangle, this.coordsTextArea);
        this.editor.deleteFromObjectList(this.rectangle);
        this.editor.insertIntoObjectList(this.rectangle);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public static void main(String[] stringArray) {
        ExceptionTracer.setEnabled(true);
        JFrame jFrame = new JFrame("dummy");
        jFrame.setSize(new Dimension(100, 100));
        ImageHelper.setVisibleParent(jFrame);
        SetupManager.loadAllProperties("jfig.cnf");
        JEditTriggerDialog jEditTriggerDialog = new JEditTriggerDialog((Frame)jFrame, null);
        jEditTriggerDialog.show();
    }

    public JEditTriggerDialog(Frame frame, FigBasicEditor figBasicEditor) {
        super(frame, figBasicEditor, "Edit rectangle");
    }
}

