/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jfig.commands.FigBasicEditor;
import jfig.gui.ImageHelper;
import jfig.gui.JEditBaseobjectDialog;
import jfig.gui.JStateButton;
import jfig.objects.FigAttribs;
import jfig.objects.FigText;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class JEditTextDialog
extends JEditBaseobjectDialog
implements ActionListener,
KeyListener,
WindowListener {
    JTextField textBasePointTF;
    JTextField textStringTF;
    JStateButton fontFlagsButton;
    FigText textObject;
    String savedText;

    public void setTextObject(FigText figText) {
        if (figText == null) {
            return;
        }
        this.textObject = figText;
        this.savedAttribs = figText.getAttributes().getClone();
        this.currentAttribs = figText.getAttributes();
        this.savedText = figText.getText();
        this.showAttribs(this.currentAttribs);
        this.AC.showCoords(figText.getPoints(), this.textBasePointTF);
        this.AC.showFontFlags(this.currentAttribs, this.fontFlagsButton);
        this.textStringTF.setText(figText.getText());
        this.savedCoords = this.textBasePointTF.getText();
    }

    public JPanel buildLabelsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 2));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.lineColorLabel);
        jPanel.add(this.depthLabel);
        jPanel.add(this.fontStyleLabel);
        jPanel.add(this.textAlignLabel);
        jPanel.add(new JLabel("FIG font flags: ", 4));
        jPanel.add(this.rotationAngleLabel);
        jPanel.add(new JLabel("text base point: ", 4));
        jPanel.add(new JLabel("text: ", 4));
        return jPanel;
    }

    public JPanel buildAttribsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 2));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.buildLineColorPanel());
        jPanel.add(this.buildDepthPanel());
        jPanel.add(this.buildFontSelectPanel());
        jPanel.add(this.buildTextAttributesPanel());
        jPanel.add(this.buildFontFlagsPanel());
        jPanel.add(this.buildRotationAnglePanel());
        jPanel.add(this.buildTextBasePointPanel());
        jPanel.add(new JPanel());
        this.dbg("-#- buildAttribsPanel ok.");
        return jPanel;
    }

    public JPanel buildFontFlagsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.fontFlagsButton = this.AC.createFontFlagButton(this);
        jPanel.add(this.fontFlagsButton);
        return jPanel;
    }

    public JPanel buildTextBasePointPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.textBasePointTF = new JTextField("(0,0)", 10);
        this.textBasePointTF.setToolTipText("text object position");
        jPanel.add(this.textBasePointTF);
        return jPanel;
    }

    public JPanel buildEditTextPanel() {
        this.textStringTF = new JTextField("text appears here", 40);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", this.textStringTF);
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        return jPanel;
    }

    public JPanel buildCoordsPanel() {
        return this.buildEditTextPanel();
    }

    public void retrieveAttribs(FigAttribs figAttribs) {
        this.AC.setLineColor(figAttribs, this.lineColorButton);
        this.AC.selectFont(figAttribs, this.fontSelectButton);
        this.AC.setFontSize(figAttribs, this.fontSizeButton);
        this.AC.setFontFlags(figAttribs, this.fontFlagsButton);
        this.AC.setTextAlignment(figAttribs, this.textAlignButton);
        this.AC.setDepth(figAttribs, this.depthButton);
        this.AC.setRotationAngle(figAttribs, this.rotationAngleButton);
        this.dbg("new attribs= " + figAttribs);
    }

    public void showAttribs(FigAttribs figAttribs) {
        this.AC.showLineColor(figAttribs, this.lineColorButton);
        this.AC.showFontName(figAttribs, this.fontSelectButton);
        this.AC.showFontSize(figAttribs, this.fontSizeButton);
        this.AC.showFontFlags(figAttribs, this.fontFlagsButton);
        this.AC.showTextAlignment(figAttribs, this.textAlignButton);
        this.AC.showDepth(figAttribs, this.depthButton);
        this.AC.showRotationAngle(figAttribs, this.rotationAngleButton);
        this.dbg("existing attribs= " + figAttribs);
    }

    public void retrievePoints(FigText figText, JTextField jTextField) {
        Point[] pointArray = this.AC.getCoords(jTextField.getText());
        if (pointArray != null) {
            figText.setPoints(pointArray);
        }
    }

    public void restorePoints(FigText figText) {
        this.textBasePointTF.setText(this.savedCoords);
        this.retrievePoints(figText, this.textBasePointTF);
    }

    public void setText(String string) {
        this.textStringTF.setText(string);
    }

    public String getText() {
        return this.textStringTF.getText();
    }

    public void doCancel() {
        this.dbg("-#- EditTextDialog.Cancel");
        this.textObject.setAttributes(this.savedAttribs);
        this.textObject.setText(this.savedText);
        this.restorePoints(this.textObject);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public void doApply() {
        this.dbg("-#- EditTextDialog.Apply");
        this.retrieveAttribs(this.currentAttribs);
        this.textObject.update(this.currentAttribs);
        this.textObject.setText(this.textStringTF.getText());
        this.retrievePoints(this.textObject, this.textBasePointTF);
        if (this.editor != null) {
            this.editor.deleteFromObjectList(this.textObject);
            this.editor.insertIntoObjectList(this.textObject);
        }
        this.doRedraw();
    }

    public void doOK() {
        this.dbg("-#- EditTextDialog.OK...");
        this.retrieveAttribs(this.currentAttribs);
        this.textObject.update(this.currentAttribs);
        this.textObject.setText(this.textStringTF.getText());
        this.retrievePoints(this.textObject, this.textBasePointTF);
        if (this.editor != null) {
            this.editor.deleteFromObjectList(this.textObject);
            this.editor.insertIntoObjectList(this.textObject);
        }
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public static void main(String[] stringArray) {
        ExceptionTracer.setEnabled(true);
        JFrame jFrame = new JFrame("dummy");
        jFrame.setSize(new Dimension(100, 100));
        ImageHelper.setVisibleParent(jFrame);
        SetupManager.loadAllProperties("jfig.cnf");
        JEditTextDialog jEditTextDialog = new JEditTextDialog((Frame)jFrame, null);
        jEditTextDialog.setTextObject(new FigText());
        jEditTextDialog.show();
    }

    public JEditTextDialog(Frame frame, FigBasicEditor figBasicEditor) {
        super(frame, figBasicEditor, "Edit text object");
    }
}

