/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import jfig.commands.FigBasicEditor;
import jfig.gui.ImageHelper;
import jfig.gui.JEditBaseobjectDialog;
import jfig.objects.FigAttribs;
import jfig.objects.FigPolyline;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class JEditPolylineDialog
extends JEditBaseobjectDialog
implements ActionListener,
KeyListener,
WindowListener {
    FigPolyline polyline;

    public void setPolyline(FigPolyline figPolyline) {
        if (figPolyline == null) {
            return;
        }
        this.polyline = figPolyline;
        this.savedAttribs = figPolyline.getAttributes().getClone();
        this.currentAttribs = figPolyline.getAttributes();
        this.showAttribs(this.currentAttribs);
        this.AC.showCoords(figPolyline.getPoints(), this.coordsTextArea);
        this.savedCoords = this.coordsTextArea.getText();
    }

    public JPanel buildLabelsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.lineColorLabel);
        jPanel.add(this.lineWidthLabel);
        jPanel.add(this.arrowModeLabel);
        jPanel.add(this.arrowFLabel);
        jPanel.add(this.arrowBLabel);
        jPanel.add(new JLabel(""));
        jPanel.add(this.fillColorLabel);
        jPanel.add(this.depthLabel);
        return jPanel;
    }

    public JPanel buildAttribsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.buildLineColorPanel());
        jPanel.add(this.buildLineStylePanel());
        jPanel.add(this.buildArrowModePanel());
        jPanel.add(this.buildFArrowPanel());
        jPanel.add(this.buildBArrowPanel());
        jPanel.add(new JLabel(""));
        jPanel.add(this.buildFillStylePanel());
        jPanel.add(this.buildDepthPanel());
        this.dbg("-#- buildAttribsPanel ok.");
        return jPanel;
    }

    public void retrieveAttribs(FigAttribs figAttribs) {
        this.AC.setLineStyle(figAttribs, this.lineStyleButton);
        this.AC.setLineWidth(figAttribs, this.lineWidthButton);
        this.AC.setLineColor(figAttribs, this.lineColorButton);
        this.AC.setDashLength(figAttribs, this.dashLengthField);
        this.AC.setArrowMode(figAttribs, this.arrowModeButton);
        this.AC.setArrowStyle(figAttribs, this.arrowStyleButton);
        this.AC.setFArrowWidth(figAttribs, this.f_arrowWidthField);
        this.AC.setFArrowLength(figAttribs, this.f_arrowLengthField);
        this.AC.setFArrowThickness(figAttribs, this.f_arrowThicknessField);
        this.AC.setBArrowWidth(figAttribs, this.b_arrowWidthField);
        this.AC.setBArrowLength(figAttribs, this.b_arrowLengthField);
        this.AC.setBArrowThickness(figAttribs, this.b_arrowThicknessField);
        this.AC.setFillColor(figAttribs, this.fillColorButton);
        this.AC.setFillPattern(figAttribs, this.fillPatternButton);
        this.AC.setDepth(figAttribs, this.depthButton);
        this.dbg("new attribs= " + figAttribs);
    }

    public void showAttribs(FigAttribs figAttribs) {
        this.AC.showLineStyle(figAttribs, this.lineStyleButton);
        this.AC.showLineWidth(figAttribs, this.lineWidthButton);
        this.AC.showLineColor(figAttribs, this.lineColorButton);
        this.AC.showDashLength(figAttribs, this.dashLengthField);
        this.AC.showArrowMode(figAttribs, this.arrowModeButton);
        this.AC.showArrowStyle(figAttribs, this.arrowStyleButton);
        this.AC.showFArrowWidth(figAttribs, this.f_arrowWidthField);
        this.AC.showFArrowLength(figAttribs, this.f_arrowLengthField);
        this.AC.showFArrowThickness(figAttribs, this.f_arrowThicknessField);
        this.AC.showBArrowWidth(figAttribs, this.b_arrowWidthField);
        this.AC.showBArrowLength(figAttribs, this.b_arrowLengthField);
        this.AC.showBArrowThickness(figAttribs, this.b_arrowThicknessField);
        this.AC.showFillColor(figAttribs, this.fillColorButton);
        this.AC.showFillPattern(figAttribs, this.fillPatternButton);
        this.AC.showDepth(figAttribs, this.depthButton);
        this.dbg("existing attribs= " + figAttribs);
    }

    public void retrievePoints(FigPolyline figPolyline, JTextArea jTextArea) {
        Point[] pointArray = this.AC.getCoords(jTextArea.getText());
        if (pointArray != null) {
            figPolyline.setPoints(pointArray);
        }
    }

    public void restorePoints(FigPolyline figPolyline) {
        this.coordsTextArea.setText(this.savedCoords);
        this.retrievePoints(figPolyline, this.coordsTextArea);
    }

    public void doCancel() {
        this.dbg("-#- EditPolylineDialog.Cancel");
        this.polyline.setAttributes(this.savedAttribs);
        this.restorePoints(this.polyline);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public void doApply() {
        this.dbg("-#- JEditPolylineDialog.Apply");
        this.retrieveAttribs(this.currentAttribs);
        this.polyline.update(this.currentAttribs);
        this.retrievePoints(this.polyline, this.coordsTextArea);
        this.editor.deleteFromObjectList(this.polyline);
        this.editor.insertIntoObjectList(this.polyline);
        this.doRedraw();
    }

    public void doOK() {
        this.dbg("-#- JEditPolylineDialog.OK...");
        this.retrieveAttribs(this.currentAttribs);
        this.polyline.update(this.currentAttribs);
        this.retrievePoints(this.polyline, this.coordsTextArea);
        this.editor.deleteFromObjectList(this.polyline);
        this.editor.insertIntoObjectList(this.polyline);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public static void main(String[] stringArray) {
        ExceptionTracer.setEnabled(true);
        JFrame jFrame = new JFrame("dummy");
        jFrame.setSize(new Dimension(100, 100));
        ImageHelper.setVisibleParent(jFrame);
        SetupManager.loadAllProperties("jfig.cnf");
        JEditPolylineDialog jEditPolylineDialog = new JEditPolylineDialog((Frame)jFrame, null);
        jEditPolylineDialog.setPolyline(new FigPolyline());
        jEditPolylineDialog.show();
    }

    public JEditPolylineDialog(Frame frame, FigBasicEditor figBasicEditor) {
        super(frame, figBasicEditor, "Edit polyline");
    }
}

