/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jfig.commands.FigBasicEditor;
import jfig.gui.ImageHelper;
import jfig.gui.JEditBaseobjectDialog;
import jfig.objects.FigAttribs;
import jfig.objects.FigImage;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class JEditImageDialog
extends JEditBaseobjectDialog
implements ActionListener,
KeyListener,
WindowListener,
ItemListener {
    FigImage imageObject;
    JTextField imageFilenameTF;
    JComboBox aspectRatioCB;
    String savedImageName;
    public final String FIT_TO_WIDTH;
    public final String FIT_TO_HEIGHT;
    public final String SELECTED_SIZE;

    public void setImageObject(FigImage figImage) {
        if (figImage == null) {
            return;
        }
        try {
            this.imageObject = figImage;
            this.savedAttribs = figImage.getAttributes().getClone();
            this.currentAttribs = figImage.getAttributes();
            this.showAttribs(this.currentAttribs);
            this.AC.showCoords(figImage.getPoints(), this.coordsTextArea);
            this.savedCoords = this.coordsTextArea.getText();
            this.savedImageName = figImage.getImageName();
            this.imageFilenameTF.setText(figImage.getImageName());
        }
        catch (Exception exception) {
            this.message("-E- EditImageDialog: " + exception);
            exception.printStackTrace();
        }
    }

    public JPanel buildLabelsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.lineColorLabel);
        jPanel.add(this.lineWidthLabel);
        jPanel.add(this.depthLabel);
        jPanel.add(new JLabel("Image file/URL: ", 4));
        jPanel.add(new JLabel("Aspect ratio: ", 4));
        return jPanel;
    }

    public JPanel buildAttribsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 5));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.buildLineColorPanel());
        jPanel.add(this.buildLineStylePanel());
        jPanel.add(this.buildDepthPanel());
        jPanel.add(this.buildImageFilenamePanel());
        jPanel.add(this.buildAspectRatioPanel());
        this.dbg("-#- buildAttribsPanel ok.");
        return jPanel;
    }

    public JPanel buildImageFilenamePanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.imageFilenameTF = new JTextField("hugo", 30);
        jPanel.add(this.imageFilenameTF);
        return jPanel;
    }

    public JPanel buildAspectRatioPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.aspectRatioCB = new JComboBox();
        this.aspectRatioCB.addItem("keep selected size");
        this.aspectRatioCB.addItem("fit to selected width");
        this.aspectRatioCB.addItem("fit to selected height");
        this.aspectRatioCB.setSelectedItem("keep selected size");
        this.aspectRatioCB.addItemListener(this);
        jPanel.add(this.aspectRatioCB);
        return jPanel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.dbg("-#- EditImageDialog.iSC: " + itemEvent);
        if (this.imageObject == null) {
            return;
        }
        int n = 0;
        String string = (String)this.aspectRatioCB.getSelectedItem();
        n = string.equals("fit to selected width") ? 13 : (string.equals("fit to selected height") ? 14 : 15);
        this.imageObject.updateAspectRatio(n);
        this.editor.doRedraw();
        this.AC.showCoords(this.imageObject.getPoints(), this.coordsTextArea);
    }

    public void retrieveAttribs(FigAttribs figAttribs) {
        this.AC.setLineStyle(figAttribs, this.lineStyleButton);
        this.AC.setLineWidth(figAttribs, this.lineWidthButton);
        this.AC.setDashLength(figAttribs, this.dashLengthField);
        this.AC.setLineColor(figAttribs, this.lineColorButton);
        this.AC.setDepth(figAttribs, this.depthButton);
        this.dbg("new attribs= " + figAttribs);
    }

    public void showAttribs(FigAttribs figAttribs) {
        this.AC.showLineStyle(figAttribs, this.lineStyleButton);
        this.AC.showLineWidth(figAttribs, this.lineWidthButton);
        this.AC.showDashLength(figAttribs, this.dashLengthField);
        this.AC.showLineColor(figAttribs, this.lineColorButton);
        this.AC.showDepth(figAttribs, this.depthButton);
        this.dbg("existing attribs= " + figAttribs);
    }

    public void retrievePoints(FigImage figImage, JTextArea jTextArea) {
        Point[] pointArray = this.AC.getCoords(jTextArea.getText());
        if (pointArray != null) {
            figImage.setPoints(pointArray);
        }
    }

    public void restorePoints(FigImage figImage) {
        this.coordsTextArea.setText(this.savedCoords);
        this.retrievePoints(figImage, this.coordsTextArea);
    }

    public void doApply() {
        this.dbg("-#- JEditImageDialog.Apply");
        this.retrieveAttribs(this.currentAttribs);
        this.imageObject.update(this.currentAttribs);
        this.imageObject.setImageName(this.imageFilenameTF.getText().trim());
        this.retrievePoints(this.imageObject, this.coordsTextArea);
        this.editor.deleteFromObjectList(this.imageObject);
        this.editor.insertIntoObjectList(this.imageObject);
        this.doRedraw();
    }

    public void doOK() {
        this.dbg("-#- JEditImageDialog.OK...");
        this.retrieveAttribs(this.currentAttribs);
        this.imageObject.update(this.currentAttribs);
        this.imageObject.setImageName(this.imageFilenameTF.getText().trim());
        this.retrievePoints(this.imageObject, this.coordsTextArea);
        this.editor.deleteFromObjectList(this.imageObject);
        this.editor.insertIntoObjectList(this.imageObject);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public static void main(String[] stringArray) {
        ExceptionTracer.setEnabled(true);
        JFrame jFrame = new JFrame("dummy");
        jFrame.setSize(new Dimension(100, 100));
        ImageHelper.setVisibleParent(jFrame);
        SetupManager.loadAllProperties("jfig.cnf");
        JEditImageDialog jEditImageDialog = new JEditImageDialog((Frame)jFrame, null);
        jEditImageDialog.setImageObject(new FigImage());
        jEditImageDialog.show();
    }

    public JEditImageDialog(Frame frame, FigBasicEditor figBasicEditor) {
        super(frame, figBasicEditor, "Edit image object");
        this.FIT_TO_WIDTH = "fit to selected width";
        this.FIT_TO_HEIGHT = "fit to selected height";
        this.SELECTED_SIZE = "keep selected size";
    }
}

