/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jfig.commands.FigBasicEditor;
import jfig.gui.ImageHelper;
import jfig.gui.JAttribsControlsFactory;
import jfig.gui.JColorButton;
import jfig.gui.JFillPatternButton;
import jfig.gui.JFontButton;
import jfig.gui.JNumericStateButton;
import jfig.gui.JStateButton;
import jfig.gui.StatusMessage;
import jfig.objects.FigAttribs;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class JEditBaseobjectDialog
extends JDialog
implements ActionListener,
KeyListener,
WindowListener {
    protected FigBasicEditor editor;
    protected FigAttribs savedAttribs;
    protected FigAttribs currentAttribs;
    protected String savedCoords;
    protected StatusMessage statusMessage;
    protected Font defaultFont;
    protected Color backgroundColor;
    protected boolean debug = false;
    protected JButton okButton;
    protected JButton applyButton;
    protected JButton cancelButton;
    protected JAttribsControlsFactory AC;
    protected JStateButton lineStyleButton;
    protected JStateButton lineWidthButton;
    protected JTextField dashLengthField;
    protected JColorButton lineColorButton;
    protected JStateButton arrowModeButton;
    protected JStateButton arrowStyleButton;
    protected JTextField f_arrowWidthField;
    protected JTextField f_arrowLengthField;
    protected JTextField f_arrowThicknessField;
    protected JTextField b_arrowWidthField;
    protected JTextField b_arrowLengthField;
    protected JTextField b_arrowThicknessField;
    protected JColorButton fillColorButton;
    protected JFillPatternButton fillPatternButton;
    protected JNumericStateButton depthButton;
    protected JFontButton fontSelectButton;
    protected JNumericStateButton fontSizeButton;
    protected JStateButton textAlignButton;
    protected JNumericStateButton cornerRadiusButton;
    protected JNumericStateButton rotationAngleButton;
    protected JComboBox landscapePortraitChoice;
    protected JComboBox centerFlushLeftChoice;
    protected JTextArea coordsTextArea;
    protected JScrollPane coordsScroller;
    protected JLabel lineStyleLabel;
    protected JLabel lineWidthLabel;
    protected JLabel lineColorLabel;
    protected JLabel arrowModeLabel;
    protected JLabel arrowStyleLabel;
    protected JLabel arrowFLabel;
    protected JLabel arrowBLabel;
    protected JLabel fillColorLabel;
    protected JLabel fontStyleLabel;
    protected JLabel textAlignLabel;
    protected JLabel cornerRadiusLabel;
    protected JLabel depthLabel;
    protected JLabel landscapeLabel;
    protected JLabel rotationAngleLabel;

    public void setAttributes(FigAttribs figAttribs) {
        if (figAttribs == null) {
            System.out.println("-E- JEditBaseobjectDialog.setAttributes: null argument!");
            return;
        }
        this.savedAttribs = figAttribs.getClone();
        this.currentAttribs = figAttribs;
        this.showAttribs(this.currentAttribs);
    }

    public void getGUIDefaults() {
        String string = SetupManager.getProperty("jfig.gui.EditDialog.FontName", "SansSerif");
        int n = SetupManager.getInteger("jfig.gui.EditDialog.FontSize", 12);
        int n2 = 0;
        this.defaultFont = new Font(string, n2, n);
        this.backgroundColor = SetupManager.getColor("jfig.gui.EditDialog.BackgroundColor", Color.lightGray);
        if (this.defaultFont != null) {
            this.setFont(this.defaultFont);
        }
        if (this.backgroundColor != null) {
            this.setBackground(this.backgroundColor);
        }
    }

    public JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new FlowLayout(1));
        this.okButton = new JButton("OK");
        this.applyButton = new JButton("Apply");
        this.cancelButton = new JButton("Cancel");
        this.okButton.setToolTipText("Apply current values and close dialog");
        this.applyButton.setToolTipText("Apply settings now");
        this.cancelButton.setToolTipText("Restore original values and close dialog");
        jPanel.add(this.cancelButton);
        jPanel.add(new JLabel("   "));
        jPanel.add(this.applyButton);
        jPanel.add(this.okButton);
        this.dbg("-#- buildButtonPanel ok.");
        return jPanel;
    }

    protected void createControls() {
        int n = 4;
        this.lineWidthLabel = new JLabel("Line width, style: ", n);
        this.lineColorLabel = new JLabel("Line pen color: ", n);
        this.fillColorLabel = new JLabel("Fill color, style: ", n);
        this.arrowModeLabel = new JLabel("Arrow mode, style: ", n);
        this.arrowFLabel = new JLabel("Front arrow size: ", n);
        this.arrowBLabel = new JLabel("Back arrow size: ", n);
        this.depthLabel = new JLabel("Depth/layer [0..999]: ", n);
        this.fontStyleLabel = new JLabel("Text font: ", n);
        this.textAlignLabel = new JLabel("Text size, alignment: ", n);
        this.cornerRadiusLabel = new JLabel("Corner radius [pixel]: ", n);
        this.landscapeLabel = new JLabel("Paper orientation: ", n);
        this.rotationAngleLabel = new JLabel("Rotation angle [deg]: ", n);
        this.lineStyleButton = this.AC.createLineStyleButton(this);
        this.lineWidthButton = this.AC.createLineWidthButton(this);
        this.lineColorButton = this.AC.createLineColorButton(this);
        this.dashLengthField = this.AC.createDashLengthField(this);
        this.arrowModeButton = this.AC.createArrowModeButton(this);
        this.arrowStyleButton = this.AC.createArrowStyleButton(this);
        this.f_arrowWidthField = this.AC.createFrontArrowWidthField(this);
        this.f_arrowLengthField = this.AC.createFrontArrowLengthField(this);
        this.f_arrowThicknessField = this.AC.createFrontArrowThicknessField(this);
        this.b_arrowWidthField = this.AC.createBackArrowWidthField(this);
        this.b_arrowLengthField = this.AC.createBackArrowLengthField(this);
        this.b_arrowThicknessField = this.AC.createBackArrowThicknessField(this);
        this.fillColorButton = this.AC.createFillColorButton(this);
        this.fillPatternButton = this.AC.createFillPatternButton(this);
        this.fontSelectButton = this.AC.createFontSelectButton(this);
        this.fontSizeButton = this.AC.createFontSizeButton(this);
        this.textAlignButton = this.AC.createTextAlignButton(this);
        this.depthButton = this.AC.createDepthButton(this);
        this.cornerRadiusButton = this.AC.createRoundRectButton(this);
        this.rotationAngleButton = this.AC.createRotationButton(this);
        this.landscapePortraitChoice = this.AC.createLandscapePortraitChoice(this);
        this.centerFlushLeftChoice = this.AC.createCenterFlushLeftChoice(this);
        this.dbg("-#- createControls ok.");
    }

    public JPanel buildLabelsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.lineColorLabel);
        jPanel.add(this.lineWidthLabel);
        jPanel.add(this.arrowModeLabel);
        jPanel.add(new JLabel("front arrow W/L [mm]: ", 4));
        jPanel.add(new JLabel("back arrow W/L [mm]: ", 4));
        jPanel.add(new JLabel(" "));
        jPanel.add(this.fillColorLabel);
        jPanel.add(this.fontStyleLabel);
        jPanel.add(this.textAlignLabel);
        jPanel.add(this.depthLabel);
        jPanel.add(new JLabel(" "));
        jPanel.add(this.landscapeLabel);
        return jPanel;
    }

    public JPanel buildAttribsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1, 0, 6));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add(this.buildLineColorPanel());
        jPanel.add(this.buildLineStylePanel());
        jPanel.add(this.buildArrowModePanel());
        jPanel.add(this.buildFArrowPanel());
        jPanel.add(this.buildBArrowPanel());
        jPanel.add(new JLabel(" "));
        jPanel.add(this.buildFillStylePanel());
        jPanel.add(this.buildFontSelectPanel());
        jPanel.add(this.buildTextAttributesPanel());
        jPanel.add(this.buildDepthPanel());
        jPanel.add(new JLabel(" "));
        jPanel.add(this.buildOptionsPanel());
        this.dbg("-#- buildAttribsPanel ok.");
        return jPanel;
    }

    public JPanel buildLineColorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.lineColorButton);
        return jPanel;
    }

    public JPanel buildLineStylePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.lineWidthButton);
        jPanel.add(new JLabel("  "));
        jPanel.add(this.lineStyleButton);
        jPanel.add(new JLabel("  "));
        jPanel.add(this.dashLengthField);
        return jPanel;
    }

    public JPanel buildArrowModePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.arrowModeButton);
        jPanel.add(new JLabel("  "));
        jPanel.add(this.arrowStyleButton);
        return jPanel;
    }

    public JPanel buildFArrowPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.f_arrowWidthField);
        jPanel.add(this.f_arrowLengthField);
        jPanel.add(this.f_arrowThicknessField);
        return jPanel;
    }

    public JPanel buildBArrowPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.b_arrowWidthField);
        jPanel.add(this.b_arrowLengthField);
        jPanel.add(this.b_arrowThicknessField);
        return jPanel;
    }

    public JPanel buildFillStylePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.fillColorButton);
        jPanel.add(new JLabel(" "));
        jPanel.add(this.fillPatternButton);
        return jPanel;
    }

    public JPanel buildFontSelectPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.fontSelectButton);
        return jPanel;
    }

    public JPanel buildTextAttributesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.fontSizeButton);
        jPanel.add(new JLabel("  "));
        jPanel.add(this.textAlignButton);
        return jPanel;
    }

    public JPanel buildDepthPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.depthButton);
        jPanel.add(new JLabel(" "));
        return jPanel;
    }

    public JPanel buildRotationAnglePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.rotationAngleButton);
        jPanel.add(new JLabel(" "));
        return jPanel;
    }

    public JPanel buildOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.landscapePortraitChoice);
        jPanel.add(this.centerFlushLeftChoice);
        return jPanel;
    }

    public JPanel buildCornerRadiusPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add(this.cornerRadiusButton);
        jPanel.add(new JLabel(" "));
        return jPanel;
    }

    public JPanel buildCoordsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BorderLayout());
        this.coordsTextArea = new JTextArea(5, 20);
        this.coordsScroller = new JScrollPane(this.coordsTextArea);
        jPanel.add("Center", this.coordsScroller);
        return jPanel;
    }

    public void retrieveAttribs(FigAttribs figAttribs) {
        this.AC.setLineStyle(figAttribs, this.lineStyleButton);
        this.AC.setLineWidth(figAttribs, this.lineWidthButton);
        this.AC.setDashLength(figAttribs, this.dashLengthField);
        this.AC.setLineColor(figAttribs, this.lineColorButton);
        this.AC.setArrowMode(figAttribs, this.arrowModeButton);
        this.AC.setArrowStyle(figAttribs, this.arrowStyleButton);
        this.AC.setFArrowWidth(figAttribs, this.f_arrowWidthField);
        this.AC.setFArrowLength(figAttribs, this.f_arrowLengthField);
        this.AC.setFArrowThickness(figAttribs, this.f_arrowThicknessField);
        this.AC.setBArrowWidth(figAttribs, this.b_arrowWidthField);
        this.AC.setBArrowLength(figAttribs, this.b_arrowLengthField);
        this.AC.setBArrowThickness(figAttribs, this.b_arrowThicknessField);
        this.AC.setFillColor(figAttribs, this.fillColorButton);
        this.AC.setFillPattern(figAttribs, this.fillPatternButton);
        this.AC.selectFont(figAttribs, this.fontSelectButton);
        this.AC.setFontSize(figAttribs, this.fontSizeButton);
        this.AC.setTextAlignment(figAttribs, this.textAlignButton);
        this.AC.setDepth(figAttribs, this.depthButton);
        this.AC.setLandscapeMode(figAttribs, this.landscapePortraitChoice);
        this.AC.setJustificationMode(figAttribs, this.centerFlushLeftChoice);
        this.dbg("new attribs= " + figAttribs);
    }

    public void showAttribs(FigAttribs figAttribs) {
        this.AC.showLineStyle(figAttribs, this.lineStyleButton);
        this.AC.showLineWidth(figAttribs, this.lineWidthButton);
        this.AC.showDashLength(figAttribs, this.dashLengthField);
        this.AC.showLineColor(figAttribs, this.lineColorButton);
        this.AC.showArrowMode(figAttribs, this.arrowModeButton);
        this.AC.showArrowStyle(figAttribs, this.arrowStyleButton);
        this.AC.showFArrowWidth(figAttribs, this.f_arrowWidthField);
        this.AC.showFArrowLength(figAttribs, this.f_arrowLengthField);
        this.AC.showFArrowThickness(figAttribs, this.f_arrowThicknessField);
        this.AC.showBArrowWidth(figAttribs, this.b_arrowWidthField);
        this.AC.showBArrowLength(figAttribs, this.b_arrowLengthField);
        this.AC.showBArrowThickness(figAttribs, this.b_arrowThicknessField);
        this.AC.showFillColor(figAttribs, this.fillColorButton);
        this.AC.showFillPattern(figAttribs, this.fillPatternButton);
        this.AC.showFontName(figAttribs, this.fontSelectButton);
        this.AC.showFontSize(figAttribs, this.fontSizeButton);
        this.AC.showTextAlignment(figAttribs, this.textAlignButton);
        this.AC.showDepth(figAttribs, this.depthButton);
        this.AC.showLandscapeMode(figAttribs, this.landscapePortraitChoice);
        this.AC.showJustificationMode(figAttribs, this.centerFlushLeftChoice);
        this.dbg("existing attribs= " + figAttribs);
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (this.debug) {
            this.message("-#- textDialog.keyPressed() " + c);
        }
        if (c == '\n') {
            this.doOK();
        } else if (c == '\u001b') {
            this.doCancel();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void doRedraw() {
        if (this.editor != null) {
            this.editor.getObjectCanvas().doFullRedraw();
        }
    }

    public void doCancel() {
        this.dbg("-#- JEditBaseobjectDialog.Cancel");
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.editor.setCurrentAttribs(this.savedAttribs);
        this.doRedraw();
    }

    public void doApply() {
        this.dbg("-#- JEditBaseobjectDialog.Apply");
        this.retrieveAttribs(this.currentAttribs);
        this.editor.setCurrentAttribs(this.currentAttribs);
        this.doRedraw();
    }

    public void doOK() {
        this.dbg("-#- JEditBaseobjectDialog.OK...");
        this.retrieveAttribs(this.currentAttribs);
        this.editor.setCurrentAttribs(this.currentAttribs);
        this.setVisible(false);
        AntiDeadlock.sleep(200L);
        this.doRedraw();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                this.doOK();
            } else if (string.equals("Apply")) {
                this.doApply();
            } else if (string.equals("Cancel")) {
                this.doCancel();
            } else {
                this.message("-E- Unknown event source: " + actionEvent);
            }
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void message(String string) {
        System.out.println(string);
    }

    public void dbg(String string) {
        if (this.debug) {
            this.message(string);
        }
    }

    public static void main(String[] stringArray) {
        ExceptionTracer.setEnabled(true);
        JFrame jFrame = new JFrame("dummy");
        jFrame.setSize(new Dimension(100, 100));
        ImageHelper.setVisibleParent(jFrame);
        SetupManager.loadAllProperties("jfig.cnf");
        JEditBaseobjectDialog jEditBaseobjectDialog = new JEditBaseobjectDialog((Frame)jFrame, null, "edit baseobject");
        jFrame.show();
        jEditBaseobjectDialog.show();
    }

    public JEditBaseobjectDialog(Frame frame, FigBasicEditor figBasicEditor, String string) {
        super(frame, string, false);
        this.editor = figBasicEditor;
        boolean bl = SetupManager.getBoolean("jfig.gui.Editor.ModalEditDialogs", false);
        this.setModal(bl);
        this.AC = JAttribsControlsFactory.getJAttribsControlsFactory(figBasicEditor);
        this.getGUIDefaults();
        this.createControls();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("North", this.buildButtonPanel());
        this.getContentPane().add("West", this.buildLabelsPanel());
        this.getContentPane().add("Center", this.buildAttribsPanel());
        this.getContentPane().add("South", this.buildCoordsPanel());
        this.pack();
        this.okButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addKeyListener(this);
        this.addWindowListener(this);
    }
}

