/*
 * Decompiled with CFR 0.152.
 */
package jfig.gui;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ColorCache {
    private static ColorCache _colorCache;
    public static int BLACK;
    public static int BLUE;
    public static int GREEN;
    public static int CYAN;
    public static int RED;
    public static int MAGENTA;
    public static int YELLOW;
    public static int WHITE;
    public static int BLUE4;
    public static int BLUE3;
    public static int BLUE2;
    public static int LTBLUE;
    public static int GREEN4;
    public static int GREEN3;
    public static int GREEN2;
    public static int CYAN4;
    public static int CYAN3;
    public static int CYAN2;
    public static int RED4;
    public static int RED3;
    public static int RED2;
    public static int MAGENTA4;
    public static int MAGENTA3;
    public static int MAGENTA2;
    public static int BROWN4;
    public static int BROWN3;
    public static int BROWN2;
    public static int PINK4;
    public static int PINK3;
    public static int PINK2;
    public static int PINK;
    public static int GOLD;
    private Hashtable nameHT = new Hashtable();
    private Hashtable intHT = new Hashtable();
    private Hashtable indexHT = new Hashtable();
    private Hashtable colorNumberHT = new Hashtable();
    private Vector figIndexVector = new Vector();
    private long timestamp;
    private boolean debug = false;

    public static synchronized ColorCache getColorCache() {
        if (_colorCache == null) {
            _colorCache = new ColorCache();
        }
        return _colorCache;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void put(String string, int n, Color color) {
        Integer n2;
        if (this.debug) {
            System.out.println("-#- ColorCache.put: '" + string + "' " + n + " " + color);
        }
        if (this.intHT.get(n2 = new Integer(n)) == null && n >= this.figIndexVector.size()) {
            this.figIndexVector.addElement(n2);
        }
        this.nameHT.put(string, color);
        this.intHT.put(n2, color);
        this.indexHT.put(n2, string);
        this.colorNumberHT.put(color, n2);
        this.timestamp = System.currentTimeMillis();
        if (this.debug) {
            System.out.println("-#- fiv.size= " + this.figIndexVector.size() + " intHT.size=" + this.intHT.size());
        }
    }

    public Color get(String string) {
        if (string == null) {
            return null;
        }
        return (Color)this.nameHT.get(string);
    }

    public Color get(int n) {
        if (n < 0) {
            n = 0;
        }
        return (Color)this.intHT.get(new Integer(n));
    }

    public int getIndex(Color color) {
        Integer n = (Integer)this.colorNumberHT.get(color);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public int getFigColorIndex(int n) {
        Integer n2 = (Integer)this.figIndexVector.elementAt(n);
        if (n2 != null) {
            return n2;
        }
        return 0;
    }

    public Color getColorAt(int n) {
        return this.get(this.getFigColorIndex(n));
    }

    public int numberOfColors() {
        return this.figIndexVector.size();
    }

    public Vector getColorNames() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.indexHT.size()) {
            vector.addElement(this.indexHT.get(new Integer(n)));
            ++n;
        }
        return vector;
    }

    public Vector getColorIndices() {
        Vector vector = new Vector();
        Enumeration enumeration = this.intHT.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public int getColorNumber(Color color) {
        Integer n = (Integer)this.colorNumberHT.get(color);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public Color get(String string, int n) {
        Color color = (Color)this.nameHT.get(string);
        if (color == null) {
            return null;
        }
        return this.xfig_area_fill(color, n);
    }

    public Color get(int n, int n2) {
        Color color;
        if (n < 0) {
            n = 0;
        }
        if ((color = (Color)this.intHT.get(new Integer(n))) == null) {
            return null;
        }
        return this.xfig_area_fill(color, n2);
    }

    public Color xfig_area_fill(Color color, int n) {
        Integer n2 = (Integer)this.colorNumberHT.get(color);
        if (n2 == null) {
            System.err.println("-E- Internal error in ColorCache: no such color");
            return null;
        }
        int n3 = n2;
        int n4 = 0;
        if (n3 == 0) {
            if (n == -1) {
                return null;
            }
            if (n >= 21) {
                return Color.orange;
            }
            n4 = 255 * (20 - n) / 20;
            return new Color(n4, n4, n4);
        }
        if (n3 == 7) {
            if (n == -1) {
                return null;
            }
            if (n >= 21) {
                return Color.orange;
            }
            n4 = 255 * n / 20;
            return new Color(n4, n4, n4);
        }
        if (n == -1) {
            return null;
        }
        if (n >= 41) {
            return Color.orange;
        }
        if (n >= 21) {
            int n5 = color.getRed();
            int n6 = color.getGreen();
            int n7 = color.getBlue();
            int n8 = 255 - n5;
            int n9 = 255 - n6;
            int n10 = 255 - n7;
            n4 = 40 - n;
            return new Color(255 - n8 * n4 / 20, 255 - n9 * n4 / 20, 255 - n10 * n4 / 20);
        }
        int n11 = color.getRed();
        int n12 = color.getGreen();
        int n13 = color.getBlue();
        return new Color(n11 * n / 20, n12 * n / 20, n13 * n / 20);
    }

    public Color getFIG21Gray(int n) {
        if (n == 0) {
            return null;
        }
        return this.xfig_area_fill((Color)this.nameHT.get("black"), n - 1);
    }

    public void putUserColor(int n, int n2) {
        if (this.debug) {
            System.out.println("-#- putUserColor: " + n + " " + n2 + " X " + this.intHT.size() + " " + this.figIndexVector.size());
        }
        Color color = new Color(n2);
        this.put("user" + n, n, color);
    }

    public boolean hasUserColors() {
        return this.intHT.size() > 32;
    }

    public int registerUserColor(Color color) {
        int n = this.getColorNumber(color);
        if (n >= 0) {
            return n;
        }
        int n2 = this.figIndexVector.size();
        this.put("user" + n2, n2, color);
        if (this.debug) {
            System.out.println("-#- registered " + "user" + n2 + " at " + n2 + " " + this.intHT.size());
        }
        return n2;
    }

    public void clearUserColors() {
        Enumeration enumeration = this.intHT.keys();
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            if (n < 32) continue;
            this.removeUserColor(n);
        }
    }

    public void removeUserColor(int n) {
        if (n <= 31) {
            return;
        }
        Integer n2 = new Integer(n);
        Color color = (Color)this.intHT.get(n2);
        String string = "user" + n;
        this.intHT.remove(n2);
        this.nameHT.remove(string);
        this.indexHT.remove(string);
        this.colorNumberHT.remove(color);
        this.figIndexVector.remove(n2);
    }

    private ColorCache() {
        this.put("black", 0, Color.black);
        this.put("blue", 1, Color.blue);
        this.put("green", 2, Color.green);
        this.put("cyan", 3, Color.cyan);
        this.put("red", 4, Color.red);
        this.put("magenta", 5, Color.magenta);
        this.put("yellow", 6, Color.yellow);
        this.put("white", 7, Color.white);
        this.put("blue4", 8, new Color(0, 0, 144));
        this.put("blue3", 9, new Color(0, 0, 176));
        this.put("blue2", 10, new Color(0, 0, 208));
        this.put("ltblue", 11, new Color(135, 206, 255));
        this.put("green4", 12, new Color(0, 144, 0));
        this.put("green3", 13, new Color(0, 176, 0));
        this.put("green2", 14, new Color(0, 208, 0));
        this.put("cyan4", 15, new Color(0, 144, 144));
        this.put("cyan3", 16, new Color(0, 176, 176));
        this.put("cyan2", 17, new Color(0, 208, 208));
        this.put("red4", 18, new Color(144, 0, 0));
        this.put("red3", 19, new Color(176, 0, 0));
        this.put("red2", 20, new Color(208, 0, 0));
        this.put("magenta4", 21, new Color(144, 0, 144));
        this.put("magenta3", 22, new Color(176, 0, 176));
        this.put("magenta2", 23, new Color(208, 0, 208));
        this.put("brown4", 24, new Color(128, 48, 0));
        this.put("brown3", 25, new Color(160, 64, 0));
        this.put("brown2", 26, new Color(192, 96, 0));
        this.put("pink4", 27, new Color(255, 128, 128));
        this.put("pink3", 28, new Color(255, 160, 160));
        this.put("pink2", 29, new Color(255, 192, 192));
        this.put("pink", 30, new Color(255, 224, 224));
        this.put("gold", 31, new Color(255, 215, 0));
    }

    static {
        BLACK = 0;
        BLUE = 1;
        GREEN = 2;
        CYAN = 3;
        RED = 4;
        MAGENTA = 5;
        YELLOW = 6;
        WHITE = 7;
        BLUE4 = 8;
        BLUE3 = 9;
        BLUE2 = 10;
        LTBLUE = 11;
        GREEN4 = 12;
        GREEN3 = 13;
        GREEN2 = 14;
        CYAN4 = 15;
        CYAN3 = 16;
        CYAN2 = 17;
        RED4 = 18;
        RED3 = 19;
        RED2 = 20;
        MAGENTA4 = 21;
        MAGENTA3 = 22;
        MAGENTA2 = 23;
        BROWN4 = 24;
        BROWN3 = 25;
        BROWN2 = 26;
        PINK4 = 27;
        PINK3 = 28;
        PINK2 = 29;
        PINK = 30;
        GOLD = 31;
    }
}

