/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.ByteArrayInputStream;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.BreakCompoundCommand;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.gui.ConsoleMessage;
import jfig.objects.FigBbox;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;
import jfig.objects.FigParser;
import jfig.utils.ExceptionTracer;
import jfig.utils.MouseMapper;

public class PasteFromClipboardCommand
extends Command {
    FigCompound buffer;
    Point startPoint;
    Point endPoint;
    ConsoleMessage console;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.buffer};
        return figObjectArray;
    }

    public void execute() {
        if (this.buffer != null) {
            int n = this.endPoint.x - this.startPoint.x;
            int n2 = this.endPoint.y - this.startPoint.y;
            this.buffer.move(n, n2);
            this.buffer.update_bbox();
            this.buffer.deselect();
            this.editor.insertIntoObjectList(this.buffer);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
            this.statusMessage("Ready. Please select a command");
        }
    }

    public void undo() {
        if (this.buffer != null) {
            int n = this.endPoint.x - this.startPoint.x;
            int n2 = this.endPoint.y - this.startPoint.y;
            this.buffer.move(-n, -n2);
            this.buffer.update_bbox();
            this.buffer.deselect();
            this.editor.deleteFromObjectList(this.buffer);
        }
        this.statusMessage("Undo paste from clipboard ready.");
        this.objectCanvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (MouseMapper.isRightClick(figCanvasEvent)) {
            this.buffer = null;
            this.ready = true;
            this.objectCanvas.changeRubberbandMode(1);
            this.objectCanvas.doFullRedraw();
            this.cancel();
            return;
        }
        if (MouseMapper.isMiddleClick(figCanvasEvent)) {
            this.endPoint = new Point(point.x, point.y);
            this.execute();
            this.objectCanvas.changeRubberbandMode(1);
            this.ready = true;
            BreakCompoundCommand breakCompoundCommand = new BreakCompoundCommand(this.editor, this.objectCanvas);
            breakCompoundCommand.setCompound(this.buffer);
            breakCompoundCommand.execute();
        } else {
            this.endPoint = new Point(point.x, point.y);
            this.execute();
            this.objectCanvas.changeRubberbandMode(1);
            this.ready = true;
        }
    }

    public void readClipboard() {
        String string = this.getClipboardContents();
        if (string == null) {
            this.message("-W- Cannot paste: clipboard is empty (or not a FIG object)!");
            this.ready = true;
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        FigObjectList figObjectList = new FigObjectList();
        FigParser figParser = new FigParser();
        figParser.setConsole(this.console);
        int n = figParser.parse_fig_file(byteArrayInputStream, true, false, this.editor.getCurrentAttribs(), this.objectCanvas.getTrafo(), figObjectList);
        if (n != 0) {
            this.message("-E- Paste: got " + n + " errors.");
        }
        this.buffer = new FigCompound();
        this.buffer.setTrafo(this.objectCanvas.getTrafo());
        int n2 = 0;
        Object object = figObjectList.elements();
        while (object.hasMoreElements()) {
            this.buffer.fastAddMember((FigObject)object.nextElement());
            ++n2;
        }
        if (n2 > 0) {
            this.buffer.update_bbox();
            object = this.buffer.getBbox();
            Point point = new Point(((FigBbox)object).getXl(), ((FigBbox)object).getYt());
            Point point2 = this.objectCanvas.getTrafo().getAnchor();
            this.startPoint = new Point(point2.x, point2.y);
            this.buffer.move(point2.x - point.x, point2.y - point.y);
            this.statusMessage("L: place object(s), M: place and open, R: cancel");
            this.objectCanvas.setRubberbandBasePoint(new Point(0, 0));
            this.objectCanvas.changeRubberbandMode(5, this.objectCanvas.getTrafo(), this.buffer.getBbox());
            this.ready = false;
        } else {
            this.buffer = null;
            this.ready = true;
            this.message("-E- Internal error: no objects read from clipboard.");
        }
    }

    private String getClipboardContents() {
        String string = null;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            ExceptionTracer.trace(exception);
        }
        return string;
    }

    public String getDescription() {
        return "paste from clipboard";
    }

    public String toString() {
        return "jfig.commands.PasteFromClipboardCommand[]";
    }

    public PasteFromClipboardCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Paste clipboard L: place, M: place and break, R: cancel");
        this.console = null;
        this.readClipboard();
        this.ready = false;
    }

    public PasteFromClipboardCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas, ConsoleMessage consoleMessage) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Paste clipboard L: place, M: place and break, R: cancel");
        this.console = consoleMessage;
        this.readClipboard();
        this.ready = false;
    }
}

