/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigObject;

public class MirrorXCommand
extends Command {
    protected FigObject object;
    protected Point P1;
    protected int n_points;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void execute() {
        if (this.object != null) {
            this.object.mirrorX(this.P1.x, this.P1.y);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.object != null) {
            this.object.mirrorX(this.P1.x, this.P1.y);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            this.object = this.editor.findObjectAt(point);
            if (this.object == null) {
                this.statusMessage("Please click directly on the object to mirror (x)!");
                return;
            }
            this.P1 = new Point(point);
            this.objectCanvas.changeRubberbandMode(1);
            this.execute();
            this.ready = true;
            this.notifyEditor();
        }
    }

    public String getDescription() {
        return "mirror object (x-axis)";
    }

    public String toString() {
        return "jfig.commands.MirrorXCommand[]";
    }

    public MirrorXCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Click on the object to mirror on the x-axis");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

