/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.gui.JEditCompoundDialog;
import jfig.gui.JEditEllipseDialog;
import jfig.gui.JEditImageDialog;
import jfig.gui.JEditPolylineDialog;
import jfig.gui.JEditRectangleDialog;
import jfig.gui.JEditTextDialog;
import jfig.gui.JEditTriggerDialog;
import jfig.gui.JEditVertexDialog;
import jfig.gui.JEditXSplineDialog;
import jfig.gui.JModularEditor;
import jfig.gui.StatusMessage;
import jfig.objects.FigAttribs;
import jfig.objects.FigBezierXSpline;
import jfig.objects.FigCompound;
import jfig.objects.FigEllipse;
import jfig.objects.FigGeneralXSpline;
import jfig.objects.FigImage;
import jfig.objects.FigNormalXSpline;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;
import jfig.objects.FigRectangle;
import jfig.objects.FigText;
import jfig.objects.FigTrigger;
import jfig.objects.FigXSpline;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;
import jfig.utils.MouseMapper;

public class JEditObjectCommand
extends Command {
    protected FigObject object;
    protected FigObject preselectedObject;
    protected FigAttribs attribs;
    protected Point P1;
    protected int n_points;
    protected Frame frame;
    protected JEditEllipseDialog editEllipseDialog;
    protected JEditImageDialog editImageDialog;
    protected JEditPolylineDialog editPolylineDialog;
    protected JEditXSplineDialog editXSplineDialog;
    protected JEditRectangleDialog editRectangleDialog;
    protected JEditTextDialog editTextDialog;
    protected JEditCompoundDialog editCompoundDialog;
    protected JEditTriggerDialog editTriggerDialog;
    protected JEditVertexDialog editVertexDialog;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void execute() {
        if (this.object != null) {
            this.attribs = this.object.getAttributes();
            this.object.setAttributes(this.editor.getCurrentAttribs().getClone());
            this.editor.addTmpObject(null);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.object != null && this.attribs != null) {
            this.object.setAttributes(this.attribs);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (MouseMapper.isRightClick(figCanvasEvent)) {
            this.object = this.editor.findObjectAt(point);
            if (this.object != null && this.object instanceof FigXSpline) {
                FigXSpline figXSpline = (FigXSpline)this.object;
                this.createShowEditVertexDialog(figXSpline, point, point2);
            }
            return;
        }
        if (MouseMapper.isShiftDown(figCanvasEvent)) {
            if (this.preselectedObject == null) {
                this.preselectedObject = this.editor.findObjectAt(point);
                if (this.preselectedObject != null) {
                    this.preselectedObject.select();
                    this.editor.addTmpObject(this.preselectedObject);
                }
                this.objectCanvas.doFullRedraw();
                return;
            }
            this.preselectedObject.showPoints();
            this.preselectedObject = this.editor.findNextObjectAt(point, this.preselectedObject);
            if (this.preselectedObject != null) {
                this.preselectedObject.select();
                this.editor.addTmpObject(this.preselectedObject);
            }
            this.objectCanvas.doFullRedraw();
            return;
        }
        if (this.preselectedObject != null) {
            this.editor.addTmpObject(null);
            this.object = this.preselectedObject;
            this.object.showPoints();
        } else {
            this.object = this.editor.findObjectAt(point);
        }
        if (this.object == null) {
            this.statusMessage("No object at that position. Please click directly on the object to edit (its corners)");
            return;
        }
        if (this.object instanceof FigCompound) {
            this.createShowJEditCompoundDialog();
        } else if (this.object instanceof FigText) {
            this.createShowJEditTextDialog();
        } else if (this.object instanceof FigXSpline) {
            this.createShowJEditXSplineDialog();
        } else if (this.object instanceof FigPolyline) {
            this.createShowJEditPolylineDialog();
        } else if (this.object instanceof FigEllipse) {
            this.createShowJEditEllipseDialog();
        } else if (this.object instanceof FigTrigger) {
            this.createShowJEditTriggerDialog();
        } else if (this.object instanceof FigImage) {
            this.createShowJEditImageDialog();
        } else if (this.object instanceof FigRectangle) {
            this.createShowJEditRectangleDialog();
        } else {
            this.message("-E- edit not implemented for object: " + this.object);
            return;
        }
    }

    private void createShowJEditCompoundDialog() {
        if (this.editCompoundDialog == null) {
            this.editCompoundDialog = new JEditCompoundDialog(this.frame, this.editor);
        }
        this.editCompoundDialog.setCompoundObject((FigCompound)this.object);
        this.editCompoundDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowJEditTextDialog() {
        if (this.editTextDialog == null) {
            this.editTextDialog = new JEditTextDialog(this.frame, this.editor);
        }
        this.editTextDialog.setTextObject((FigText)this.object);
        this.editTextDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowJEditXSplineDialog() {
        if (this.editXSplineDialog == null) {
            this.editXSplineDialog = new JEditXSplineDialog(this.frame, this.editor);
        }
        this.editXSplineDialog.setXSpline((FigXSpline)this.object);
        this.editXSplineDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowJEditPolylineDialog() {
        if (this.editPolylineDialog == null) {
            this.editPolylineDialog = new JEditPolylineDialog(this.frame, this.editor);
        }
        this.editPolylineDialog.setPolyline((FigPolyline)this.object);
        this.editPolylineDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowJEditRectangleDialog() {
        if (this.editRectangleDialog == null) {
            this.editRectangleDialog = new JEditRectangleDialog(this.frame, this.editor);
        }
        this.editRectangleDialog.setRectangle((FigRectangle)this.object);
        this.editRectangleDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowJEditEllipseDialog() {
        if (this.editEllipseDialog == null) {
            this.editEllipseDialog = new JEditEllipseDialog(this.frame, this.editor);
        }
        this.editEllipseDialog.setEllipse((FigEllipse)this.object);
        this.editEllipseDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowJEditTriggerDialog() {
        if (this.editTriggerDialog == null) {
            this.editTriggerDialog = new JEditTriggerDialog(this.frame, this.editor);
        }
        this.editTriggerDialog.setTriggerObject((FigTrigger)this.object);
        this.editTriggerDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowJEditImageDialog() {
        if (this.editImageDialog == null) {
            this.editImageDialog = new JEditImageDialog(this.frame, this.editor);
        }
        this.editImageDialog.setImageObject((FigImage)this.object);
        this.editImageDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowEditVertexDialog(FigXSpline figXSpline, Point point, Point point2) {
        if (this.editVertexDialog == null) {
            this.editVertexDialog = new JEditVertexDialog(this.objectCanvas.getComponent());
        }
        this.editVertexDialog.setPosition(new Point(point2.x + 30, point2.y + 30));
        this.editVertexDialog.show();
        if (figXSpline instanceof FigNormalXSpline || figXSpline instanceof FigBezierXSpline) {
            Point[] pointArray = figXSpline.getPoints();
            double[] dArray = figXSpline.getSFactors();
            FigAttribs figAttribs = figXSpline.getAttributes();
            FigTrafo2D figTrafo2D = figXSpline.getTrafo();
            boolean bl = figXSpline.isClosed();
            Point point3 = figXSpline.getPosition();
            FigGeneralXSpline figGeneralXSpline = new FigGeneralXSpline(point3.x, point3.y, bl, figAttribs, figTrafo2D);
            figGeneralXSpline.setPoints(pointArray);
            figGeneralXSpline.setSFactors(dArray);
            figGeneralXSpline.showPoints();
            this.editor.deleteFromObjectList(figXSpline);
            this.editor.insertIntoObjectList(figGeneralXSpline);
            this.editor.doRedraw();
            figXSpline = figGeneralXSpline;
            this.object = figGeneralXSpline;
        }
        int n = figXSpline.indexOfNearestNeighbor(point);
        this.editVertexDialog.setXSpline(figXSpline);
        this.editVertexDialog.setVertexIndex(n);
        AntiDeadlock.sleep(100L);
    }

    public StatusMessage getStatusMessage() {
        StatusMessage statusMessage = null;
        try {
            statusMessage = ((JModularEditor)this.editor).getStatusMessage();
        }
        catch (Exception exception) {
            this.message("-E- could not get a StatusMessage object.");
            ExceptionTracer.trace(exception);
        }
        return statusMessage;
    }

    public String getDescription() {
        return "edit object attributes";
    }

    public String toString() {
        return "jfig.commands.JEditObjectCommand[]";
    }

    public JEditObjectCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        try {
            this.frame = ((JModularEditor)figBasicEditor).getFrame();
        }
        catch (Exception exception) {
            this.frame = new Frame("Dummy Frame");
            this.frame.setSize(new Dimension(100, 100));
        }
        this.statusMessage("L: edit object, R: edit x-spline vertex");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

