/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.gui.EditCompoundDialog;
import jfig.gui.EditEllipseDialog;
import jfig.gui.EditImageDialog;
import jfig.gui.EditPolylineDialog;
import jfig.gui.EditRectangleDialog;
import jfig.gui.EditTextDialog;
import jfig.gui.EditTriggerDialog;
import jfig.gui.ModularEditor;
import jfig.gui.StatusMessage;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;
import jfig.objects.FigEllipse;
import jfig.objects.FigImage;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;
import jfig.objects.FigRectangle;
import jfig.objects.FigText;
import jfig.objects.FigTrigger;
import jfig.utils.AntiDeadlock;
import jfig.utils.ExceptionTracer;
import jfig.utils.MouseMapper;

public class EditObjectCommand
extends Command {
    protected static EditEllipseDialog editEllipseDialog;
    protected static EditImageDialog editImageDialog;
    protected static EditPolylineDialog editPolylineDialog;
    protected static EditRectangleDialog editRectangleDialog;
    protected static EditTextDialog editTextDialog;
    protected static EditTriggerDialog editTriggerDialog;
    protected static EditCompoundDialog editCompoundDialog;
    protected FigObject object;
    protected FigObject preselectedObject;
    protected FigAttribs attribs;
    protected Point P1;
    protected int n_points;
    protected Frame frame;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void execute() {
        if (this.object != null) {
            this.attribs = this.object.getAttributes();
            this.object.setAttributes(this.editor.getCurrentAttribs().getClone());
            this.editor.addTmpObject(null);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.object != null && this.attribs != null) {
            this.object.setAttributes(this.attribs);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (MouseMapper.isShiftDown(figCanvasEvent)) {
            if (this.preselectedObject == null) {
                this.preselectedObject = this.editor.findObjectAt(point);
                if (this.preselectedObject != null) {
                    this.preselectedObject.select();
                    this.editor.addTmpObject(this.preselectedObject);
                }
                this.objectCanvas.doFullRedraw();
                return;
            }
            this.preselectedObject.showPoints();
            this.preselectedObject = this.editor.findNextObjectAt(point, this.preselectedObject);
            if (this.preselectedObject != null) {
                this.preselectedObject.select();
                this.editor.addTmpObject(this.preselectedObject);
            }
            this.objectCanvas.doFullRedraw();
            return;
        }
        if (this.preselectedObject != null) {
            this.editor.addTmpObject(null);
            this.object = this.preselectedObject;
            this.object.showPoints();
        } else {
            this.object = this.editor.findObjectAt(point);
        }
        if (this.object == null) {
            this.statusMessage("No object at that position. Please click directly on the object to edit (its corners)");
            return;
        }
        if (this.object instanceof FigCompound) {
            this.createShowEditCompoundDialog();
        } else if (this.object instanceof FigText) {
            this.createShowEditTextDialog();
        } else if (this.object instanceof FigPolyline) {
            this.createShowEditPolylineDialog();
        } else if (this.object instanceof FigEllipse) {
            this.createShowEditEllipseDialog();
        } else if (this.object instanceof FigTrigger) {
            this.createShowEditTriggerDialog();
        } else if (this.object instanceof FigImage) {
            this.createShowEditImageDialog();
        } else if (this.object instanceof FigRectangle) {
            this.createShowEditRectangleDialog();
        } else {
            this.message("-E- edit not implemented for object: " + this.object);
            return;
        }
    }

    private void createShowEditCompoundDialog() {
        if (editCompoundDialog == null) {
            editCompoundDialog = new EditCompoundDialog((FigCompound)this.object, this.editor, this.frame);
        } else {
            editCompoundDialog.setCompoundObject((FigCompound)this.object);
        }
        editCompoundDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowEditTextDialog() {
        if (editTextDialog == null) {
            editTextDialog = new EditTextDialog((FigText)this.object, this.editor, this.frame);
        } else {
            editTextDialog.setTextObject((FigText)this.object);
        }
        editTextDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowEditPolylineDialog() {
        if (editPolylineDialog == null) {
            editPolylineDialog = new EditPolylineDialog((FigPolyline)this.object, this.editor, this.frame);
        } else {
            editPolylineDialog.setPolyline((FigPolyline)this.object);
        }
        editPolylineDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowEditRectangleDialog() {
        if (editRectangleDialog == null) {
            editRectangleDialog = new EditRectangleDialog((FigRectangle)this.object, this.editor, this.frame);
        } else {
            editRectangleDialog.setRectangle((FigRectangle)this.object);
        }
        editRectangleDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowEditEllipseDialog() {
        if (editEllipseDialog == null) {
            editEllipseDialog = new EditEllipseDialog((FigEllipse)this.object, this.editor, this.frame);
        } else {
            editEllipseDialog.setEllipse((FigEllipse)this.object);
        }
        editEllipseDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowEditTriggerDialog() {
        if (editTriggerDialog == null) {
            editTriggerDialog = new EditTriggerDialog((FigTrigger)this.object, this.editor, this.frame);
        } else {
            editTriggerDialog.setTriggerObject((FigTrigger)this.object);
        }
        editTriggerDialog.show();
        AntiDeadlock.sleep(100L);
    }

    private void createShowEditImageDialog() {
        if (editImageDialog == null) {
            editImageDialog = new EditImageDialog((FigImage)this.object, this.editor, this.frame);
        } else {
            editImageDialog.setImageObject((FigImage)this.object);
        }
        editImageDialog.show();
        AntiDeadlock.sleep(100L);
    }

    public StatusMessage getStatusMessage() {
        StatusMessage statusMessage = null;
        try {
            statusMessage = ((ModularEditor)this.editor).getStatusMessage();
        }
        catch (Exception exception) {
            this.message("-E- could not get a StatusMessage object.");
            ExceptionTracer.trace(exception);
        }
        return statusMessage;
    }

    public String getDescription() {
        return "edit object attributes";
    }

    public String toString() {
        return "jfig.commands.EditObjectCommand[]";
    }

    public EditObjectCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        try {
            this.frame = ((ModularEditor)figBasicEditor).getFrame();
        }
        catch (Exception exception) {
            this.frame = new Frame("Dummy Frame");
            this.frame.setSize(new Dimension(100, 100));
        }
        this.statusMessage("Click on the object to edit:");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

