/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import java.util.Enumeration;
import java.util.Stack;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.utils.MouseMapper;

public class DeleteObjectCommand
extends Command {
    protected int n_points;
    protected FigObject object;
    protected Point startPoint;
    protected Point endPoint;
    protected Stack victims;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[this.victims.size()];
        int n = 0;
        while (n < figObjectArray.length) {
            figObjectArray[n] = (FigObject)this.victims.elementAt(n);
            ++n;
        }
        return figObjectArray;
    }

    public void execute() {
        Enumeration enumeration = this.victims.elements();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            this.editor.deleteFromObjectList(figObject);
        }
        this.editor.getUndoStack().push(this);
        this.objectCanvas.changeRubberbandMode(1);
        this.objectCanvas.doFullRedraw();
    }

    public void undo() {
        Enumeration enumeration = this.victims.elements();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            this.editor.insertIntoObjectList(figObject);
        }
        this.objectCanvas.changeRubberbandMode(1);
        this.objectCanvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            this.startPoint = new Point(point);
            if (MouseMapper.isMiddleClick(figCanvasEvent)) {
                this.objectCanvas.setRubberbandBasePoint(point2);
                this.objectCanvas.changeRubberbandMode(4);
                this.statusMessage("Click on opposite corner of region to delete");
                ++this.n_points;
                return;
            }
            if (MouseMapper.isShiftDown(figCanvasEvent)) {
                this.message("-I- selecting the object to delete...");
                if (this.object == null) {
                    this.object = this.editor.findObjectAt(point);
                    this.object.select();
                } else {
                    this.object.deselect();
                    this.object = this.editor.findNextObjectAt(point, this.object);
                    this.object.select();
                }
                if (this.object == null) {
                    this.statusMessage("Please click directly on the object to delete!");
                    return;
                }
            } else {
                if (this.object == null) {
                    this.object = this.editor.findObjectAt(point);
                }
                if (this.object == null) {
                    this.statusMessage("Please click directly on the object to delete!");
                    return;
                }
                this.victims.push(this.object);
                this.execute();
                this.ready = true;
                this.notifyEditor();
            }
        } else {
            this.endPoint = new Point(point);
            FigBbox figBbox = new FigBbox(this.startPoint, this.endPoint);
            Enumeration enumeration = this.editor.getObjects();
            while (enumeration.hasMoreElements()) {
                FigObject figObject = (FigObject)enumeration.nextElement();
                if (!figObject.getBbox().inside(figBbox)) continue;
                this.victims.push(figObject);
            }
            this.execute();
            this.ready = true;
            this.notifyEditor();
        }
    }

    public String getDescription() {
        return "delete object";
    }

    public String toString() {
        return "jfig.commands.DeleteObjectCommand[]";
    }

    public DeleteObjectCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.statusMessage("L: delete object, <shift>+L: select object,M: delete region");
        this.object = null;
        this.victims = new Stack();
        this.n_points = 0;
        this.ready = false;
    }
}

