/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigBaseobject;
import jfig.objects.FigObject;

public class CutPointCommand
extends Command {
    protected int n_points;
    protected FigObject object;
    protected Point P1;
    protected Point P2;
    protected Point[] origPoints;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void execute() {
        if (this.object != null) {
            this.origPoints = FigBaseobject.clonePoints(this.object.getPoints());
            this.P2 = this.object.deletePoint(this.P1);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.object != null) {
            this.object.setPoints(this.origPoints);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            this.object = this.editor.findObjectAt(point);
            if (this.object == null) {
                this.statusMessage("Please click directly on the point to remove!");
                return;
            }
            if (!this.object.supportsPointOps()) {
                this.statusMessage("Cannot delete points from that object!");
                return;
            }
            this.P1 = new Point(point);
            this.execute();
            this.ready = true;
            this.notifyEditor();
        }
    }

    public String getDescription() {
        return "cut point";
    }

    public String toString() {
        return "jfig.commands.CutPointCommand[]";
    }

    public CutPointCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Click on the polyline point to delete");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

