/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigNormalXSpline;
import jfig.objects.FigObject;
import jfig.objects.FigSpline;
import jfig.utils.MouseMapper;
import jfig.utils.SetupManager;

public class CreateSplineCommand
extends Command {
    protected int n_points;
    protected FigObject spline;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.spline};
        return figObjectArray;
    }

    public void execute() {
        if (this.spline != null) {
            this.editor.insertIntoObjectList(this.spline);
            this.editor.deleteTmpObject(this.spline);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.spline != null) {
            this.editor.deleteFromObjectList(this.spline);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void cancel() {
        if (this.spline != null) {
            this.editor.deleteTmpObject(this.spline);
        }
        this.objectCanvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            FigAttribs figAttribs = this.editor.getCurrentAttribs().getClone();
            FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
            this.spline = SetupManager.getBoolean("jfig.enableXSplines", true) ? new FigNormalXSpline(point.x, point.y, false, figAttribs, figTrafo2D) : new FigSpline(point.x, point.y, false, figAttribs, figTrafo2D);
            this.editor.addTmpObject(this.spline);
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.changeRubberbandMode(2);
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("L: next point, M: final point, R: cancel");
            ++this.n_points;
        } else if (MouseMapper.isMiddleClick(figCanvasEvent) || MouseMapper.isShiftDown(figCanvasEvent)) {
            this.spline.appendPoint(point);
            this.objectCanvas.changeRubberbandMode(1);
            this.execute();
            this.ready = true;
            this.notifyEditor();
        } else if (MouseMapper.isRightClick(figCanvasEvent)) {
            this.n_points = 0;
            if (this.spline != null) {
                this.editor.deleteTmpObject(this.spline);
            }
            this.spline = null;
            this.objectCanvas.changeRubberbandMode(1);
            this.objectCanvas.doFullRedraw();
            this.statusMessage("L: first spline point");
        } else {
            this.spline.appendPoint(point);
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("L: next point, M: final point, R: cancel");
            ++this.n_points;
        }
    }

    public String getDescription() {
        return "create spline";
    }

    public String toString() {
        return "jfig.commands.CreateSplineCommand[]";
    }

    public CreateSplineCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: first spline point");
        figBasicEditor.hideAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

