/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigRectangle;
import jfig.utils.MouseMapper;

public class CreateRoundedRectangleCommand
extends Command {
    protected int n_points;
    protected FigObject rectangle;
    protected FigAttribs attribs;
    protected Point P1;
    protected Point P2;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.rectangle};
        return figObjectArray;
    }

    public void execute() {
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        this.rectangle = new FigRectangle(this.P1.x, this.P1.y, this.P2.x, this.P2.y, true, this.attribs, figTrafo2D);
        if (this.rectangle != null) {
            this.editor.insertIntoObjectList(this.rectangle);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.rectangle != null) {
            this.editor.deleteFromObjectList(this.rectangle);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            this.P1 = new Point(point);
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.changeRubberbandMode(4);
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("L: opposite rectangle corner, R: cancel");
            ++this.n_points;
        } else if (!MouseMapper.isMiddleClick(figCanvasEvent)) {
            if (MouseMapper.isRightClick(figCanvasEvent)) {
                this.n_points = 0;
                if (this.rectangle != null) {
                    this.editor.deleteTmpObject(this.rectangle);
                }
                this.rectangle = null;
                this.objectCanvas.changeRubberbandMode(1);
                this.objectCanvas.doFullRedraw();
                this.statusMessage("L: first rectangle corner");
            } else {
                this.P2 = new Point(point);
                this.objectCanvas.changeRubberbandMode(1);
                this.attribs = this.editor.getCurrentAttribs().getClone();
                this.execute();
                this.ready = true;
                this.notifyEditor();
            }
        }
    }

    public String getDescription() {
        return "create rounded rectangle";
    }

    public String toString() {
        return "jfig.commands.CreateRoundedRectangleCommand[]";
    }

    public CreateRoundedRectangleCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: first rectangle corner");
        figBasicEditor.hideAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

