/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.gui.ColorCache;
import jfig.gui.CreateImageDialog;
import jfig.objects.FigAttribs;
import jfig.objects.FigImage;
import jfig.objects.FigObject;
import jfig.utils.MouseMapper;
import jfig.utils.SetupManager;

public class CreateImageCommand
extends Command
implements ActionListener,
ItemListener,
WindowListener {
    protected static FileDialog fileDialog;
    protected static Frame frame;
    protected int n_points;
    protected FigObject imageObject;
    protected FigAttribs attribs;
    protected Image image;
    protected Point P1;
    protected Point P2;
    protected String filename = ".gif";
    protected CreateImageDialog imageOptionsDialog;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.imageObject};
        return figObjectArray;
    }

    public void setFrame(Frame frame) {
        CreateImageCommand.frame = frame;
    }

    public void execute() {
        if (this.imageObject != null) {
            FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
            this.editor.insertIntoObjectList(this.imageObject);
            this.editor.deleteTmpObject(this.imageObject);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.imageObject != null) {
            this.editor.deleteFromObjectList(this.imageObject);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            this.P1 = new Point(point);
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.changeRubberbandMode(4);
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("L: opposite image object corner, R: cancel");
            ++this.n_points;
        } else if (!MouseMapper.isMiddleClick(figCanvasEvent)) {
            if (MouseMapper.isRightClick(figCanvasEvent)) {
                this.n_points = 0;
                if (this.imageObject != null) {
                    this.editor.deleteTmpObject(this.imageObject);
                }
                this.imageObject = null;
                this.objectCanvas.changeRubberbandMode(1);
                this.objectCanvas.doFullRedraw();
                this.statusMessage("L: first image object corner");
            } else if (this.n_points == 1) {
                int n;
                this.P2 = new Point(point);
                if (this.P1.x > this.P2.x) {
                    n = this.P2.x;
                    this.P2.x = this.P1.x;
                    this.P1.x = n;
                }
                if (this.P1.y > this.P2.y) {
                    n = this.P2.y;
                    this.P2.y = this.P1.y;
                    this.P1.y = n;
                }
                this.objectCanvas.changeRubberbandMode(1);
                Point[] pointArray = new Point[]{this.P1, this.P2};
                this.imageObject = new FigImage();
                this.imageObject.setAttributes(this.editor.getCurrentAttribs().getClone());
                this.imageObject.setTrafo(this.objectCanvas.getTrafo());
                this.imageObject.setPoints(pointArray);
                this.imageObject.setObjectPainter(this.objectCanvas);
                this.editor.addTmpObject(this.imageObject);
                this.showImageOptionsDialog();
                ++this.n_points;
            } else {
                this.statusMessage("Please select the image options first!");
            }
        }
    }

    private void showImageOptionsDialog() {
        if (this.imageOptionsDialog == null) {
            this.imageOptionsDialog = new CreateImageDialog();
            this.imageOptionsDialog.setActionListener((ActionListener)this);
            this.imageOptionsDialog.setItemListener((ItemListener)this);
            this.imageOptionsDialog.addWindowListener((WindowListener)this);
        }
        this.imageOptionsDialog.setFilename(this.filename);
        this.showImageSizeInches();
        this.imageOptionsDialog.setVisible(true);
        this.imageOptionsDialog.toFront();
    }

    private void showImageSizeInches() {
        if (this.imageOptionsDialog == null) {
            return;
        }
        int n = this.P2.x - this.P1.x;
        int n2 = this.P2.y - this.P1.y;
        this.imageOptionsDialog.showSize(new Dimension(n, n2));
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.message("-#- Canceled!");
        this.imageOptionsDialog.setVisible(false);
        this.editor.deleteTmpObject(this.imageObject);
        this.ready = true;
        this.notifyEditor();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Cancel")) {
                this.message("-#- Canceled!");
                this.imageOptionsDialog.setVisible(false);
                this.editor.deleteTmpObject(this.imageObject);
                this.ready = true;
                this.notifyEditor();
            } else if (string.equals("OK")) {
                this.imageOptionsDialog.setVisible(false);
                this.loadImage();
                this.execute();
                this.ready = true;
                this.notifyEditor();
            } else if (string.equals("Load Image")) {
                this.loadImage();
            } else if (string.equals("Browse")) {
                String string2;
                if (frame == null) {
                    frame = new Frame("dummy frame");
                    frame.setSize(new Dimension(50, 50));
                    frame.show();
                }
                if (fileDialog == null) {
                    fileDialog = new FileDialog(frame);
                    fileDialog.setFile(this.filename);
                }
                if ((string2 = SetupManager.getProperty("jfig.gui.CurrentCreateImageDirectory", null)) != null) {
                    fileDialog.setDirectory(string2);
                }
                fileDialog.show();
                this.filename = fileDialog.getFile();
                if (this.filename != null) {
                    String string3 = fileDialog.getDirectory();
                    this.imageOptionsDialog.setFilename(string3 + this.filename);
                    SetupManager.setProperty("jfig.gui.CurrentCreateImageDirectory", string3);
                }
                this.imageOptionsDialog.toFront();
            } else {
                this.message("-E- Unknown event source: " + actionEvent);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.imageObject == null) {
            return;
        }
        ((FigImage)this.imageObject).updateAspectRatio(this.getAspectRatio());
        this.editor.doRedraw();
    }

    private int getAspectRatio() {
        int n = 0;
        String string = this.imageOptionsDialog.getAspectRatio();
        n = string.equals("fit to selected width") ? 13 : (string.equals("fit to selected height") ? 14 : 15);
        return n;
    }

    private void loadImage() {
        FigImage figImage = new FigImage(this.P1.x, this.P1.y, this.P2.x, this.P2.y, this.editor.getCurrentAttribs(), this.objectCanvas.getTrafo(), null);
        this.filename = this.imageOptionsDialog.getFilename();
        String string = "";
        figImage.setImageAndFilename(this.filename, string, "", false);
        figImage.setObjectPainter(this.objectCanvas);
        figImage.updateAspectRatio(this.getAspectRatio());
        if (this.imageOptionsDialog.getLayerCorrectionState()) {
            FigAttribs figAttribs = figImage.getAttributes();
            figAttribs.currentLayer += 10;
            figAttribs.fig_line_color = ColorCache.WHITE;
            figAttribs.lineColor = Color.white;
        }
        this.editor.deleteTmpObject(this.imageObject);
        this.imageObject = figImage;
        this.editor.addTmpObject(this.imageObject);
        this.editor.doRedraw();
    }

    public String getDescription() {
        return "create image";
    }

    public String toString() {
        return "jfig.commands.CreateImageCommand[]";
    }

    public CreateImageCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: first image object corner");
        figBasicEditor.hideAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

