/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;
import jfig.objects.FigText;
import jfig.utils.Format;
import jfig.utils.MouseMapper;
import jfig.utils.SetupManager;

public class CreateDimensioningCommand
extends Command {
    protected Point P;
    protected Point Q;
    protected FigCompound dimensioning;
    protected int n_points;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.dimensioning};
        return figObjectArray;
    }

    public void execute() {
        if (this.dimensioning != null) {
            this.editor.insertIntoObjectList(this.dimensioning);
            this.editor.deleteTmpObject(this.dimensioning);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void cancel() {
        if (this.dimensioning != null) {
            this.editor.deleteTmpObject(this.dimensioning);
        }
        this.objectCanvas.changeRubberbandMode(1);
        this.objectCanvas.doFullRedraw();
    }

    public void undo() {
        if (this.dimensioning != null) {
            this.editor.deleteFromObjectList(this.dimensioning);
            this.objectCanvas.doFullRedraw();
        }
    }

    public static Point[] getMarkerPoints(Point point, double d, double d2, double d3, double d4) {
        Point[] pointArray = new Point[2];
        int n = (int)(d4 * d / d3);
        int n2 = (int)(d4 * d2 / d3);
        pointArray[0] = new Point(point.x - n2, point.y + n);
        pointArray[1] = new Point(point.x + n2, point.y - n);
        return pointArray;
    }

    private static String lookup(String string, String string2) {
        return SetupManager.getProperty(string, string2);
    }

    public static FigCompound createDimensioning(Point point, Point point2, FigTrafo2D figTrafo2D) {
        double d = 94.48818897637796;
        double d2 = point2.x - point.x;
        double d3 = point2.y - point.y;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        String string = "jfig.commands.CreateDimensioningCommand.";
        String string2 = " layer=" + CreateDimensioningCommand.lookup(string + "layer", "200");
        String string3 = " color=" + CreateDimensioningCommand.lookup(string + "color", "black");
        String string4 = " arrowsize=" + CreateDimensioningCommand.lookup(string + "arrowhead", "1.0,4.0,1");
        String string5 = " linewidth=" + CreateDimensioningCommand.lookup(string + "linewidth", "1");
        String string6 = CreateDimensioningCommand.lookup(string + "markerlength", "2.0");
        double d5 = 0.0;
        try {
            String string7 = CreateDimensioningCommand.lookup(string + "outerArrowLimit", "10.0");
            d5 = Double.valueOf(string7) * d;
        }
        catch (Exception exception) {
            d5 = 10.0 * d;
        }
        double d6 = 0.0;
        try {
            d6 = Double.valueOf(string6) * d;
        }
        catch (Exception exception) {
            d6 = 2.0 * d;
        }
        FigAttribs figAttribs = new FigAttribs();
        FigPolyline figPolyline = new FigPolyline();
        figPolyline.setPoints(new Point[]{point, point2});
        if (d4 >= d5) {
            figPolyline.getAttributes().parse(string2 + string3 + " <-> arrowstyle=2" + string4);
        } else {
            figPolyline.getAttributes().parse(string2 + string3);
        }
        FigPolyline figPolyline2 = null;
        FigPolyline figPolyline3 = null;
        if (d4 < d5) {
            int n = (int)(d2 / d4 * 10.0 * d);
            int n2 = (int)(d3 / d4 * 10.0 * d);
            figPolyline2 = new FigPolyline();
            figPolyline2.setPoints(new Point[]{new Point(point.x - n, point.y - n2), point});
            figPolyline2.getAttributes().parse(string2 + string3 + " -> arrowstyle=2" + string4);
            figPolyline3 = new FigPolyline();
            figPolyline3.setPoints(new Point[]{point2, new Point(point2.x + n, point2.y + n2)});
            figPolyline3.getAttributes().parse(string2 + string3 + " <- arrowstyle=2" + string4);
        }
        FigPolyline figPolyline4 = null;
        FigPolyline figPolyline5 = null;
        if (d6 >= 0.0) {
            figPolyline4 = new FigPolyline();
            figPolyline4.setPoints(CreateDimensioningCommand.getMarkerPoints(point, d2, d3, d4, d6));
            figPolyline4.getAttributes().parse(string2 + string3);
            figPolyline5 = new FigPolyline();
            figPolyline5.setPoints(CreateDimensioningCommand.getMarkerPoints(point2, d2, d3, d4, d6));
            figPolyline5.getAttributes().parse(string2 + string3);
        }
        String string8 = " font=" + CreateDimensioningCommand.lookup(string + "font", "SansSerif");
        String string9 = " fontsize=" + CreateDimensioningCommand.lookup(string + "fontsize", "10");
        String string10 = CreateDimensioningCommand.lookup(string + "format", "%6.2f");
        String string11 = CreateDimensioningCommand.lookup(string + "units", "mm");
        double d7 = 0.0;
        d7 = "mm".equals(string11) ? d4 / 96.0 : ("cm".equals(string11) ? d4 / 960.0 : ("in".equals(string11) ? d4 / 2400.0 : d4));
        String string12 = null;
        try {
            long l = Math.round(d7 * 100.0);
            long l2 = l / 100L;
            long l3 = l - 100L * l2;
            string12 = l3 == 0L ? "" + l2 : "" + l2 + "." + l3;
        }
        catch (Exception exception) {
            string12 = "" + new Format("%8.2f").form(d7);
        }
        int n = (point.x + point2.x) / 2;
        int n3 = (point.y + point2.y) / 2;
        double d8 = 0.5 * d;
        int n4 = (int)Math.abs(d3 * d8 / d4);
        int n5 = (int)Math.abs(d2 * d8 / d4);
        double d9 = Math.atan2(-d3, d2);
        if (d9 == -Math.PI) {
            d9 = 0.0;
            n -= n4;
            n3 -= n5;
        } else if (d9 > 1.5707963267948966) {
            d9 = Math.PI - d9;
            n += n4;
            n3 -= n5;
        } else if (d9 >= 0.0) {
            d9 = Math.PI * 2 - d9;
            n -= n4;
            n3 -= n5;
        } else if (d9 > -1.5707963267948966) {
            d9 = -d9;
            n += n4;
            n3 -= n5;
        } else {
            d9 = Math.PI - d9;
            n -= n4;
            n3 -= n5;
        }
        FigText figText = new FigText(new Point(n, n3), string12, figAttribs, figTrafo2D);
        figText.getAttributes().parse(string2 + string3 + string8 + string9 + " textalign=center");
        figText.rotate(figText.getPosition(), d9);
        FigCompound figCompound = new FigCompound();
        figCompound.setComment("dimensioning " + point + " " + point2);
        figCompound.fastAddMember(figText);
        figCompound.fastAddMember(figPolyline);
        if (figPolyline2 != null) {
            figCompound.fastAddMember(figPolyline2);
        }
        if (figPolyline3 != null) {
            figCompound.fastAddMember(figPolyline3);
        }
        if (figPolyline4 != null) {
            figCompound.fastAddMember(figPolyline4);
        }
        if (figPolyline5 != null) {
            figCompound.fastAddMember(figPolyline5);
        }
        figCompound.setTrafo(figTrafo2D);
        return figCompound;
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            this.P = new Point(point.x, point.y);
            FigAttribs figAttribs = this.editor.getCurrentAttribs().getClone();
            FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.changeRubberbandMode(2);
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("L: end point, R: cancel");
            ++this.n_points;
        } else if (MouseMapper.isRightClick(figCanvasEvent)) {
            this.n_points = 0;
            this.objectCanvas.changeRubberbandMode(1);
            this.objectCanvas.doFullRedraw();
            this.statusMessage("L: first dimensioning point");
        } else {
            this.Q = new Point(point.x, point.y);
            this.objectCanvas.changeRubberbandMode(1);
            this.dimensioning = CreateDimensioningCommand.createDimensioning(this.P, this.Q, this.objectCanvas.getTrafo());
            this.execute();
            this.ready = true;
            this.notifyEditor();
        }
    }

    public String getDescription() {
        return "create dimensioning";
    }

    public String toString() {
        return "jfig.commands.CreateDimensioningCommand[]";
    }

    public CreateDimensioningCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: first dimensioning point");
        figBasicEditor.hideAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

