/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigArc;
import jfig.objects.FigAttribs;
import jfig.objects.FigEllipse;
import jfig.objects.FigObject;
import jfig.utils.MouseMapper;

public class CreateArcCommand
extends Command {
    public static final boolean P1_P2_P3 = false;
    public static final boolean CENTER_P1_P2_P3 = true;
    protected int n_points;
    protected FigObject arc;
    protected Point P1;
    protected Point P2;
    protected Point P3;
    protected FigAttribs attribs;
    protected boolean mode;
    protected FigObject tmpCircle;
    protected Point PX;
    protected int radius;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.arc};
        return figObjectArray;
    }

    public void execute() {
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        this.arc = new FigArc(this.P1, this.P2, this.P3, this.attribs, figTrafo2D);
        if (this.arc != null) {
            this.editor.insertIntoObjectList(this.arc);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.arc != null) {
            this.editor.deleteFromObjectList(this.arc);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (MouseMapper.isMiddleClick(figCanvasEvent)) {
            if (this.n_points == 0) {
                this.mode = true;
                this.PX = new Point(point.x, point.y);
                this.objectCanvas.setRubberbandBasePoint(point2);
                this.objectCanvas.changeRubberbandMode(16);
                this.objectCanvas.doFullRedraw();
                this.statusMessage("L: first angle R:cancel");
            }
        } else if (MouseMapper.isRightClick(figCanvasEvent)) {
            this.n_points = 0;
            this.mode = false;
            if (this.tmpCircle != null) {
                this.editor.deleteTmpObject(this.tmpCircle);
            }
            if (this.arc != null) {
                this.editor.deleteTmpObject(this.arc);
            }
            this.arc = null;
            this.objectCanvas.changeRubberbandMode(1);
            this.objectCanvas.doFullRedraw();
            this.statusMessage("L: first arc point M: arc center");
        } else if (this.mode) {
            if (this.n_points == 0) {
                double d = point.x - this.PX.x;
                double d2 = point.y - this.PX.y;
                this.radius = (int)Math.sqrt(d * d + d2 * d2);
                Point point3 = new Point(this.PX.x + this.radius, this.PX.y + this.radius);
                this.tmpCircle = new FigEllipse(this.PX, point3, new FigAttribs(), this.objectCanvas.getTrafo());
                this.editor.addTmpObject(this.tmpCircle);
                this.P1 = new Point(point);
                this.objectCanvas.setRubberbandBasePoint(point2);
                this.objectCanvas.changeRubberbandMode(2);
                this.objectCanvas.doSimpleRedraw();
                this.statusMessage("L: second arc point, R: cancel");
                ++this.n_points;
            } else if (this.n_points == 1) {
                if (point.equals(this.P1)) {
                    this.statusMessage("L: second arc point, R: cancel (double point ignored!)");
                } else {
                    double d = point.x - this.PX.x;
                    double d3 = point.y - this.PX.y;
                    double d4 = Math.sqrt(d * d + d3 * d3);
                    if (d4 == 0.0) {
                        return;
                    }
                    double d5 = d * (double)this.radius / d4;
                    double d6 = d3 * (double)this.radius / d4;
                    this.P2 = new Point(this.PX.x + (int)d5, this.PX.y + (int)d6);
                    this.objectCanvas.setRubberbandBasePoint2(this.objectCanvas.getTrafo().getScreenCoords(this.P2));
                    this.objectCanvas.changeRubberbandMode(12);
                    this.objectCanvas.doSimpleRedraw();
                    this.statusMessage("L: third arc point, R: cancel");
                    ++this.n_points;
                }
            } else if (point.equals(this.P1) || point.equals(this.P2)) {
                this.statusMessage("L: third arc point, R: cancel (double point ignored!)");
            } else {
                double d = point.x - this.PX.x;
                double d7 = point.y - this.PX.y;
                double d8 = Math.sqrt(d * d + d7 * d7);
                if (d8 == 0.0) {
                    return;
                }
                double d9 = d * (double)this.radius / d8;
                double d10 = d7 * (double)this.radius / d8;
                this.P3 = new Point(this.PX.x + (int)d9, this.PX.y + (int)d10);
                this.editor.deleteTmpObject(this.tmpCircle);
                this.objectCanvas.changeRubberbandMode(1);
                this.attribs = this.editor.getCurrentAttribs().getClone();
                this.execute();
                this.ready = true;
                this.notifyEditor();
            }
        } else if (this.n_points == 0) {
            this.P1 = new Point(point);
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.changeRubberbandMode(2);
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("L: second arc point, R: cancel");
            ++this.n_points;
        } else if (this.n_points == 1) {
            if (point.equals(this.P1)) {
                this.statusMessage("L: second arc point, R: cancel (double point ignored!)");
            } else {
                this.P2 = new Point(point);
                this.objectCanvas.setRubberbandBasePoint2(point2);
                this.objectCanvas.changeRubberbandMode(12);
                this.objectCanvas.doSimpleRedraw();
                this.statusMessage("L: third arc point, R: cancel");
                ++this.n_points;
            }
        } else if (point.equals(this.P1) || point.equals(this.P2)) {
            this.statusMessage("L: third arc point, R: cancel (double point ignored!)");
        } else {
            this.P3 = new Point(point);
            this.objectCanvas.changeRubberbandMode(1);
            this.attribs = this.editor.getCurrentAttribs().getClone();
            this.execute();
            this.ready = true;
            this.notifyEditor();
        }
    }

    public String getDescription() {
        return "create arc";
    }

    public String toString() {
        return "jfig.commands.CreateArcCommand[]";
    }

    public CreateArcCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: first arc point M: arc center");
        figBasicEditor.hideAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.mode = false;
        this.ready = false;
    }
}

