/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;
import jfig.objects.FigWriter;
import jfig.utils.MouseMapper;

public class CopyObjectCommand
extends Command {
    protected int n_points;
    protected FigObject source;
    protected FigObject clone;
    protected Point startPoint;
    protected Point endPoint;
    protected int dx;
    protected int dy;
    protected boolean restricted;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.source, this.clone};
        return figObjectArray;
    }

    public void execute() {
        if (this.source != null) {
            this.clone = this.source.copy();
            if (this.clone == null) {
                return;
            }
            this.dx = this.endPoint.x - this.startPoint.x;
            this.dy = this.endPoint.y - this.startPoint.y;
            if (this.restricted) {
                if (Math.abs(this.dx) > Math.abs(this.dy)) {
                    this.dy = 0;
                } else {
                    this.dx = 0;
                }
            }
            this.clone.move(this.dx, this.dy);
            this.editor.insertIntoObjectList(this.clone);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.clone != null) {
            this.editor.deleteFromObjectList(this.clone);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            this.source = this.editor.findObjectAt(point);
            if (this.source == null) {
                this.statusMessage("L: copy object, M: horiz/vert copy, R: copy to clipboard");
                return;
            }
            ++this.n_points;
            this.startPoint = new Point(point);
            if (MouseMapper.isRightClick(figCanvasEvent)) {
                this.copyToClipboard(this.source);
                this.statusMessage("L: copy object, M: horiz/vert copy, R: copy to clipboard");
                this.n_points = 0;
                this.source = null;
                return;
            }
            if (MouseMapper.isMiddleClick(figCanvasEvent)) {
                this.restricted = true;
                this.setRubberbanding(this.source, point2);
                this.statusMessage("L: put object,   R: cancel");
            } else {
                this.restricted = false;
                this.setRubberbanding(this.source, point2);
                this.statusMessage("L: put object,   R: cancel");
            }
        } else if (MouseMapper.isRightClick(figCanvasEvent)) {
            this.n_points = 0;
            if (this.source != null) {
                this.source.showPoints();
            }
            this.source = null;
            this.objectCanvas.changeRubberbandMode(1);
            this.objectCanvas.doFullRedraw();
            this.statusMessage("L: copy object, M: horiz/vert copy, R: copy to clipboard");
        } else if (!MouseMapper.isMiddleClick(figCanvasEvent)) {
            if (figCanvasEvent.isShiftDown() && point.equals(this.startPoint)) {
                this.message("-I- trying to find the next stacked object...");
                if (this.source != null) {
                    this.source.deselect();
                }
                this.source = this.editor.findNextObjectAt(point, this.source);
                if (this.source == null) {
                    return;
                }
                this.source.select();
                this.objectCanvas.doFullRedraw();
                this.setRubberbanding(this.source, point2);
            } else {
                this.endPoint = new Point(point);
                this.objectCanvas.changeRubberbandMode(1);
                this.execute();
                this.ready = true;
                this.notifyEditor();
            }
        }
    }

    private void copyToClipboard(FigObject figObject) {
        if (figObject == null) {
            return;
        }
        this.message("-I- Writing object to clipboard buffer...");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        FigObjectList figObjectList = new FigObjectList();
        figObjectList.insert(figObject);
        FigWriter figWriter = new FigWriter();
        figWriter.write_fig31_file(dataOutputStream, true, figObjectList);
        StringSelection stringSelection = new StringSelection(byteArrayOutputStream.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    private void setRubberbanding(FigObject figObject, Point point) {
        figObject.select();
        this.objectCanvas.setRubberbandBasePoint(point);
        this.objectCanvas.changeRubberbandMode(5, this.objectCanvas.getTrafo(), figObject.getBbox());
        if (this.restricted) {
            this.objectCanvas.changeRubberbandMode(13);
        }
        this.objectCanvas.doFullRedraw();
    }

    public String getDescription() {
        return "copy object";
    }

    public String toString() {
        return "jfig.commands.CopyObjectCommand[]";
    }

    public CopyObjectCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: copy object, M: horiz/vert copy, R: copy to clipboard");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

