/*
 * Decompiled with CFR 0.152.
 */
package jfig.canvas;

import java.awt.Point;
import jfig.utils.ExceptionTracer;

public class FigTrafo2D
implements Cloneable {
    public static final int dpi = 2400;
    public static final int DPI = 2400;
    public static final int DOTS_PER_MM = 96;
    public static final int DOTS_PER_INCH = 75;
    public static final int DOTS_PER_XMM = 80;
    public static final int UNITS_MM = 1;
    public static final int UNITS_INCHES = 2;
    public static final int UNITS_XMM = 3;
    public static String[] UNITS_STRING = new String[]{"??", "cm", "in", "xmm"};
    public static final int NO_GRID = 0;
    public static final int FINE_GRID = 240;
    public static final int MEDIUM_GRID = 480;
    public static final int COARSE_GRID = 960;
    public static final int TEN_GRID = 961;
    public static final int NO_SNAP = 1;
    public static final int COARSE_SNAP = 2;
    public static final int MEDIUM_SNAP = 3;
    public static final int FINE_SNAP = 4;
    public static final int TEN_SNAP = 10;
    public static final double MIN_ZOOM_FACTOR = 0.03125;
    public static final double MAX_ZOOM_FACTOR = 32.0;
    public static final boolean debug = false;
    static final double[] offsets = new double[]{-15.5, -10.814, -7.5, -5.157, -3.5, -2.3284, -1.5, -0.9142, -0.5, -0.2071, 0.0, 0.14644, 0.25, 0.32322, 0.375, 0.4116, 0.4375, 0.4558, 0.46875, 0.4779, 0.484375};
    static final double[] factors = new double[]{32.0, 22.627, 16.0, 11.3137, 8.0, 5.6569, 4.0, 2.82843, 2.0, 1.41421, 1.0, 0.70711, 0.5, 0.35355, 0.25, 0.1767, 0.125, 0.08839, 0.0625, 0.04419, 0.03125};
    static final double FACTOR = 2.0;
    public int units = 2;
    protected double zoom_factor = 1.0;
    protected int zoom_factor75 = (int)(75.0 * this.zoom_factor);
    protected double d_zoom_factor = this.zoom_factor * 75.0 / 2400.0;
    protected double snapDelta = 48.0;
    public int snapMode = 3;
    public int gridMode = 960;
    public long timestamp;
    protected Point anchor = new Point(0, 0);
    protected Point p = new Point(0, 0);

    public void setAnchor(Point point) {
        this.anchor.x = point.x;
        this.anchor.y = point.y;
        this.timestamp = System.currentTimeMillis();
    }

    public Point getAnchor() {
        return this.anchor;
    }

    public void set_zoom(double d) {
        if (d >= 32.0) {
            d = 32.0;
        }
        if (d <= 0.03125) {
            d = 0.03125;
        }
        this.zoom_factor = d;
        this.zoom_factor75 = (int)(75.0 * this.zoom_factor);
        if (this.zoom_factor75 < 1) {
            this.zoom_factor75 = 1;
        }
        this.d_zoom_factor = this.zoom_factor * 75.0 / 2400.0;
        this.setSnapRelative(this.snapMode);
        this.timestamp = System.currentTimeMillis();
    }

    public void set_zoom_region(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n > n3) {
            n7 = n;
            n = n3;
            n3 = n7;
        }
        if (n2 > n4) {
            n7 = n2;
            n2 = n4;
            n4 = n7;
        }
        if (n3 == n) {
            n3 = n + 1;
        }
        if (n4 == n2) {
            n4 = n2 + 1;
        }
        this.anchor.x = n;
        this.anchor.y = n2;
        double d = 32.0 * (double)n5 / (double)(n3 - n);
        double d2 = 32.0 * (double)n6 / (double)(n4 - n2);
        double d3 = Math.min(d, d2);
        int n8 = 0;
        while (n8 < factors.length) {
            if (1.1 * d3 > factors[n8]) {
                d3 = factors[n8];
                break;
            }
            ++n8;
        }
        d3 = Math.max(0.013333333333333334, d3);
        this.set_zoom(d3);
    }

    public void set_zoom_region_ooooolllllldddd(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n > n3) {
            n7 = n;
            n = n3;
            n3 = n7;
        }
        if (n2 > n4) {
            n7 = n2;
            n2 = n4;
            n4 = n7;
        }
        if (n3 == n) {
            n3 = n + 1;
        }
        if (n4 == n2) {
            n4 = n2 + 1;
        }
        this.anchor.x = n;
        this.anchor.y = n2;
        double d = 32.0 * (double)n5 / (double)(n3 - n);
        double d2 = 32.0 * (double)n6 / (double)(n4 - n2);
        double d3 = Math.min(d, d2);
        double d4 = 1.52587890625E-5;
        while (d4 < d3) {
            d4 *= 2.0;
        }
        d3 = d4;
        d3 = Math.max(0.013333333333333334, d3);
        this.set_zoom(d3);
    }

    public double getZoomFactor() {
        return this.zoom_factor;
    }

    public double getZoom() {
        return this.zoom_factor;
    }

    public double getMinZoomFactor() {
        return 0.03125;
    }

    public double getMaxZoomFactor() {
        return 32.0;
    }

    /*
     * Unable to fully structure code
     */
    public double getZoomFactor_MultipleOfTwo() {
        block2: {
            var1_1 = 1.0;
            if (!(this.zoom_factor >= 1.0)) ** GOTO lbl8
            while (var1_1 < this.zoom_factor) {
                var1_1 = 2.0 * var1_1;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var1_1 = 0.5 * var1_1;
lbl8:
                // 2 sources

                ** while (var1_1 >= this.zoom_factor)
            }
lbl9:
            // 1 sources

            var1_1 = 2.0 * var1_1;
        }
        return var1_1;
    }

    public int get_units() {
        return this.units;
    }

    public int getUnits() {
        return this.get_units();
    }

    public String get_units_string() {
        return UNITS_STRING[this.units];
    }

    public double getValueInUnits(int n) {
        if (this.units == 1) {
            return (double)n / 960.0;
        }
        if (this.units == 2) {
            return (double)n / 2400.0;
        }
        if (this.units == 3) {
            return (double)n / 80.0;
        }
        System.err.println("-E- FigTrafo2D: units not set?");
        return n;
    }

    public void setSnapAbsolute(double d) {
        this.snapDelta = d;
    }

    public void setSnapRelative(int n) {
        int n2 = 1;
        this.snapDelta = 1.0;
        this.snapMode = n;
        if (n == 1) {
            return;
        }
        if (n == 2) {
            n2 = 2;
        } else if (n == 3) {
            n2 = 4;
        } else if (n == 4) {
            n2 = 8;
        } else if (n == 10) {
            n2 = 10;
        } else {
            this.message("-E- FigTrafo2D.setSnapRelative: illegal snap mode " + n);
            this.snapMode = 1;
            return;
        }
        if (this.units == 1) {
            this.snapDelta = 1920.0;
        } else if (this.units == 2) {
            this.snapDelta = 2400.0;
        } else if (this.units == 3) {
            this.snapDelta = 1800.0;
        } else {
            this.message("-E- FigTrafo2D.setSnapRelative: illegal units:" + this.units);
            this.snapDelta = 1.0;
            return;
        }
        this.snapDelta /= (double)n2 * this.getZoomFactor_MultipleOfTwo();
    }

    public double getSnap() {
        return Math.max(this.snapDelta, 1.0);
    }

    public int getSnapRelative() {
        if (this.snapDelta > 1.0) {
            return (int)this.snapDelta;
        }
        return this.screen_to_wc(8);
    }

    public boolean insideSnap(int n, int n2) {
        return Math.abs(n - n2) <= this.getSnapRelative();
    }

    public double getGridSpacingValue() {
        double d = 1.0;
        if (this.units == 1) {
            d = 1920.0 / this.zoom_factor;
        } else if (this.units == 2) {
            d = 2400.0 / this.zoom_factor;
        } else if (this.units == 3) {
            d = 1800.0 / this.zoom_factor;
        } else {
            System.out.println("FigTrafo2D.getGridSpacing: illegal units!");
            d = 1.0;
        }
        return d;
    }

    public int screen_to_wc(int n) {
        return (int)((double)n * 32.0 / this.zoom_factor);
    }

    public int screen_to_wc_x(int n) {
        return this.anchor.x + (int)((double)n * 32.0 / this.zoom_factor);
    }

    public int screen_to_wc_y(int n) {
        return this.anchor.y + (int)((double)n * 32.0 / this.zoom_factor);
    }

    public Point screen_to_wc(Point point, Point point2) {
        point2.x = this.anchor.x + (int)((double)point.x * 32.0 / this.zoom_factor);
        point2.y = this.anchor.y + (int)((double)point.y * 32.0 / this.zoom_factor);
        return point2;
    }

    public int wc_to_screen(int n) {
        return (int)((double)n * this.zoom_factor / 32.0);
    }

    public double wc_to_screen(double d) {
        return d * this.zoom_factor / 32.0;
    }

    public int wc_to_screen_x(int n) {
        return (int)((double)(n - this.anchor.x) * this.zoom_factor / 32.0);
    }

    public int wc_to_screen_y(int n) {
        return (int)((double)(n - this.anchor.y) * this.zoom_factor / 32.0);
    }

    public Point wc_to_screen(Point point, Point point2) {
        if (point == null) {
            this.message("-F- FigTrafo2D.wc_to_screen: wp is null!");
            return new Point(0, 0);
        }
        if (point2 == null) {
            this.message("-F- FigTrafo2D.wc_to_screen: sp is null!");
            return new Point(0, 0);
        }
        point2.x = (int)((double)(point.x - this.anchor.x) * this.zoom_factor / 32.0);
        point2.y = (int)((double)(point.y - this.anchor.y) * this.zoom_factor / 32.0);
        return point2;
    }

    public Point wc_to_screen(double d, double d2, Point point) {
        point.x = (int)((d - (double)this.anchor.x) * this.zoom_factor / 32.0);
        point.y = (int)((d2 - (double)this.anchor.y) * this.zoom_factor / 32.0);
        return point;
    }

    public Point screen_to_wc_snapped(Point point, Point point2) {
        return this.screen_to_wc_snapped(point.x, point.y, point2);
    }

    public Point screen_to_wc_snapped(int n, int n2, Point point) {
        double d = (double)this.anchor.x + (double)n * 32.0 / this.zoom_factor + 0.5 * this.snapDelta;
        double d2 = (double)this.anchor.y + (double)n2 * 32.0 / this.zoom_factor + 0.5 * this.snapDelta;
        point.x = (int)(Math.floor(d / this.snapDelta) * this.snapDelta);
        point.y = (int)(Math.floor(d2 / this.snapDelta) * this.snapDelta);
        return point;
    }

    public Point getWorldCoords(int n, int n2) {
        Point point = new Point(0, 0);
        point.x = this.anchor.x + (int)((double)n * 32.0 / this.zoom_factor);
        point.y = this.anchor.y + (int)((double)n2 * 32.0 / this.zoom_factor);
        return point;
    }

    public Point getWorldCoords(Point point) {
        return this.getWorldCoords(point.x, point.y);
    }

    public Point getWorldCoordsSnapped(int n, int n2) {
        Point point = new Point(0, 0);
        return this.screen_to_wc_snapped(n, n2, point);
    }

    public Point getWorldCoordsSnapped(Point point) {
        return this.getWorldCoordsSnapped(point.x, point.y);
    }

    public Point getScreenCoords(Point point) {
        Point point2 = new Point(0, 0);
        return this.wc_to_screen(point.x, point.y, point2);
    }

    public void setGridMode(int n) {
        this.gridMode = n;
    }

    public int getGridMode() {
        return this.gridMode;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void doChangeUnits() {
        ++this.units;
        if (this.units > 3) {
            this.units = 1;
        }
        this.setSnapRelative(this.snapMode);
    }

    public void setUnits(int n) {
        if (n == 1) {
            this.units = 1;
        } else if (n == 2) {
            this.units = 2;
        } else if (n == 3) {
            this.units = 3;
        } else {
            throw new IllegalArgumentException("setUnits: unknown units value: " + n);
        }
        this.setSnapRelative(this.snapMode);
    }

    public FigTrafo2D getClone() {
        try {
            FigTrafo2D figTrafo2D = (FigTrafo2D)FigTrafo2D.super.clone();
            figTrafo2D.anchor = new Point(this.anchor.x, this.anchor.y);
            return figTrafo2D;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void message(String string) {
        ExceptionTracer.message(string);
    }

    public FigTrafo2D() {
        this.timestamp = System.currentTimeMillis();
    }
}

