/*
 * Decompiled with CFR 0.152.
 */
package jfig.canvas;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigCanvasListener;
import jfig.canvas.FigCanvasRubberband;
import jfig.canvas.FigDrawable;
import jfig.canvas.FigDrawableEnumerator;
import jfig.canvas.FigTrafo2D;
import jfig.canvas.FullRedraw;
import jfig.canvas.ObjectPainter;
import jfig.canvas.SyncPainter;
import jfig.canvas.ZoomListener;
import jfig.gui.ConsoleMessage;
import jfig.gui.StatusMessage;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.utils.BoundingBoxCalculator;
import jfig.utils.Format;
import jfig.utils.GeometryManager;
import jfig.utils.SetupManager;

public class FigSwingCanvas
extends JComponent
implements FigCanvas,
FullRedraw,
ObjectPainter,
SyncPainter,
MouseListener,
MouseMotionListener {
    protected static final Font rulerFont = new Font("MonoSpaced", 0, 8);
    public static final int PAINT_TMP_TEXT = 5;
    public static final int PAINT_NO_CHANGES = 7;
    public static final int PAINT_TOP_RULER = 13;
    public static final int PAINT_RIGHT_RULER = 14;
    public static final int PAINT_CURSOR = 15;
    public static final int PAINT_RUBBERBAND = 16;
    public static final int PAINT_OBJECTS = 27;
    public static final int PAINT_ALL = -1;
    protected FigDrawableEnumerator objectEnumerator;
    protected FigTrafo2D trafo;
    protected ConsoleMessage printer = null;
    protected StatusMessage helper = null;
    protected FigCanvasListener canvasListener = null;
    protected Vector zoomListenerVector = null;
    public Cursor waitCursor;
    public Cursor defaultCursor;
    protected FigCanvasRubberband rubberband;
    protected ImageObserver theObserver = null;
    protected Image offscreenImage;
    protected Image tripleBuffer;
    protected Graphics offscreenGR;
    protected Graphics objectGR;
    protected Graphics tripleBufferGR;
    protected int cur_x = 0;
    protected int cur_y = 0;
    protected int old_x = -10;
    protected int old_y = -10;
    protected int cur_width = 0;
    protected int cur_height = 0;
    protected Dimension XXX;
    protected Point ptmp;
    protected Point tmp_sc;
    protected Point tmp_wc;
    protected Color backgroundColor = Color.white;
    protected Color gridColor = Color.black;
    protected Color defaultColor = Color.black;
    protected boolean gridVisible;
    protected int gridMode;
    protected int zoomFitBorderWidth = 15;
    protected int mode = -1;
    protected int BASE_ANCHOR_X = 0;
    protected int BASE_ANCHOR_Y = -781;
    protected int RULER_XL_OFFSET = 0;
    protected int RULER_XR_OFFSET = 26;
    protected int RULER_YT_OFFSET = 26;
    protected int RULER_YB_OFFSET = 0;
    int mouse_drag_x = -1;
    int mouse_drag_y = -1;
    protected boolean hasRulers = true;
    protected boolean enableRulerDragging = true;
    protected boolean debug = false;
    protected boolean Jdebug = false;
    protected boolean enableTimingInfo = true;
    protected boolean useTripleBuffering = false;
    int n_updates = 0;
    int n_redraws = 0;
    long t_redraw = 0L;
    long t_redraw_mean = 0L;
    int n_grid = 0;
    long t_grid = 0L;
    long t_grid_mean = 0L;
    long t_delay = 30L;
    protected Format two_decimals = new Format("%.2f");
    private Rectangle _lastTextClipRectangle = new Rectangle(0, 0, 0, 0);
    int n_trials_to_create_offscreenImage = 0;
    private Options2D options2D = null;

    public String getSwingRepaintMode() {
        if (this.mode == 5) {
            return "PAINT_TMP_TEXT";
        }
        if (this.mode == 7) {
            return "PAINT_NO_CHANGES";
        }
        if (this.mode == 13) {
            return "PAINT_TOP_RULER";
        }
        if (this.mode == 14) {
            return "PAINT_RIGHT_RULER";
        }
        if (this.mode == 15) {
            return "PAINT_CURSOR";
        }
        if (this.mode == 16) {
            return "PAINT_RUBBERBAND";
        }
        if (this.mode == 27) {
            return "PAINT_OBJECTS";
        }
        if (this.mode == -1) {
            return "PAINT_ALL";
        }
        return "###UNKNOWN_MODE###" + this.mode;
    }

    public void setRulerOffsets() {
        if (this.hasRulers) {
            this.BASE_ANCHOR_X = 0;
            this.BASE_ANCHOR_Y = -781;
            this.RULER_XL_OFFSET = 0;
            this.RULER_YT_OFFSET = 26;
            this.RULER_XR_OFFSET = 26;
            this.RULER_YB_OFFSET = 0;
        } else {
            this.BASE_ANCHOR_X = 0;
            this.BASE_ANCHOR_Y = 0;
            this.RULER_XL_OFFSET = 0;
            this.RULER_YT_OFFSET = 0;
            this.RULER_XR_OFFSET = 0;
            this.RULER_YB_OFFSET = 0;
        }
    }

    public boolean isRightYRuler() {
        return true;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public FigTrafo2D getTrafo() {
        return this.trafo;
    }

    public void setTrafo(FigTrafo2D figTrafo2D) {
        if (this.debug) {
            this.msg("-#- FigSwingCanvas.setTrafo: " + figTrafo2D);
        }
        this.trafo = figTrafo2D;
        this.rubberband.setTrafo(figTrafo2D);
    }

    public Component getComponent() {
        return this;
    }

    public Graphics getOffscreenGraphics() {
        if (this.debug) {
            this.msg("-#- FigSwingCanvas.getOffscreenGraphics:" + this.offscreenGR);
        }
        return this.offscreenGR;
    }

    public void setDefaultCursor(Cursor cursor) {
        this.defaultCursor = cursor;
        this.setCursor(this.defaultCursor);
    }

    public void addCanvasListener(FigCanvasListener figCanvasListener) {
        this.canvasListener = figCanvasListener;
    }

    public void setObjectEnumerator(FigDrawableEnumerator figDrawableEnumerator) {
        this.objectEnumerator = figDrawableEnumerator;
    }

    public FigDrawableEnumerator getObjectEnumerator() {
        return this.objectEnumerator;
    }

    public void statusMessage(String string) {
        if (this.helper != null) {
            this.helper.setStatusMessage(string);
        } else {
            this.msg(string);
        }
    }

    public void setStatusMessage(StatusMessage statusMessage) {
        this.helper = statusMessage;
    }

    public void msg(String string) {
        if (this.printer != null) {
            this.printer.consoleMessage(string);
        } else {
            System.out.println(string);
        }
    }

    public void setConsole(ConsoleMessage consoleMessage) {
        this.printer = consoleMessage;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
        this.defaultColor = color;
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public Point getMousePosition() {
        return new Point(this.cur_x, this.cur_y);
    }

    public void showRulers(boolean bl) {
        this.hasRulers = bl;
        this.setRulerOffsets();
    }

    public void setEnableRulerDragging(boolean bl) {
        this.enableRulerDragging = bl;
    }

    public void setTripleBuffering(boolean bl) {
        this.useTripleBuffering = bl;
        this.offscreenGR = null;
        this.initializeOffscreenBuffers();
        this.doFullRedraw();
        if (this.debug) {
            this.msg("-#- FigSwingCanvas.setTripleBuffering: " + this.useTripleBuffering);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.debug) {
            this.msg("-#- FigSwingCanvas: mousePressed: " + mouseEvent);
        }
        this.requestFocus();
        if (this.Jdebug) {
            System.err.println("-#- gotFocus: " + this.hasFocus());
            System.err.println("-#  isRequestFocusEnabled: " + this.isRequestFocusEnabled());
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.getCurrentCanvasSize();
        if (this.hasRulers && (n2 < 25 || n > this.cur_width - 25)) {
            this.mouse_drag_x = n;
            this.mouse_drag_y = n2;
            if (this.debug) {
                this.msg("-#- FigSwingCanvas: doPanning at " + n + ", " + n2);
            }
            if (n2 < 25 && n < 25) {
                this.doPanning(1, false);
            } else if (n2 < 25 && n > this.cur_width - 50 && n < this.cur_width - 25) {
                this.doPanning(2, false);
            } else if (n > this.cur_width - 25 && n2 > this.cur_height - 25) {
                this.doPanning(4, false);
            } else if (n > this.cur_width - 25 && n2 > 25 && n2 < 50) {
                this.doPanning(3, false);
            } else if (n > this.cur_width - 25 && n2 < 25) {
                this.trafo.doChangeUnits();
                this.doFullRedraw(20L);
            }
            return;
        }
        this.ptmp = this.trafo.screen_to_wc_snapped(n, n2, this.ptmp);
        this.tmp_sc = this.trafo.wc_to_screen(this.ptmp, this.tmp_sc);
        this.cur_x = this.tmp_sc.x;
        this.cur_y = this.tmp_sc.y;
        if (this.debug) {
            this.msg("-#- snapped world coords: " + this.ptmp.x + ", " + this.ptmp.y);
        }
        if (this.canvasListener != null) {
            Point point = new Point(this.ptmp);
            Point point2 = new Point(this.tmp_sc);
            this.canvasListener.mousePressed(new FigCanvasEvent(mouseEvent, point2, point));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.debug) {
            this.msg("-#- FigSwingCanvas: mouseReleased: " + mouseEvent);
        }
        if (!this.enableRulerDragging) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.mouse_drag_x == n && this.mouse_drag_y == n2) {
            return;
        }
        if (!(this.mouse_drag_x <= this.cur_width - 25 && this.mouse_drag_y >= 25 || n <= this.cur_width - 25 && n2 >= 25)) {
            int n3 = this.mouse_drag_x - n;
            int n4 = this.mouse_drag_y - n2;
            if (Math.abs(n3) < 10) {
                n3 = 0;
            }
            if (Math.abs(n4) < 10) {
                n4 = 0;
            }
            if (this.debug) {
                this.msg("-#- mouseRelease: drag distance= " + n3 + ", " + n4);
            }
            int n5 = this.trafo.screen_to_wc(n3);
            int n6 = this.trafo.screen_to_wc(n4);
            Point point = new Point(0, 0);
            point = this.trafo.getAnchor();
            point.x += n5;
            point.y += n6;
            this.trafo.setAnchor(point);
            if (this.debug) {
                this.msg("-#- new viewport anchor at (" + this.trafo.getValueInUnits(point.x) + ", " + this.trafo.getValueInUnits(point.y) + ") " + this.trafo.get_units_string());
            }
            this.doFullRedraw();
        }
        this.mouse_drag_x = n;
        this.mouse_drag_y = n2;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.debug) {
            this.msg("-#- FigSwingCanvas: mouseEntered");
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.debug) {
            this.msg("-#- FigSwingCanvas: mouseMove to (" + n + ", " + n2 + ")");
        }
        this.ptmp = this.trafo.screen_to_wc_snapped(n, n2, this.ptmp);
        this.tmp_sc = this.trafo.wc_to_screen(this.ptmp, this.tmp_sc);
        this.cur_x = this.tmp_sc.x;
        this.cur_y = this.tmp_sc.y;
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        int n5 = Math.min(this.old_x, this.cur_x);
        int n6 = Math.min(this.old_y, this.cur_y);
        int n7 = Math.max(this.old_x, this.cur_x) - n5 + 1;
        int n8 = Math.max(this.old_y, this.cur_y) - n6 + 1;
        if (this.Jdebug) {
            this.msg("-#- FSC.mouseMoved: " + n + " " + n2);
        }
        if (this.hasRulers) {
            this.paintImmediately(n5, 0, n7, 11);
            if (this.isRightYRuler()) {
                this.paintImmediately(n3 - 26, n6, n3, n8);
            } else {
                this.paintImmediately(0, n6, 5, n8);
            }
        }
        Rectangle rectangle = this.rubberband.getRubberBoundingBox(this.old_x, this.old_y, this.cur_x, this.cur_y);
        this.paintImmediately(rectangle.x - 4, rectangle.y - 4, rectangle.width + 7, rectangle.height + 7);
        this.old_x = this.cur_x;
        this.old_y = this.cur_y;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public boolean gotFocus() {
        if (this.debug) {
            this.msg("-#- FigSwingCanvas: Got the keyboard focus!");
        }
        return true;
    }

    public void doPanning(int n, boolean bl) {
        this.getCurrentCanvasSize();
        this.tmp_sc.x = this.cur_width;
        this.tmp_sc.y = this.cur_height;
        this.tmp_wc = this.trafo.screen_to_wc(this.tmp_sc, this.tmp_wc);
        Point point = this.trafo.getAnchor();
        if (this.debug) {
            this.msg("-#- FigSwingCanvas.doPanning: anchor=" + point);
        }
        double d = bl ? 0.4 : 0.05;
        int n2 = (int)((double)(this.tmp_wc.x - point.x) * d);
        int n3 = (int)((double)(this.tmp_wc.y - point.y) * d);
        switch (n) {
            case 0: {
                point.x = this.BASE_ANCHOR_X;
                point.y = this.BASE_ANCHOR_Y;
                this.trafo.setAnchor(point);
                break;
            }
            case 2: {
                point.x += n2;
                this.trafo.setAnchor(point);
                break;
            }
            case 1: {
                point.x -= n2;
                this.trafo.setAnchor(point);
                break;
            }
            case 4: {
                point.y += n3;
                this.trafo.setAnchor(point);
                break;
            }
            case 3: {
                point.y -= n3;
                this.trafo.setAnchor(point);
                break;
            }
            default: {
                this.msg("-E- FigSwingCanvas.doPanning: unknown direction " + n);
                break;
            }
        }
        this.doFullRedraw();
        this.notifyZoomListeners();
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public boolean isOptimizedDrawingEnabled() {
        if (this.Jdebug) {
            this.msg("-#- FSC.isOptimizedDrawingEnabled: super=" + super.isOptimizedDrawingEnabled());
        }
        return true;
    }

    public boolean isOpaque() {
        if (this.Jdebug) {
            this.msg("-#- FSC.isOpaque: super=" + super.isOpaque());
        }
        return true;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.Jdebug) {
            System.err.println("\n### processKeyEvent: " + keyEvent);
        }
        super.processKeyEvent(keyEvent);
    }

    public void paint(Graphics graphics) {
        if (this.Jdebug) {
            this.msg("-#- FSC.paint: " + graphics.getClip());
        }
        this.paintComponent(graphics);
    }

    public void paintBorder(Graphics graphics) {
        if (this.Jdebug) {
            this.msg("-#- FSC.paintBorder: " + graphics.getClip());
        }
    }

    public void paintImmediately(int n, int n2, int n3, int n4) {
        if (this.Jdebug) {
            this.msg("-#- FSC.pI: " + n + " " + n2 + " " + n3 + " " + n4);
        }
        super.paintImmediately(n, n2, n3, n4);
    }

    public void paintComponent(Graphics graphics) {
        try {
            if (this.Jdebug) {
                this.msg("-#- FSC.pC: " + this.getSwingRepaintMode() + " clip=" + graphics.getClip());
            }
            if (graphics == null) {
                return;
            }
            if (this.offscreenImage == null) {
                this.initializeOffscreenBuffers();
            }
            if (this.offscreenImage == null) {
                return;
            }
            if (this.canvasSizeChanged()) {
                this.initializeOffscreenBuffers();
                this.mode = -1;
            }
            switch (this.mode) {
                case 7: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    if (this.useTripleBuffering) {
                        this.paintNoChanges(this.tripleBufferGR);
                        this.blitTripleBuffer(graphics);
                        break;
                    }
                    this.paintNoChanges(graphics);
                    break;
                }
                case 5: {
                    if (this.useTripleBuffering) {
                        this.paintTmpText(this.tripleBufferGR);
                        this.blitTripleBuffer(graphics);
                        break;
                    }
                    this.paintTmpText(graphics);
                    break;
                }
                default: {
                    if (this.useTripleBuffering) {
                        this.paintAllObjects(this.tripleBufferGR);
                        this.blitTripleBuffer(graphics);
                        this.mode = 7;
                        break;
                    }
                    this.paintAllObjects(graphics);
                    this.mode = 7;
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.msg("-E- internal in paintComponent: " + exception);
            exception.printStackTrace();
        }
    }

    public void paintNoChanges(Graphics graphics) {
        this.blitOffscreenBuffer(graphics);
        this.drawTmpObjects(graphics);
        graphics.setColor(Color.black);
        if (this.hasRulers) {
            graphics.drawLine(this.cur_x, 5, this.cur_x, 0);
            graphics.drawLine(this.cur_width - 6, this.cur_y, this.cur_width - 1, this.cur_y);
        }
        this.rubberband.paintOnce(graphics, this.cur_x, this.cur_y);
        if (this.rubberband.getMode() != 0) {
            graphics.drawLine(this.cur_x - 3, this.cur_y, this.cur_x + 3, this.cur_y);
            graphics.drawLine(this.cur_x, this.cur_y - 3, this.cur_x, this.cur_y + 3);
        }
    }

    public void paintCursor(Graphics graphics) {
        this.blitOffscreenBuffer(graphics);
        this.drawTmpObjects(graphics);
        graphics.setColor(Color.black);
        graphics.drawLine(this.cur_x - 3, this.cur_y, this.cur_x + 3, this.cur_y);
        graphics.drawLine(this.cur_x, this.cur_y - 3, this.cur_x, this.cur_y + 3);
    }

    public void paintRubberband(Graphics graphics) {
        this.blitOffscreenBuffer(graphics);
        this.drawTmpObjects(graphics);
        graphics.setColor(Color.black);
        this.rubberband.paintOnce(graphics, this.cur_x, this.cur_y);
    }

    public void paintTmpText(Graphics graphics) {
        if (this.objectEnumerator == null) {
            return;
        }
        FigDrawable figDrawable = this.objectEnumerator.getTmpObject();
        if (figDrawable == null) {
            return;
        }
        this.blitOffscreenBuffer(graphics);
        figDrawable.paint(graphics);
    }

    public void paintAllObjects(Graphics graphics) {
        this.initializeOffscreenBuffers();
        this.clearBuffer(this.offscreenGR);
        this.drawRulers(this.offscreenGR);
        this.drawGrid(this.offscreenGR);
        this.drawAllObjects(this.objectGR);
        this.paintNoChanges(graphics);
    }

    public void paint(FigDrawable figDrawable) {
        try {
            Graphics graphics;
            if (this.offscreenGR != null) {
                figDrawable.paint(this.offscreenGR, this.trafo);
            }
            if ((graphics = this.getGraphics()) != null) {
                figDrawable.paint(graphics, this.trafo);
            }
        }
        catch (Throwable throwable) {
            System.err.println("-E- internal error in FigSwingCanvas.paint(obj): " + throwable);
        }
    }

    public void paint(FigDrawable figDrawable, int n) {
        try {
            if (this.offscreenGR != null) {
                figDrawable.paint(this.offscreenGR, this.trafo);
            }
            FigBbox figBbox = figDrawable.get_sc_bbox();
            this.repaint(n, figBbox.getXl() - 10, figBbox.getYt() - 10, figBbox.getXr() - figBbox.getXl() + 20, figBbox.getYb() - figBbox.getYt() + 20);
        }
        catch (Throwable throwable) {
            System.err.println("-E- internal error in FigSwingCanvas.paint(obj,millis): " + throwable);
        }
    }

    public void repaint(int n) {
        super.repaint(n);
    }

    public void synchronousRepaint() {
    }

    public void update(Graphics graphics) {
        if (this.debug) {
            this.msg("-#- FigSwingCanvas.update: mode=" + this.mode);
        }
        ++this.n_updates;
        this.paint(graphics);
    }

    public void drawTmpObjects(Graphics graphics) {
        if (this.objectEnumerator == null) {
            return;
        }
        try {
            FigDrawable figDrawable = this.objectEnumerator.getTmpObject();
            if (figDrawable != null) {
                figDrawable.paint(graphics);
            }
        }
        catch (Throwable throwable) {
            System.err.println("-E- internal error in FigSwingCanvas.drawTmpObjects: " + throwable);
        }
    }

    public void clippedDrawTmpObject(Graphics graphics) {
        if (this.objectEnumerator == null) {
            return;
        }
        try {
            FigDrawable figDrawable = this.objectEnumerator.getTmpObject();
            if (figDrawable == null) {
                return;
            }
            FigBbox figBbox = figDrawable.get_sc_bbox();
            int n = figBbox.getXl() - 60;
            int n2 = figBbox.getYt() - 30;
            int n3 = figBbox.getXr() - figBbox.getXl() + 120;
            int n4 = figBbox.getYb() - figBbox.getYt() + 30;
            graphics.setClip(n, n2, n3, n4);
            this.blitOffscreenBuffer(graphics);
            figDrawable.paint(graphics);
        }
        catch (Throwable throwable) {
            System.err.println("-E- internal error in FigSwingCanvas.clippedDrawTmpObject: " + throwable);
        }
    }

    public void blitTripleBuffer(Graphics graphics) {
        try {
            graphics.drawImage(this.tripleBuffer, 0, 0, this.cur_width, this.cur_height, 0, 0, this.cur_width, this.cur_height, this.theObserver);
        }
        catch (Exception exception) {
            this.msg("-E- FigSwingCanvas.blitTripleBuffer: " + exception);
        }
    }

    public void blitOffscreenBuffer(Graphics graphics) {
        graphics.drawImage(this.offscreenImage, 0, 0, this.cur_width, this.cur_height, 0, 0, this.cur_width, this.cur_height, this.theObserver);
        if (this.debug) {
            this.msg("-#- blitOffscreen buffer, dimensions= " + this.offscreenImage.getWidth(this.theObserver) + " x " + this.offscreenImage.getHeight(this.theObserver) + " pixels");
        }
    }

    public void blitOffscreenBufferClipped(Graphics graphics) {
        Graphics graphics2 = graphics.create(this.RULER_XL_OFFSET, this.RULER_YT_OFFSET, this.cur_width - this.RULER_XL_OFFSET - this.RULER_XR_OFFSET, this.cur_height - this.RULER_YT_OFFSET - this.RULER_YB_OFFSET);
        graphics2.translate(-this.RULER_XL_OFFSET, -this.RULER_YT_OFFSET);
        graphics2.drawImage(this.offscreenImage, 0, 0, this.cur_width, this.cur_height, 0, 0, this.cur_width, this.cur_height, this.theObserver);
        graphics2.dispose();
    }

    public void printTimingStats() {
        this.msg("-I- FigSwingCanvas redraw stats:");
        this.msg("n_redraws= " + this.n_redraws + " n_updates= " + this.n_updates);
        this.msg("t_redraw=  " + this.t_redraw + "mean time= " + (double)this.t_redraw_mean * 1.0 / (double)this.n_redraws);
        this.msg(" t_grid=   " + this.t_grid + " mean time= " + (double)this.t_grid_mean * 1.0 / (double)this.n_grid);
    }

    public void doFullRedraw() {
        this.doFullRedraw(this.t_delay);
    }

    public void doFullRedraw(long l) {
        if (this.debug) {
            this.msg("-I- doFullRedraw: " + l + " msecs.");
        }
        this.mode = -1;
        this.repaint(l);
    }

    public void doSimpleRedraw() {
        this.repaint();
    }

    public void doTextRedraw() {
        this.mode = 5;
        if (this.objectEnumerator == null) {
            return;
        }
        FigDrawable figDrawable = this.objectEnumerator.getTmpObject();
        if (figDrawable == null) {
            return;
        }
        Rectangle rectangle = figDrawable.get_sc_bbox().getRectangle();
        Rectangle rectangle2 = rectangle.union(this._lastTextClipRectangle);
        this._lastTextClipRectangle = rectangle;
        this.paintImmediately(rectangle2.x - 5, rectangle2.y - 5, rectangle2.width + 11, rectangle2.height + 11);
    }

    public void doObjectRedraw() {
        this.msg("-E- doObjectRedraw not implemented!");
        this.doFullRedraw();
    }

    public void doMotionRedraw() {
        this.repaint();
    }

    public void doSystemRedraw() {
        if (this.canvasSizeChanged()) {
            this.doFullRedraw();
        } else {
            this.doSimpleRedraw();
        }
    }

    public void doSyncRedraw() {
        this.doSimpleRedraw();
    }

    public void handleRedraw(Graphics graphics) {
        if (this.debug) {
            this.msg("-W- FigSwingCanvas.handleRedraw() should not be called!");
            try {
                throw new Exception("FigSwingCanvas.handleRedraw call stack");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.paintComponent(graphics);
    }

    public void eraseObject(Graphics graphics, FigObject figObject) {
        graphics.setXORMode(this.backgroundColor);
        figObject.paint(graphics);
        graphics.setPaintMode();
    }

    public void drawObject(Graphics graphics, FigObject figObject) {
        graphics.setPaintMode();
        figObject.paint(graphics);
    }

    public void drawSlidersAndCursor(Graphics graphics, boolean bl) {
        graphics.setXORMode(this.backgroundColor);
        this.rubberband.paint(graphics, this.cur_x, this.cur_y, bl);
        this.drawSliders(graphics, bl);
        graphics.setPaintMode();
    }

    public void drawSlidersOnce(Graphics graphics, int n, int n2) {
        graphics.drawLine(n, 5, n, 0);
        graphics.drawLine(this.cur_width - 6, n2, this.cur_width - 1, n2);
    }

    public void drawSliders(Graphics graphics, boolean bl) {
        graphics.setXORMode(this.backgroundColor);
        graphics.setColor(this.gridColor);
        if (this.hasRulers) {
            if (bl) {
                this.drawSlidersOnce(graphics, this.old_x, this.old_y);
            }
            this.drawSlidersOnce(graphics, this.cur_x, this.cur_y);
        }
    }

    public final Point getViewportWCmax() {
        Point point = new Point(this.getSize().width, this.getSize().height);
        Point point2 = new Point(0, 0);
        point2 = this.trafo.screen_to_wc(point, point2);
        return point2;
    }

    public FigBbox getVisibleRegionBoundingBox() {
        return new FigBbox(this.getTrafo().getWorldCoords(this.RULER_XL_OFFSET, this.RULER_YT_OFFSET), this.getTrafo().getWorldCoords(this.getSize().width - this.RULER_XR_OFFSET, this.getSize().height - this.RULER_YB_OFFSET));
    }

    public void drawAllObjects(Graphics graphics) {
        if (this.debug) {
            this.msg("FigSwingCanvas.drawAllObjects...");
        }
        if (graphics == null) {
            if (this.debug) {
                this.msg("-E- FigSwingCanvas.drawAllObjects: graphics is null!");
            }
            return;
        }
        if (this.objectEnumerator == null) {
            return;
        }
        this.getCurrentCanvasSize();
        graphics.setColor(this.defaultColor);
        int n = 0;
        int n2 = 0;
        FigBbox figBbox = new FigBbox(this.trafo.getAnchor(), this.getViewportWCmax());
        Enumeration enumeration = this.objectEnumerator.getDrawableObjects();
        while (enumeration.hasMoreElements()) {
            FigDrawable figDrawable = (FigDrawable)enumeration.nextElement();
            if (figDrawable.isVisible(figBbox)) {
                figDrawable.paint(graphics);
                ++n;
                continue;
            }
            ++n2;
        }
        if (this.debug) {
            System.out.println("drawAllObjects: drawn/invisible/total: " + n + " " + n2 + " " + (n + n2));
        }
    }

    public void setGrid(int n) {
        this.trafo.setGridMode(n);
        this.doFullRedraw();
    }

    public void drawRulers(Graphics graphics) {
        String string;
        int n;
        double d;
        double d2;
        double d3;
        if (!this.hasRulers) {
            return;
        }
        if (this.debug) {
            this.msg("-#- FigSwingCanvas.drawRulers...");
        }
        if (this.trafo.get_units() == 2) {
            d3 = 2400.0 / this.trafo.getZoomFactor_MultipleOfTwo();
            d2 = 240.0 / this.trafo.getZoomFactor_MultipleOfTwo();
            d = 4.166666666666667E-4;
        } else if (this.trafo.get_units() == 1) {
            d3 = 1920.0 / this.trafo.getZoomFactor_MultipleOfTwo();
            d2 = 192.0 / this.trafo.getZoomFactor_MultipleOfTwo();
            d = 0.0010416666666666667;
        } else {
            d3 = 1800.0 / this.trafo.getZoomFactor_MultipleOfTwo();
            d2 = 180.0 / this.trafo.getZoomFactor_MultipleOfTwo();
            d = 0.0011111111111111111;
        }
        double d4 = 0.5 * d3;
        int n2 = (int)d3;
        int n3 = this.trafo.getAnchor().x;
        int n4 = this.trafo.getAnchor().y;
        Point point = this.getViewportWCmax();
        int n5 = point.x;
        int n6 = point.y;
        int n7 = this.cur_width;
        int n8 = this.cur_height;
        n3 = n3 - n3 % n2 - n2;
        n5 = n5 - n5 % n2 + n2;
        n4 = n4 - n4 % n2 - n2;
        n6 = n6 - n6 % n2 + n2;
        if (this.debug) {
            this.msg("-#- drawRulers() wxmin " + n3 + " wxmax " + n5 + " d_label " + d3 + " wymin " + n4 + " wymax " + n6);
        }
        int n9 = (n3 + n5) / 2;
        int n10 = (n4 + n6) / 2;
        n9 = (int)(Math.floor((double)n9 / d3) * d3);
        n10 = (int)(Math.floor((double)n10 / d3) * d3);
        int n11 = this.trafo.wc_to_screen_x(n9);
        int n12 = this.trafo.wc_to_screen_y(n10);
        graphics.setPaintMode();
        graphics.setColor(this.gridColor);
        graphics.drawLine(0, 25, n7, 25);
        graphics.drawLine(n7 - 25, 0, n7 - 25, n8);
        graphics.setColor(Color.lightGray);
        this.drawTriangles(graphics, n7, n8);
        graphics.setColor(this.gridColor);
        double d5 = n9;
        while (d5 < (double)n5) {
            n = this.trafo.wc_to_screen_x((int)d5);
            graphics.drawLine(n, 21, n, 25);
            d5 += d2;
        }
        d5 = n9;
        while (d5 < (double)n5) {
            n = this.trafo.wc_to_screen_x((int)d5);
            graphics.drawLine(n, 18, n, 25);
            d5 += d4;
        }
        d5 = n9;
        while (d5 > (double)n3) {
            n = this.trafo.wc_to_screen_x((int)d5);
            graphics.drawLine(n, 21, n, 25);
            d5 -= d2;
        }
        d5 = n9;
        while (d5 > (double)n3) {
            n = this.trafo.wc_to_screen_x((int)d5);
            graphics.drawLine(n, 18, n, 25);
            d5 -= d4;
        }
        try {
            graphics.setFont(rulerFont);
            d5 = n9;
            while (d5 < (double)n5) {
                n = this.trafo.wc_to_screen_x((int)d5);
                graphics.drawLine(n, 12, n, 25);
                string = this.two_decimals.form(d5 * d);
                graphics.drawString(string, n + 4, 16);
                d5 += d3;
            }
            d5 = n9;
            while (d5 > (double)n3) {
                n = this.trafo.wc_to_screen_x((int)d5);
                graphics.drawLine(n, 12, n, 25);
                string = this.two_decimals.form(d5 * d);
                graphics.drawString(string, n + 4, 16);
                d5 -= d3;
            }
        }
        catch (Throwable throwable) {
            System.err.println("-E- internal in drawRulers: " + throwable);
        }
        try {
            Graphics2D graphics2D;
            int n13;
            double d6 = n10;
            while (d6 < (double)n6) {
                n13 = this.trafo.wc_to_screen_y((int)d6);
                graphics.drawLine(n7 - 25, n13, n7 - 21, n13);
                d6 += d2;
            }
            d6 = n10;
            while (d6 < (double)n6) {
                n13 = this.trafo.wc_to_screen_y((int)d6);
                graphics.drawLine(n7 - 25, n13, n7 - 18, n13);
                d6 += d4;
            }
            d6 = n10;
            while (d6 < (double)n6) {
                n13 = this.trafo.wc_to_screen_y((int)d6);
                graphics.drawLine(n7 - 25, n13, n7 - 12, n13);
                string = this.two_decimals.form(d6 * d);
                if (graphics instanceof Graphics2D) {
                    graphics2D = (Graphics2D)graphics.create();
                    graphics2D.rotate(-1.5707963267948966, n7 - 8, n13 - 3);
                    graphics2D.drawString(string, n7 - 8, n13 - 3);
                } else {
                    graphics.drawString(string, n7 - 16, n13 - 3);
                }
                d6 += d3;
            }
            d6 = n10;
            while (d6 > (double)n4) {
                n13 = this.trafo.wc_to_screen_y((int)d6);
                graphics.drawLine(n7 - 25, n13, n7 - 21, n13);
                d6 -= d2;
            }
            d6 = n10;
            while (d6 > (double)n4) {
                n13 = this.trafo.wc_to_screen_y((int)d6);
                graphics.drawLine(n7 - 25, n13, n7 - 18, n13);
                d6 -= d4;
            }
            d6 = n10;
            while (d6 > (double)n4) {
                n13 = this.trafo.wc_to_screen_y((int)d6);
                graphics.drawLine(n7 - 25, n13, n7 - 12, n13);
                string = this.two_decimals.form(d6 * d);
                if (graphics instanceof Graphics2D) {
                    graphics2D = (Graphics2D)graphics.create();
                    graphics2D.rotate(-1.5707963267948966, n7 - 8, n13 - 3);
                    graphics2D.drawString(string, n7 - 8, n13 - 3);
                } else {
                    graphics.drawString(string, n7 - 16, n13 - 3);
                }
                d6 -= d3;
            }
        }
        catch (Throwable throwable) {
            System.err.println("-E- internal in drawRulers: " + throwable);
        }
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(n7 - 24, 0, 25, 25);
        graphics.setColor(this.gridColor);
        graphics.setFont(rulerFont);
        graphics.drawString(this.trafo.get_units_string(), n7 - 16, 16);
        graphics.setColor(this.defaultColor);
    }

    public void drawTriangles(Graphics graphics, int n, int n2) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int[] nArray3 = new int[3];
        int[] nArray4 = new int[3];
        int[] nArray5 = new int[3];
        int[] nArray6 = new int[3];
        int[] nArray7 = new int[3];
        int[] nArray8 = new int[3];
        graphics.setColor(Color.lightGray);
        nArray[0] = 5;
        nArray3[0] = 10;
        nArray[1] = 20;
        nArray3[1] = 1;
        nArray[2] = 20;
        nArray3[2] = 19;
        graphics.fillPolygon(nArray, nArray3, 3);
        nArray2[0] = n - 5 - 25;
        nArray4[0] = 10;
        nArray2[1] = n - 20 - 25;
        nArray4[1] = 1;
        nArray2[2] = n - 20 - 25;
        nArray4[2] = 19;
        graphics.fillPolygon(nArray2, nArray4, 3);
        nArray5[0] = n - 12;
        nArray6[0] = 30;
        nArray5[1] = n - 2;
        nArray6[1] = 45;
        nArray5[2] = n - 22;
        nArray6[2] = 45;
        graphics.fillPolygon(nArray5, nArray6, 3);
        nArray7[0] = n - 12;
        nArray8[0] = n2 - 5;
        nArray7[1] = n - 2;
        nArray8[1] = n2 - 20;
        nArray7[2] = n - 22;
        nArray8[2] = n2 - 20;
        graphics.fillPolygon(nArray7, nArray8, 3);
    }

    public void getCurrentCanvasSize() {
        this.cur_width = this.getSize().width;
        this.cur_height = this.getSize().height;
        if (this.debug) {
            this.msg("-I- FigSwingCanvas size: " + this.cur_width + " x " + this.cur_height);
        }
    }

    public void initializeOffscreenBuffers() {
        if (this.debug) {
            this.msg("-#- FigSwingCanvas.initializeOffscreenBuffers...");
        }
        ++this.n_trials_to_create_offscreenImage;
        if (this.offscreenImage == null && this.n_trials_to_create_offscreenImage > 20) {
            this.msg("-E- FigSwingCanvas: problems creating the offscreen buffer,already " + this.n_trials_to_create_offscreenImage + " tries...");
        }
        this.getCurrentCanvasSize();
        if (this.cur_width <= 0 || this.cur_height <= 0) {
            if (this.n_trials_to_create_offscreenImage > 10) {
                this.msg("-W- FigSwingCanvas: size still < 0 ");
            }
            return;
        }
        if (this.offscreenImage == null || this.offscreenGR == null || this.offscreenImage.getWidth(this.theObserver) != this.cur_width || this.offscreenImage.getHeight(this.theObserver) != this.cur_height) {
            if (this.objectGR != null) {
                this.objectGR.dispose();
            }
            if (this.offscreenGR != null) {
                this.offscreenGR.dispose();
            }
            if (this.offscreenImage != null) {
                this.offscreenImage.flush();
            }
            int n = Math.max(this.cur_width, 1);
            int n2 = Math.max(this.cur_height, 1);
            this.offscreenImage = this.createImage(n, n2);
            if (this.offscreenImage == null) {
                return;
            }
            this.offscreenGR = this.offscreenImage.getGraphics();
            this.objectGR = this.offscreenGR.create(this.RULER_XL_OFFSET, this.RULER_YT_OFFSET, this.cur_width - this.RULER_XL_OFFSET - this.RULER_XR_OFFSET, this.cur_height - this.RULER_YT_OFFSET - this.RULER_YB_OFFSET);
            this.objectGR.translate(-this.RULER_XL_OFFSET, -this.RULER_YT_OFFSET);
            if (this.useTripleBuffering) {
                try {
                    this.tripleBuffer = this.createImage(n, n2);
                    this.tripleBufferGR = this.tripleBuffer.getGraphics();
                }
                catch (Exception exception) {
                    this.msg("-E- failed to create the triple buffer: " + exception);
                    this.msg("-E- falling back to normal double buffering.");
                    this.useTripleBuffering = false;
                }
            }
            if (this.options2D != null) {
                this.options2D.updateGraphics(this.objectGR);
            }
        }
        if (this.debug) {
            this.msg("-#- offscreenImage=" + this.offscreenImage);
        }
    }

    public boolean canvasSizeChanged() {
        if (this.offscreenImage == null) {
            return true;
        }
        this.getCurrentCanvasSize();
        return this.offscreenImage.getWidth(this.theObserver) != this.cur_width || this.offscreenImage.getHeight(this.theObserver) != this.cur_height;
    }

    public void flush() {
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
        }
        if (this.tripleBuffer != null) {
            this.tripleBuffer.flush();
        }
    }

    public void clearBuffer(Graphics graphics) {
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.cur_width, this.cur_height);
        graphics.setColor(this.defaultColor);
    }

    public void drawGrid(Graphics graphics) {
        this.drawGridByHand(graphics);
    }

    public void drawGridByHand(Graphics graphics) {
        int n;
        double d;
        int n2;
        if (this.debug) {
            this.msg("-#- FigBasicCanvas.drawGrid()..." + graphics);
        }
        if (graphics == null) {
            return;
        }
        if (this.trafo.gridMode == 0) {
            return;
        }
        long l = 0L;
        if (this.enableTimingInfo) {
            l = System.currentTimeMillis();
        }
        graphics.setColor(this.gridColor);
        double d2 = 1.0;
        this.tmp_wc = this.trafo.screen_to_wc(new Point(this.RULER_XL_OFFSET, this.RULER_YT_OFFSET), this.tmp_wc);
        int n3 = this.tmp_wc.x;
        int n4 = this.tmp_wc.y;
        this.tmp_wc = this.trafo.screen_to_wc(new Point(this.cur_width - this.RULER_XR_OFFSET, this.cur_height - this.RULER_YB_OFFSET), this.tmp_wc);
        int n5 = this.tmp_wc.x;
        int n6 = this.tmp_wc.y;
        if (this.debug) {
            this.msg("-#- FigBasicCanvas.drawGrid(): wxmin,wymin,wxmax, wymax= " + n3 + " " + n4 + " " + n5 + " " + n6);
        }
        double d3 = this.trafo.get_units() == 2 ? 2400.0 : (this.trafo.get_units() == 1 ? 1920.0 : (this.trafo.get_units() == 3 ? 1800.0 : 2400.0));
        d3 = 0.5 * d3 / this.trafo.getZoomFactor_MultipleOfTwo();
        int n7 = (n3 + n5) / 2;
        int n8 = (n4 + n6) / 2;
        n7 = (int)(Math.floor((double)n7 / d3) * d3);
        n8 = (int)(Math.floor((double)n8 / d3) * d3);
        int n9 = this.trafo.wc_to_screen_x(n7);
        int n10 = this.trafo.wc_to_screen_y(n8);
        if (this.trafo.gridMode == 240) {
            d2 = 0.25 * d3;
        } else if (this.trafo.gridMode == 480) {
            d2 = 0.5 * d3;
        } else if (this.trafo.gridMode == 960) {
            d2 = 1.0 * d3;
        } else if (this.trafo.gridMode == 961) {
            d2 = 0.2 * d3;
        } else {
            this.msg("-E- FigBasicCanvas: illegal gridMode=" + this.trafo.gridMode);
        }
        int n11 = (int)(d3 / d2);
        int n12 = (int)this.trafo.wc_to_screen(d3);
        Graphics graphics2 = graphics.create(this.RULER_XL_OFFSET, this.RULER_YT_OFFSET, this.cur_width - this.RULER_XL_OFFSET - this.RULER_XR_OFFSET, this.cur_height - this.RULER_YT_OFFSET - this.RULER_YB_OFFSET);
        graphics2.translate(-this.RULER_XL_OFFSET, -this.RULER_YT_OFFSET);
        graphics2.setColor(this.gridColor);
        double d4 = n8;
        while (d4 < (double)n6) {
            n2 = this.trafo.wc_to_screen_y((int)d4);
            d = n7;
            while (d < (double)n5 + d3) {
                n = this.trafo.wc_to_screen_x((int)d);
                graphics2.drawLine(n, n2, n, n2);
                d += d2;
            }
            d = n7;
            while (d >= (double)n3) {
                n = this.trafo.wc_to_screen_x((int)d);
                graphics2.drawLine(n, n2, n, n2);
                d -= d2;
            }
            d4 += d3;
        }
        d4 = (double)n8 - d3;
        while (d4 >= (double)n4) {
            n2 = this.trafo.wc_to_screen_y((int)d4);
            d = n7;
            while (d < (double)n5 + d3) {
                n = this.trafo.wc_to_screen_x((int)d);
                graphics2.drawLine(n, n2, n, n2);
                d += d2;
            }
            d = n7;
            while (d >= (double)n3) {
                n = this.trafo.wc_to_screen_x((int)d);
                graphics2.drawLine(n, n2, n, n2);
                d -= d2;
            }
            d4 -= d3;
        }
        d4 = n7;
        while (d4 < (double)n5) {
            n = this.trafo.wc_to_screen_x((int)d4);
            d = n8;
            while (d < (double)n6 + d3) {
                n2 = this.trafo.wc_to_screen_y((int)d);
                graphics2.drawLine(n, n2, n, n2);
                d += d2;
            }
            d = n8;
            while (d >= (double)n4) {
                n2 = this.trafo.wc_to_screen_y((int)d);
                graphics2.drawLine(n, n2, n, n2);
                d -= d2;
            }
            d4 += d3;
        }
        d4 = (double)n7 - d3;
        while (d4 >= (double)n3) {
            n = this.trafo.wc_to_screen_x((int)d4);
            d = n8;
            while (d < (double)n6 + d3) {
                n2 = this.trafo.wc_to_screen_y((int)d);
                graphics2.drawLine(n, n2, n, n2);
                d += d2;
            }
            d = n8;
            while (d >= (double)n4) {
                n2 = this.trafo.wc_to_screen_y((int)d);
                graphics2.drawLine(n, n2, n, n2);
                d -= d2;
            }
            d4 -= d3;
        }
        graphics2.dispose();
        if (this.enableTimingInfo) {
            long l2 = System.currentTimeMillis();
            this.t_grid = l2 - l;
            ++this.n_grid;
            this.t_grid_mean += this.t_grid;
            if (this.Jdebug) {
                this.msg("-#- FigBasicCanvas.drawGrid took " + this.t_grid + " msec.");
            }
        }
    }

    public void setZoomFitBorderWidth(int n) {
        this.zoomFitBorderWidth = n;
    }

    public int getZoomFitBorderWidth() {
        return this.zoomFitBorderWidth;
    }

    public synchronized void doZoomFit() {
        FigBbox figBbox = BoundingBoxCalculator.getBoundingBox(this.objectEnumerator.getDrawableObjects());
        Dimension dimension = this.getSize();
        int n = this.zoomFitBorderWidth;
        int n2 = this.RULER_XL_OFFSET + n;
        int n3 = dimension.width - this.RULER_XR_OFFSET - n;
        int n4 = this.RULER_YT_OFFSET + n;
        int n5 = dimension.height - this.RULER_YB_OFFSET - n;
        int n6 = Math.abs(n3 - n2);
        int n7 = Math.abs(n5 - n4);
        int n8 = figBbox.getXr() - figBbox.getXl();
        int n9 = figBbox.getYb() - figBbox.getYt();
        double d = 32.0 * (double)n6 / (double)n8;
        double d2 = 32.0 * (double)n7 / (double)n9;
        double d3 = Math.min(d, d2);
        int n10 = (n3 + n2) / 2;
        int n11 = (n4 + n5) / 2;
        int n12 = (figBbox.getXl() + figBbox.getXr()) / 2;
        int n13 = (figBbox.getYt() + figBbox.getYb()) / 2;
        int n14 = (int)((double)n12 - (double)n10 * 32.0 / d3);
        int n15 = (int)((double)n13 - (double)n11 * 32.0 / d3);
        this.trafo.setAnchor(new Point(n14, n15));
        this.trafo.set_zoom(d3);
        this.doFullRedraw();
        this.notifyZoomListeners();
    }

    public synchronized void doZoomOut() {
        if (this.debug) {
            this.msg("-#- FigSwingCanvas.doZoomOut()");
        }
        if (this.trafo.getZoomFactor() <= this.trafo.getMinZoomFactor()) {
            this.statusMessage("already at minimum scale");
            return;
        }
        Rectangle rectangle = this.getBounds();
        Point point = new Point(rectangle.width / 2, rectangle.height / 2);
        Point point2 = new Point(0, 0);
        point2 = this.trafo.screen_to_wc(point, point2);
        int n = this.trafo.screen_to_wc(rectangle.width);
        int n2 = this.trafo.screen_to_wc(rectangle.height);
        this.trafo.set_zoom_region(point2.x - n, point2.y - n2, point2.x + n, point2.y + n2, rectangle.width, rectangle.height);
        this.doFullRedraw();
        this.notifyZoomListeners();
    }

    public synchronized void doZoomIn() {
        if (this.debug) {
            this.msg("-#- FigSwingCanvas.doZoomIn()");
        }
        if (this.trafo.getZoomFactor() >= this.trafo.getMaxZoomFactor()) {
            this.statusMessage("already at maximum zoom factor...");
        } else {
            Rectangle rectangle = this.getBounds();
            Point point = new Point(rectangle.width / 4, rectangle.height / 4);
            Point point2 = new Point(0, 0);
            point2 = this.trafo.screen_to_wc(point, point2);
            int n = this.trafo.screen_to_wc(rectangle.width);
            int n2 = this.trafo.screen_to_wc(rectangle.height);
            this.trafo.set_zoom_region(point2.x, point2.y, point2.x + n / 2, point2.y + n2 / 2, rectangle.width, rectangle.height);
            this.doFullRedraw();
            this.notifyZoomListeners();
        }
    }

    public synchronized void doZoomFull() {
        if (this.debug) {
            this.msg("-#- FigSwingCanvas.doZoomFull()");
        }
        this.trafo.set_zoom(1.0);
        this.doFullRedraw();
        this.notifyZoomListeners();
    }

    public synchronized void doZoom11() {
        this.trafo.set_zoom(1.0);
        this.doPanning(0, false);
        this.doFullRedraw();
        this.notifyZoomListeners();
    }

    public synchronized void doZoomRegion(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        this.trafo.set_zoom_region(n, n2, n3, n4, rectangle.width, rectangle.height);
        this.doFullRedraw();
        this.notifyZoomListeners();
    }

    public synchronized void doZoomIn14() {
        throw new Error("-E- FigSwingCanvs.doZoomIn14 not implemented!");
    }

    public synchronized void doZoomOut07() {
        throw new Error("-E- FigSwingCanvs.doZoomOut07 not implemented!");
    }

    public void addZoomListener(ZoomListener zoomListener) {
        if (this.zoomListenerVector == null) {
            this.zoomListenerVector = new Vector();
        }
        this.zoomListenerVector.addElement(zoomListener);
    }

    public void removeZoomListener(ZoomListener zoomListener) {
        if (this.zoomListenerVector == null) {
            return;
        }
        this.zoomListenerVector.removeElement(zoomListener);
    }

    public void notifyZoomListeners() {
        if (this.zoomListenerVector != null) {
            int n = 0;
            while (n < this.zoomListenerVector.size()) {
                ((ZoomListener)this.zoomListenerVector.elementAt(n)).zoomChanged(this);
                ++n;
            }
        }
    }

    public final void changeRubberbandMode(int n) {
        this.rubberband.changeMode(n);
    }

    public final void changeRubberbandMode(int n, GeometryManager geometryManager) {
        this.rubberband.changeMode(n, geometryManager);
    }

    public final void changeRubberbandMode(int n, FigTrafo2D figTrafo2D, Object object) {
        this.rubberband.changeMode(n, figTrafo2D, object);
    }

    public final void setRubberbandBasePoint(Point point) {
        this.rubberband.setBasePoint(point.x, point.y);
    }

    public final void setRubberbandBasePoint(int n, int n2) {
        this.rubberband.setBasePoint(n, n2);
    }

    public final void setRubberbandBasePoint2(Point point) {
        this.rubberband.setBasePoint2(new Point(point));
    }

    public final void setRubberbandBasePoint2(int n, int n2) {
        this.rubberband.setBasePoint2(new Point(n, n2));
    }

    public final void setRubberbandAspect(double d) {
        this.rubberband.setAspect(d);
    }

    public void doToggleRubberbandDebug() {
        this.rubberband.setDebug(!this.rubberband.getDebug());
    }

    public void setRubberbandShowLineLengths(boolean bl) {
        this.rubberband.setShowLineLengths(bl);
    }

    public void requestRenderQuality(boolean bl) {
        if (FigAttribs.enableJava2D) {
            this.getOptions2D().requestRenderQuality(bl);
        }
    }

    public void requestAntiAliasing(boolean bl) {
        if (FigAttribs.enableJava2D) {
            this.getOptions2D().requestAntiAliasing(bl);
        }
    }

    public Options2D getOptions2D() {
        if (this.options2D == null) {
            FigSwingCanvas figSwingCanvas = this;
            if (figSwingCanvas == null) {
                throw null;
            }
            this.options2D = figSwingCanvas.new Options2D();
        }
        return this.options2D;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("FigSwingCanvas self test... ");
        FigSwingCanvas figSwingCanvas = new FigSwingCanvas();
        figSwingCanvas.setDebug(true);
        figSwingCanvas.getTrafo().setSnapRelative(1);
        figSwingCanvas.setPreferredSize(new Dimension(500, 500));
        figSwingCanvas.setMinimumSize(new Dimension(500, 300));
        figSwingCanvas.setRubberbandBasePoint(new Point(250, 250));
        figSwingCanvas.changeRubberbandMode(2);
        JFrame jFrame = new JFrame("FigSwingCanvas selftest");
        jFrame.setSize(new Dimension(500, 400));
        jFrame.getContentPane().add("Center", figSwingCanvas);
        jFrame.show();
    }

    public FigSwingCanvas() {
        if (this.debug) {
            this.msg("-#- FigSwingCanvas constructor...");
        }
        this.setRulerOffsets();
        this.useTripleBuffering = SetupManager.getBoolean("jfig.gui.canvas.TripleBuffering", false);
        this.theObserver = this;
        this.setBackground(this.backgroundColor);
        this.defaultCursor = new Cursor(0);
        this.waitCursor = new Cursor(3);
        this.trafo = new FigTrafo2D();
        this.trafo.setAnchor(new Point(this.BASE_ANCHOR_X, this.BASE_ANCHOR_Y));
        this.initializeOffscreenBuffers();
        this.ptmp = new Point(0, 0);
        this.tmp_sc = new Point(0, 0);
        this.tmp_wc = new Point(0, 0);
        this.rubberband = new FigCanvasRubberband(this.trafo);
        this.rubberband.changeMode(1);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.repaint();
    }

    public class Options2D {
        private RenderingHints hints = new RenderingHints(null);

        public void requestAntiAliasing(boolean bl) {
            if (bl) {
                this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            this.updateGraphics(FigSwingCanvas.this.objectGR);
            FigSwingCanvas.this.doFullRedraw();
        }

        public void requestRenderQuality(boolean bl) {
            if (bl) {
                this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                this.hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            } else {
                this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                this.hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            this.updateGraphics(FigSwingCanvas.this.objectGR);
            FigSwingCanvas.this.doFullRedraw();
        }

        public void updateGraphics(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (graphics2D != null) {
                graphics2D.setRenderingHints(this.hints);
            }
        }
    }
}

