/*
 * Decompiled with CFR 0.152.
 */
package jfig.canvas;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigBbox;
import jfig.utils.Format;
import jfig.utils.GeometryManager;

public class FigCanvasRubberband {
    public static final int noRubber = 0;
    public static final int pointRubber = 1;
    public static final int lineRubber = 2;
    public static final int line2Rubber = 3;
    public static final int rectRubber = 4;
    public static final int bboxRubber = 5;
    public static final int circleRubber = 6;
    public static final int ellipseRubber = 7;
    public static final int polylineRubber = 8;
    public static final int scaleRubber = 11;
    public static final int arcRubber = 12;
    public static final int restrictedBboxRubber = 13;
    public static final int restrictedScaleRubber = 14;
    public static final int geometryManagedRubber = 15;
    public static final int circle2Rubber = 16;
    public static final int RC = 0;
    public static final int LC = 1;
    public static final int CC = 2;
    public static final int CT = 3;
    public static final int CB = 5;
    public static final int RT = 6;
    public static final int RB = 7;
    public static final int LB = 8;
    public static final int LT = 9;
    int mode = 1;
    Object obj;
    FigBbox bbox;
    FigTrafo2D trafo;
    Polygon pg;
    int base_x;
    int base_y;
    int base2_x;
    int base2_y;
    int old_x;
    int old_y;
    int x;
    int y;
    int dx;
    int dy;
    int offset_x;
    int offset_y;
    double aspect;
    boolean debug = false;
    boolean showLineLengthsEnable = false;
    Font mfont = new Font("Monospaced", 0, 10);
    GeometryManager geometryManager = null;

    public boolean setDebug(boolean bl) {
        this.debug = bl;
        return bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setTrafo(FigTrafo2D figTrafo2D) {
        this.trafo = figTrafo2D;
    }

    public void setShowLineLengths(boolean bl) {
        this.showLineLengthsEnable = bl;
    }

    public void setBasePoint(Point point) {
        this.base_x = point.x;
        this.base_y = point.y;
        if (this.debug) {
            System.out.println("FigCanvasRubberband.setBasePoint at (" + point.x + ", " + point.y + ") ");
        }
    }

    public void setBasePoint(int n, int n2) {
        this.base_x = n;
        this.base_y = n2;
        if (this.debug) {
            System.out.println("FigCanvasRubberband.setBasePoint at (" + n + ", " + n2 + ") ");
        }
    }

    public void setGeometryManager(GeometryManager geometryManager) {
        this.geometryManager = geometryManager;
    }

    public void setBasePoint2(Point point) {
        this.base2_x = point.x;
        this.base2_y = point.y;
    }

    public void setAspect(double d) {
        this.aspect = d;
    }

    public int getMode() {
        return this.mode;
    }

    public void changeMode(int n) {
        this.mode = n;
        this.obj = null;
        if (this.debug) {
            System.out.println("FigCanvasRubberband.changeMode: " + n);
        }
    }

    public void changeMode(int n, GeometryManager geometryManager) {
        this.changeMode(n);
        this.setGeometryManager(geometryManager);
    }

    public void changeMode(int n, FigTrafo2D figTrafo2D, Object object) {
        block3: {
            Polygon polygon;
            block1: {
                block2: {
                    this.mode = n;
                    this.trafo = figTrafo2D;
                    this.obj = object;
                    if (n != 5) break block1;
                    FigBbox figBbox = (FigBbox)object;
                    if (figBbox == null) break block2;
                    Point point = new Point(figBbox.getXl(), figBbox.getYt());
                    Point point2 = new Point(figBbox.getXr(), figBbox.getYb());
                    Point point3 = new Point(0, 0);
                    Point point4 = new Point(0, 0);
                    point3 = figTrafo2D.wc_to_screen(point, point3);
                    point4 = figTrafo2D.wc_to_screen(point2, point4);
                    this.offset_x = point3.x - this.base_x;
                    this.offset_y = point3.y - this.base_y;
                    this.dx = point4.x - point3.x;
                    this.dy = point4.y - point3.y;
                    if (this.dx <= 0) {
                        this.dx = 1;
                    }
                    if (this.dy > 0) break block3;
                    this.dy = 1;
                    break block3;
                }
                System.out.println("FigCanvasRubberband.changeMode: wrong object for bboxRubber mode! ");
                this.dx = 1;
                this.dy = 1;
                break block3;
            }
            if (n != 8 || (polygon = (Polygon)object) != null) break block3;
            System.out.println("FigCanvasRubberband.changeMode: wrong object for polygonRubber mode! ");
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            nArray[0] = 100;
            nArray[1] = 105;
            nArray2[0] = 100;
            nArray2[1] = 105;
            polygon = new Polygon(nArray, nArray2, 2);
        }
    }

    public void paint(Graphics graphics, int n, int n2, boolean bl) {
        if (this.mode == 0) {
            return;
        }
        graphics.setXORMode(Color.white);
        graphics.setColor(Color.black);
        if (bl) {
            this.paintOnce(graphics, this.old_x, this.old_y);
        }
        this.paintOnce(graphics, n, n2);
        bl = true;
        this.old_x = n;
        this.old_y = n2;
    }

    public Point getBasePoint() {
        return new Point(this.base_x, this.base_y);
    }

    public void paintOnce(Graphics graphics, int n, int n2) {
        if (this.mode == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.debug) {
            System.out.println("FigCanvasRubberband.paintOnce(): mode: " + this.mode + " at (" + n + ", " + n2 + ") from base at (" + this.base_x + ", " + this.base_y + ") ");
        }
        switch (this.mode) {
            case 1: {
                graphics.drawLine(n - 3, n2, n + 3, n2);
                graphics.drawLine(n, n2 - 3, n, n2 + 3);
                break;
            }
            case 2: {
                if (this.showLineLengthsEnable) {
                    graphics.drawLine(this.base_x, this.base_y, n, n2);
                    int n6 = n - this.base_x;
                    int n7 = n2 - this.base_y;
                    int n8 = (int)(0.5 + Math.sqrt(n6 * n6 + n7 * n7));
                    Color color = graphics.getColor();
                    graphics.setColor(Color.red);
                    graphics.setFont(this.mfont);
                    if (n6 > 0) {
                        if (n7 > 0) {
                            graphics.drawLine(this.base_x, n2, n, n2);
                            graphics.drawLine(this.base_x, this.base_y, this.base_x, n2);
                            this.measure(graphics, n6, (n + this.base_x) / 2, n2, 5);
                            this.measure(graphics, n7, this.base_x, (n2 + this.base_y) / 2, 1);
                            this.measure(graphics, n8, (n + this.base_x) / 2, (n2 + this.base_y) / 2, 6);
                        } else if (n7 < 0) {
                            graphics.drawLine(this.base_x, n2, n, n2);
                            graphics.drawLine(this.base_x, this.base_y, this.base_x, n2);
                            this.measure(graphics, n6, (n + this.base_x) / 2, n2, 3);
                            this.measure(graphics, n7, this.base_x, (n2 + this.base_y) / 2, 1);
                            this.measure(graphics, n8, (n + this.base_x) / 2, (n2 + this.base_y) / 2, 7);
                        } else {
                            this.measure(graphics, n8, (n + this.base_x) / 2, this.base_y, 6);
                        }
                    } else if (n6 < 0) {
                        if (n7 > 0) {
                            graphics.drawLine(this.base_x, n2, n, n2);
                            graphics.drawLine(this.base_x, this.base_y, this.base_x, n2);
                            this.measure(graphics, n6, (n + this.base_x) / 2, n2, 5);
                            this.measure(graphics, n7, this.base_x, (n2 + this.base_y) / 2, 0);
                            this.measure(graphics, n8, (n + this.base_x) / 2, (n2 + this.base_y) / 2, 9);
                        } else if (n7 < 0) {
                            graphics.drawLine(this.base_x, n2, n, n2);
                            graphics.drawLine(this.base_x, this.base_y, this.base_x, n2);
                            this.measure(graphics, n7, this.base_x, (n2 + this.base_y) / 2, 0);
                            this.measure(graphics, n6, (n + this.base_x) / 2, n2, 3);
                            this.measure(graphics, n8, (n + this.base_x) / 2, (n2 + this.base_y) / 2, 8);
                        } else {
                            this.measure(graphics, n8, this.base_x, (n2 + this.base_y) / 2, 9);
                        }
                    } else {
                        this.measure(graphics, n8, this.base_x, (n2 + this.base_y) / 2, 0);
                    }
                    graphics.setColor(color);
                    break;
                }
                graphics.drawLine(this.base_x, this.base_y, n, n2);
                break;
            }
            case 3: {
                graphics.drawLine(this.base_x, this.base_y, n, n2);
                graphics.drawLine(this.base2_x, this.base2_y, n, n2);
                break;
            }
            case 4: {
                int n9 = n - this.base_x;
                int n10 = n2 - this.base_y;
                graphics.drawLine(this.base_x, this.base_y, n, this.base_y);
                graphics.drawLine(this.base_x, this.base_y, this.base_x, n2);
                if (n10 != 0) {
                    graphics.drawLine(this.base_x, n2, n, n2);
                }
                if (n9 != 0) {
                    graphics.drawLine(n, this.base_y, n, n2);
                }
                if (!this.showLineLengthsEnable) break;
                Color color = graphics.getColor();
                graphics.setFont(this.mfont);
                if (n9 > 0) {
                    this.measure(graphics, n9, n, (n2 + this.base_y) / 2, 0);
                } else if (n9 < 0) {
                    this.measure(graphics, n9, n, (n2 + this.base_y) / 2, 1);
                }
                if (n10 > 0) {
                    this.measure(graphics, n10, (n + this.base_x) / 2, n2, 5);
                } else if (n10 < 0) {
                    this.measure(graphics, n10, (n + this.base_x) / 2, n2, 3);
                }
                graphics.setColor(color);
                break;
            }
            case 5: {
                graphics.drawRect(this.offset_x + n, this.offset_y + n2, this.dx, this.dy);
                break;
            }
            case 13: {
                int n11 = n;
                int n12 = n2;
                if (Math.abs(n11 - this.base_x) > Math.abs(n12 - this.base_y)) {
                    n12 = this.base_y;
                } else {
                    n11 = this.base_x;
                }
                graphics.drawRect(this.offset_x + n11, this.offset_y + n12, this.dx, this.dy);
                break;
            }
            case 6: {
                n5 = Math.max(Math.abs(n - this.base_x), Math.abs(n2 - this.base_y));
                graphics.drawOval(this.base_x - n5, this.base_y - n5, 2 * n5, 2 * n5);
                break;
            }
            case 16: {
                int n13 = n - this.base_x;
                int n14 = n2 - this.base_y;
                n5 = (int)Math.sqrt(n13 * n13 + n14 * n14);
                graphics.drawOval(this.base_x - n5, this.base_y - n5, 2 * n5, 2 * n5);
                break;
            }
            case 7: {
                n3 = n < this.base_x ? n : 2 * this.base_x - n;
                n4 = n2 < this.base_y ? n2 : 2 * this.base_y - n2;
                graphics.drawOval(n3, n4, Math.abs(2 * (n - this.base_x)), Math.abs(2 * (n2 - this.base_y)));
                break;
            }
            case 8: {
                graphics.drawPolygon(this.pg);
                break;
            }
            case 11: {
                n3 = n < this.base_x ? n : 2 * this.base_x - n;
                n4 = n2 < this.base_y ? n2 : 2 * this.base_y - n2;
                graphics.drawRect(n3, n4, Math.abs(2 * (n - this.base_x)), Math.abs(2 * (n2 - this.base_y)));
                break;
            }
            case 14: {
                n2 = this.base_y + (int)(this.aspect * (double)(n - this.base_x) + 0.5);
                n3 = n < this.base_x ? n : 2 * this.base_x - n;
                n4 = n2 < this.base_y ? n2 : 2 * this.base_y - n2;
                graphics.drawRect(n3, n4, Math.abs(2 * (n - this.base_x)), Math.abs(2 * (n2 - this.base_y)));
                break;
            }
            case 12: {
                graphics.drawLine(this.base2_x, this.base2_y, this.base_x, this.base_y);
                graphics.drawLine(this.base2_x, this.base2_y, n, n2);
                break;
            }
            case 15: {
                Point point = this.geometryManager.getNearestAllowedPoint(this.getBasePoint(), new Point(n, n2));
                graphics.drawLine(this.base_x, this.base_y, point.x, point.y);
                break;
            }
            default: {
                System.out.println("FigCanvasRubberband.paintOnce(): mode not supported " + this.mode);
                break;
            }
        }
    }

    public Rectangle getRubberBoundingBox(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        switch (this.mode) {
            case 0: 
            case 1: {
                n5 = Math.min(n, n3) - 3;
                n6 = Math.min(n2, n4) - 3;
                n7 = Math.max(n, n3) - n5 + 7;
                n8 = Math.max(n2, n4) - n6 + 7;
                break;
            }
            case 2: {
                if (this.showLineLengthsEnable) {
                    n5 = FigCanvasRubberband.min(n, n3, this.base_x) - 60;
                    n6 = FigCanvasRubberband.min(n2, n4, this.base_y) - 20;
                    n7 = FigCanvasRubberband.max(n, n3, this.base_x) - n5 + 121;
                    n8 = FigCanvasRubberband.max(n2, n4, this.base_y) - n6 + 41;
                    break;
                }
                n5 = FigCanvasRubberband.min(n, n3, this.base_x);
                n6 = FigCanvasRubberband.min(n2, n4, this.base_y);
                n7 = FigCanvasRubberband.max(n, n3, this.base_x) - n5 + 1;
                n8 = FigCanvasRubberband.max(n2, n4, this.base_y) - n6 + 1;
                break;
            }
            case 3: {
                n5 = FigCanvasRubberband.min(n, n3, this.base_x, this.base2_x);
                n6 = FigCanvasRubberband.min(n2, n4, this.base_y, this.base2_y);
                n7 = FigCanvasRubberband.max(n, n3, this.base_x, this.base2_x) - n5 + 1;
                n8 = FigCanvasRubberband.max(n2, n4, this.base_y, this.base2_y) - n6 + 1;
                break;
            }
            case 4: {
                if (this.showLineLengthsEnable) {
                    n5 = FigCanvasRubberband.min(n, n3, this.base_x) - 60;
                    n6 = FigCanvasRubberband.min(n2, n4, this.base_y) - 20;
                    n7 = FigCanvasRubberband.max(n, n3, this.base_x) - n5 + 121;
                    n8 = FigCanvasRubberband.max(n2, n4, this.base_y) - n6 + 41;
                    break;
                }
                n5 = FigCanvasRubberband.min(n, n3, this.base_x);
                n6 = FigCanvasRubberband.min(n2, n4, this.base_y);
                n7 = FigCanvasRubberband.max(n, n3, this.base_x) - n5 + 1;
                n8 = FigCanvasRubberband.max(n2, n4, this.base_y) - n6 + 1;
                break;
            }
            case 5: {
                n5 = Math.min(n, n3) - Math.abs(this.offset_x);
                n6 = Math.min(n2, n4) - Math.abs(this.offset_y);
                n7 = this.dx + 2 * Math.abs(this.offset_x) + Math.abs(n - n3) + 1;
                n8 = this.dy + 2 * Math.abs(this.offset_y) + Math.abs(n2 - n4) + 1;
                break;
            }
            case 13: {
                int n9 = n3;
                int n10 = n4;
                if (Math.abs(n9 - this.base_x) > Math.abs(n10 - this.base_y)) {
                    n10 = this.base_y;
                } else {
                    n9 = this.base_x;
                }
                int n11 = n;
                int n12 = n2;
                if (Math.abs(n11 - this.base_x) > Math.abs(n12 - this.base_y)) {
                    n12 = this.base_y;
                } else {
                    n11 = this.base_x;
                }
                int n13 = FigCanvasRubberband.min(n3, n, n11, n9) - Math.abs(this.offset_x);
                int n14 = FigCanvasRubberband.min(n4, n2, n12, n10) - Math.abs(this.offset_y);
                int n15 = FigCanvasRubberband.max(n3, n, n11, n9) + Math.abs(this.offset_x);
                int n16 = FigCanvasRubberband.max(n4, n2, n12, n10) + Math.abs(this.offset_y);
                n5 = n13;
                n6 = n14;
                n7 = n15 - n13 + this.dx + 1;
                n8 = n16 - n14 + this.dy + 1;
                break;
            }
            case 16: {
                int n17 = n3 - this.base_x;
                int n18 = n4 - this.base_y;
                int n19 = (int)Math.sqrt(n17 * n17 + n18 * n18);
                int n20 = n - this.base_x;
                int n21 = n2 - this.base_y;
                int n22 = (int)Math.sqrt(n20 * n20 + n21 * n21);
                int n23 = Math.max(n19, n22);
                n5 = this.base_x - n23;
                n6 = this.base_y - n23;
                n7 = 2 * n23 + 1;
                n8 = 2 * n23 + 1;
                break;
            }
            case 6: {
                int n24 = Math.max(Math.abs(n3 - this.base_x), Math.abs(n4 - this.base_y));
                int n25 = Math.max(Math.abs(n - this.base_x), Math.abs(n2 - this.base_y));
                int n26 = Math.max(n24, n25);
                n5 = this.base_x - n26;
                n6 = this.base_y - n26;
                n7 = 2 * n26 + 1;
                n8 = 2 * n26 + 1;
                break;
            }
            case 7: {
                int n27 = Math.max(Math.abs(n3 - this.base_x), Math.abs(n - this.base_x));
                int n28 = Math.max(Math.abs(n4 - this.base_y), Math.abs(n2 - this.base_y));
                n5 = this.base_x - n27;
                n6 = this.base_y - n28;
                n7 = 2 * n27 + 1;
                n8 = 2 * n28 + 1;
                break;
            }
            case 8: {
                Rectangle rectangle = this.pg.getBounds();
                n5 = rectangle.x;
                n6 = rectangle.y;
                n7 = rectangle.width;
                n8 = rectangle.height;
                break;
            }
            case 11: {
                int n29 = Math.max(Math.abs(n3 - this.base_x), Math.abs(n - this.base_x));
                int n30 = Math.max(Math.abs(n4 - this.base_y), Math.abs(n2 - this.base_y));
                n5 = this.base_x - n29;
                n6 = this.base_y - n30;
                n7 = 2 * n29 + 1;
                n8 = 2 * n30 + 1;
                break;
            }
            case 14: {
                n2 = this.base_y + (int)(this.aspect * (double)(n - this.base_x) + 0.5);
                n4 = this.base_y + (int)(this.aspect * (double)(n3 - this.base_x) + 0.5);
                int n31 = Math.max(Math.abs(n3 - this.base_x), Math.abs(n - this.base_x));
                int n32 = Math.max(Math.abs(n4 - this.base_y), Math.abs(n2 - this.base_y));
                n5 = this.base_x - n31 - 5;
                n6 = this.base_y - n32 - 5;
                n7 = 2 * n31 + 1 + 10;
                n8 = 2 * n32 + 1 + 10;
                break;
            }
            case 12: {
                n5 = FigCanvasRubberband.min(n, n3, this.base_x, this.base2_x);
                n6 = FigCanvasRubberband.min(n2, n4, this.base_y, this.base2_y);
                n7 = FigCanvasRubberband.max(n, n3, this.base_x, this.base2_x) - n5 + 1;
                n8 = FigCanvasRubberband.max(n2, n4, this.base_y, this.base2_y) - n6 + 1;
                break;
            }
            case 15: {
                Point point = new Point(this.base_x, this.base_y);
                Point point2 = new Point(n, n2);
                Point point3 = this.geometryManager.getNearestAllowedPoint(point, point2);
                Point point4 = new Point(n3, n4);
                Point point5 = this.geometryManager.getNearestAllowedPoint(point, point4);
                n5 = FigCanvasRubberband.min(point2.x, point4.x, point3.x, point5.x, point.x);
                n6 = FigCanvasRubberband.min(point2.y, point4.y, point3.y, point5.y, point.y);
                n7 = FigCanvasRubberband.max(point2.x, point4.x, point3.x, point5.x, point.x) - n5 + 1;
                n8 = FigCanvasRubberband.max(point2.y, point4.y, point3.y, point5.y, point.y) - n6 + 1;
                break;
            }
            default: {
                System.out.println("FigCanvasRubberband.paintOnce(): mode not supported " + this.mode);
            }
        }
        Rectangle rectangle = new Rectangle(n5, n6, n7, n8);
        return rectangle;
    }

    void measure(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = (int)(32.0 * (double)n / this.trafo.getZoomFactor());
        double d = this.trafo.getValueInUnits(n5);
        String string = new Format("%4.3f").form(d);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n6 = fontMetrics.stringWidth(string);
        int n7 = fontMetrics.getMaxAscent();
        int n8 = fontMetrics.getMaxDescent();
        graphics.setColor(Color.red);
        switch (n4) {
            case 0: {
                graphics.drawString(string, n2 + 5, n3);
                break;
            }
            case 1: {
                graphics.drawString(string, n2 - 5 - n6, n3);
                break;
            }
            case 2: {
                graphics.drawString(string, n2 - n6 / 2, n3);
                break;
            }
            case 3: {
                graphics.drawString(string, n2 - n6 / 2, n3 - 5);
                break;
            }
            case 5: {
                graphics.drawString(string, n2 - n6 / 2, n3 + 5 + n7);
                break;
            }
            case 6: {
                graphics.drawString(string, n2 + 5, n3 - 5);
                break;
            }
            case 7: {
                graphics.drawString(string, n2 + 5, n3 + 5 + n7);
                break;
            }
            case 9: {
                graphics.drawString(string, n2 - 5 - n6, n3 - 5);
                break;
            }
            case 8: {
                graphics.drawString(string, n2 - 5 - n6, n3 + 5 + n7);
                break;
            }
            default: {
                System.out.println("measure: unknown alignment..." + n4);
                break;
            }
        }
    }

    public static final int min(int n, int n2, int n3) {
        return Math.min(n, Math.min(n2, n3));
    }

    public static final int min(int n, int n2, int n3, int n4) {
        return Math.min(Math.min(n, n2), Math.min(n3, n4));
    }

    public static final int min(int n, int n2, int n3, int n4, int n5) {
        return FigCanvasRubberband.min(n, n2, FigCanvasRubberband.min(n3, n4, n5));
    }

    public static final int max(int n, int n2, int n3) {
        return Math.max(n, Math.max(n2, n3));
    }

    public static final int max(int n, int n2, int n3, int n4) {
        return Math.max(Math.max(n, n2), Math.max(n3, n4));
    }

    public static final int max(int n, int n2, int n3, int n4, int n5) {
        return FigCanvasRubberband.max(n, n2, FigCanvasRubberband.max(n3, n4, n5));
    }

    public FigCanvasRubberband(FigTrafo2D figTrafo2D) {
        this.trafo = figTrafo2D;
    }
}

