/*
 * Decompiled with CFR 0.152.
 */
package hades.utils.vhdl;

import hades.manager.DesignManager;
import hades.models.Design;
import hades.models.InputConnector;
import hades.models.OutputConnector;
import hades.models.io.Ipin;
import hades.models.io.Opin;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.signals.SignalStdLogicVector;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.utils.vhdl.VHDLModelFactory;
import hades.utils.vhdl.VHDLNameMangler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import jfig.utils.ExceptionTracer;

public class VHDLWriter {
    public static final String VERSION_ID = "HADES VHDLWriter 0.3 (22.03.01)";
    public static boolean debug = false;
    Design design;
    String resourceName;
    String fileName;
    File outputDirectory;
    PrintWriter printWriter;
    VHDLModelFactory modelFactory;
    Hashtable componentDeclTable;
    Hashtable vhdlFilesTable;
    Stack makefileStack;
    Hashtable architectureTable;
    Hashtable configurationTable;
    Hashtable instanceTable;
    Hashtable classmapTable;
    Hashtable objectToNameTable;
    Hashtable nameToObjectTable;
    boolean dontWritePowerPorts = true;
    String defaultArchitectureName = "NETLIST";
    String defaultConfigurationName;
    static /* synthetic */ Class class$hades$signals$SignalStdLogic1164;

    public VHDLWriter() {
        VHDLWriter.dbg("VHDLWriter<init>... ");
        this.design = null;
        this.componentDeclTable = new Hashtable();
        this.vhdlFilesTable = new Hashtable();
        this.makefileStack = new Stack();
        this.architectureTable = new Hashtable();
        this.configurationTable = new Hashtable();
        this.instanceTable = new Hashtable();
        this.classmapTable = new Hashtable();
        this.modelFactory = new VHDLModelFactory();
        this.modelFactory.setVHDLWriter(this);
        try {
            this.setOutputDirectory(new File("."));
        }
        catch (Exception e) {
            VHDLWriter.msg("-E- " + e);
            e.printStackTrace();
        }
    }

    public void setClassmapTable(Hashtable ht) {
        this.classmapTable = ht;
    }

    public Hashtable getClassmapTable() {
        return this.classmapTable;
    }

    public void setOutputDirectory(File dir) {
        this.outputDirectory = dir;
        this.modelFactory.setOutputDirectory(dir);
    }

    public void setDesign(Design design) {
        this.design = design;
    }

    public void writeDesign() {
        this.resourceName = this.design.getResourceName();
        if (this.resourceName == null) {
            this.resourceName = this.design.getName();
        }
        this.instanceTable.put(this.design, this.design);
        String key = this.getEntityNameFromClassname(this.design);
        this.componentDeclTable = new Hashtable();
        this.componentDeclTable.put(key, this.design);
        this.nameToObjectTable = new Hashtable();
        this.objectToNameTable = new Hashtable();
        this.vhdlFilesTable.put(key, this.design);
        this.makefileStack.push(key);
        VHDLWriter.dbg("-#- writeDesign: " + this.resourceName);
        this.openDesignOutputFile();
        this.writeDesignHeader();
        this.writeDesignEntityDeclaration();
        this.writeDesignArchitecture();
        this.writeDesignConfiguration();
        this.printWriter.flush();
        this.printWriter.close();
        this.writeSubdesignsAndSimobjects(this.design);
    }

    public void writeSubdesignsAndSimobjects(Design parent) {
        VHDLWriter.dbg("-#- writeSubdesigns...");
        Enumeration e = this.design.getComponents();
        while (e.hasMoreElements()) {
            SimObject tmp = (SimObject)e.nextElement();
            if (tmp instanceof Ipin || tmp instanceof Opin) continue;
            if (tmp instanceof Design) {
                Design sub = (Design)tmp;
                String key = this.getEntityNameFromClassname(sub);
                if (this.vhdlFilesTable.get(key) != null) {
                    VHDLWriter.dbg("-#- skipping subdesign " + sub + " " + key);
                    continue;
                }
                this.setDesign(sub);
                this.writeDesign();
                continue;
            }
            String key = this.getEntityNameFromClassname(tmp);
            if (this.vhdlFilesTable.get(key) != null) {
                VHDLWriter.dbg("-#- skipping simobject " + tmp + " " + key);
                continue;
            }
            this.vhdlFilesTable.put(key, tmp);
            VHDLWriter.dbg("-#- writing simobject: " + tmp);
            this.modelFactory.writeSimObject(tmp);
        }
    }

    public void openDesignOutputFile() {
        this.fileName = this.getEntityNameFromClassname(this.design) + ".vhd";
        VHDLWriter.dbg("-#- fileName = '" + this.fileName + "'");
        try {
            File outputFile = new File(this.outputDirectory, this.fileName);
            FileOutputStream fos = new FileOutputStream(outputFile);
            this.printWriter = new PrintWriter(fos);
        }
        catch (Exception e) {
            VHDLWriter.msg("-E- internal error: " + e);
            this.printWriter = new PrintWriter(System.out);
        }
    }

    public void writeDesignHeader() {
        this.println("-- HADES VHDLWriter 0.3 (22.03.01) on " + new Date());
        this.println("-- for Design " + this.resourceName);
        this.println("");
        this.println("");
        this.println("library IEEE;");
        this.println("use IEEE.std_logic_1164.all;");
        this.println("use IEEE.std_logic_arith.all;");
        this.println("");
        this.println("library WORK;");
        this.println("");
    }

    public void writeDesignEntityDeclaration() {
        String e_name = this.getEntityNameFromClassname(this.design);
        this.println("");
        this.println("entity " + e_name + " is");
        this.println("  port (");
        this.writeDesignPortList(this.design);
        this.println("end " + e_name + ";");
        this.println("");
        this.println("");
    }

    public void writeDesignPortList(Design design) {
        Hashtable<String, SimObject> portNameTable = new Hashtable<String, SimObject>();
        Vector<SimObject> inouts = new Vector<SimObject>();
        Enumeration E = design.getComponents();
        while (E.hasMoreElements()) {
            SimObject tmp = (SimObject)E.nextElement();
            if (tmp instanceof InputConnector) {
                inouts.addElement(tmp);
                continue;
            }
            if (!(tmp instanceof OutputConnector)) continue;
            inouts.addElement(tmp);
        }
        VHDLWriter.dbg("-#- writeDesignPortList: n_inouts= " + inouts.size());
        boolean needsSemicolon = false;
        Enumeration E2 = inouts.elements();
        while (E2.hasMoreElements()) {
            SimObject inout;
            String portName;
            if (needsSemicolon) {
                this.println(";");
            }
            if (portNameTable.get(portName = VHDLWriter.makeVHDLName((inout = (SimObject)E2.nextElement()).getName())) != null) {
                VHDLWriter.msg("-E- double port name after VHDL name mangling: " + portName);
                VHDLWriter.msg("-E- Please correct the I/O names of Hades design." + design);
            }
            portNameTable.put(portName, inout);
            this.print("         " + this.tabulate(portName, 12, 6));
            if (inout instanceof InputConnector) {
                this.print(" :     in  ");
            } else if (inout instanceof OutputConnector) {
                this.print(" :     out ");
            } else {
                this.print(" :  XXXXXX ");
            }
            this.print("  std_logic");
            needsSemicolon = true;
        }
        this.println("");
        this.println("       );");
    }

    public void writeDesignArchitecture() {
        String arch = this.defaultArchitectureName;
        String e_name = this.getEntityNameFromClassname(this.design);
        this.println("architecture " + arch + " of " + e_name + " is ");
        this.println("");
        this.writeDesignComponentDeclarations();
        this.writeDesignSignalDeclarations();
        this.writeDesignNetlist();
        this.println("end " + arch + ";");
        this.println("");
        this.println("");
    }

    public void writeDesignComponentDeclarations() {
        this.println("  -- component declarations start here ");
        Enumeration e = this.design.getComponents();
        while (e.hasMoreElements()) {
            SimObject tmp = (SimObject)e.nextElement();
            String className = this.getEntityNameFromClassname(tmp);
            if (this.componentDeclTable.get(className) != null) continue;
            this.componentDeclTable.put(className, className);
            this.writeComponentDeclaration(tmp);
        }
        this.println("  -- end component declarations");
        this.println("");
        this.println("");
    }

    public void writeComponentDeclaration(SimObject tmp) {
        if (tmp instanceof Ipin) {
            return;
        }
        if (tmp instanceof Opin) {
            return;
        }
        if (tmp instanceof Design) {
            this.writeSubdesignComponentDeclaration((Design)tmp);
        } else {
            this.writeSimObjectComponentDeclaration(tmp);
        }
    }

    public void writeSubdesignComponentDeclaration(Design sub) {
        String className = this.getEntityNameFromClassname(sub);
        VHDLWriter.dbg("-#- wCDecl: " + sub + " " + className);
        this.println("");
        this.println("  component " + className + " is");
        this.println("    port (");
        this.writeDesignPortList(sub);
        this.println("  end component;");
        this.println("");
        this.println("");
    }

    public void writeSimObjectComponentDeclaration(SimObject obj) {
        String className = this.getEntityNameFromClassname(obj);
        this.println("");
        this.println("  component " + className + " is ");
        this.println("    port (");
        Port[] e_ports = obj.getPorts();
        boolean needsSemicolon = false;
        int i = 0;
        while (i < e_ports.length) {
            Port port = e_ports[i];
            if (!port.isPowerPort() || !this.dontWritePowerPorts) {
                if (needsSemicolon) {
                    this.println(";");
                }
                this.print("         " + VHDLWriter.makeVHDLPortName(port));
                this.print(" :       " + VHDLWriter.getPortDirection(port));
                this.print("  " + VHDLWriter.getPortSignalType(port));
                needsSemicolon = true;
            }
            ++i;
        }
        this.println("");
        this.println("    );");
        this.println("  end component;");
        this.println("");
    }

    public void writeDesignSignalDeclarations() {
        this.println("");
        this.println("  -- signal declarations...");
        this.println("");
        Enumeration e = this.design.getSignals();
        while (e.hasMoreElements()) {
            Signal signal = (Signal)e.nextElement();
            String name = this.makeUniqueVHDLName(signal);
            String type = VHDLWriter.getSignalType(signal);
            this.println("  signal " + name + "    : " + type + ";");
        }
        this.println("");
        this.println("  -- end signal declarations");
        this.println("");
    }

    public static String getSignalType(Signal signal) {
        if (signal instanceof SignalStdLogic1164) {
            return "std_logic";
        }
        if (signal instanceof SignalStdLogicVector) {
            int n = ((SignalStdLogicVector)signal).getWidth();
            return "std_logic_vector( " + n + " downto 0";
        }
        return signal.getClass().getName();
    }

    public void writeDesignNetlist() {
        this.println("begin     -- netlist");
        Enumeration e = this.design.getComponents();
        while (e.hasMoreElements()) {
            SimObject tmp = (SimObject)e.nextElement();
            if (tmp instanceof Ipin) {
                this.writeIpinConnection((Ipin)tmp);
                continue;
            }
            if (tmp instanceof Opin) {
                this.writeOpinConnection((Opin)tmp);
                continue;
            }
            this.writeComponentInstantiation(tmp);
        }
    }

    public void writeIpinConnection(Ipin obj) {
        String signalName;
        this.println("");
        this.println("  -- writeIpinConnection: " + obj);
        Port[] ports = obj.getPorts();
        Signal signal = ports[0].getSignal();
        String topName = this.makeUniqueVHDLName(obj);
        String string = signalName = signal != null ? this.makeUniqueVHDLName(signal) : "open";
        if (signalName.equals(topName)) {
            this.println("  -- " + signalName + " <= " + topName + ";");
        } else {
            this.println("  " + signalName + " <= " + topName + ";");
        }
        this.println("");
    }

    public void writeOpinConnection(Opin obj) {
        this.println("");
        this.println("  -- writeOpinConnection: " + obj);
        Port[] ports = obj.getPorts();
        Signal signal = ports[0].getSignal();
        String signalName = signal != null ? this.makeUniqueVHDLName(signal) : "X";
        String topName = this.makeUniqueVHDLName(obj);
        if (signalName.equals(topName)) {
            this.println("  -- " + topName + " <= " + signalName + ";");
        } else {
            this.println("  " + topName + " <= " + signalName + ";");
        }
        this.println("");
    }

    public void writeComponentInstantiation(SimObject obj) {
        this.println("");
        this.println("  -- writeComponentInstantiation: " + obj);
        String iName = this.makeUniqueVHDLName(obj);
        String className = this.getEntityNameFromClassname(obj);
        String komma = ",";
        this.println("  " + iName + " : " + className);
        this.println("    port map ( ");
        Port[] ports = obj.getPorts();
        int i = 0;
        while (i < ports.length) {
            String portName = VHDLWriter.makeVHDLName(ports[i].getName());
            Signal signal = ports[i].getSignal();
            String signalName = signal != null ? this.makeUniqueVHDLName(signal) : "open";
            this.print("      " + portName + " => " + signalName);
            if (i + 1 < ports.length) {
                this.print(komma);
            }
            this.println("");
            ++i;
        }
        this.println("    ); ");
        this.println("");
    }

    public void writeDesignConfiguration() {
        String e_name = this.getEntityNameFromClassname(this.design);
        String cfg_name = "cfg_" + e_name;
        this.println("");
        this.println("configuration " + cfg_name + " of " + e_name + " is");
        this.println("  for " + this.defaultArchitectureName);
        this.println("  end for;");
        this.println("end " + cfg_name + ";");
        this.println("");
        this.println("");
        this.println("-- HADES VHDLWriter 0.3 (22.03.01) on " + new Date());
    }

    public String getEntityNameFromClassname(SimObject obj) {
        String tmp = null;
        if (obj instanceof Design) {
            Design design = (Design)obj;
            String resname = design.getResourceName();
            if (resname == null) {
                resname = design.getName();
            }
            if ((tmp = (String)this.classmapTable.get(resname)) == null) {
                tmp = resname;
                int dot = tmp.lastIndexOf(46);
                if (dot > 0) {
                    tmp = tmp.substring(0, dot);
                }
                if ((tmp = tmp.replace('/', '_')).startsWith("_")) {
                    tmp = tmp.substring(1);
                }
            }
        } else {
            tmp = (String)this.classmapTable.get(obj.getClass().getName());
            if (tmp == null) {
                tmp = obj.getClass().getName().replace('.', '_');
            }
        }
        return tmp;
    }

    public static String makeVHDLName(String s) {
        return VHDLNameMangler.getValidVHDLName(s);
    }

    public String makeUniqueVHDLName(Signal s) {
        return this.makeUniqueVHDLName(s, s.getName());
    }

    public String makeUniqueVHDLName(SimObject so) {
        return this.makeUniqueVHDLName(so, so.getName());
    }

    public String makeUniqueVHDLName(Object obj, String objName) {
        if (obj == null) {
            return "NULL object";
        }
        Object tmp = this.objectToNameTable.get(obj);
        if (tmp != null) {
            return (String)tmp;
        }
        String name = VHDLNameMangler.getValidVHDLName(objName);
        while ((tmp = this.nameToObjectTable.get(name)) != null) {
            VHDLWriter.msg("-W- mangled object name conflicts with previous mangled name");
            VHDLWriter.msg("-W- object is: " + obj + " name is: " + name);
            name = name + "X" + Math.round(100.0 * Math.random());
            VHDLWriter.msg("-I- renaming to : " + name);
        }
        this.objectToNameTable.put(obj, name);
        this.nameToObjectTable.put(name, obj);
        return name;
    }

    public static String makeVHDLPortName(Port port) {
        return VHDLNameMangler.getValidVHDLName(port.getName());
    }

    public static String getPortDirection(Port port) {
        switch (port.getType()) {
            case 0: 
            case 3: 
            case 6: {
                return "in ";
            }
            case 1: {
                return "out";
            }
            case 2: {
                return "inout";
            }
            case 4: {
                return "VCC";
            }
            case 5: {
                return "GND";
            }
            case 7: {
                return "UNUSED";
            }
        }
        return "UNKNOWN";
    }

    public static String getPortSignalType(Port port) {
        Signal signal = port.getSignal();
        if (signal != null) {
            return VHDLWriter.getSignalType(signal);
        }
        if (port.getSignalClass() == (class$hades$signals$SignalStdLogic1164 == null ? (class$hades$signals$SignalStdLogic1164 = VHDLWriter.class$("hades.signals.SignalStdLogic1164")) : class$hades$signals$SignalStdLogic1164)) {
            return "std_logic";
        }
        return port.getSignalClass().toString();
    }

    public void writeMakefile() {
        try {
            FileOutputStream fos = new FileOutputStream(new File(this.outputDirectory, "makefile"));
            PrintWriter pw = new PrintWriter(fos);
            pw.println("# simobjects...");
            pw.println("#");
            Enumeration e = this.vhdlFilesTable.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = this.vhdlFilesTable.get(key);
                if (value instanceof Design) continue;
                pw.println("vhdlan " + key);
            }
            pw.println("# designs...");
            pw.println("#");
            while (!this.makefileStack.isEmpty()) {
                pw.println("vhdlan " + this.makefileStack.pop());
            }
            pw.flush();
            pw.close();
            fos.close();
        }
        catch (Exception e) {
            VHDLWriter.msg("-E- internal error: could not write makefile: " + e);
        }
    }

    public void dumpTables() {
        Object tmp;
        VHDLWriter.dbg("");
        VHDLWriter.dbg("componentDeclTable: ");
        Enumeration E = this.componentDeclTable.keys();
        while (E.hasMoreElements()) {
            tmp = E.nextElement();
            VHDLWriter.dbg("  " + tmp + " -> " + this.componentDeclTable.get(tmp));
        }
        VHDLWriter.dbg("");
        VHDLWriter.dbg("architectureTable:");
        Enumeration E2 = this.architectureTable.keys();
        while (E2.hasMoreElements()) {
            tmp = E2.nextElement();
            VHDLWriter.dbg("  " + tmp + " -> " + this.architectureTable.get(tmp));
        }
        VHDLWriter.dbg("");
        VHDLWriter.dbg("configurationTable:");
        Enumeration E3 = this.configurationTable.keys();
        while (E3.hasMoreElements()) {
            tmp = E3.nextElement();
            VHDLWriter.dbg("  " + tmp + " -> " + this.configurationTable.get(tmp));
        }
        VHDLWriter.dbg("");
        VHDLWriter.dbg("instanceTable: ");
        Enumeration E4 = this.instanceTable.keys();
        while (E4.hasMoreElements()) {
            tmp = E4.nextElement();
            VHDLWriter.dbg("  " + tmp + " -> " + this.instanceTable.get(tmp));
        }
        VHDLWriter.dbg("");
    }

    public String tabulate(String s, int min_width, int tab_width) {
        int length = s.length();
        int n_spaces = 0;
        n_spaces = length < min_width ? min_width - length : (length / tab_width + 1) * tab_width - min_width;
        StringBuffer sb = new StringBuffer(s);
        int i = 0;
        while (i < n_spaces) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public void print(String s) {
        this.printWriter.print(s);
    }

    public void println(String s) {
        this.printWriter.println(s);
    }

    public static void msg(String msg) {
        ExceptionTracer.message(msg);
    }

    public static void dbg(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    public static void usage() {
        System.out.println("Usage: java hades.utils.vhdl.VHDLWriter <directory> <designname> [classmapfile]\nExamples:\njava hades.utils.vhdl.VHDLWriter /tmp/hugo  /hades/examples/simple/dlatch.hds\njava hades.utils.vhdl.VHDLWriter /tmp/vhdl/dcf77  /hades/examples/dcf77/Toplevel.hds /tmp/classmap.txt\n");
        System.exit(1);
    }

    public static void main(String[] argv) throws Exception {
        Properties classmap = new Properties();
        Design design = null;
        try {
            design = DesignManager.getDesignManager().getDesign(null, argv[1], true);
            if (argv.length == 3) {
                classmap.load(new FileInputStream(argv[2]));
                VHDLWriter.msg("-I- loaded class mapping from " + argv[2]);
            }
        }
        catch (Exception e) {
            VHDLWriter.usage();
        }
        VHDLWriter writer = new VHDLWriter();
        writer.setClassmapTable(classmap);
        writer.setDesign(design);
        writer.setOutputDirectory(new File(argv[0]));
        writer.writeDesign();
        writer.writeMakefile();
        System.exit(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

