/*
 * Decompiled with CFR 0.152.
 */
package hades.utils.vhdl;

import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.utils.vhdl.VHDLExportable;
import hades.utils.vhdl.VHDLWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;

public class VHDLModelFactory {
    public static final String defaultArchitectureName = "SIMPLE";
    Hashtable configurationTable = new Hashtable();
    Hashtable architectureTable = new Hashtable();
    boolean dontWritePowerPorts = true;
    VHDLWriter vhdlWriter = null;
    File outputDirectory = null;
    SimObject simObject = null;
    PrintWriter printWriter = null;
    public static final String[][] _simpleBehaviours = new String[][]{{"hades.models.gates.And2", "Y <= A and B"}, {"hades.models.gates.And3", "Y <= (A and B) and C"}, {"hades.models.gates.And4", "Y <= (A and B) and (C and D)"}, {"hades.models.gates.Buffer", "Y <= A"}, {"hades.models.gates.Inv", "Y <= not A after 10 ns"}, {"hades.models.gates.InvSmall", "Y <= not A after 10 ns"}, {"hades.models.gates.Mux21", "Y <= A0 when (S = '0') else A1"}, {"hades.models.gates.Nand2", "Y <= not (A and B)"}, {"hades.models.gates.Nand3", "Y <= not ((A and B) and C)"}, {"hades.models.gates.Nand4", "Y <= not ((A and B) and (C and D))"}, {"hades.models.gates.Nor2", "Y <= not (A or B)"}, {"hades.models.gates.Nor3", "Y <= not ((A or B) or C)"}, {"hades.models.gates.Nor4", "Y <= not ((A or B) or (C or D))"}, {"hades.models.gates.Or2", "Y <= A or B"}, {"hades.models.gates.Or3", "Y <= (A or B) or C"}, {"hades.models.gates.Or4", "Y <= (A or B) or (C or D)"}, {"hades.models.gates.Tri", "Y <= A when (S = '0') else 'Z'"}, {"hades.models.gates.Xor2", "Y <= A xor B"}, {"hades.models.gates.Xnor2", "Y <= not (A xor B)"}, {"hades.models.complexgates.AOI21", "Y <= not ((A1 and A2) or B1)"}, {"hades.models.complexgates.AOI22", "Y <= not ((A1 and A2) or (B1 and B2))"}, {"hades.models.complexgates.AOI31", "Y <= not (((A1 and A2) and A3) or B1)"}, {"hades.models.complexgates.AOI32", "Y <= not (((A1 and A2) and A3) or (B1 and B2))"}, {"hades.models.complexgates.AOI33", "Y <= not ( ((A1 and A2) and A3) or ((B1 and B2) and B3) )"}, {"hades.models.complexgates.OAI21", "Y <= not ((A1 or A2) and B1)"}, {"hades.models.complexgates.OAI22", "Y <= not ((A1 or A2) and (B1 or B2))"}, {"hades.models.complexgates.OAI31", "Y <= not (((A1 or A2) and A3) or B1)"}, {"hades.models.complexgates.OAI32", "Y <= not (((A1 or A2) or A3) and (B1 or B2))"}, {"hades.models.complexgates.OAI33", "Y <= not ( ((A1 or A2) or A3) and ((B1 or B2) or B3) )"}, {"hades.models.io.ClockGen", "\n  process\n  begin\n    CLK <= '0';\n    wait for t_initial;\n    loop\n      CLK <= '1';\n      wait for t_period*duty_cycle;\n      CLK <= '0';\n      wait for t_period*(1-duty_cycle);\n    end loop\n  end process"}, {"hades.models.io.PowerOnReset", "\n  process\n  begin\n    nreset <= 'X';\n    wait for 1800 ns;\n    nreset <= '0';\n    wait for 1000 ns;\n    nreset <= '1';\n    wait;\n  end process"}, {"hades.models.io.Gnd", "\nGND <= '0'"}, {"hades.models.io.Vcc", "\nVCC <= '1'"}, {"hades.models.io.Pullup", "\nH <= 'Z'"}, {"hades.models.flipflops.Dff", "process( C, D )\n  begin\n    if (C'event and (C = '1')) then  -- rising edge\n      Q  <= D;\n      NQ <= not D;\n    end if;\n  end process"}, {"hades.models.flipflops.Dffr", "process( C, D, NR )\n  begin\n    if (NR = '0') then               -- reset\n      Q  <= '0';\n      NQ <= '1';\n    else \n      if  (C'event and (C = '1')) then  -- rising edge\n        Q  <= D;\n        NQ <= not D;\n      end if;\n    end if;\n  end process"}, {"hades.models.flipflops.Latch", "process( C, D )\n  begin\n    if (C = '1') then  -- transparent \n      Q  <= D;\n      NQ <= not D;\n    end if;\n  end process"}, {"hades.models.flipflops.Latchr", "process( C, D, NR )\n  begin\n    if (NR = '0') then    -- reset\n      Q  <= '0';\n      NQ <= '1';\n    else \n      if  (C = '1') then  -- transparent \n        Q  <= D;\n        NQ <= not D;\n      end if;\n    end if;\n  end process"}, {"hades.models.io.HexDisplay", "\n  process (A3, A2, A1, A0)\n  begin\n    report \"HexDisplay\"  \n      & simple'path_name       & std_logic'image(A3)       & std_logic'image(A2)       & std_logic'image(A1)       & std_logic'image(A0) ;\n  end process"}, {"hades.models.io.LED", "\n  process (A)\n  begin\n    report \"LED\" & simple'path_name & std_logic'image(A); \n  end process"}};
    public static Hashtable behaviourTable = new Hashtable();

    public void setOutputDirectory(File dir) {
        this.outputDirectory = dir;
    }

    public void setVHDLWriter(VHDLWriter writer) {
        this.vhdlWriter = writer;
    }

    public void writeSimObject(SimObject tmp) {
        this.simObject = tmp;
        try {
            this.openOutputFile();
            if (this.simObject instanceof VHDLExportable) {
                VHDLExportable obj = (VHDLExportable)((Object)this.simObject);
                obj.writeEntity(this.printWriter);
                obj.writePackageDeclaration(this.printWriter);
                obj.writePackageBody(this.printWriter);
                obj.writeArchitecture(this.printWriter);
                obj.writeConfiguration(this.printWriter);
            } else {
                this.writeHeader(this.simObject, this.printWriter);
                this.writeEntityDeclaration(this.simObject, this.printWriter);
                this.writeArchitecture(this.simObject, this.printWriter);
                this.writeConfiguration(this.simObject, this.printWriter);
            }
            this.printWriter.flush();
            this.printWriter.close();
        }
        catch (Exception e) {
            VHDLModelFactory.msg("-E- VHDLModelFactory.writeSimObject failed: " + e);
            e.printStackTrace();
        }
    }

    private void openOutputFile() throws Exception {
        String fileName = this.vhdlWriter.getEntityNameFromClassname(this.simObject) + ".vhd";
        File outputFile = new File(this.outputDirectory, fileName);
        FileOutputStream fos = new FileOutputStream(outputFile);
        this.printWriter = new PrintWriter(fos);
    }

    private void writeHeader(SimObject simObject, PrintWriter PW) {
        PW.println("-- VHDL for " + simObject);
        PW.println("--");
        PW.println();
        PW.println("library IEEE;");
        PW.println("use IEEE.std_logic_1164.all;");
        PW.println();
    }

    private void writeEntityDeclaration(SimObject obj, PrintWriter PW) {
        String className = this.vhdlWriter.getEntityNameFromClassname(obj);
        PW.println("");
        PW.println("entity " + className + " is ");
        PW.println("    port (");
        Port[] e_ports = obj.getPorts();
        boolean needsSemicolon = false;
        int i = 0;
        while (i < e_ports.length) {
            Port port = e_ports[i];
            if (!port.isPowerPort() || !this.dontWritePowerPorts) {
                if (needsSemicolon) {
                    PW.println(";");
                }
                PW.print("         " + VHDLWriter.makeVHDLPortName(port));
                PW.print(" :       " + VHDLWriter.getPortDirection(port));
                PW.print("  " + VHDLWriter.getPortSignalType(port));
                needsSemicolon = true;
            }
            ++i;
        }
        PW.println("");
        PW.println("    );");
        PW.println("end " + className + ";");
        PW.println("");
    }

    public void writeArchitecture(SimObject gate, PrintWriter PW) {
        String e_name = this.vhdlWriter.getEntityNameFromClassname(gate);
        String a_name = defaultArchitectureName;
        String cl_name = gate.getClass().getName();
        String key = e_name + ":" + a_name;
        if (this.architectureTable.get(key) != null) {
            return;
        }
        this.architectureTable.put(key, "dummy");
        String behav = (String)behaviourTable.get(cl_name);
        if (behav == null) {
            VHDLModelFactory.msg("-W- VHDLModelFactory: writing empty architecture for: " + cl_name);
            behav = "-- put the gate's behaviour here";
        }
        PW.println();
        PW.println("-- default architecture for: " + gate);
        PW.println("--");
        PW.println("architecture " + a_name + " of " + e_name + " is");
        PW.println("begin");
        PW.println("  " + behav + ";");
        PW.println("end " + a_name + ";");
        PW.println();
        PW.println();
    }

    public void writeConfiguration(SimObject obj, PrintWriter PW) {
        String e_name = this.vhdlWriter.getEntityNameFromClassname(obj);
        String cfg_name = "cfg_" + e_name;
        String key = cfg_name;
        if (this.configurationTable.get(key) != null) {
            return;
        }
        this.configurationTable.put(key, "dummy");
        PW.println();
        PW.println("configuration " + cfg_name + " of " + e_name + " is");
        PW.println("  for SIMPLE");
        PW.println("  end for;");
        PW.println("end " + cfg_name + ";");
        PW.println();
        PW.println();
    }

    static void msg(String s) {
        System.out.println(s);
    }

    static {
        int i = 0;
        while (i < _simpleBehaviours.length) {
            behaviourTable.put(_simpleBehaviours[i][0], _simpleBehaviours[i][1]);
            ++i;
        }
    }
}

