/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.gui.Console;

public class ValidName {
    private static String[] spaces = new String[]{"0000", "000", "00", "0", ""};

    public static String getValidName(String name) {
        String newname = new String(name);
        if (newname.indexOf(32) > 0 || newname.indexOf(9) > 0) {
            newname = newname.replace(' ', '_');
            newname = newname.replace('\t', '_');
            Console.getConsole().message("-W- name contains spaces/tabs, changed to: " + newname);
        }
        return newname;
    }

    public static boolean isAsciiLetterOrDigitOrSomething(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '/' || c == '_' || c == '-' || c == ':' || c == '.';
    }

    public static String getUnicodeEscape(char c) {
        String hex = Integer.toHexString(c);
        return "\\u" + spaces[hex.length()] + hex;
    }

    public static String encodeWithUnicodeEscapes(String src) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int max = src.length();
        while (i < max) {
            char c = src.charAt(i);
            if (ValidName.isAsciiLetterOrDigitOrSomething(c)) {
                sb.append(c);
            } else {
                sb.append(ValidName.getUnicodeEscape(c));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String decodeUnicodeEscapes(String src) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int max = src.length();
        while (i < max) {
            char c = src.charAt(i);
            if (c == '\\') {
                if (src.charAt(i + 1) == 'u') {
                    int j = Integer.parseInt(src.substring(i + 2, i + 6), 16);
                    sb.append((char)j);
                    i += 5;
                } else {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] argv) {
        System.out.println("Unicode encoding/decoding selftest...");
        String[] tests = new String[]{"Abba", "Baywatch", "Christiane", "delta t", "epsilon theta tau", "c:\\Program Files\\User Data\\Garbage Collectors Item.hds", "_01234_56769_", "_abcde_fghij_klmno_pqrst_uvwxy_z", "_ABCDE_FGHIJ_KLMNO_PQRST_UVWXY_Z", "_!?<>^_@#$%&_*(){{}_[]:;.,/_+|~=\\_"};
        int i = 0;
        while (i < tests.length) {
            String original = tests[i];
            String encoded = ValidName.encodeWithUnicodeEscapes(original);
            String decoded = ValidName.decodeUnicodeEscapes(encoded);
            System.out.println(original + "\n" + encoded + "\n" + original.equals(decoded) + "\n");
            ++i;
        }
    }
}

