/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.gui.MultiLineLabel;
import hades.gui.ObjectCanvas;
import hades.utils.ContextToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Date;
import jfig.utils.ExceptionTracer;

public class ToolTipManager
implements Runnable,
KeyListener,
MouseListener,
MouseMotionListener {
    protected long timeout = 1000L;
    protected long deltat = 500L;
    protected long t_update = 1000L;
    protected long time = 0L;
    protected boolean enabled;
    protected boolean mouseIsInside;
    protected Thread timerThread;
    protected boolean toolTipIsVisible;
    protected int mouse_x;
    protected int mouse_y;
    protected Component target;
    protected Frame targetFrame;
    protected Window tipWindow;
    protected MultiLineLabel tipLabel;
    protected ContextToolTip contextToolTip;
    protected String fixedToolTip;

    public ToolTipManager(Component target, long timeout) {
        target.addKeyListener(this);
        target.addMouseListener(this);
        target.addMouseMotionListener(this);
        this.target = target;
        this.tipLabel = new MultiLineLabel("no tip yet");
        this.tipLabel.setBackground(new Color(255, 255, 180));
        this.buildToolTipWindow();
        this.timeout = timeout;
        this.toolTipIsVisible = false;
        this.mouseIsInside = false;
        this.contextToolTip = null;
        this.fixedToolTip = null;
        this.timerThread = new Thread((Runnable)this, "ToolTipManager for " + target.toString());
        this.timerThread.setDaemon(true);
        this.timerThread.setPriority(1);
        this.timerThread.start();
    }

    public ToolTipManager(Component target, ContextToolTip helper, long timeout) {
        this(target, timeout);
        this.contextToolTip = helper;
    }

    public ToolTipManager(Component target, String message, long timeout) {
        this(target, timeout);
        this.fixedToolTip = message;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled && this.toolTipIsVisible) {
            this.hideToolTip();
        }
    }

    public Frame findFrame(Component target) {
        if (target instanceof Frame) {
            return (Frame)target;
        }
        if (target.getParent() != null) {
            return this.findFrame(target.getParent());
        }
        ToolTipManager.msg("-E- Internal: no parent Frame found for " + target);
        return null;
    }

    public void setTimeout(long millis) {
        this.timeout = millis;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setDeltaT(long millis) {
        this.deltat = millis;
    }

    public long getDeltat() {
        return this.deltat;
    }

    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(this.deltat);
                this.time += this.deltat;
                if (this.time >= this.timeout + this.t_update) {
                    this.time -= this.t_update;
                    this.updateToolTip();
                    continue;
                }
                if (this.time < this.timeout) continue;
                this.showToolTip();
            }
            catch (InterruptedException ie) {
                this.hideToolTip();
            }
            catch (Exception e) {
                ExceptionTracer.message("-E- ToolTipManager: " + e);
                ExceptionTracer.trace(e);
                this.hideToolTip();
            }
        }
    }

    public void buildToolTipWindow() {
        this.targetFrame = this.findFrame(this.target);
        if (this.targetFrame != null) {
            this.tipWindow = new Window(this.targetFrame);
            this.tipWindow.add("Center", this.tipLabel);
        }
    }

    public void showToolTip() {
        if (!this.enabled) {
            return;
        }
        if (!this.mouseIsInside) {
            return;
        }
        if (this.toolTipIsVisible) {
            return;
        }
        if (this.tipWindow == null) {
            this.buildToolTipWindow();
            if (this.tipWindow == null) {
                return;
            }
        }
        if (!this.targetFrame.isVisible()) {
            return;
        }
        if (this.checkObjectCanvasPopupIsShowing()) {
            return;
        }
        String tip = this.getToolTip();
        if (tip == null) {
            return;
        }
        this.tipLabel.setText(tip);
        this.tipLabel.measure();
        this.tipLabel.invalidate();
        this.tipWindow.pack();
        Point pos = this.target.getLocationOnScreen();
        pos.x = pos.x + this.mouse_x + 10;
        pos.y = pos.y + this.mouse_y + 10;
        this.tipWindow.setLocation(pos);
        this.tipWindow.setVisible(true);
        this.tipWindow.setSize(this.tipLabel.getPreferredSize());
        this.tipWindow.validate();
        this.tipWindow.repaint();
        this.toolTipIsVisible = true;
    }

    public void hideToolTip() {
        if (!this.toolTipIsVisible) {
            return;
        }
        this.tipWindow.setVisible(false);
        this.toolTipIsVisible = false;
    }

    public void updateToolTip() {
        if (!this.enabled) {
            return;
        }
        if (!this.mouseIsInside) {
            return;
        }
        if (this.tipWindow == null) {
            this.buildToolTipWindow();
            if (this.tipWindow == null) {
                return;
            }
        }
        if (!this.targetFrame.isVisible()) {
            return;
        }
        if (this.checkObjectCanvasPopupIsShowing()) {
            return;
        }
        String tip = this.getToolTip();
        if (tip == null) {
            return;
        }
        if (tip.equals(this.tipLabel.getLabel())) {
            return;
        }
        this.tipLabel.setText(tip);
        this.tipLabel.measure();
        this.tipLabel.invalidate();
        Point pos = this.target.getLocationOnScreen();
        pos.x = pos.x + this.mouse_x + 10;
        pos.y = pos.y + this.mouse_y + 10;
        this.tipWindow.setSize(this.tipLabel.getPreferredSize());
        this.tipWindow.validate();
        this.tipWindow.setLocation(pos);
        this.tipWindow.repaint();
    }

    public String getToolTip() {
        String tip = null;
        tip = this.contextToolTip != null ? this.contextToolTip.getToolTip(new Point(this.mouse_x, this.mouse_y), this.time) : (this.fixedToolTip != null ? this.fixedToolTip : "-E- internal: no tool tip specified!");
        return tip;
    }

    public boolean checkObjectCanvasPopupIsShowing() {
        if (this.target instanceof ObjectCanvas) {
            boolean b = ((ObjectCanvas)((Object)this.target)).isPopupShowing();
            return b;
        }
        return false;
    }

    public void mouseClicked(MouseEvent evt) {
        this.time = 0L;
        this.mouse_x = evt.getX();
        this.mouse_y = evt.getY();
        this.hideToolTip();
    }

    public void mouseReleased(MouseEvent evt) {
        this.time = 0L;
        this.mouse_x = evt.getX();
        this.mouse_y = evt.getY();
        this.hideToolTip();
    }

    public void mousePressed(MouseEvent evt) {
        this.time = 0L;
        this.mouse_x = evt.getX();
        this.mouse_y = evt.getY();
        this.hideToolTip();
    }

    public void mouseMoved(MouseEvent evt) {
        this.time = 0L;
        this.mouse_x = evt.getX();
        this.mouse_y = evt.getY();
        this.mouseIsInside = true;
        this.hideToolTip();
    }

    public void mouseDragged(MouseEvent evt) {
        this.time = 0L;
        this.mouse_x = evt.getX();
        this.mouse_y = evt.getY();
        this.mouseIsInside = true;
        this.hideToolTip();
    }

    public void mouseEntered(MouseEvent evt) {
        this.time = 0L;
        this.mouse_x = evt.getX();
        this.mouse_y = evt.getY();
        this.mouseIsInside = true;
        this.hideToolTip();
    }

    public void mouseExited(MouseEvent evt) {
        this.time = 0L;
        this.mouse_x = evt.getX();
        this.mouse_y = evt.getY();
        this.mouseIsInside = false;
        this.hideToolTip();
    }

    public void keyPressed(KeyEvent evt) {
        this.time = 0L;
        this.mouseIsInside = true;
        this.hideToolTip();
    }

    public void keyReleased(KeyEvent evt) {
        this.time = 0L;
        this.mouseIsInside = true;
        this.hideToolTip();
    }

    public void keyTyped(KeyEvent evt) {
        this.time = 0L;
        this.mouseIsInside = true;
        this.hideToolTip();
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        Frame f = new Frame();
        f.setSize(new Dimension(300, 300));
        f.setVisible(true);
        ContextToolTip ctt = new ContextToolTip(){

            public String getToolTip(Point position, long millis) {
                int n_lines = (int)(1.0 + Math.random() * 5.0);
                StringBuffer lines = new StringBuffer();
                int i = 0;
                while (i < n_lines) {
                    int n_chars = (int)(1.0 + Math.random() * 79.0);
                    StringBuffer sb = new StringBuffer();
                    int j = 0;
                    while (j < n_chars) {
                        char c = (char)(65 + (int)(Math.random() * 26.0));
                        sb.append(c);
                        ++j;
                    }
                    sb.append('\n');
                    lines.append(sb.toString());
                    ++i;
                }
                String base = "at (" + position.x + "," + position.y + ")" + " after " + millis + " msec." + "\nat time " + new Date();
                return base + "\n" + lines.toString();
            }
        };
        ToolTipManager tt = new ToolTipManager((Component)f, ctt, 1000L);
        tt.setEnabled(true);
    }
}

