/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private int currentPosition = 0;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retTokens;

    public StringTokenizer(String str, String delim, boolean returnTokens) {
        this.str = str;
        this.maxPosition = str.length();
        this.delimiters = delim;
        this.retTokens = returnTokens;
    }

    public StringTokenizer(String str, String delim) {
        this(str, delim, false);
    }

    public StringTokenizer(String str) {
        this(str, " \t\n\r\u0013", false);
    }

    private void skipDelimiters() {
        while (!this.retTokens && this.currentPosition < this.maxPosition && this.delimiters.indexOf(this.str.charAt(this.currentPosition)) >= 0) {
            ++this.currentPosition;
        }
    }

    public boolean hasMoreTokens() {
        this.skipDelimiters();
        return this.currentPosition < this.maxPosition;
    }

    public String nextToken() {
        this.skipDelimiters();
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        while (this.currentPosition < this.maxPosition && this.delimiters.indexOf(this.str.charAt(this.currentPosition)) < 0) {
            ++this.currentPosition;
        }
        if (this.retTokens && start == this.currentPosition && this.delimiters.indexOf(this.str.charAt(this.currentPosition)) >= 0) {
            ++this.currentPosition;
        }
        return this.str.substring(start, this.currentPosition);
    }

    public String nextToken(String delim) {
        this.delimiters = delim;
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    /*
     * Unable to fully structure code
     */
    public int countTokens() {
        count = 0;
        currpos = this.currentPosition;
        ** GOTO lbl15
        {
            ++currpos;
            do {
                if (!this.retTokens && currpos < this.maxPosition && this.delimiters.indexOf(this.str.charAt(currpos)) >= 0) continue block0;
                if (currpos >= this.maxPosition) break block0;
                start = currpos;
                while (currpos < this.maxPosition && this.delimiters.indexOf(this.str.charAt(currpos)) < 0) {
                    ++currpos;
                }
                if (this.retTokens && start == currpos && this.delimiters.indexOf(this.str.charAt(currpos)) >= 0) {
                    ++currpos;
                }
                ++count;
lbl15:
                // 2 sources

            } while (currpos < this.maxPosition);
        }
        return count;
    }

    public int currentPosition() {
        return this.currentPosition;
    }

    public String restOfLine() {
        return this.str.substring(this.currentPosition, this.str.length());
    }
}

