/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.utils.HexFormat;

public class LFSR32 {
    private int value = -559038737;
    private int mask = 9;

    public void setValue(int value) {
        if (value == 0) {
            LFSR32.msg("-W- replacing invalid start value 0 with 1");
            value = 1;
        }
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public void clock() {
        int bit31 = this.value & Integer.MIN_VALUE;
        this.value = bit31 != 0 ? ((this.value ^ this.mask) << 1) + 1 : (this.value <<= 1);
    }

    public void normal_clock() {
        boolean newbit;
        boolean bl = newbit = (this.value & Integer.MIN_VALUE) != 0;
        if ((this.value & 8) != 0) {
            boolean bl2 = newbit = !newbit;
        }
        if ((this.value & 1) != 0) {
            newbit = !newbit;
        }
        this.value <<= 1;
        if (newbit) {
            ++this.value;
        }
    }

    public void signature_clock(int input_value) {
        boolean newbit;
        this.value ^= input_value;
        if (this.value == 0) {
            LFSR32.msg("-W- LFSR32 value zero during signature analysis!");
        }
        boolean bl = newbit = (this.value & Integer.MIN_VALUE) != 0;
        if ((this.value & 8) != 0) {
            boolean bl2 = newbit = !newbit;
        }
        if ((this.value & 1) != 0) {
            newbit = !newbit;
        }
        this.value <<= 1;
        if (newbit) {
            ++this.value;
        }
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void usage() {
        LFSR32.msg("Usage: java LFSR32 <seed> <n-cycles>");
        System.exit(0);
    }

    public static void main(String[] argv) {
        int seed = 13;
        int num = 50;
        try {
            seed = Integer.parseInt(argv[0], 10);
            num = Integer.parseInt(argv[1], 10);
        }
        catch (Exception e) {
            LFSR32.usage();
        }
        LFSR32 lsfr = new LFSR32();
        lsfr.setValue(seed);
        LFSR32 analyzer = new LFSR32();
        analyzer.setValue(123456);
        int i = 0;
        while (i < num) {
            lsfr.normal_clock();
            int value = lsfr.getValue();
            if ((value & 0xFFFF) == value) {
                System.out.println(HexFormat.getHexString((long)value & 0xFFFFFFFFL, 8) + "  " + i);
            }
            analyzer.signature_clock(value);
            int signature = analyzer.getValue();
            if ((signature & 0xFFFF) == signature) {
                System.out.println("    " + HexFormat.getHexString((long)signature & 0xFFFFFFFFL, 8) + "  " + i);
            }
            ++i;
        }
    }
}

