/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class JavaVersionCheck {
    static String msg = "You are attempting to run this Java application or applet \nwith an outdated or incompatible Java virtual machine. \n\nUnfortunately, this program requires features only introduced\nin Java 1.3, which means that the program cannot run and will\nbe stopped after this message.\nPlease download a compatible Java VM from your systems vendor\nand check the documentation for this program for help.\n\nYou seem to be running the following Java virtual machine:\njava.version: " + System.getProperty("java.version") + "\n" + "java.vendor:  " + System.getProperty("java.vendor") + "\n";

    public static String getVersion() {
        return System.getProperty("java.version");
    }

    public static boolean isOK() {
        try {
            Class.forName("java.util.LinkedList");
            Class.forName("javax.swing.JComponent");
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static void displayVersionCheckWarning() {
        Frame frame = new Frame("Java Version Check Failed!");
        TextArea ta = new TextArea(20, 60);
        ta.setText(msg);
        Button ok = new Button("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    Component parent = (Component)evt.getSource();
                    while (parent.getParent() != null) {
                        parent = parent.getParent();
                    }
                    if (parent instanceof Frame) {
                        ((Frame)parent).setVisible(false);
                    }
                    System.exit(0);
                }
                catch (Throwable t) {
                    System.out.println("JavaVersionCheck: internal: " + t);
                    t.printStackTrace();
                }
            }
        });
        Panel panel = new Panel(new FlowLayout(1));
        panel.add(ok);
        frame.add("Center", ta);
        frame.add("South", panel);
        frame.pack();
        frame.setVisible(true);
    }

    public static void printVersionCheckWarning() {
        System.err.println(msg);
    }

    public static void main(String[] args) {
        System.out.println("JavaVersionCheck: " + JavaVersionCheck.getVersion() + " is ok: " + JavaVersionCheck.isOK());
        JavaVersionCheck.displayVersionCheckWarning();
    }
}

