/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.models.Design;
import hades.models.flipflops.Dffr;
import hades.models.gates.GenericGate;
import hades.models.gates.Inv;
import hades.models.io.ClockGen;
import hades.models.io.Ipin;
import hades.models.io.Opin;
import hades.models.io.PowerOnReset;
import hades.models.register.LFSRAnalyzer16;
import hades.models.register.LFSRGenerator16;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class ISCAS89Converter {
    boolean debug = false;
    Design design;
    LineNumberReader reader;

    public void setDesign(Design _design) {
        this.design = _design;
    }

    public Design getDesign() {
        return this.design;
    }

    public void setReader(LineNumberReader _reader) {
        this.reader = _reader;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    /*
     * WARNING - void declaration
     */
    public void parse() throws Exception {
        String line;
        while ((line = this.reader.readLine()) != null) {
            void var1_1;
            if (var1_1.length() == 0 || var1_1.charAt(0) == '#') continue;
            if (var1_1.startsWith("INPUT")) {
                this.handleInputDeclaration((String)var1_1);
                continue;
            }
            if (var1_1.startsWith("OUTPUT")) {
                this.handleOutputDeclaration((String)var1_1);
                continue;
            }
            this.handleComponentDeclaration((String)var1_1);
        }
    }

    public void handleInputDeclaration(String line) {
        int start = line.indexOf(40);
        int end = line.indexOf(41);
        String name = line.substring(start + 1, end);
        Ipin pin = new Ipin();
        pin.setName("in_" + name);
        this.design.addComponent(pin);
        Signal signal = this.checkCreateSignal(name);
        signal.connect(pin.getPort("Y"));
        if (this.debug) {
            ISCAS89Converter.msg("#input: '" + name + "'");
        }
    }

    public void handleOutputDeclaration(String line) {
        int start = line.indexOf(40);
        int end = line.indexOf(41);
        String name = line.substring(start + 1, end);
        Opin pin = new Opin();
        pin.setName("out_" + name);
        this.design.addComponent(pin);
        Signal signal = this.checkCreateSignal(name);
        signal.connect(pin.getPort("A"));
        if (this.debug) {
            ISCAS89Converter.msg("#output: '" + name + "'");
        }
    }

    public void handleComponentDeclaration(String line) {
        StringTokenizer st = new StringTokenizer(line, " \t=(,)");
        int n_tokens = st.countTokens();
        String[] tokens = new String[n_tokens];
        int i = 0;
        while (i < n_tokens) {
            tokens[i] = st.nextToken();
            ++i;
        }
        if (this.debug) {
            this.printTokens(tokens);
        }
        if ("AND".equals(tokens[1])) {
            this.handleGate(tokens, "And");
        } else if ("NAND".equals(tokens[1])) {
            this.handleGate(tokens, "Nand");
        } else if ("NOR".equals(tokens[1])) {
            this.handleGate(tokens, "Nor");
        } else if ("OR".equals(tokens[1])) {
            this.handleGate(tokens, "Or");
        } else if ("NOT".equals(tokens[1])) {
            this.handleInverter(tokens);
        } else if ("DFF".equals(tokens[1])) {
            this.handleDFF(tokens);
        } else {
            ISCAS89Converter.msg("ERROR: unknown gate: " + tokens[1]);
        }
    }

    public void printTokens(String[] tokens) {
        StringBuffer sb = new StringBuffer();
        sb.append("#tokens: ");
        int i = 0;
        while (i < tokens.length) {
            sb.append("'");
            sb.append(tokens[i]);
            sb.append("' ");
            ++i;
        }
        ISCAS89Converter.msg(sb.toString());
    }

    public void handleInverter(String[] tokens) {
        Inv inv = new Inv();
        inv.setName("Inv" + this.reader.getLineNumber());
        this.design.addComponent(inv);
        Signal out = this.checkCreateSignal(tokens[0]);
        Signal in = this.checkCreateSignal(tokens[2]);
        out.connect(inv.getPort("Y"));
        in.connect(inv.getPort("A"));
    }

    public void handleDFF(String[] tokens) {
        Dffr dffr = new Dffr();
        dffr.setName("DFF" + this.reader.getLineNumber());
        this.design.addComponent(dffr);
        Signal Q = this.checkCreateSignal(tokens[0]);
        Signal D = this.checkCreateSignal(tokens[2]);
        Signal CLK = this.checkCreateSignal("clk");
        Signal NR = this.checkCreateSignal("nreset");
        Q.connect(dffr.getPort("Q"));
        D.connect(dffr.getPort("D"));
        CLK.connect(dffr.getPort("C"));
        NR.connect(dffr.getPort("NR"));
    }

    public void handleGate(String[] tokens, String type) {
        if (tokens.length > 6) {
            ISCAS89Converter.msg("ERROR: too many gate inputs: " + tokens.length);
        }
        try {
            int n_inputs = tokens.length - 2;
            String classname = "hades.models.gates." + type + n_inputs;
            Object tmp = Class.forName(classname).newInstance();
            GenericGate gate = (GenericGate)tmp;
            gate.setName(type + this.reader.getLineNumber());
            this.design.addComponent(gate);
            Signal Y = this.checkCreateSignal(tokens[0]);
            Y.connect(gate.getPort("Y"));
            Signal A = this.checkCreateSignal(tokens[2]);
            A.connect(gate.getPort("A"));
            Signal B = this.checkCreateSignal(tokens[3]);
            B.connect(gate.getPort("B"));
            if (n_inputs >= 3) {
                Signal C = this.checkCreateSignal(tokens[4]);
                C.connect(gate.getPort("C"));
            }
            if (n_inputs >= 4) {
                Signal D = this.checkCreateSignal(tokens[5]);
                D.connect(gate.getPort("D"));
            }
        }
        catch (Exception e) {
            ISCAS89Converter.msg("ERROR: " + e);
            ISCAS89Converter.msg("on line: " + this.reader.getLineNumber());
            this.printTokens(tokens);
        }
    }

    Signal checkCreateSignal(String name) {
        Signal signal = this.design.getSignal(name);
        if (signal == null) {
            signal = new SignalStdLogic1164();
            signal.setName(name);
            this.design.addSignal(signal);
        }
        return signal;
    }

    public void checkCreateClkResetPins() {
        Signal nreset;
        Ipin pin = null;
        Signal clk = this.design.getSignal("clk");
        if (clk != null) {
            pin = new Ipin();
            pin.setName("in_clk");
            this.design.addComponent(pin);
            clk.connect(pin.getPort("Y"));
        }
        if ((nreset = this.design.getSignal("nreset")) != null) {
            pin = new Ipin();
            pin.setName("in_nreset");
            this.design.addComponent(pin);
            nreset.connect(pin.getPort("Y"));
        }
    }

    public void writeTestbench(PrintWriter PW) {
        SignalStdLogic1164 tmp = null;
        Design tb = new Design();
        tb.setName("testbench");
        this.design.setResourceName("/hades/iscas/hugo.hds");
        this.design.setName("uut");
        tb.addComponent(this.design);
        LFSRGenerator16 generator = new LFSRGenerator16();
        generator.setName("generator");
        tb.addComponent(generator);
        LFSRAnalyzer16 analyzer = new LFSRAnalyzer16();
        analyzer.setName("analyzer");
        tb.addComponent(analyzer);
        Port[] ports = this.design.getPorts();
        int n_inputs = 0;
        int n_outputs = 0;
        int i = 0;
        while (i < ports.length) {
            if (ports[i].getType() == 6) {
                tmp = new SignalStdLogic1164();
                tmp.setName("s_" + ports[i].getName());
                tb.addSignal(tmp);
                tmp.connect(ports[i]);
                tmp.connect(generator.getPort("Q" + n_inputs));
                ++n_inputs;
            }
            if (ports[i].getType() == 1) {
                tmp = new SignalStdLogic1164();
                tmp.setName("s_" + ports[i].getName());
                tb.addSignal(tmp);
                tmp.connect(ports[i]);
                tmp.connect(analyzer.getPort("D" + n_inputs));
                ++n_outputs;
            }
            ++i;
        }
        ISCAS89Converter.msg("...testbench: found " + n_inputs + " " + n_outputs + " ports.");
        ClockGen clockGen = new ClockGen();
        clockGen.setName("tb_clk");
        tb.addComponent(clockGen);
        tmp = new SignalStdLogic1164();
        tb.addSignal(tmp);
        tmp.connect(clockGen.getPort("clk"));
        tmp.connect(generator.getPort("CLK"));
        tmp.connect(analyzer.getPort("CLK"));
        if (this.design.getSignal("clk") != null) {
            tmp.connect(this.design.getPort("in_clk"));
        }
        if (this.design.getSignal("nreset") != null) {
            PowerOnReset powerOn = new PowerOnReset();
            powerOn.setName("tb_nreset");
            tb.addComponent(powerOn);
            tmp = new SignalStdLogic1164();
            tb.addSignal(tmp);
            tmp.connect(powerOn.getPort("nreset"));
            tmp.connect(this.design.getPort("in_nreset"));
        }
        tb.write(PW);
    }

    public static String changeExtension(String filename, String extension) {
        int index = filename.lastIndexOf(46);
        if (index >= 0) {
            return filename.substring(0, index) + extension;
        }
        return filename + extension;
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void usage() {
        ISCAS89Converter.msg("Convert a circuit from ISCAS benchmark format to .hds format.");
        ISCAS89Converter.msg("Usage: java hades.utils.ISCAS89Converter <file> [debug]");
        ISCAS89Converter.msg("Example: java hades.utils.ISCAS89Converter s27.bench");
        ISCAS89Converter.msg("which generates s27.hds and s27.sym");
        System.exit(0);
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length == 0) {
            ISCAS89Converter.usage();
        }
        LineNumberReader BR = new LineNumberReader(new InputStreamReader(new FileInputStream(argv[0])));
        ISCAS89Converter converter = new ISCAS89Converter();
        if (argv.length == 2 && "debug".equals(argv[1])) {
            converter.setDebug(true);
        }
        converter.setDesign(new Design());
        converter.setReader(BR);
        ISCAS89Converter.msg("...parsing: " + argv[0]);
        converter.parse();
        converter.checkCreateClkResetPins();
        BR.close();
        String hdsName = ISCAS89Converter.changeExtension(argv[0], ".hds");
        ISCAS89Converter.msg("...writing Hades netlist to: " + hdsName);
        PrintWriter PW = new PrintWriter(new FileOutputStream(hdsName));
        converter.getDesign().write(PW);
        PW.close();
        String symName = ISCAS89Converter.changeExtension(argv[0], ".sym");
        ISCAS89Converter.msg("...writing symbol description: " + symName);
        PrintWriter PX = new PrintWriter(new FileOutputStream(symName));
        Symbol symbol = converter.getDesign().createSymbol();
        symbol.writeAsResource(PX);
        PX.close();
        String tbName = ISCAS89Converter.changeExtension(argv[0], ".tb");
        ISCAS89Converter.msg("...writing BILBO LFSR testbench: " + tbName);
        PrintWriter PY = new PrintWriter(new FileOutputStream(tbName));
        converter.writeTestbench(PY);
        PY.close();
        ISCAS89Converter.msg("...ok.");
        System.exit(0);
    }
}

