/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.manager.DesignManager;
import hades.models.Design;
import hades.models.io.ClockGenWithAutoStop;
import hades.models.register.LFSRAnalyzer;
import hades.models.register.LFSRGenerator;
import hades.simulator.SimKernel;
import hades.simulator.VhdlBatchSimKernel;

public class BatchMode {
    public static void main(String[] args) throws Exception {
        String resourcename = "./ke15/3/testbench_3_1_b.hds";
        Design design = DesignManager.getDesignManager().getDesign(null, resourcename, false);
        design.setVisible(false);
        VhdlBatchSimKernel simulator = new VhdlBatchSimKernel();
        design.setSimulator(simulator);
        simulator.setDesign(design);
        LFSRGenerator generator = null;
        LFSRAnalyzer analyzer = null;
        generator = (LFSRGenerator)design.getComponent("generator");
        analyzer = (LFSRAnalyzer)design.getComponent("analysator");
        generator.setSeed(13534451);
        analyzer.setSeed(13534451);
        ClockGenWithAutoStop clock = (ClockGenWithAutoStop)design.getComponent("clk_255");
        clock.setAutoStopCycles(1000001);
        clock.setPeriod(1.0E-6);
        clock.setDutycycle(0.5);
        clock.setOffset(0.0);
        long realStartTime = System.currentTimeMillis();
        double endSimTime = 20.0;
        simulator.runFor(endSimTime);
        System.out.println("-I- sleeping until the simulation is ready...");
        while (simulator.getSimTime() < endSimTime) {
            double simtime = simulator.getSimTime();
            long cputime = System.currentTimeMillis() - realStartTime;
            System.out.println("... sim.time= " + simtime + " cpu time= " + cputime + " msecs.");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        ((SimKernel)simulator).printStatus();
        long signature = analyzer.getValue();
        System.out.println("final signature is: " + signature);
        System.out.println("final generator value: " + generator.getValue());
        System.out.println("selftest OK.");
        System.exit(0);
    }
}

