/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.utils.AudioFileLoader;
import hades.utils.NameListener;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AudioPlayer
extends JPanel
implements ActionListener {
    AudioFileLoader loader = null;
    AudioClip audioClip = null;
    NameListener nameListener = null;
    Window parent;
    JButton playButton;
    JButton loopButton;
    JButton stopButton;
    JButton loadButton;
    JButton okButton;
    JTextField filenameTF;

    public AudioPlayer() {
        this.buildGUI();
        this.buildCallbacks();
    }

    public void setParent(Window parent) {
        this.parent = parent;
    }

    public void setNameListener(NameListener IL) {
        this.nameListener = IL;
    }

    private void buildGUI() {
        this.playButton = new JButton("Play");
        this.loopButton = new JButton("Loop");
        this.stopButton = new JButton("Stop");
        this.loadButton = new JButton("Load");
        this.okButton = new JButton("OK");
        this.filenameTF = new JTextField("/hades/welcome.wav", 30);
        JPanel northPanel = new JPanel();
        northPanel.add(this.playButton);
        northPanel.add(this.loopButton);
        northPanel.add(this.stopButton);
        JPanel southPanel = new JPanel();
        southPanel.add(this.loadButton);
        southPanel.add(this.okButton);
        this.setLayout(new BorderLayout());
        this.add("North", northPanel);
        this.add("South", southPanel);
        this.add("Center", this.filenameTF);
    }

    private void buildCallbacks() {
        this.playButton.addActionListener(this);
        this.loopButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.loadButton.addActionListener(this);
        this.okButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.playButton) {
            this.play();
        } else if (source == this.loopButton) {
            this.loop();
        } else if (source == this.stopButton) {
            this.stop();
        } else if (source == this.loadButton) {
            this.loadSelectedFile();
        } else if (source == this.okButton) {
            if (this.parent != null) {
                this.parent.setVisible(false);
            } else {
                System.err.println("-E- AudioPlayer unknown event: " + e);
            }
        }
    }

    public void loadSelectedFile() {
        String filename = this.filenameTF.getText().trim();
        this.load(filename);
        if (this.nameListener != null) {
            this.nameListener.nameChanged(filename);
        }
    }

    public void load(String audioResourceName) {
        this.stop();
        this.filenameTF.setText(audioResourceName);
        this.loader = new AudioFileLoader(audioResourceName);
        this.audioClip = this.loader.getAudioClip();
    }

    public void play() {
        this.checkGetAudioClip();
        if (this.audioClip != null) {
            this.audioClip.play();
        }
    }

    public void stop() {
        if (this.audioClip != null) {
            this.audioClip.stop();
        }
        this.checkGetAudioClip();
        if (this.audioClip != null) {
            this.audioClip.stop();
        }
    }

    public void loop() {
        this.checkGetAudioClip();
        if (this.audioClip != null) {
            this.audioClip.loop();
        }
    }

    private void checkGetAudioClip() {
        if (this.loader != null) {
            this.audioClip = this.loader.getAudioClip();
        }
    }

    public static void main(String[] argv) {
        AudioPlayer player = new AudioPlayer();
        player.load(argv[0]);
        JFrame frame = new JFrame("AudioPlayer selftest");
        player.setParent(frame);
        frame.getContentPane().add("Center", player);
        frame.pack();
        frame.setVisible(true);
    }
}

