/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import hades.signals.Signal;
import hades.symbols.ColorSource;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigEllipse;

public class SolderDot
extends FigEllipse
implements Serializable {
    private Point position;
    private Signal signal = null;
    private ColorSource colorSource;

    public SolderDot() {
        super(new Point(0, 0), new Point(0, 0), new FigAttribs(), new FigTrafo2D());
        this.build_attribs();
    }

    public SolderDot(Signal signal, Point position) {
        this();
        this.signal = signal;
        this.setColorSource(signal);
        this.position = new Point(position);
        super.setCenterAndRadius(this.position, new Point(100, 100));
    }

    public Signal getSignal() {
        return this.signal;
    }

    public boolean initialize(String s) {
        int x = 0;
        int y = 0;
        try {
            StringTokenizer st = new StringTokenizer(s);
            x = Integer.parseInt(st.nextToken());
            y = Integer.parseInt(st.nextToken());
            Point center = new Point(x, y);
            Point radius = new Point(100, 100);
            super.setCenterAndRadius(center, radius);
        }
        catch (Exception e) {
            System.err.println("" + e);
        }
        return true;
    }

    protected void build_attribs() {
        FigAttribs attribs = new FigAttribs();
        attribs.lineColor = attribs.fillColor = ColorCache.getColorCache().get(1);
        attribs.fig_fill_color = 1;
        attribs.fig_line_color = 1;
        attribs.fillStyle = 2;
        attribs.currentLayer = 15;
        attribs.lineWidth = 30.0;
        attribs.arrowMode = 0;
        attribs.lineStyle = 0;
        attribs.cornerRadius = 0;
        super.setAttributes(attribs);
    }

    public void writeAsResource(PrintWriter ps) {
        Point p1 = this.getCenterPoint();
        String s = this.getClass().getName() + " " + p1.x + " " + p1.y + " ";
        ps.println(s);
    }

    public void move(int dx, int dy) {
        this.position.x += dx;
        this.position.y += dy;
        super.move(dx, dy);
    }

    public void setColorSource(ColorSource _colorSource) {
        this.colorSource = _colorSource;
    }

    public void paint(Graphics g) {
        if (this.colorSource != null) {
            Color c = this.colorSource.getColor();
            if (this.attribs.lineColor != c) {
                this.attribs.setLineColor(c);
            }
            if (this.attribs.fillColor != c) {
                this.attribs.setFillColor(c);
            }
        }
        super.paint(g);
    }

    public void paint(Graphics g, FigTrafo2D trafo) {
        Color c;
        if (this.colorSource != null && this.attribs.fillColor != (c = this.colorSource.getColor())) {
            this.attribs.setFillColor(c);
            this.attribs.setLineColor(c);
            this.rebuild();
        }
        super.paint(g, trafo);
    }

    public String toString() {
        return "SolderDot[" + this.getCenterPoint() + "]";
    }
}

