/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import java.awt.Color;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigRectangle;

public class PortSymbol
extends FigRectangle
implements Serializable {
    protected static int size = 50;
    protected String name = "";
    protected Point pos = new Point(0, 0);

    public PortSymbol() {
        this(size);
    }

    public PortSymbol(int size) {
        super(-size, -size, size, size, 10);
        this.build_attribs();
    }

    public boolean initialize(String s) {
        int x = 0;
        int y = 0;
        try {
            StringTokenizer st = new StringTokenizer(s);
            x = Integer.parseInt(st.nextToken());
            y = Integer.parseInt(st.nextToken());
            this.name = st.nextToken();
        }
        catch (Exception e) {
            System.err.println("" + e);
        }
        this.pos = new Point(0, 0);
        this.move(x, y);
        return true;
    }

    public int getSize() {
        return size;
    }

    public void setSize(int _size) {
        size = _size;
    }

    public void move(int dx, int dy) {
        this.pos.x += dx;
        this.pos.y += dy;
        super.move(dx, dy);
    }

    public void mirrorX(int mirror_x, int mirror_y) {
        super.mirrorX(mirror_x, mirror_y);
        this.x = this.pos.x = 2 * mirror_x - this.pos.x;
        this.y = this.pos.y;
    }

    public void mirrorY(int mirror_x, int mirror_y) {
        super.mirrorY(mirror_x, mirror_y);
        this.pos.y = 2 * mirror_y - this.pos.y;
        this.x = this.pos.x;
        this.y = this.pos.y;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void writeAsResource(PrintWriter ps) {
        Point[] wcp = this.getPoints();
        int x = (wcp[0].x + wcp[1].x) / 2;
        int y = (wcp[0].y + wcp[1].y) / 2;
        String s = this.getClass().getName() + " " + x + " " + y + " " + this.getName();
        ps.println(s);
    }

    protected void build_attribs() {
        FigAttribs attribs = new FigAttribs();
        attribs.lineColor = attribs.fillColor = Color.red;
        attribs.fillStyle = 2;
        attribs.currentLayer = 10;
        attribs.cornerRadius = 0;
        attribs.fig_fill_color = 4;
        attribs.fig_line_color = 4;
        super.setAttributes(attribs);
    }

    public Point getPosition() {
        return new Point(this.pos);
    }

    public FigObject copy() {
        PortSymbol carbon = new PortSymbol();
        Point p = this.getPosition();
        carbon.move(p.x, p.y);
        carbon.name = new String(this.getName());
        carbon.setAttributes(this.getAttributes().getClone());
        return carbon;
    }

    public String toString() {
        return "PortSymbol[" + super.toString() + "]";
    }
}

