/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import hades.symbols.ColorSource;
import hades.symbols.TextSource;
import hades.utils.NameMangler;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigText;

public class Label
extends FigText
implements Serializable {
    protected TextSource textSource;
    protected ColorSource colorSource;

    public Label() {
        this.build_attribs();
    }

    public boolean initialize(String s) {
        String label;
        int y;
        int x;
        block5: {
            x = 0;
            y = 0;
            label = null;
            try {
                StringTokenizer st = new StringTokenizer(s);
                int n_tokens = st.countTokens();
                if (n_tokens == 7) {
                    x = Integer.parseInt(st.nextToken());
                    y = Integer.parseInt(st.nextToken());
                    int align = Integer.parseInt(st.nextToken());
                    int font = Integer.parseInt(st.nextToken());
                    int size = Integer.parseInt(st.nextToken());
                    int color = Integer.parseInt(st.nextToken());
                    label = st.nextToken();
                    FigAttribs attr = this.getAttributes();
                    attr.textAlign = align;
                    attr.fig_font = font;
                    attr.fontSize = size;
                    attr.setLineColor(new Color(color));
                    this.setAttributes(attr);
                    break block5;
                }
                if (n_tokens == 4) {
                    x = Integer.parseInt(st.nextToken());
                    y = Integer.parseInt(st.nextToken());
                    int align = Integer.parseInt(st.nextToken());
                    FigAttribs attr = this.getAttributes();
                    attr.textAlign = align;
                    this.setAttributes(attr);
                    label = st.nextToken();
                    break block5;
                }
                if (n_tokens == 3) {
                    x = Integer.parseInt(st.nextToken());
                    y = Integer.parseInt(st.nextToken());
                    label = st.nextToken();
                    break block5;
                }
                throw new Exception("too few arguments to Label.initialize: " + s);
            }
            catch (Exception e) {
                System.err.println("" + e);
            }
        }
        super.setText(NameMangler.decodeUnicodeEscapes(label));
        this.move(x, y);
        return true;
    }

    protected void build_attribs() {
        FigAttribs attribs = new FigAttribs();
        attribs.lineColor = attribs.fillColor = Color.black;
        attribs.fillStyle = 1;
        attribs.currentLayer = 10;
        attribs.fontSize = 10;
        attribs.fig_font = 16;
        this.setAttributes(attribs);
    }

    public void writeAsResource(PrintWriter ps) {
        Point[] wcp = this.getPoints();
        int x = wcp[0].x;
        int y = wcp[0].y;
        String s = this.getClass().getName() + " " + x + " " + y + " ";
        int align = this.getAttributes().textAlign;
        if (align != 1) {
            s = s + align + " ";
        }
        s = s + NameMangler.encodeWithUnicodeEscapes(this.getText());
        ps.println(s);
    }

    public FigObject copy() {
        Label carbon = new Label();
        carbon.setAttributes(this.getAttributes().getClone());
        carbon.setText(this.getText());
        Point[] pp = this.getPoints();
        carbon.move(pp[0].x, pp[0].y);
        return carbon;
    }

    public void mirrorY(int mirror_x, int mirror_y) {
        int new_y = 2 * mirror_y - this.y;
        this.move(0, new_y - this.y);
    }

    public void setTextSource(TextSource _textSource) {
        this.textSource = _textSource;
    }

    public void setColorSource(ColorSource _colorSource) {
        this.colorSource = _colorSource;
    }

    public void paint(Graphics g) {
        Color c;
        if (this.textSource != null && !this.getText().equals(this.textSource.getText())) {
            this.setText(this.textSource.getText());
        }
        if (this.colorSource != null && this.attribs.lineColor != (c = this.colorSource.getColor())) {
            this.attribs.setLineColor(c);
        }
        super.paint(g);
    }

    public String toString() {
        return "Label[" + super.toString() + "]";
    }
}

