/*
 * Decompiled with CFR 0.152.
 */
package hades.styx;

import hades.gui.Editor;
import hades.gui.JImageButton;
import hades.manager.DesignManager;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.string.StringSignal;
import hades.signals.Signal;
import hades.signals.SignalDouble;
import hades.signals.SignalInteger;
import hades.signals.SignalStdLogic1164;
import hades.signals.SignalStdLogicVector;
import hades.styx.NameCanvas;
import hades.styx.TimePanel;
import hades.styx.Transformation;
import hades.styx.WaveCanvas;
import hades.styx.WaveDouble;
import hades.styx.WaveInteger;
import hades.styx.WaveStdLogic1164;
import hades.styx.WaveStdLogicVector;
import hades.styx.WaveString;
import hades.styx.Waveform;
import hades.styx.Xscroller;
import hades.styx.Yscroller;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import jfig.gui.ImageHelper;
import jfig.gui.JStatusCanvas;
import jfig.gui.JTextViewer;
import jfig.gui.StatusMessage;
import jfig.utils.ExceptionTracer;
import jfig.utils.PPMWriter;
import jfig.utils.SetupManager;

public class WaveformViewer
extends JFrame
implements AdjustmentListener,
ComponentListener,
ActionListener,
KeyListener {
    public static final String versionString = "HADES Waveform Viewer 0.31";
    public static final double INITIAL_END_TIME = 1.0E-8;
    boolean debug = false;
    JPanel wavePanel;
    JPanel controlPanel;
    JPanel buttonPanel;
    JLabel timeLabel;
    JLabel scaleLabel;
    JLabel valueLabel;
    Transformation trafo;
    TimePanel timePanel;
    WaveCanvas waveCanvas;
    NameCanvas nameCanvas;
    Xscroller xscroller;
    Yscroller yscroller;
    JStatusCanvas statusCanvas;
    JMenu fileMenu;
    JMenu editMenu;
    JMenu searchMenu;
    JMenu optionsMenu;
    JMenu helpMenu;
    JMenu formatMenu;
    JMenuItem openMI;
    JMenuItem saveAsMI;
    JMenuItem savePPMMI;
    JMenuItem closeMI;
    JMenuItem exitMI;
    JMenuItem updateWavesMI;
    JMenuItem clearWavesMI;
    JMenuItem deleteWaveMI;
    JMenuItem deleteAllWavesMI;
    JMenuItem addSpacerMI;
    JMenuItem searchNextMI;
    JMenuItem searchPrevMI;
    JMenuItem searchSetValueMI;
    JMenuItem searchNextValueMI;
    JMenuItem searchPrevValueMI;
    JMenuItem searchSetBaseMI;
    JMenuItem searchShowMarkerMI;
    JMenuItem searchHideMarkerMI;
    JMenuItem binaryFormatMI;
    JMenuItem decimalFormatMI;
    JMenuItem hexFormatMI;
    JMenuItem aboutMI;
    JMenuItem keysMI;
    JMenuItem helpSearchingMI;
    JImageButton swapButton;
    JImageButton moveUpButton;
    JImageButton moveDownButton;
    JImageButton zoom400Button;
    JImageButton zoom200Button;
    JImageButton zoomFitButton;
    JImageButton zoomAreaButton;
    JImageButton zoom050Button;
    JImageButton zoom025Button;
    JImageButton zoomEndButton;
    StatusMessage helper;
    Editor editor;
    public int x;
    public int n;
    public double tleft;
    public double tright;
    public double tend;
    public double tstart;
    public double deltat;
    public double tges;
    double searchTime = 0.0;
    String searchPattern = "";

    public WaveformViewer() {
        this.setTitle(versionString);
        this.buildMenus();
        this.buildMenuCallbacks();
        this.buildStatusLabels();
        this.buildButtonPanel();
        this.buildControlPanel();
        this.buildWavePanel();
        this.addComponentListener(this);
        this.addComponentListener(this.waveCanvas);
        this.addKeyListener(this);
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.wavePanel);
        this.getContentPane().add("South", this.controlPanel);
        this.pack();
        this.setSize(SetupManager.getInteger("Hades.WaveformViewer.DefaultWidth", 700), SetupManager.getInteger("Hades.WaveformViewer.DefaultHeight", 500));
        this.setVisible(true);
    }

    public Waveform addSignal(Signal signal) {
        Waveform waveform;
        if (signal instanceof SignalStdLogic1164) {
            waveform = new WaveStdLogic1164();
        } else if (signal instanceof SignalStdLogicVector) {
            waveform = new WaveStdLogicVector();
        } else if (signal instanceof StringSignal) {
            waveform = new WaveString();
        } else if (signal instanceof SignalInteger) {
            waveform = new WaveInteger();
        } else if (signal instanceof SignalDouble) {
            waveform = new WaveDouble();
        } else {
            this.msg("-E- Signal type not supported: " + signal);
            return null;
        }
        waveform.setTrafo(this.trafo);
        waveform.setName(signal.getName());
        waveform.setFullName(signal.getFullName());
        waveform.setPos(0);
        this.waveCanvas.addWave(waveform);
        this.yscroller.repaint();
        this.redraw();
        this.timePanel.repaint();
        return waveform;
    }

    public void delWaveform(Waveform waveform) {
        this.waveCanvas.delWaveform(waveform);
        this.nameCanvas.clear();
        this.redraw();
    }

    public void deleteAllWaveforms() {
        this.waveCanvas.deleteAllWaveforms();
        this.nameCanvas.clear();
        this.redraw();
    }

    public void setEditor(Editor editor) {
        this.editor = editor;
    }

    public void clearWaveData() {
        this.waveCanvas.clearWaveData();
        this.updateTrafo();
        this.waveCanvas.repaint();
        this.nameCanvas.repaint();
        this.repaint();
    }

    public WaveCanvas getWaveCanvas() {
        return this.waveCanvas;
    }

    public Transformation getTrafo() {
        return this.trafo;
    }

    public void updateTrafo() {
        double d = this.waveCanvas.getMaxWaveTime();
        if (d <= 0.0) {
            this.trafo.setTStart(0.0);
            this.trafo.setTEnd(1.0E-8);
        } else {
            this.trafo.setTStart(0.0);
            this.trafo.setTEnd(d * 1.1);
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.timePanel.repaint();
        this.redraw();
    }

    public void msg(String string) {
        System.out.println(string);
    }

    public void buildWavePanel() {
        this.trafo = new Transformation(600.0, 400.0, 0.0, 200.0);
        this.timePanel = new TimePanel(this.trafo);
        this.waveCanvas = new WaveCanvas(this, this.trafo, this.valueLabel, this.timeLabel);
        this.nameCanvas = new NameCanvas(this.waveCanvas, this.trafo);
        this.xscroller = new Xscroller(this.trafo);
        this.yscroller = new Yscroller(this.trafo, this.waveCanvas);
        this.wavePanel = new WavePanel();
        this.wavePanel.add(this.nameCanvas);
        this.wavePanel.add(this.waveCanvas);
        this.wavePanel.add(this.timePanel);
        this.wavePanel.add(this.xscroller);
        this.wavePanel.add(this.yscroller);
        this.waveCanvas.addKeyListener(this);
        this.nameCanvas.addKeyListener(this);
        this.xscroller.addAdjustmentListener(this);
        this.yscroller.addAdjustmentListener(this);
        ShowSignalNameListener showSignalNameListener = new ShowSignalNameListener();
        this.nameCanvas.addMouseMotionListener(showSignalNameListener);
        this.waveCanvas.addMouseMotionListener(showSignalNameListener);
    }

    public void buildMenus() {
        this.fileMenu = new JMenu("File");
        this.openMI = new JMenuItem("Open...");
        this.saveAsMI = new JMenuItem("Save as...");
        this.savePPMMI = new JMenuItem("Save as PPM...");
        this.closeMI = new JMenuItem("Close");
        this.exitMI = new JMenuItem("Exit");
        this.exitMI.setEnabled(false);
        this.fileMenu.add(this.openMI);
        this.fileMenu.add(this.saveAsMI);
        this.fileMenu.add(this.savePPMMI);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.closeMI);
        this.fileMenu.add(this.exitMI);
        this.editMenu = new JMenu("Edit");
        this.updateWavesMI = new JMenuItem("Update Waves");
        this.updateWavesMI.setAccelerator(KeyStroke.getKeyStroke("F5"));
        this.clearWavesMI = new JMenuItem("Clear Waves");
        this.deleteWaveMI = new JMenuItem("Delete Waveform");
        this.deleteWaveMI.setEnabled(false);
        this.deleteAllWavesMI = new JMenuItem("Delete All Waveforms");
        this.addSpacerMI = new JMenuItem("Insert Spacer");
        this.addSpacerMI.setEnabled(false);
        this.editMenu.add(this.updateWavesMI);
        this.editMenu.addSeparator();
        this.editMenu.add(this.clearWavesMI);
        this.editMenu.addSeparator();
        this.editMenu.add(this.deleteWaveMI);
        this.editMenu.add(this.deleteAllWavesMI);
        this.editMenu.add(this.addSpacerMI);
        this.searchMenu = new JMenu("Search");
        this.searchNextMI = new JMenuItem("Search next event");
        this.searchPrevMI = new JMenuItem("Search previous event");
        this.searchNextValueMI = new JMenuItem("Search next matching value");
        this.searchPrevValueMI = new JMenuItem("Search previous matching value");
        this.searchSetValueMI = new JMenuItem("Set search pattern/value");
        this.searchSetBaseMI = new JMenuItem("Set search base time");
        this.searchShowMarkerMI = new JMenuItem("Show search marker");
        this.searchHideMarkerMI = new JMenuItem("Hide search marker");
        this.searchMenu.add(this.searchNextMI);
        this.searchMenu.add(this.searchPrevMI);
        this.searchMenu.addSeparator();
        this.searchMenu.add(this.searchSetBaseMI);
        this.searchMenu.add(this.searchSetValueMI);
        this.searchMenu.add(this.searchNextValueMI);
        this.searchMenu.add(this.searchPrevValueMI);
        this.searchMenu.addSeparator();
        this.searchMenu.add(this.searchShowMarkerMI);
        this.searchMenu.add(this.searchHideMarkerMI);
        this.optionsMenu = new JMenu("Options");
        this.formatMenu = new JMenu("Number format");
        this.binaryFormatMI = new JMenuItem("BIN");
        this.decimalFormatMI = new JMenuItem("DEC");
        this.hexFormatMI = new JMenuItem("HEX");
        this.formatMenu.add(this.binaryFormatMI);
        this.formatMenu.add(this.decimalFormatMI);
        this.formatMenu.add(this.hexFormatMI);
        this.optionsMenu.add(this.formatMenu);
        this.helpMenu = new JMenu("Help");
        this.aboutMI = new JMenuItem("About");
        this.keysMI = new JMenuItem("Keys");
        this.helpSearchingMI = new JMenuItem("Searching");
        this.helpMenu.add(this.aboutMI);
        this.helpMenu.addSeparator();
        this.helpMenu.add(this.keysMI);
        this.helpMenu.add(this.helpSearchingMI);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.fileMenu);
        jMenuBar.add(this.editMenu);
        jMenuBar.add(this.searchMenu);
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(this.helpMenu);
        this.setJMenuBar(jMenuBar);
    }

    void buildMenuCallbacks() {
        this.openMI.addActionListener(this);
        this.saveAsMI.addActionListener(this);
        this.savePPMMI.addActionListener(this);
        this.closeMI.addActionListener(this);
        this.exitMI.addActionListener(this);
        this.updateWavesMI.addActionListener(this);
        this.clearWavesMI.addActionListener(this);
        this.deleteWaveMI.addActionListener(this);
        this.deleteAllWavesMI.addActionListener(this);
        this.addSpacerMI.addActionListener(this);
        this.aboutMI.addActionListener(this);
        this.keysMI.addActionListener(this);
        this.helpSearchingMI.addActionListener(this);
        this.searchNextMI.addActionListener(this);
        this.searchPrevMI.addActionListener(this);
        this.searchNextValueMI.addActionListener(this);
        this.searchPrevValueMI.addActionListener(this);
        this.searchSetValueMI.addActionListener(this);
        this.searchSetBaseMI.addActionListener(this);
        this.searchShowMarkerMI.addActionListener(this);
        this.searchHideMarkerMI.addActionListener(this);
        this.hexFormatMI.addActionListener(this);
        this.decimalFormatMI.addActionListener(this);
        this.binaryFormatMI.addActionListener(this);
    }

    public void setStatusMessage(StatusMessage statusMessage) {
        this.helper = statusMessage;
        this.zoom400Button.setStatusMessage(statusMessage);
        this.zoom200Button.setStatusMessage(statusMessage);
        this.zoom050Button.setStatusMessage(statusMessage);
        this.zoom025Button.setStatusMessage(statusMessage);
        this.zoomFitButton.setStatusMessage(statusMessage);
        this.zoomEndButton.setStatusMessage(statusMessage);
        this.zoomAreaButton.setStatusMessage(statusMessage);
        this.moveDownButton.setStatusMessage(statusMessage);
        this.moveUpButton.setStatusMessage(statusMessage);
        this.swapButton.setStatusMessage(statusMessage);
    }

    private void buildStatusLabels() {
        this.timeLabel = new JLabel("Time 0.000,000,000,000 hugo");
        this.valueLabel = new JLabel("Value: 0-000-000-000-000-000");
        this.scaleLabel = new JLabel();
    }

    private void buildControlPanel() {
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BorderLayout());
        this.statusCanvas = new JStatusCanvas("hugo");
        this.controlPanel.add("North", this.buttonPanel);
        this.controlPanel.add("South", this.statusCanvas);
        this.setStatusMessage(this.statusCanvas);
    }

    private void buildButtonPanel() {
        int n = 6;
        int n2 = 3;
        int n3 = 20;
        Image[][] imageArray = new Image[n2][n];
        Image[][] imageArray2 = new Image[n2][n];
        Image image = null;
        try {
            image = ImageHelper.loadResourceImage("/hades/gui/images/wavebuttons.gif");
            int n4 = 0;
            while (n4 < n) {
                int n5 = 0;
                while (n5 < n2) {
                    imageArray[n5][n4] = ImageHelper.createImage(n3, n3);
                    Graphics graphics = imageArray[n5][n4].getGraphics();
                    graphics.translate(-n3 * n4, -n3 * n5);
                    graphics.drawImage(image, 0, 0, this);
                    imageArray2[n5][n4] = ImageHelper.createImage(n3, n3);
                    graphics = imageArray2[n5][n4].getGraphics();
                    graphics.translate(-n3 * n4, -n3 * n5);
                    graphics.drawImage(image, 0, 0, this);
                    ++n5;
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.zoom400Button = new JImageButton("Zoom 400%", this.helper, "zoom in to 400%", imageArray2[1][1], imageArray[1][1]);
        this.zoom200Button = new JImageButton("Zoom 200%", this.helper, "zoom in to 200%", imageArray2[1][2], imageArray[1][2]);
        this.zoom050Button = new JImageButton("Zoom 50%", this.helper, "zoom out to 50%", imageArray2[0][2], imageArray[0][2]);
        this.zoom025Button = new JImageButton("Zoom 25%", this.helper, "zoom out to 25%", imageArray2[0][1], imageArray[0][1]);
        this.zoomFitButton = new JImageButton("Zoom Fit", this.helper, "zoom fit (reload)", imageArray2[1][0], imageArray[1][0]);
        this.zoomEndButton = new JImageButton("Zoom Selection", this.helper, "zoom to end", imageArray2[1][4], imageArray[1][4]);
        this.zoomAreaButton = new JImageButton("Zoom Selection", this.helper, "zoom into selected area", imageArray2[1][4], imageArray[1][4]);
        this.moveDownButton = new JImageButton("Move Down", this.helper, "move selected signal down", imageArray2[2][3], imageArray[2][3]);
        this.moveUpButton = new JImageButton("Move Up", this.helper, "move selected signal up", imageArray2[2][4], imageArray[2][4]);
        this.swapButton = new JImageButton("Swap Signals", this.helper, "swap selected signals", imageArray2[2][5], imageArray[2][5]);
        this.zoom400Button.setActive(true);
        this.zoom200Button.setActive(true);
        this.zoom050Button.setActive(true);
        this.zoom025Button.setActive(true);
        this.zoomFitButton.setActive(true);
        this.zoomAreaButton.setActive(true);
        this.moveDownButton.setActive(true);
        this.moveUpButton.setActive(true);
        this.swapButton.setActive(true);
        this.zoom400Button.addActionListener(this);
        this.zoom200Button.addActionListener(this);
        this.zoom050Button.addActionListener(this);
        this.zoom025Button.addActionListener(this);
        this.zoomFitButton.addActionListener(this);
        this.zoomAreaButton.addActionListener(this);
        this.moveDownButton.addActionListener(this);
        this.moveUpButton.addActionListener(this);
        this.swapButton.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(0, 2, 2));
        this.buttonPanel.add(this.swapButton);
        this.buttonPanel.add(this.moveDownButton);
        this.buttonPanel.add(this.moveUpButton);
        this.buttonPanel.add(new JLabel(" "));
        this.buttonPanel.add(this.zoomFitButton);
        this.buttonPanel.add(new JLabel(" "));
        this.buttonPanel.add(this.zoom025Button);
        this.buttonPanel.add(this.zoom050Button);
        this.buttonPanel.add(this.zoom200Button);
        this.buttonPanel.add(this.zoom400Button);
        this.buttonPanel.add(this.zoomAreaButton);
        this.buttonPanel.add(new JLabel(" "));
        this.buttonPanel.add(this.timeLabel);
        this.buttonPanel.add(new JLabel(" "));
        this.buttonPanel.add(this.valueLabel);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.xscroller) {
            double d = this.trafo.getTLeft();
            double d2 = this.trafo.getTRight();
            double d3 = this.trafo.getTStart();
            double d4 = this.trafo.getTEnd();
            double d5 = d2 - d;
            double d6 = d5 / 10.0;
            if (adjustmentEvent.getAdjustmentType() == 4) {
                this.trafo.deltaZoom(d + d5, d2 + d5);
            } else if (adjustmentEvent.getAdjustmentType() == 3) {
                this.trafo.deltaZoom(d - d5, d2 - d5);
            } else if (adjustmentEvent.getAdjustmentType() == 1) {
                this.trafo.deltaZoom(d + d6, d2 + d6);
            } else if (adjustmentEvent.getAdjustmentType() == 2) {
                this.trafo.deltaZoom(d - d6, d2 - d6);
            } else if (adjustmentEvent.getAdjustmentType() == 5) {
                double d7 = this.xscroller.dragThumb();
                double d8 = d7 + d2 - d;
                if (d8 > this.trafo.tEnd) {
                    d8 = this.trafo.tEnd;
                }
                this.trafo.deltaZoom(d7, d8);
            }
        } else if (adjustmentEvent.getSource() == this.yscroller) {
            this.trafo.setYPos(this.yscroller.getValue());
        }
        this.redraw();
        this.timePanel.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        if (keyEvent.isActionKey()) {
            if (n == 116) {
                this.doUpdateWavesAndRedraw();
            } else if (n == 39) {
                double d = this.trafo.getTLeft();
                double d2 = this.trafo.getTRight();
                double d3 = (d2 - d) / 10.0;
                this.trafo.deltaZoom(d + d3, d2 + d3);
                this.xscroller.setThumb();
            } else if (n == 37) {
                double d = this.trafo.getTLeft();
                double d4 = this.trafo.getTRight();
                double d5 = (d4 - d) / 10.0;
                this.trafo.deltaZoom(d - d5, d4 - d5);
                this.xscroller.setThumb();
            } else if (n == 36) {
                if (this.debug) {
                    System.out.println("-#- VK_HOME: zoom fit...");
                }
                this.doZoomHome();
            } else if (n == 35) {
                if (this.debug) {
                    System.out.println("-#- VK_END: zoom end...");
                }
                this.doZoomEnd();
            } else if (n == 38) {
                if (this.trafo.getYPos() > 0.0) {
                    this.trafo.setYPos(this.trafo.getYPos() - 1.0);
                    this.yscroller.setValue((int)this.trafo.getYPos());
                    this.redraw();
                    this.timePanel.repaint();
                }
            } else if (n == 40) {
                this.trafo.setYPos(this.trafo.getYPos() + 1.0);
                this.yscroller.setValue((int)this.trafo.getYPos());
                this.redraw();
                this.timePanel.repaint();
            }
        } else {
            switch (c) {
                case '0': {
                    this.doSearchValue("0");
                    break;
                }
                case '1': {
                    this.doSearchValue("1");
                    break;
                }
                case 'A': {
                    this.doZoomAuto();
                    break;
                }
                case 'f': {
                    this.doZoomFit();
                    break;
                }
                case 'l': {
                    this.doSearchValue("L");
                    break;
                }
                case 'h': {
                    this.doSearchValue("H");
                    break;
                }
                case 'n': {
                    this.doSearchNextEvent();
                    break;
                }
                case 'N': {
                    this.doSearchNextEventAllWaveforms();
                    break;
                }
                case 'p': {
                    this.doSearchPreviousEvent();
                    break;
                }
                case 'P': {
                    this.doSearchPreviousEventAllWaveforms();
                    break;
                }
                case 'Q': {
                    if (this.exitMI.isEnabled()) {
                        System.exit(0);
                        break;
                    }
                    this.setVisible(false);
                    break;
                }
                case 'r': {
                    this.doUpdateWavesAndRedraw();
                    break;
                }
                case 's': {
                    this.doZoomSelection();
                    break;
                }
                case 'S': {
                    this.doSetSearchTimeFromMousePosition();
                    break;
                }
                case 'R': {
                    this.doHideSearchMarker();
                    break;
                }
                case 'u': {
                    this.doSearchValue("U");
                    break;
                }
                case 'v': {
                    if (this.searchPattern == null) {
                        this.doShowSearchValueDialog();
                    }
                    this.doSearchValue(this.searchPattern);
                    break;
                }
                case 'V': {
                    this.doShowSearchValueDialog();
                    break;
                }
                case 'w': {
                    this.doSearchValue("W");
                    break;
                }
                case 'x': {
                    this.doSearchValue("X");
                    break;
                }
                case 'y': {
                    this.doZoomOut();
                    break;
                }
                case 'Y': {
                    this.doZoomIn();
                    break;
                }
                case 'z': {
                    this.doSearchValue("Z");
                    break;
                }
                default: {
                    if (!this.debug) break;
                    System.err.println("-#- Unknown key event: " + keyEvent);
                }
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (string.equals("Close")) {
            this.setVisible(false);
        } else if (string.equals("Exit")) {
            System.exit(0);
        } else if (string.equals("About")) {
            this.about();
        } else if (string.equals("Keys")) {
            this.doShowHelpOnKeys();
        } else if (string.equals("Searching")) {
            this.doShowHelpOnSearching();
        } else if (string.equals("Update Waves")) {
            this.doUpdateWavesAndRedraw();
        } else if (string.equals("Clear Waves")) {
            this.clearWaveData();
            this.repaint();
        } else if (object.equals(this.searchNextMI)) {
            this.doSearchNextEventAllWaveforms();
        } else if (object.equals(this.searchPrevMI)) {
            this.doSearchPreviousEventAllWaveforms();
        } else if (object.equals(this.searchSetBaseMI)) {
            this.doShowSearchBaseTimeDialog();
        } else if (object.equals(this.searchSetValueMI)) {
            this.doShowSearchValueDialog();
        } else if (object.equals(this.searchShowMarkerMI)) {
            this.doShowSearchMarker();
        } else if (object.equals(this.searchHideMarkerMI)) {
            this.doHideSearchMarker();
        } else if (string.equals("BIN")) {
            this.trafo.setNumberformat(1);
            this.waveCanvas.repaint();
        } else if (string.equals("DEC")) {
            this.trafo.setNumberformat(2);
            this.waveCanvas.repaint();
        } else if (string.equals("HEX")) {
            this.trafo.setNumberformat(3);
            this.waveCanvas.repaint();
        } else if (string.equals("Zoom Selection")) {
            this.doZoomSelection();
        } else if (string.equals("Zoom 200%")) {
            this.doZoomIn();
        } else if (string.equals("Zoom 400%")) {
            this.updateTrafo();
            this.waveCanvas.zoom400();
            this.xscroller.setThumb();
            this.timePanel.repaint();
            this.redraw();
        } else if (string.equals("Zoom 50%")) {
            this.doZoomOut();
        } else if (string.equals("Zoom 25%")) {
            this.updateTrafo();
            this.waveCanvas.zoom25();
            this.xscroller.setThumb();
            this.timePanel.repaint();
            this.redraw();
        } else if (string.equals("Zoom Fit")) {
            this.doUpdateWavesAndRedraw();
        } else if (string.equals("Swap Signals")) {
            int n = this.nameCanvas.swap();
            if (n == 1) {
                this.msg("nothing selected");
            }
            if (n == 2) {
                this.msg("two Signals have to be selected");
            }
            this.redraw();
        } else if (string.equals("Move Up")) {
            int n = this.nameCanvas.moveup();
            if (n == 1) {
                this.msg("nothing selected");
            }
            if (n == 2) {
                this.msg("out of range");
            }
            this.redraw();
        } else if (string.equals("Move Down")) {
            int n = this.nameCanvas.movedown();
            if (n == 1) {
                this.msg("nothing selected");
            }
            if (n == 2) {
                this.msg("out of range");
            }
            this.redraw();
        } else if (string.equals("middle")) {
            boolean bl = this.waveCanvas.getshowFind();
            if (bl) {
                this.waveCanvas.showFind(false);
            } else {
                this.waveCanvas.showFind(true);
            }
            this.redraw();
        } else if (object == this.openMI) {
            this.deleteAllWaveforms();
            this.doReadData();
            this.redraw();
        } else if (object == this.saveAsMI) {
            this.doDumpData();
        } else if (object == this.savePPMMI) {
            this.doExportPPM();
        } else if (object == this.deleteAllWavesMI) {
            this.deleteAllWaveforms();
        } else {
            this.msg("-SW: Unknown action command: " + string);
        }
    }

    public void update() {
        this.nameCanvas.repaint();
        this.timePanel.repaint();
        this.waveCanvas.repaint();
        this.xscroller.setThumb();
        this.xscroller.setVisible(true);
        this.repaint();
    }

    public void redraw() {
        this.repaint();
        this.nameCanvas.repaint();
        this.waveCanvas.repaint();
        this.timePanel.repaint();
    }

    public void about() {
        System.out.println(versionString);
        JOptionPane.showMessageDialog(this, "Styx - the Hades waveform viewer\n\n(C) 1998-2006 by\nNorman Hendrich and Marcus Carl\n", "About Styx", 1);
    }

    public void doUpdateWavesAndRedraw() {
        this.updateTrafo();
        this.waveCanvas.zoomFit();
        this.xscroller.setThumb();
        this.redraw();
    }

    public void doZoomFit() {
        this.trafo.deltaZoom(this.trafo.getTStart(), this.trafo.getTEnd());
        this.xscroller.setThumb();
        this.redraw();
    }

    public void doZoomHome() {
        double d = this.trafo.getTLeft();
        double d2 = this.trafo.getTRight();
        double d3 = d2 - d;
        this.trafo.deltaZoom(0.0, 0.0 + d3);
        this.xscroller.setThumb();
        this.redraw();
    }

    public void doZoomEnd() {
        double d = this.trafo.getTLeft();
        double d2 = this.trafo.getTRight();
        double d3 = this.trafo.getTEnd();
        double d4 = d2 - d;
        this.trafo.deltaZoom(d3 - d4, d3);
        this.xscroller.setThumb();
        this.redraw();
    }

    public void doZoomIn() {
        double d = this.trafo.getTLeft();
        double d2 = this.trafo.getTRight();
        double d3 = d2 - d;
        this.trafo.deltaZoom(d + d3 / 4.0, d2 - d3 / 4.0);
        this.xscroller.setThumb();
        this.redraw();
    }

    public void doZoomOut() {
        double d = this.trafo.getTLeft();
        double d2 = this.trafo.getTRight();
        double d3 = d2 - d;
        this.trafo.deltaZoom(d - d3 / 2.0, d2 + d3 / 2.0);
        this.xscroller.setThumb();
        this.redraw();
    }

    public void doZoomSelection() {
        System.err.println("-#- doZoomSelection...");
        this.waveCanvas.zoomS();
        this.xscroller.setThumb();
        this.timePanel.repaint();
        this.redraw();
    }

    public void doZoomAuto() {
        int n;
        System.err.println("-#- doZoomAuto...");
        Point point = this.waveCanvas.getMousePosition();
        double d = this.trafo.getTime(point.x);
        this.setSearchTime(d);
        double d2 = this.trafo.getTStart();
        double d3 = this.trafo.getTEnd();
        int n2 = this.waveCanvas.getNumberOfSignals();
        int n3 = 0;
        while (n3 < n2) {
            double d4;
            Waveform waveform = this.waveCanvas.getWaveform(n3);
            int n4 = waveform.indexOfNextEventAfter(d);
            n = waveform.indexOfPreviousEventBefore(d);
            if (n4 != Waveform.NOT_FOUND && (d4 = waveform.getTimeAtIndex(n4)) <= d3) {
                d3 = d4;
            }
            if (n != Waveform.NOT_FOUND && (d4 = waveform.getTimeAtIndex(n)) >= d2) {
                d2 = d4;
            }
            ++n3;
        }
        double d5 = d3 - d2;
        if (d5 == 0.0) {
            this.doZoomFit();
            return;
        }
        System.out.println("    tprev= " + d2 + "  tmouse= " + d + "  tnext= " + d3 + "  delta= " + d5);
        n = Math.max(1, this.waveCanvas.getSize().width);
        int n5 = 20;
        double d6 = 0.25;
        double d7 = d6 * d5 * (double)n / (double)n5;
        this.trafo.deltaZoom(d - d7, d + d7);
        this.waveCanvas.findx = d;
        this.waveCanvas.showFind(true);
        this.xscroller.setThumb();
        this.redraw();
    }

    public void doShowSearchBaseTimeDialog() {
        block2: {
            System.out.println("-#- doShowSearchBaseTimeDialog...");
            String string = JOptionPane.showInputDialog(this, "Enter the search base time", "" + this.getSearchTime());
            if (string == null) break block2;
            try {
                this.setSearchTime(Double.parseDouble(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void doShowSearchValueDialog() {
        System.out.println("-#- doShowSearchValueDialog...");
        String string = JOptionPane.showInputDialog(this, "Enter the search pattern (value)", this.searchPattern);
        if (string != null) {
            this.searchPattern = string;
        }
        this.doShowSearchMarker();
    }

    public void doShowSearchMarker() {
        double d = this.getSearchTime();
        this.waveCanvas.moveToTime(d);
        this.waveCanvas.findx = d;
        this.waveCanvas.showFind(true);
        this.redraw();
    }

    public void doHideSearchMarker() {
        this.waveCanvas.showFind(false);
        this.redraw();
    }

    public double getSearchTime() {
        return this.searchTime;
    }

    public void setSearchTime(double d) {
        this.searchTime = d;
    }

    public void doSetSearchTimeFromMousePosition() {
        System.out.println("-#- doSetSearchTimeFromMousePosition...");
        Point point = this.waveCanvas.getMousePosition();
        double d = this.trafo.getTime(point.x);
        this.setSearchTime(d);
        System.out.println("-#- pos.x= " + point.x + " searchTime=" + d);
    }

    public void doSearchValue(String string) {
        int n;
        int n2;
        System.err.println("-E- doSearchValue: pattern is '" + string + "'");
        Point point = this.waveCanvas.getMousePosition();
        int n3 = this.trafo.getRow(point.y);
        Waveform waveform = this.waveCanvas.getWaveform(n3);
        if (waveform == null) {
            return;
        }
        boolean bl = point.x >= this.waveCanvas.getSize().width / 2;
        System.err.println("   searchTime= " + this.getSearchTime() + " forward= " + bl);
        int n4 = n2 = -1;
        if (bl) {
            n = waveform.countEvents();
            int n5 = waveform.indexOfNextEventAfter(this.searchTime);
            if (n5 < 0) {
                return;
            }
            int n6 = n5;
            while (n6 < n) {
                if (waveform.compareEventToSearchObject(n6, string)) {
                    n4 = n6;
                    break;
                }
                ++n6;
            }
        } else {
            n = waveform.indexOfPreviousEventBefore(this.searchTime);
            if (n < 0) {
                return;
            }
            int n7 = n;
            while (n7 >= 0) {
                if (waveform.compareEventToSearchObject(n7, string)) {
                    n4 = n7;
                    break;
                }
                --n7;
            }
        }
        if (n4 == n2) {
            return;
        }
        double d = waveform.getTimeAtIndex(n4);
        this.waveCanvas.moveToTime(d);
        this.waveCanvas.findx = d;
        this.waveCanvas.showFind(true);
        this.update();
        this.redraw();
        this.setSearchTime(d);
    }

    public void doSearchNextEvent() {
        Point point = this.waveCanvas.getMousePosition();
        int n = this.trafo.getRow(point.y);
        Waveform waveform = this.waveCanvas.getWaveform(n);
        if (waveform == null) {
            return;
        }
        int n2 = waveform.indexOfNextEventAfter(this.searchTime);
        if (n2 == Waveform.NOT_FOUND) {
            return;
        }
        double d = waveform.getTimeAtIndex(n2);
        this.waveCanvas.moveToTime(d);
        this.waveCanvas.findx = d;
        this.waveCanvas.showFind(true);
        this.update();
        this.redraw();
        this.setSearchTime(d);
    }

    public void doSearchPreviousEvent() {
        Point point = this.waveCanvas.getMousePosition();
        int n = this.trafo.getRow(point.y);
        Waveform waveform = this.waveCanvas.getWaveform(n);
        if (waveform == null) {
            return;
        }
        int n2 = waveform.indexOfPreviousEventBefore(this.searchTime);
        if (n2 == Waveform.NOT_FOUND) {
            return;
        }
        double d = waveform.getTimeAtIndex(n2);
        this.waveCanvas.moveToTime(d);
        this.waveCanvas.findx = d;
        this.waveCanvas.showFind(true);
        this.update();
        this.redraw();
        this.setSearchTime(d);
    }

    public void doSearchNextEventAllWaveforms() {
        System.out.println("-#- doSearchNextEventAllWaveforms... ");
        int n = this.waveCanvas.getNumberOfSignals();
        int[] nArray = new int[n];
        double d = Double.MAX_VALUE;
        int n2 = Waveform.NOT_FOUND;
        System.out.println("    searchTime= " + this.searchTime);
        int n3 = 0;
        while (n3 < n) {
            System.out.println("    wave " + n3);
            Waveform waveform = this.waveCanvas.getWaveform(n3);
            nArray[n3] = waveform.indexOfNextEventAfter(this.searchTime);
            if (nArray[n3] != Waveform.NOT_FOUND) {
                double d2 = waveform.getTimeAtIndex(nArray[n3]);
                if (d2 < d) {
                    d = d2;
                    n2 = n3;
                }
                System.out.println("    itmp= " + nArray[n3] + " time= " + d2 + " inext= " + n2 + " tnext=" + d);
            }
            ++n3;
        }
        if (n2 == Waveform.NOT_FOUND) {
            return;
        }
        this.waveCanvas.moveToTime(d);
        this.waveCanvas.findx = d;
        this.waveCanvas.showFind(true);
        this.update();
        this.redraw();
        this.setSearchTime(d);
        System.err.println("   index= " + n2 + "  tnext= " + d);
    }

    public void doSearchPreviousEventAllWaveforms() {
        System.out.println("-#- doSearchPreviousEventAllWaveforms... ");
        int n = this.waveCanvas.getNumberOfSignals();
        int[] nArray = new int[n];
        double d = Double.MIN_VALUE;
        int n2 = -1;
        System.out.println("    searchTime= " + this.searchTime);
        int n3 = 0;
        while (n3 < n) {
            System.out.println("    wave " + n3);
            Waveform waveform = this.waveCanvas.getWaveform(n3);
            nArray[n3] = waveform.indexOfPreviousEventBefore(this.searchTime);
            if (nArray[n3] != Waveform.NOT_FOUND) {
                double d2 = waveform.getTimeAtIndex(nArray[n3]);
                if (d2 > d) {
                    d = d2;
                    n2 = n3;
                }
                System.out.println("    itmp= " + nArray[n3] + " time= " + d2 + " iprev= " + n2 + " tprev=" + d);
            }
            ++n3;
        }
        if (n2 == -1) {
            return;
        }
        this.waveCanvas.moveToTime(d);
        this.waveCanvas.findx = d;
        this.waveCanvas.showFind(true);
        this.update();
        this.redraw();
        this.setSearchTime(d);
        System.err.println("   index= " + n2 + "  tprev= " + d);
    }

    public void doShowHelpOnKeys() {
        try {
            JTextViewer jTextViewer = new JTextViewer("HADES Waveform Viewer 0.31 shortcut keys", 20, 70);
            jTextViewer.parse(DesignManager.getDesignManager().getResourceAsStream("/hades/styx/help-keys.txt"));
            jTextViewer.setCaretPosition(0);
            jTextViewer.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doShowHelpOnSearching() {
        try {
            JTextViewer jTextViewer = new JTextViewer("HADES Waveform Viewer 0.31 searching", 20, 70);
            jTextViewer.parse(DesignManager.getDesignManager().getResourceAsStream("/hades/styx/help-searching.txt"));
            jTextViewer.setCaretPosition(0);
            jTextViewer.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doDumpData() {
        try {
            String string = DesignManager.getDesignManager().selectFileOrURLName("dump.hwv", "Save waveform data...", ".hwv", 1);
            if (string == null) {
                this.msg("-W- doDumpData canceled.");
                return;
            }
            OutputStream outputStream = DesignManager.getDesignManager().getOutputStream(this, string);
            this.doDumpData(outputStream);
        }
        catch (Exception exception) {
            this.msg("-E- doDumpData: " + exception);
            ExceptionTracer.trace(exception);
        }
    }

    public void doDumpData(OutputStream outputStream) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(outputStream));
            this.writeObject(objectOutputStream);
            objectOutputStream.close();
            outputStream.close();
        }
        catch (Exception exception) {
            ExceptionTracer.trace(exception);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.msg("-I- writeObject: starting serialization...");
        int n = this.waveCanvas.getNumberOfSignals();
        objectOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutputStream.writeObject(this.waveCanvas.getWaveform(n2));
            ++n2;
        }
        this.msg("-I- writeObject ok.");
    }

    public void doExportPPM() {
        try {
            int n;
            int n2;
            Image image;
            String string = DesignManager.getDesignManager().selectFileOrURLName("Save PPM image data...", "waves.ppm", ".ppm", 1);
            if (string == null) {
                this.msg("-W- doExportPPM canceled.");
                return;
            }
            OutputStream outputStream = DesignManager.getDesignManager().getOutputStream(this, string);
            if (outputStream != null) {
                this.setCursor(new Cursor(3));
            }
            if ((image = this.createImage(n2 = this.wavePanel.getSize().width, n = this.wavePanel.getSize().height)) == null) {
                this.msg("-E- Internal in doExportPPM: Cannot create buffer image...");
                return;
            }
            this.msg("-I- ...drawing wave data...");
            Graphics graphics = image.getGraphics();
            graphics.translate(150, 0);
            this.timePanel.paint(graphics);
            graphics.translate(-150, 31);
            this.nameCanvas.paint(graphics);
            graphics.translate(150, 0);
            this.waveCanvas.paint(graphics);
            this.msg("-I- ...encoding PPM data...");
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
            new PPMWriter().writePPM(image, dataOutputStream);
            dataOutputStream.close();
            outputStream.close();
            this.msg("-I- ...ok.");
        }
        catch (Exception exception) {
            this.msg("-E- Exception during PPM export: " + exception.toString());
            ExceptionTracer.trace(exception);
        }
        this.setCursor(new Cursor(0));
    }

    public void doReadData() {
        try {
            String string = DesignManager.getDesignManager().selectFileOrURLName("dump.hwv", "Read waveform data...", ".hwv", 0);
            if (string == null) {
                this.msg("-W- doReadData canceled.");
                return;
            }
            InputStream inputStream = DesignManager.getDesignManager().getInputStream(this, string);
            if (inputStream == null) {
                this.msg("-W- doReadData canceled.");
                return;
            }
            this.doReadData(inputStream);
        }
        catch (Exception exception) {
            this.msg("-E- doReadData: " + exception);
            ExceptionTracer.trace(exception);
        }
    }

    public void doReadData(InputStream inputStream) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
            this.readObject(objectInputStream);
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.msg("-I- readObject: reading serialized data...");
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            Waveform waveform = (Waveform)objectInputStream.readObject();
            waveform.setTrafo(this.trafo);
            waveform.setPos(0);
            this.waveCanvas.addWave(waveform);
            ++n2;
        }
        WaveformViewer.err("-I- readObject ok.");
    }

    public static void err(String string) {
        System.err.println(string);
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        double d;
        SetupManager.setProperty("Hades.UseSwingGUI", "true");
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadUserProperties(".hadesrc");
        SetupManager.loadLocalProperties(".hadesrc");
        System.out.println(SetupManager.getProperty("Hades.UseSwingGUI"));
        System.out.println("-#- loaded properties...");
        System.out.println("-#- creating waveform viewer now...");
        WaveformViewer waveformViewer = new WaveformViewer();
        waveformViewer.setSize(300, 300);
        waveformViewer.exitMI.setEnabled(true);
        waveformViewer.closeMI.setEnabled(false);
        System.out.println(new Date());
        waveformViewer.setVisible(true);
        System.out.println("-#- filling with random waves...");
        int n2 = 0;
        while (n2 < 10) {
            WaveStdLogic1164 waveStdLogic1164 = new WaveStdLogic1164();
            waveStdLogic1164.setTrafo(waveformViewer.getTrafo());
            waveStdLogic1164.setName("n_" + n2);
            waveStdLogic1164.setFullName("/hugo/gabi/fred/" + waveStdLogic1164.getName());
            waveStdLogic1164.setPos(0);
            waveformViewer.waveCanvas.addWave(waveStdLogic1164);
            d = 1.0;
            int n3 = 0;
            n = 0;
            while (n < 30) {
                d = n2 == 0 ? (d += 0.1) : (d += Math.random());
                n3 = n2 > 3 ? (int)(5.0 * Math.random()) : n % 8;
                ((Waveform)waveStdLogic1164).addValue(new StdLogic1164(n3), d);
                ++n;
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < 5) {
            WaveStdLogicVector waveStdLogicVector = new WaveStdLogicVector();
            waveStdLogicVector.setTrafo(waveformViewer.getTrafo());
            waveStdLogicVector.setName("v_" + n4);
            waveStdLogicVector.setFullName("/jojojo/v_" + n4);
            waveStdLogicVector.setPos(0);
            waveformViewer.waveCanvas.addWave(waveStdLogicVector);
            d = 0.0;
            n = 0;
            while (n < 30) {
                d = n4 == 0 ? (d += 0.2) : (d += Math.random());
                long l = n;
                waveStdLogicVector.addValue(new StdLogicVector(8, l), d);
                ++n;
            }
            ++n4;
        }
        String[] stringArray2 = new String[]{"Anja", "Bettina", "Cornelia", "Dorothea", "Edda", "Franziska", "Gunda", "Heather", "Inken", "Jasmin", "Kirsten", "Laila", "Maren", "Natalie", "Olga", "Petra", "Q", "Ramona", "Susanne", "Tanja", "Ulla", "Viola", "Wiebke", "Xenia", "Yvonne", "Zarah"};
        Waveform waveform = null;
        waveform = new WaveString();
        waveform.setTrafo(waveformViewer.getTrafo());
        waveform.setName("girls");
        waveform.setFullName("girls");
        waveform.setPos(0);
        waveformViewer.waveCanvas.addWave(waveform);
        d = 0.0;
        int n5 = 0;
        while (n5 < 40) {
            waveform.addValue(stringArray2[n5 % stringArray2.length], d);
            d += Math.random();
            ++n5;
        }
        waveform = new WaveString();
        waveform.setTrafo(waveformViewer.getTrafo());
        waveform.setName("random girls");
        waveform.setFullName("random girls");
        waveform.setPos(0);
        waveformViewer.waveCanvas.addWave(waveform);
        d = 0.0;
        int n6 = 0;
        while (n6 < 30) {
            waveform.addValue(stringArray2[(int)((double)stringArray2.length * Math.random())], d);
            d += Math.random();
            ++n6;
        }
        waveform = new WaveInteger();
        waveform.setTrafo(waveformViewer.getTrafo());
        waveform.setName("integers");
        waveform.setFullName("integers");
        waveform.setPos(0);
        waveformViewer.waveCanvas.addWave(waveform);
        d = 1.0;
        int n7 = 0;
        while (n7 < 100) {
            waveform.addValue(new Integer(n7), d);
            d += 0.1;
            ++n7;
        }
        waveform = new WaveDouble();
        waveform.setTrafo(waveformViewer.getTrafo());
        waveform.setName("data");
        waveform.setFullName("doubles");
        waveform.setPos(0);
        waveformViewer.waveCanvas.addWave(waveform);
        d = 1.0;
        int n8 = 0;
        while (n8 < 100) {
            waveform.addValue(new Double(Math.sin((double)n8 * 0.03 * Math.PI)), d);
            d += 0.1;
            ++n8;
        }
        System.out.println("-#- redrawing now...");
        waveformViewer.updateTrafo();
        waveformViewer.redraw();
        System.out.println("-#- dumping data to /tmp/waves.dump...");
        waveformViewer.doDumpData(new FileOutputStream("/tmp/waves.dump"));
        if (stringArray.length == 0) {
            System.out.println("-#- restoring data from /tmp/waves.dump...");
            WaveformViewer waveformViewer2 = new WaveformViewer();
            waveformViewer2.setSize(300, 300);
            waveformViewer2.exitMI.setEnabled(true);
            waveformViewer2.closeMI.setEnabled(false);
            waveformViewer2.setVisible(true);
            waveformViewer2.doReadData(new FileInputStream("/tmp/waves.dump"));
        }
    }

    class WavePanel
    extends JPanel {
        public WavePanel() {
            this.setDoubleBuffered(false);
        }

        public boolean isOpaque() {
            return true;
        }

        public boolean isDoubleBuffered() {
            return false;
        }

        public void doLayout() {
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            int n3 = this.getInsets().top;
            int n4 = 150;
            int n5 = 31;
            int n6 = 20;
            WaveformViewer.this.nameCanvas.setBounds(0, n5 + n3, n4 + 1, n2 - n6 - n3 - n5 - 1);
            WaveformViewer.this.waveCanvas.setBounds(n4 + 1, n5 + n3, n - n4 - n6, n2 - n6 - n3 - n5 - 1);
            WaveformViewer.this.timePanel.setBounds(n4 + 1, n3, n - n4 - n6, n5);
            WaveformViewer.this.xscroller.setBounds(n4 + 1, n2 - n6 - 1, n - n4 - n6, n6);
            WaveformViewer.this.yscroller.setBounds(n - n6, n5 + n3, n6, n2 - n6 - n3 - n5 - 1);
            WaveformViewer.this.trafo.setMaxX(n - n4 - n6);
            WaveformViewer.this.trafo.setMaxY(n2 - n6 - n3 - n5 - 1);
            WaveformViewer.this.trafo.setYRes((double)(n2 - n6 - n3 - n5 - 1) / (1.0 * (double)n6));
            WaveformViewer.this.yscroller.setThumb();
        }

        public Dimension getMinimumSize() {
            return new Dimension(400, 150);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }
    }

    class ShowSignalNameListener
    implements MouseMotionListener {
        ShowSignalNameListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = WaveformViewer.this.trafo.getRow(mouseEvent.getY());
            if (n >= 0 && n < WaveformViewer.this.waveCanvas.getNumberOfSignals()) {
                String string = WaveformViewer.this.waveCanvas.getFullName(n);
                if (string != null) {
                    WaveformViewer.this.statusCanvas.setStatusMessage(string);
                } else {
                    System.err.println("-W- internal: signal name is null: " + n);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }
    }
}

