/*
 * Decompiled with CFR 0.152.
 */
package hades.styx;

import hades.models.StdLogic1164;
import hades.styx.Waveform;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;

public class WaveStdLogic1164
extends Waveform
implements Serializable {
    public static final int IEEE_U = 0;
    public static final int IEEE_X = 1;
    public static final int IEEE_0 = 2;
    public static final int IEEE_1 = 3;
    public static final int IEEE_Z = 4;
    public static final int IEEE_L = 6;
    public static final int IEEE_H = 7;
    public static final int IEEE_W = 5;
    public static final int IEEE_D = 8;
    private int[] intValues;

    public WaveStdLogic1164() {
        this.intValues = new int[this.SIZE];
        this.clearData();
    }

    public void clearData() {
        this.fill = 0;
        int n = 0;
        while (n < this.times.length) {
            this.times[n] = 0.0;
            ++n;
        }
        this.intValues[0] = 0;
    }

    public void addValue(Object object, double d) {
        if (object == null) {
            return;
        }
        if (this.fill + 1 >= this.SIZE) {
            this.reallocate();
        }
        ++this.fill;
        this.times[this.fill] = d;
        this.intValues[this.fill] = ((StdLogic1164)object).intValue();
        if (Waveform.debug) {
            System.out.println("-#- WaveStdLogic1164.addValue: " + object + " " + d);
        }
    }

    public void reallocate() {
        try {
            int n = 2 * this.SIZE;
            double[] dArray = new double[n];
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < this.SIZE) {
                dArray[n2] = this.times[n2];
                nArray[n2] = this.intValues[n2];
                ++n2;
            }
            this.times = dArray;
            this.intValues = nArray;
            this.SIZE = n;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            try {
                System.out.println("-E- out of memory in WaveStdLogic1164.reallocate..." + this.getName() + " " + this.fill);
                System.out.println("... overwriting oldest event data ...");
                int n = this.fill / 2;
                int n3 = 1;
                while (n3 < n) {
                    this.times[n3] = this.times[n3 + n];
                    this.intValues[n3] = this.intValues[n3 + n];
                    ++n3;
                }
                this.fill = n - 1;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public Object getValueAtTime(double d) {
        int n = this.gototime(d);
        String string = new StdLogic1164(this.intValues[n]).getValueString();
        return string;
    }

    public boolean compareEventToSearchObject(int n, Object object) {
        try {
            if (object == null) {
                return false;
            }
            int n2 = this.intValues[n];
            if (object instanceof String) {
                switch (n2) {
                    case 0: {
                        return object.equals("U");
                    }
                    case 1: {
                        return object.equals("X");
                    }
                    case 2: {
                        return object.equals("0");
                    }
                    case 3: {
                        return object.equals("1");
                    }
                    case 4: {
                        return object.equals("Z");
                    }
                    case 5: {
                        return object.equals("W");
                    }
                    case 6: {
                        return object.equals("L");
                    }
                    case 7: {
                        return object.equals("H");
                    }
                    case 8: {
                        return object.equals("D");
                    }
                }
                return false;
            }
            if (object instanceof StdLogic1164) {
                return n2 == ((StdLogic1164)object).intValue();
            }
            if (object instanceof Integer) {
                return n2 == (Integer)object;
            }
            return super.compareEventToSearchObject(n, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void paint(Graphics graphics) {
        int n = this.trafo.transformRow(this.pos) + 2;
        int n2 = this.trafo.transformRow(this.pos + 1) - 2;
        if (n <= 1 || n2 <= 0 || n2 >= this.trafo.getMaxScreenY()) {
            return;
        }
        double d = this.trafo.getTLeft();
        double d2 = this.trafo.getTRight();
        int n3 = this.gototime(d);
        int n4 = n3 + 1;
        int n5 = this.intValues[n3];
        double d3 = n4 <= this.fill ? this.times[n4] : this.trafo.tEnd;
        int n6 = 0;
        int n7 = this.trafo.transformT(d3);
        if (n5 == 2 || n5 == 3) {
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(StdLogic1164.getColorFromIntValue(n5));
        }
        if (n5 == 0 || n5 == 1 || n5 == 5 || n5 == 4 || n5 == 8) {
            graphics.fillRect(0, n, n7, n2 - n + 1);
        } else if (n5 == 3 || n5 == 7) {
            graphics.drawLine(0, n, n7, n);
        } else if (n5 == 2 || n5 == 6) {
            graphics.drawLine(0, n2, n7, n2);
        }
        int n8 = n4;
        int n9 = n5;
        while (n8 <= this.fill && this.times[n8] <= d2) {
            n5 = this.intValues[n8];
            d3 = this.times[n8];
            double d4 = n8 < this.fill ? this.times[n8 + 1] : this.trafo.tEnd;
            n6 = this.trafo.transformT(d3);
            n7 = this.trafo.transformT(d4);
            if (n5 == 2 || n5 == 3) {
                graphics.setColor(Color.blue);
            } else {
                graphics.setColor(StdLogic1164.getColorFromIntValue(n5));
            }
            if (n5 == 3 || n5 == 7) {
                graphics.drawLine(n6, n, n7, n);
                if (n9 == 2 || n9 == 6) {
                    graphics.drawLine(n6, n, n6, n2);
                }
            } else if (n5 == 2 || n5 == 6) {
                graphics.drawLine(n6, n2, n7, n2);
                if (n9 == 3 || n9 == 7) {
                    graphics.drawLine(n6, n2, n6, n);
                }
            } else if (n5 == 0 || n5 == 1 || n5 == 5 || n5 == 4 || n5 == 8) {
                graphics.fillRect(n6, n, n7 - n6 + 1, n2 - n + 1);
            }
            ++n8;
            n9 = n5;
        }
        n6 = n7;
        n7 = (int)this.trafo.getXMax();
        if (n5 == 2 || n5 == 3) {
            graphics.setColor(Color.blue);
        } else {
            graphics.setColor(StdLogic1164.getColorFromIntValue(n5));
        }
        if (n5 == 3 || n5 == 7) {
            graphics.drawLine(n6, n, n7, n);
            if (n9 == 2 || n9 == 6) {
                graphics.drawLine(n6, n, n6, n2);
            }
        } else if (n5 == 2 || n5 == 6) {
            graphics.drawLine(n6, n2, n7, n2);
            if (n9 == 3 || n9 == 7) {
                graphics.drawLine(n6, n2, n6, n);
            }
        } else if (n5 == 0 || n5 == 1 || n5 == 5 || n5 == 4 || n5 == 8) {
            graphics.fillRect(n6, n, n7 - n6 + 1, n2 - n + 1);
        }
    }
}

