/*
 * Decompiled with CFR 0.152.
 */
package hades.styx;

import hades.styx.TimeFormatter;
import hades.styx.Transformation;
import hades.styx.Waveform;
import hades.styx.WaveformViewer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jfig.utils.SetupManager;

public class WaveCanvas
extends JPanel
implements ActionListener,
MouseMotionListener,
MouseListener,
ComponentListener {
    public Transformation trafo;
    private int n_signals;
    private int oldx;
    private int oldy;
    private int mark1;
    private int mark2;
    private int marks;
    private int wav;
    private int clickwave;
    public double time;
    public double lasttime;
    public double clicktime;
    public double findx;
    public double eps = 1.0E-11;
    public boolean showfind;
    public TimeFormatter timeFormatter;
    Color xorColor;
    Color backgroundColor;
    public int SIZE = 50;
    public Waveform[] waveArray;
    public JLabel timeLabel;
    public JLabel valueLabel;
    public Graphics g;
    public MouseEvent M;
    public JPopupMenu findmenu;
    public JMenuItem findnextMI;
    public JMenuItem findprevMI;
    public JMenuItem findlastnextMI;
    public JMenuItem findlastprevMI;
    public JMenuItem findforwardMI;
    public JMenuItem findbackwardMI;
    public WaveformViewer sw;

    public boolean isOpaque() {
        return true;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public WaveCanvas(WaveformViewer waveformViewer, Transformation transformation, JLabel jLabel, JLabel jLabel2) {
        this.trafo = transformation;
        this.valueLabel = jLabel;
        this.timeLabel = jLabel2;
        this.sw = waveformViewer;
        this.n_signals = 0;
        this.waveArray = new Waveform[this.SIZE];
        this.oldy = -1;
        this.oldx = -1;
        this.mark1 = -1;
        this.mark2 = -1;
        this.lasttime = -1.0;
        this.timeFormatter = new TimeFormatter();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addComponentListener(this);
        this.xorColor = SetupManager.getColor("Hades.WaveformViewer.WaveCanvas.XORColor", Color.white);
        this.backgroundColor = SetupManager.getColor("Hades.WaveformViewer.WaveCanvas.BackgroundColor", this.getBackground());
        this.setBackground(this.backgroundColor);
    }

    public void showFind(boolean bl) {
        this.showfind = bl;
    }

    public boolean getshowFind() {
        return this.showfind;
    }

    public void clearWaveData() {
        int n = 0;
        while (n < this.n_signals) {
            this.waveArray[n].clearData();
            ++n;
        }
    }

    public void deleteAllWaveforms() {
        this.n_signals = 0;
        this.waveArray = new Waveform[this.SIZE];
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.sw.requestFocus();
        if (!this.sw.hasFocus()) {
            System.out.println("-E- Swing bug: failed to get keyboard focus!");
        }
        this.updateTimeAndValueLabels(mouseEvent);
    }

    public void updateTimeAndValueLabels(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.wav = this.trafo.getRow(n2);
            this.time = this.trafo.getTime(n);
            if (this.waveArray[this.wav] != null) {
                String string = this.waveArray[this.wav].getValueAsString(this.time);
                this.valueLabel.setText("Value: " + string);
            } else {
                this.valueLabel.setText("Value: ---");
            }
            this.timeLabel.setText("Time: " + TimeFormatter.format(this.time));
            this.clickwave = this.wav;
            this.clicktime = this.time;
        }
        catch (Exception exception) {
            System.err.println("-E- WaveCanvas.updateTimeAndValueLabels: " + exception);
            exception.printStackTrace();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.clearCrosshair();
    }

    public void clearCrosshair() {
        Dimension dimension = this.getSize();
        Graphics graphics = this.getGraphics();
        graphics.setXORMode(this.xorColor);
        graphics.drawLine(this.oldx, 0, this.oldx, dimension.height);
        graphics.drawLine(0, this.oldy, dimension.width, this.oldy);
        graphics.setPaintMode();
        this.oldx = -1;
        this.oldy = -1;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Dimension dimension = this.getSize();
        this.g = this.getGraphics();
        this.g.setColor(new Color(0, 0, 0));
        this.g.setXORMode(this.xorColor);
        this.g.fillRect(this.mark1, 0, this.mark2 - this.mark1, dimension.height);
        this.marks = this.mark1 = mouseEvent.getX();
        this.mark2 = this.mark1;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.oldx = -1;
        this.oldy = -1;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        throw new UnsupportedOperationException("Searching via popup-menu no longer supported!");
    }

    public void zoomS() {
        if (this.mark1 < 0) {
            this.mark1 = 0;
        }
        if ((double)this.mark2 > this.trafo.xMax) {
            this.mark2 = (int)this.trafo.xMax;
        }
        this.trafo.deltaZoom(this.trafo.getTime(this.mark1), this.trafo.getTime(this.mark2));
    }

    public void zoom200() {
        double d = (this.trafo.tRight + this.trafo.tLeft) * 0.5;
        double d2 = this.trafo.tRight - this.trafo.tLeft;
        this.trafo.deltaZoom(d - 0.25 * d2, d + 0.25 * d2);
    }

    public void zoom400() {
        double d = (this.trafo.tRight + this.trafo.tLeft) * 0.5;
        double d2 = this.trafo.tRight - this.trafo.tLeft;
        this.trafo.deltaZoom(d - 0.125 * d2, d + 0.125 * d2);
    }

    public void zoom50() {
        double d = (this.trafo.tRight + this.trafo.tLeft) * 0.5;
        double d2 = this.trafo.tRight - this.trafo.tLeft;
        this.trafo.deltaZoom(d - 1.0 * d2, d + 1.0 * d2);
    }

    public void zoom25() {
        double d = (this.trafo.tRight + this.trafo.tLeft) * 0.5;
        double d2 = this.trafo.tRight - this.trafo.tLeft;
        this.trafo.deltaZoom(d - 2.0 * d2, d + 2.0 * d2);
    }

    public void zoom400OLD() {
        double d = (this.trafo.tRight - this.trafo.tLeft) / 4.0;
        d += d / 2.0;
        this.trafo.deltaZoom(this.trafo.tLeft + d, this.trafo.tRight - d);
    }

    public void zoom50OLD() {
        double d = (this.trafo.tRight - this.trafo.tLeft) / 4.0;
        double d2 = this.trafo.tLeft - d < 0.0 ? 0.0 : this.trafo.tLeft - d;
        double d3 = this.trafo.tRight + d > this.trafo.tEnd ? this.trafo.tEnd : this.trafo.tRight + d;
        this.trafo.deltaZoom(d2, d3);
    }

    public void zoom25OLD() {
        double d = (this.trafo.tRight - this.trafo.tLeft) / 2.0;
        double d2 = this.trafo.tLeft - d < 0.0 ? 0.0 : this.trafo.tLeft - d;
        double d3 = this.trafo.tRight + d > this.trafo.tEnd ? this.trafo.tEnd : this.trafo.tRight + d;
        this.trafo.deltaZoom(d2, d3);
    }

    public void zoomFit() {
        this.trafo.deltaZoom(this.trafo.tStart, this.trafo.tEnd);
    }

    public void zoomEnd() {
        double d = this.trafo.tLeft;
        double d2 = this.trafo.tRight;
        double d3 = this.trafo.tEnd;
        double d4 = this.getMaxWaveTime();
        double d5 = d4 - d3;
        if (d5 > 0.0) {
            this.trafo.tEnd = d4;
            this.trafo.deltaZoom(d + d5, d2 + d5);
        } else {
            System.err.println("-W- internal problem in zoomEnd(): delta<0");
            System.err.println("-W- doing a zoom fit instead of zoom end!");
            this.zoomFit();
        }
    }

    public void moveToTime(double d) {
        double d2 = this.trafo.tRight - this.trafo.tLeft;
        this.trafo.deltaZoom(d - 0.5 * d2, d + 0.5 * d2);
    }

    public String getName(int n) {
        if (n < 0 || n > this.getNumberOfSignals()) {
            return "out of range: " + n;
        }
        return this.waveArray[n].getName();
    }

    public String getFullName(int n) {
        if (n < 0 || n > this.getNumberOfSignals()) {
            return "out of range: " + n;
        }
        return this.waveArray[n].getFullName();
    }

    public Point getMousePosition() {
        return new Point(this.oldx, this.oldy);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Dimension dimension = this.getSize();
        this.g = this.getGraphics();
        this.g.setColor(new Color(0, 0, 0));
        this.g.setXORMode(this.xorColor);
        this.g.fillRect(this.mark1, 0, this.mark2 - this.mark1, dimension.height);
        this.mark2 = mouseEvent.getX();
        if (this.mark2 < this.marks) {
            this.mark1 = this.mark2;
            this.mark2 = this.marks;
        } else {
            this.mark1 = this.marks;
        }
        double d = this.trafo.getTime(this.mark2) - this.trafo.getTime(this.mark1);
        this.timeLabel.setText("Delta: " + TimeFormatter.format(d));
        this.g.fillRect(this.mark1, 0, this.mark2 - this.mark1, dimension.height);
        this.g.setPaintMode();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Dimension dimension = this.getSize();
        Graphics graphics = this.getGraphics();
        graphics.setColor(new Color(0, 0, 0));
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.wav = this.trafo.getRow(n2);
        this.time = this.trafo.getTime(n);
        graphics.setXORMode(this.xorColor);
        graphics.drawLine(this.oldx, 0, this.oldx, dimension.height);
        graphics.drawLine(0, this.oldy, dimension.width, this.oldy);
        graphics.drawLine(n, 0, n, dimension.height);
        graphics.drawLine(0, n2, dimension.width, n2);
        graphics.setPaintMode();
        this.oldx = n;
        this.oldy = n2;
        this.updateTimeAndValueLabels(mouseEvent);
    }

    public void addWave(Waveform waveform) {
        if (this.n_signals >= this.SIZE) {
            int n = this.SIZE * 2;
            Waveform[] waveformArray = new Waveform[n];
            int n2 = 0;
            while (n2 < this.SIZE) {
                waveformArray[n2] = this.waveArray[n2];
                ++n2;
            }
            this.waveArray = waveformArray;
            this.SIZE = n;
        }
        waveform.setPos(this.n_signals);
        waveform.setWaveCanvas(this);
        this.waveArray[this.n_signals] = waveform;
        ++this.n_signals;
    }

    public void delWaveform(Waveform waveform) {
        int n = 1;
        while (this.waveArray[n] != waveform && n < this.n_signals) {
            ++n;
        }
        int n2 = n;
        while (n2 < this.n_signals - 1) {
            this.waveArray[n2] = this.waveArray[n2 + 1];
            this.waveArray[n2].setPos(n2);
            ++n2;
        }
        --this.n_signals;
        if (this.n_signals < 0) {
            System.err.println("-E- in WaveCanvas.delWaveform: n_signals < 0 !");
            System.err.println("i1,i2,n_signals: " + n + " " + n2 + " " + this.n_signals);
            this.n_signals = 0;
        }
    }

    public void swapWaves(int n, int n2) {
        Waveform waveform = this.waveArray[n];
        this.waveArray[n] = this.waveArray[n2];
        this.waveArray[n2] = waveform;
        this.waveArray[n].setPos(n);
        this.waveArray[n2].setPos(n2);
    }

    public int getNumberOfSignals() {
        return this.n_signals;
    }

    public Waveform getWaveform(int n) {
        if (n >= 0 && n < this.n_signals) {
            return this.waveArray[n];
        }
        return null;
    }

    public double getMaxWaveTime() {
        double d = 0.0;
        int n = 0;
        while (n < this.n_signals) {
            double d2 = this.waveArray[n].getMaxTime();
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(Color.green);
        Dimension dimension = this.getSize();
        int n = 0;
        while (n < this.n_signals) {
            try {
                this.waveArray[n].paint(graphics);
            }
            catch (Exception exception) {
                System.err.println("-E- in WaveCanvas.paint: " + exception);
                exception.printStackTrace();
            }
            ++n;
        }
        this.mark1 = -1;
        this.mark2 = -1;
        graphics.setXORMode(this.xorColor);
        graphics.drawLine(this.oldx, 0, this.oldx, dimension.height);
        graphics.drawLine(0, this.oldy, dimension.width, this.oldy);
        graphics.setPaintMode();
        if (this.showfind) {
            n = this.trafo.transformT(this.findx);
            graphics.setColor(Color.red);
            graphics.drawLine(n, 0, n, dimension.height);
        }
    }
}

