/*
 * Decompiled with CFR 0.152.
 */
package hades.styx;

public class Transformation {
    public static final int BINARY = 1;
    public static final int DECIMAL = 2;
    public static final int HEX = 3;
    double tLeft;
    double tRight;
    double deltat;
    double deltay;
    double verschub;
    double zoomX;
    double yRes;
    double tPlus;
    double tMinus;
    double xMax;
    double yMax;
    double tStart;
    double tEnd;
    double yPos;
    double xRes;
    double OFFSET = 0.0;
    int numberformat = 2;
    private double tmpRight;
    private double tmpLeft;

    public Transformation(double d, double d2, double d3, double d4) {
        this.tStart = d3;
        this.tEnd = d4;
        this.xMax = d;
        this.yMax = d2;
        this.tLeft = 1.0;
        this.tRight = 6.0;
        this.yRes = 10.0;
        this.yPos = 0.0;
        this.xresolution();
        this.yresolution(this.yRes);
    }

    public void setNumberformat(int n) {
        this.numberformat = n;
    }

    public int getNumberformat() {
        return this.numberformat;
    }

    public void xresolution() {
        this.deltat = this.tRight - this.tLeft;
        this.xRes = this.deltat > 0.0 ? this.xMax / this.deltat : 0.0;
    }

    public void yresolution(double d) {
        this.deltay = this.yMax > 0.0 ? this.yMax / d : 0.0;
    }

    public void setMaxX(double d) {
        this.xMax = d;
        this.xresolution();
    }

    public void setMaxY(double d) {
        this.yMax = d;
        this.yresolution(this.yRes);
    }

    public void setYRes(double d) {
        this.yRes = d;
        this.yresolution(this.yRes);
    }

    public void setTStart(double d) {
        this.tStart = d;
    }

    public void setTEnd(double d) {
        this.tEnd = d;
    }

    public void setTLeft(double d) {
        this.tLeft = d + this.OFFSET;
        this.xresolution();
    }

    public void setTRight(double d) {
        this.tRight = d;
        this.xresolution();
    }

    public void setYPos(double d) {
        this.yPos = d <= 0.0 ? 0.0 : (d >= this.yMax ? this.yMax : d);
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double getXRes() {
        return this.xRes;
    }

    public double getYRes() {
        return this.yRes;
    }

    public double getYPos() {
        return this.yPos;
    }

    public double getTStart() {
        return this.tStart;
    }

    public double getTEnd() {
        return this.tEnd;
    }

    public double getTLeft() {
        return this.tLeft;
    }

    public double getTRight() {
        return this.tRight;
    }

    public double getxMax() {
        return this.xMax;
    }

    public double getDeltaT() {
        return this.deltat;
    }

    public double getDeltaY() {
        return this.deltay;
    }

    public int getMaxScreenY() {
        return (int)this.yMax;
    }

    public int transformT(double d) {
        double d2 = (d - this.tLeft) * this.xRes;
        if (d2 > this.xMax) {
            return (int)this.xMax;
        }
        if (d2 < 0.0) {
            return -1;
        }
        return (int)d2;
    }

    public int transformRow(double d) {
        if (d >= this.yPos && d <= this.yRes + this.yPos) {
            return (int)((d - this.yPos) * this.deltay);
        }
        return -1;
    }

    public int getRow(int n) {
        return (int)(this.yPos + (double)n / this.deltay);
    }

    public double getTime(int n) {
        return this.tLeft + (double)n / this.xRes;
    }

    public void deltaZoom(double d, double d2) {
        if (d == d2) {
            Transformation.err("-W- deltaZoom: t1==t2, ignoring...");
            return;
        }
        if (d > d2) {
            Transformation.err("-W- deltaZoom: t1>t2, swapping...");
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        if (d < 0.0) {
            Transformation.err("-W- deltaZoom: t1<0, using t1 = 0 instead!");
            d2 -= d;
            d = 0.0;
        }
        if (d2 > this.tEnd) {
            Transformation.err("-W- deltaZoom: t2>tEnd, using t2=tEnd instead!");
            d -= d2 - this.tEnd;
            d2 = this.tEnd;
            if (d <= 0.0) {
                d = 0.0;
                d2 = this.tEnd;
            }
        }
        this.tLeft = d;
        this.tRight = d2;
        this.xresolution();
    }

    public static void err(String string) {
        System.out.println("Transformation() -> " + string);
    }
}

