/*
 * Decompiled with CFR 0.152.
 */
package hades.styx;

import hades.styx.Transformation;
import hades.styx.WaveCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import jfig.utils.SetupManager;

class NameCanvas
extends JPanel
implements MouseListener {
    private WaveCanvas waveCanvas;
    private Transformation trafo;
    private int select1;
    private int select2;
    private int move;
    public static final int NAME_CANVAS_WIDTH = 150;

    public NameCanvas(WaveCanvas waveCanvas, Transformation transformation) {
        this.setDoubleBuffered(false);
        this.waveCanvas = waveCanvas;
        this.trafo = transformation;
        this.select1 = -1;
        this.select2 = -1;
        this.move = 0;
        this.addMouseListener(this);
        this.setBackground(SetupManager.getColor("Hades.WaveformViewer.NameCanvas.BackgroundColor", this.getBackground()));
    }

    public void clear() {
        this.select1 = -1;
        this.select2 = -1;
        this.move = 0;
    }

    public boolean isOpaque() {
        return true;
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getSize().width + 1, this.getSize().height + 1);
        graphics.setColor(Color.black);
        int n3 = 0;
        while (n3 < this.waveCanvas.getNumberOfSignals()) {
            n2 = this.trafo.transformRow(n3);
            n = this.trafo.transformRow((double)n3 + 1.0);
            if (n2 != -1 && n != -1) {
                String string = this.waveCanvas.getName(n3);
                graphics.drawString(string, 10, (n2 + n) / 2 + 3);
                graphics.drawRect(0, n2, 150, n - n2);
            }
            ++n3;
        }
        if (this.select2 != -1) {
            n2 = this.trafo.transformRow(this.select2);
            n = this.trafo.transformRow((double)this.select2 + 1.0);
            graphics.setXORMode(new Color(255, 255, 255));
            graphics.fillRect(0, n2, 150, n - n2);
        }
        if (this.select1 != -1) {
            n2 = this.trafo.transformRow(this.select1);
            n = this.trafo.transformRow((double)this.select1 + 1.0);
            graphics.setXORMode(new Color(255, 255, 255));
            graphics.fillRect(0, n2, 150, n - n2);
        }
    }

    public int moveup() {
        if (this.select1 > 0 && this.select1 != -1 && this.select1 <= this.waveCanvas.getNumberOfSignals()) {
            this.waveCanvas.swapWaves(this.select1, this.select1 - 1);
            --this.select1;
            this.select2 = -1;
            this.move = 1;
            return 0;
        }
        if (this.select1 == -1) {
            return 1;
        }
        return 2;
    }

    public int movedown() {
        if (this.select1 < this.waveCanvas.getNumberOfSignals() - 1 && this.select1 != -1) {
            this.waveCanvas.swapWaves(this.select1, this.select1 + 1);
            ++this.select1;
            this.select2 = -1;
            this.move = 1;
            return 0;
        }
        if (this.select1 == -1) {
            return 1;
        }
        return 2;
    }

    public int swap() {
        if (this.select1 != -1 && this.select2 != -1 && this.select1 <= this.waveCanvas.getNumberOfSignals() && this.select2 <= this.waveCanvas.getNumberOfSignals()) {
            this.waveCanvas.swapWaves(this.select1, this.select2);
            this.select1 = -1;
            this.select2 = -1;
            return 0;
        }
        if (this.select1 == -1) {
            return 1;
        }
        return 2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.trafo.getRow(mouseEvent.getY());
        if (n <= this.waveCanvas.getNumberOfSignals()) {
            if (this.select1 == -1 || this.select2 == -1 && this.move == 1) {
                if (this.move == 1) {
                    this.move = 0;
                }
                this.select1 = n;
            } else if (this.select1 == n) {
                this.select1 = -1;
            } else if (this.select2 == -1) {
                this.select2 = n;
            } else if (this.select2 == n) {
                this.select2 = -1;
            }
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

