/*
 * Decompiled with CFR 0.152.
 */
package hades.simulator;

import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.simulator.Wakeable;
import hades.utils.TimeFormatter;
import java.io.Serializable;

public class WakeupEvent
extends SimEvent
implements Serializable {
    protected Wakeable target;
    public static boolean debug = false;
    public static int STACK_SIZE = 50;
    public static int STACK_SIZE_1 = STACK_SIZE - 1;
    private static WakeupEvent[] recycleStack = new WakeupEvent[STACK_SIZE];
    private static int stackPointer = 0;
    private static long global_id = 0L;
    private static long n_available = 0L;
    private static long n_recycled = 0L;
    private static long n_new = 0L;

    public static WakeupEvent getNewWakeupEvent(Wakeable target, double time, Object arg) {
        return new WakeupEvent(target, time, arg);
    }

    public WakeupEvent(Wakeable target, double time, Object arg, Object source) {
        super(target, time, arg, source);
        this.target = target;
        ++global_id;
        ++n_new;
    }

    public WakeupEvent(Wakeable target, double time, Object arg) {
        super(target, time, arg, null);
        this.target = target;
        ++global_id;
        ++n_new;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        WakeupEvent[] wakeupEventArray = recycleStack;
        synchronized (recycleStack) {
            if (n_available < (long)STACK_SIZE_1) {
                WakeupEvent.recycleStack[WakeupEvent.stackPointer++] = this;
                ++n_available;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void evaluate() {
        this.target.wakeup(this);
    }

    public static long getNumberOfAvailableRecycledSimEvents() {
        return n_available;
    }

    public static long getNumberOfRecycledSimEvents() {
        return n_recycled;
    }

    public static long getNumberOfSimEvents() {
        return global_id;
    }

    public String toShortString() {
        return TimeFormatter.format(this.time) + " wakeup for " + ((SimObject)((Object)this.target)).getFullName();
    }

    public String toString() {
        return "WakeupEvent_" + this.id + "[" + "\n for:   " + this.target + "\n at:    " + TimeFormatter.format(this.time) + " sec." + "\n arg:   " + (this.arg != null ? this.arg : null) + "\n]";
    }
}

