/*
 * Decompiled with CFR 0.152.
 */
package hades.simulator;

import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.SimulatorCommand;
import hades.simulator.SimulatorScheduleCommand;
import hades.simulator.WakeupEvent;
import hades.utils.TimeFormatter;
import jfig.utils.ExceptionTracer;

public class VhdlSimKernel
extends SimKernel
implements Runnable {
    String versionString = "HADES VHDL simulation kernel (v0.07)";
    public static final int IDLE_CYCLE = 7;
    public static final int COLLECT_CYCLE = 8;
    public static final int EXECUTE_CYCLE = 9;
    protected int macroState = 2;
    protected int microState = 7;
    double realTime;
    double lastSyncTime;
    double eventTime;
    long t0;
    long t1;
    int n_resync_iterations = this.delta_resync_iterations = 20000;
    int delta_resync_iterations;
    int global_errors = 0;
    protected int PENDING_ARRAY_SIZE = 100;
    protected int pendingArrayIndex = 0;
    protected int n_max_pending = 0;
    protected SimEvent[] pendingEventArray = new SimEvent[this.PENDING_ARRAY_SIZE];
    protected Port[] pendingEventTargetArray = new Port[this.PENDING_ARRAY_SIZE];
    protected int RECYCLE_ARRAY_SIZE = 100;
    protected int recycleIndex = 0;
    protected SimEvent[] recycleEventArray = new SimEvent[this.RECYCLE_ARRAY_SIZE];
    public static int t_sleep = 25;

    public void addPendingEvent(SimEvent event, Port target) {
        if (this.debug) {
            this.message("-#- addPendingEvent: " + event + "\n target= " + target);
        }
        this.pendingEventArray[this.pendingArrayIndex] = event;
        this.pendingEventTargetArray[this.pendingArrayIndex] = target;
        ++this.pendingArrayIndex;
        if (this.pendingArrayIndex > this.n_max_pending) {
            this.n_max_pending = this.pendingArrayIndex;
        }
        if (this.pendingArrayIndex >= this.pendingEventArray.length) {
            this.reallocatePendingEventArrays();
        }
    }

    void reallocatePendingEventArrays() {
        int old_size = this.pendingEventArray.length;
        int new_size = 2 * old_size;
        if (this.debug) {
            this.message("-W- reallocatePendingEventArrays to size: " + new_size);
        }
        SimEvent[] tmpEvents = new SimEvent[new_size];
        Port[] tmpPorts = new Port[new_size];
        int i = 0;
        while (i < old_size) {
            tmpEvents[i] = this.pendingEventArray[i];
            tmpPorts[i] = this.pendingEventTargetArray[i];
            ++i;
        }
        this.pendingEventArray = tmpEvents;
        this.pendingEventTargetArray = tmpPorts;
    }

    void executePendingEvent() {
        if (this.debug) {
            this.message("-#- executePendingEvent " + this.pendingArrayIndex);
        }
        --this.pendingArrayIndex;
        if (this.pendingArrayIndex < 0) {
            this.pendingArrayIndex = 0;
            return;
        }
        Port target = this.pendingEventTargetArray[this.pendingArrayIndex];
        SimEvent event = this.pendingEventArray[this.pendingArrayIndex];
        event.setTargetPort(target);
        target.getHandler().evaluate(event);
    }

    void executeAllPendingEvents() {
        while (this.pendingArrayIndex > 0) {
            this.executePendingEvent();
        }
    }

    public void addRecycleableEvent(SimEvent event) {
        if (this.debug) {
            this.message("-#- addRecycleableEvent: " + event);
        }
        this.recycleEventArray[this.recycleIndex] = event;
        ++this.recycleIndex;
        if (this.recycleIndex >= this.recycleEventArray.length) {
            this.reallocateRecycleEventArrays();
        }
    }

    void reallocateRecycleEventArrays() {
        int old_size = this.recycleEventArray.length;
        int new_size = 2 * old_size;
        if (this.debug) {
            this.message("-#- reallocateRecycleEventArrays to size: " + new_size);
        }
        SimEvent[] tmpEvents = new SimEvent[new_size];
        int i = 0;
        while (i < old_size) {
            tmpEvents[i] = this.recycleEventArray[i];
            ++i;
        }
        this.recycleEventArray = tmpEvents;
    }

    void recycleEvents() {
        while (this.recycleIndex > 0) {
            --this.recycleIndex;
            this.recycleEventArray[this.recycleIndex].recycle();
        }
    }

    public void runForever() {
        if (this.debug) {
            this.message("VhdlSimKernel.runForever()...");
        }
        if (this.state == 0) {
            this.initializeSimulator();
            this.elaborateComponents();
        } else if (this.state == 2) {
            this.message("-W- SimKernel: simulation is still running.");
            return;
        }
        this.endTime = Double.MAX_VALUE;
        this.continueSimulation();
    }

    public void initializeSimulator() {
        super.initializeSimulator();
        this.n_iterations = 0;
        this.n_resync_iterations = this.delta_resync_iterations;
        this.t0 = System.currentTimeMillis();
        this.simTime = 0.0;
        this.lastSyncTime = this.realTime = 0.0;
        this.global_errors = 0;
    }

    public void run() {
        this.eventList.first();
        while (!this.shouldStop && this.global_errors < 10) {
            try {
                this.simulation();
            }
            catch (RuntimeException re) {
                this.message("-E- Internal error: " + re);
                re.printStackTrace();
                this.printStatus();
                this.shouldStop = true;
            }
            catch (Throwable t) {
                if (t instanceof OutOfMemoryError) {
                    this.message("-E- VhdlSimKernel: out of memory!" + t);
                    t.printStackTrace();
                    ++this.global_errors;
                    System.gc();
                    this.printStatus();
                    return;
                }
                if (t instanceof ThreadDeath) {
                    this.printStatus();
                    throw (ThreadDeath)t;
                }
                this.message("-E- VhdlSimKernel: unexpected exception: " + t);
                this.printStatus();
                ExceptionTracer.trace(t);
                System.err.println("SimEvent is: " + this.eventList.getData());
            }
        }
        if (this.debug) {
            this.message("-I- VhdlSimKernel: leaving run()...");
        }
    }

    void simulation() {
        while (!this.shouldStop) {
            ++this.n_iterations;
            this.checkInteractiveEvents();
            this.checkResync();
            this.collectEvents();
            this.executeAllPendingEvents();
            this.recycleEvents();
            this.processPendingRepaints();
        }
    }

    void checkInteractiveEvents() {
        while (!this.commandQueue.isEmpty()) {
            Object o = this.commandQueue.fetch();
            if (o instanceof SimulatorCommand) {
                if (this.debug) {
                    this.message("-I- executing interactive command: " + o);
                }
                ((SimulatorCommand)o).execute();
                continue;
            }
            this.message("-E- don't know what to do with interactive command: " + o);
        }
    }

    public void scheduleInteractiveEvent(SimEvent se) {
        if (this.debug) {
            this.message("-I- scheduleInteractiveEvent: " + se);
        }
        SimulatorScheduleCommand command = new SimulatorScheduleCommand(this, se);
        this.commandQueue.append(command);
    }

    public void deleteAllEventsFromSource(SimObject source) {
        this.commandQueue.append(new DeleteAllEventsFromSourceCommand(source));
    }

    void checkResync() {
        if (this.n_iterations > this.n_resync_iterations || this.realTime - this.lastSyncTime > 0.5) {
            this.resync();
        }
    }

    void collectEvents() {
        if (this.eventList.isEmpty()) {
            this.sleep();
            this.simTime = this.realTime;
            return;
        }
        this.eventList.first();
        this.eventTime = this.eventList.getSimTime();
        if (this.eventTime > this.realTime) {
            this.sleep();
            this.simTime = this.realTime;
            return;
        }
        double t_current = this.eventTime;
        double t_next = 0.0;
        this.simTime = this.eventTime;
        do {
            SimEvent event = this.eventList.getData();
            this.eventList.deleteFirst();
            event.evaluate();
            this.addRecycleableEvent(event);
            ++this.n_processed;
            if (this.eventList.isEmpty()) break;
            this.eventList.first();
            t_next = this.eventList.getSimTime();
            if (!this.debug) continue;
            this.message("$$$ t_next, t_current: " + t_next + " " + t_current);
        } while (t_next == t_current);
    }

    public void resync() {
        if (this.debug) {
            System.out.println("#VhdlSimKernel.resync(): ");
            this.printStatus();
        }
        this.n_resync_iterations = this.n_iterations + this.delta_resync_iterations;
        this.lastSyncTime = this.realTime;
        this.t1 = System.currentTimeMillis();
        this.realTime = 0.001 * (double)(this.t1 - this.t0);
    }

    public void printStatus() {
        this.message(" ");
        this.message("> " + this.toString() + " status: ");
        this.message("> Time : simTime= " + TimeFormatter.format(this.getSimTime()) + " realTime= " + TimeFormatter.format(this.realTime) + "\n");
        this.message("> Events: sched=" + this.n_scheduled + " procd= " + this.n_processed + " iters= " + this.n_iterations + " ev/sec= " + (int)((double)this.n_processed / this.realTime));
        if (this.debug) {
            this.message("> Pending: " + this.pendingArrayIndex + " max: " + this.n_max_pending);
        }
        this.message("> SimEvent:  total= " + SimEvent.getNumberOfSimEvents() + " recyc= " + SimEvent.getNumberOfRecycledSimEvents() + " avail= " + SimEvent.getNumberOfAvailableRecycledSimEvents());
        this.message("> SimE1164:  total= " + SimEvent1164.getNumberOfSimEvents() + " recyc= " + SimEvent1164.getNumberOfRecycledSimEvents() + " avail= " + SimEvent1164.getNumberOfAvailableRecycledSimEvents());
        this.message("> WakeupEv:  total= " + WakeupEvent.getNumberOfSimEvents() + " recyc= " + WakeupEvent.getNumberOfRecycledSimEvents() + " avail= " + WakeupEvent.getNumberOfAvailableRecycledSimEvents());
        if (this.debug) {
            this.message(">" + this.eventList.printStatus());
        }
        long bytesTotal = Runtime.getRuntime().totalMemory();
        long bytesFree = Runtime.getRuntime().freeMemory();
        this.message("> Memory = " + bytesFree + " of " + bytesTotal + " free...");
    }

    public void sleep() {
        if (this.debug) {
            System.out.println("---> Simulator.sleep()...");
        }
        try {
            Thread.sleep(t_sleep);
            this.realTime += 0.001 * (double)t_sleep;
        }
        catch (InterruptedException e) {
            this.message("-I- VhdlSimKernel: " + e);
            this.shouldStop = true;
        }
    }

    public String toString() {
        String s = "VhdlSimKernel'" + this.name + "'";
        return s;
    }

    class NOP
    implements Simulatable {
        NOP() {
        }

        public void elaborate(Object o) {
        }

        public void evaluate(Object o) {
        }

        public void message(String s) {
        }
    }

    class DeleteAllEventsFromSourceCommand
    implements SimulatorCommand {
        SimObject source;

        public DeleteAllEventsFromSourceCommand(SimObject _source) {
            this.source = _source;
        }

        public void execute() {
            VhdlSimKernel.this.eventList.deleteAllEventsFromSource(this.source);
            int i = 0;
            while (i < VhdlSimKernel.this.pendingArrayIndex) {
                SimEvent event = VhdlSimKernel.this.pendingEventArray[i];
                if (event.getSource() == this.source) {
                    VhdlSimKernel.this.message("-E- VhdlSimKernel.dAEFS: replacing pending event: " + event);
                    VhdlSimKernel.this.pendingEventArray[i] = new SimEvent(new NOP(), event.getTime(), null);
                }
                ++i;
            }
        }
    }
}

