/*
 * Decompiled with CFR 0.152.
 */
package hades.simulator;

import hades.gui.Console;
import hades.gui.SimControlPanel;
import hades.models.Design;
import hades.simulator.CommandQueue;
import hades.simulator.EventList;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.SimulatorInterruptEvent;
import hades.simulator.Wakeable;
import hades.simulator.WakeupEvent;
import hades.styx.WaveformViewer;
import hades.utils.ContextToolTip;
import java.awt.Point;
import jfig.canvas.SyncPainter;

public class SimKernel
implements Runnable,
Simulatable,
ContextToolTip {
    protected String name;
    public static String versionString = "HADES simulation kernel (v0.6)";
    public boolean debug = false;
    protected Console console;
    protected SimControlPanel controlPanel = null;
    protected SyncPainter painter;
    public static final int RESET = 0;
    public static final int ELABORATE = 1;
    public static final int RUNNING = 2;
    public static final int PAUSED = 3;
    public static final int SINGLESTEP = 13;
    public static final int STOPPED = 15;
    protected int state = 0;
    protected static int n_simulators = 0;
    protected int simulatorID = n_simulators++;
    protected CommandQueue commandQueue;
    protected EventList eventList;
    protected double simTime;
    protected double endTime;
    protected int n_scheduled;
    protected int n_processed;
    protected int n_iterations;
    protected int n_interactive;
    protected int n_interactive_transferred;
    protected Thread runner;
    protected boolean shouldStop;
    protected Design design = null;

    public void executeSingleStep() {
        System.err.println("-E- don't call executeSingleStep on SimKernel!");
    }

    public SimKernel() {
        this.name = "simulator" + this.simulatorID;
        this.commandQueue = new CommandQueue();
        this.initializeSimulator();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDesign(Design design) {
        this.design = design;
    }

    public long getNumberOfScheduledEvents() {
        return this.n_scheduled;
    }

    public long getNumberOfProcessedEvents() {
        return this.n_processed;
    }

    public void setControlPanel(SimControlPanel scp) {
        this.controlPanel = scp;
        this.controlPanel.updateVisual();
    }

    public void setConsole(Console c) {
        this.console = c;
    }

    public void setDebug(boolean onoff) {
        this.debug = onoff;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setSyncPainter(SyncPainter painter) {
        this.painter = painter;
    }

    public SyncPainter getSyncPainter() {
        return this.painter;
    }

    public void processPendingRepaints() {
        if (this.painter != null) {
            this.painter.synchronousRepaint();
        }
    }

    public boolean hasEvents() {
        return !this.eventList.isEmpty();
    }

    public boolean isRunning() {
        return this.state == 2;
    }

    public boolean isPaused() {
        return this.state == 3;
    }

    public boolean isReset() {
        return this.state == 0;
    }

    public boolean isSingleStep() {
        return this.state == 13;
    }

    public double getSimTime() {
        return this.simTime;
    }

    public EventList getEventList() {
        return this.eventList;
    }

    public void scheduleEvent(SimEvent se) {
        if (this.debug) {
            this.message("-I- SimKernel.scheduleEvent: " + se);
        }
        ++this.n_scheduled;
        this.eventList.insert(se);
    }

    public void addPendingEvent(SimEvent se, Port target) {
        se.setTargetPort(target);
        target.getHandler().evaluate(se);
    }

    public void scheduleWakeup(Wakeable target, double time, Object arg) {
        if (this.debug) {
            this.message("-I- SimKernel.scheduleWakeup: " + target);
        }
        WakeupEvent w = WakeupEvent.getNewWakeupEvent(target, time, arg);
        ++this.n_scheduled;
        this.eventList.insert(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleInteractiveEvent(SimEvent se) {
        if (this.debug) {
            this.message("-I- SimKernel.scheduleInteractiveEvent: " + se);
        }
        EventList eventList = this.eventList;
        synchronized (eventList) {
            ++this.n_scheduled;
            this.eventList.insert(se);
        }
        if (this.state != 2 && this.controlPanel != null) {
            this.controlPanel.updateVisual();
        }
    }

    public void elaborateComponents() {
        if (this.debug) {
            this.message("-I- SimKernel.elaborateComponents started...");
        }
        if (this.design != null) {
            if (this.debug) {
                this.message("-I- elaborating: " + this.design);
            }
            this.design.elaborate(null);
            this.checkClearWaveforms();
        } else if (this.debug) {
            this.message("-W- SimKernel.elaborateComponents: design is null");
        }
    }

    public void checkClearWaveforms() {
        if (this.design.getEditor() == null) {
            return;
        }
        try {
            WaveformViewer waveformViewer = this.design.getEditor().getWaveformViewer();
            if (waveformViewer != null) {
                waveformViewer.clearWaveData();
            }
        }
        catch (Exception e) {
            System.err.println("-E- internal in SimKernel.checkClearWaveforms: " + e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllEventsFromSource(SimObject source) {
        this.message("-W- SimKernel: deleteAllEventsFromSource is not thread safe!");
        if (this.debug) {
            this.message("-I- SimKernel: deleting all events from source:" + source + "...");
        }
        EventList eventList = this.eventList;
        synchronized (eventList) {
            this.eventList.deleteAllEventsFromSource(source);
        }
    }

    public void pauseSimulation_NEW() {
        if (this.debug) {
            this.message("-I- SimKernel.pauseSimulation()..." + this.getState());
        }
        if (this.runner != null && this.runner.isAlive()) {
            this.state = 3;
        } else {
            this.message("-W- SimKernel already stopped, time " + this.getSimTime());
        }
        if (this.controlPanel != null) {
            this.controlPanel.updateVisual();
        }
    }

    public void pauseSimulation() {
        block10: {
            if (this.debug) {
                this.message("-I- SimKernel.pauseSimulation()..." + this.getState());
            }
            if (this.runner != null && this.runner.isAlive()) {
                this.shouldStop = true;
                this.state = 3;
                if (Thread.currentThread() != this.runner) {
                    if (this.debug) {
                        this.message("...calling runner.join()...");
                    }
                    try {
                        this.runner.join();
                        this.runner = null;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (this.debug) {
                        this.message("...runner.join() ok.");
                    }
                }
            } else {
                this.message("-W- SimKernel already stopped, time " + this.getSimTime());
                this.shouldStop = true;
                this.state = 3;
            }
            if (this.controlPanel == null) break block10;
            this.controlPanel.updateVisual();
            try {
                Thread.sleep(150L);
            }
            catch (Exception e) {}
        }
    }

    public void stopSimulation_NEW() {
        if (this.debug) {
            this.message("-I- SimKernel.stopSimulation()..." + this.getState());
        }
        if (this.state != 15) {
            this.shouldStop = true;
            this.state = 15;
        } else {
            if (this.debug) {
                this.message("-W- simulation is already stopped.");
            }
            this.shouldStop = true;
            this.state = 0;
        }
        if (this.controlPanel != null) {
            this.controlPanel.updateVisual();
        }
    }

    public void stopSimulation() {
        block11: {
            if (this.debug) {
                this.message("-I- SimKernel.stopSimulation()..." + this.getState());
            }
            if (this.runner != null && this.runner.isAlive()) {
                this.shouldStop = true;
                this.state = 0;
                if (this.debug) {
                    this.message("...calling runner.join()...");
                }
                if (this.runner != Thread.currentThread()) {
                    try {
                        this.runner.join();
                        this.runner = null;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (this.debug) {
                        this.message("...runner.join() ok.");
                    }
                }
            } else {
                if (this.debug) {
                    this.message("-W- simulation is already stopped.");
                }
                this.shouldStop = true;
                this.state = 0;
            }
            if (this.controlPanel == null) break block11;
            this.controlPanel.updateVisual();
            try {
                Thread.sleep(150L);
            }
            catch (Exception e) {}
        }
    }

    public void initializeSimulator() {
        if (this.debug) {
            this.message("-I- SimKernel.initializeSimulator()...");
        }
        this.eventList = new EventList();
        this.simTime = 0.0;
        this.endTime = Double.MAX_VALUE;
        this.state = 0;
        this.n_processed = 0;
        this.n_scheduled = 0;
        this.n_iterations = 0;
    }

    public void continueSimulation() {
        if (this.debug) {
            this.message("SimKernel.continueSimulation() at t=" + this.simTime);
        }
        if (this.runner == null) {
            this.shouldStop = false;
            this.state = 2;
            this.runner = new Thread(this);
            this.runner.setPriority(1);
            this.runner.setDaemon(true);
            this.runner.start();
        } else {
            if (this.runner.isAlive()) {
                this.message("-W- SimKernel.continueSimulation: internal problem,\n    the previous simulation Thread is still alive...");
            }
            if (this.debug) {
                System.err.println("-#- SimKernel.continueSimulation: creating new Thread anyway...");
            }
            this.shouldStop = false;
            this.state = 2;
            this.runner = new Thread(this);
            this.runner.setPriority(1);
            this.runner.setDaemon(true);
            this.runner.start();
        }
        if (this.controlPanel != null) {
            this.controlPanel.updateVisual();
        }
    }

    public void runForever() {
        if (this.debug) {
            this.message("SimKernel.runForever()...");
        }
        if (this.state == 0) {
            this.initializeSimulator();
            this.elaborateComponents();
        } else if (this.state == 2) {
            this.message("-W- SimKernel: simulation is already running.");
            return;
        }
        this.endTime = Double.MAX_VALUE;
        this.continueSimulation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runFor(double delta_t) {
        if (this.debug) {
            this.message("-I- SimKernel.runFor(" + delta_t + ")...");
        }
        if (this.state == 0) {
            this.initializeSimulator();
            this.elaborateComponents();
        } else if (this.state == 2) {
            this.message("SimKernel: simulation is still running.");
            return;
        }
        this.endTime = this.simTime + delta_t;
        if (this.debug) {
            this.message("-I- Simulator: runFor()...");
        }
        if (this.debug) {
            this.message("    sim.time= " + this.simTime + " end time= " + this.endTime);
        }
        EventList eventList = this.eventList;
        synchronized (eventList) {
            this.scheduleEvent(new SimulatorInterruptEvent(this, this.endTime, (Object)this));
        }
        this.continueSimulation();
    }

    public void singleStep() {
        if (this.debug) {
            this.message("\n\n-I- Simulator.singleStep(): eventlist=" + this.eventList);
        }
        if (this.state == 0) {
            this.initializeSimulator();
            this.elaborateComponents();
        }
        this.state = 3;
        if (!this.eventList.isEmpty()) {
            this.eventList.first();
            this.simTime = this.eventList.getSimTime();
            this.eventList.getData().evaluate();
            this.eventList.deleteFirst();
            this.processPendingRepaints();
            this.printNextPendingEvent();
        } else {
            this.message("-W- Simulator.singleStep(): no events left!");
        }
    }

    public void printNextPendingEvent() {
        if (!this.eventList.isEmpty()) {
            this.eventList.first();
            this.message("" + this.eventList.getData());
        } else {
            this.message("no events remaining.");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.eventList.first();
        ** GOTO lbl20
        {
            block4: {
                if (!this.eventList.isEmpty()) break block4;
                if (this.debug) {
                    this.message("SimKernel.run(): no events remaining, t=" + this.simTime);
                }
                ** GOTO lbl16
            }
            this.eventList.first();
            this.simTime = this.eventList.getSimTime();
            if (this.debug) {
                this.message("SimKernel.run(): processing event: " + this.eventList.getData());
            }
            this.eventList.getData().evaluate();
            this.eventList.deleteFirst();
            do {
                if (this.eventList.getSimTime() < this.endTime) continue block0;
lbl16:
                // 2 sources

                System.out.println("ok. [t=" + this.simTime + "]");
                this.simTime = this.endTime;
                this.shouldStop = true;
                this.state = 3;
lbl20:
                // 2 sources

            } while (!this.shouldStop);
        }
        System.out.println("-#- SimKernel: Thread.run() exited: " + this.toString());
    }

    public void run_debug() {
        while (true) {
            System.out.println("SimKernel.run(), time= " + this.simTime + " end time= " + this.endTime);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.simTime > this.endTime) {
                this.stopSimulation();
                continue;
            }
            this.simTime += (double)((int)(100.0 * Math.random()));
        }
    }

    public void printStatus() {
        this.message("Simulator t= " + this.simTime);
    }

    public void elaborate(Object arg) {
        if (this.debug) {
            this.message("-I- Simulator.elaborate()... ignored.");
        }
    }

    public void evaluate(Object arg) {
        if (this.debug) {
            this.message("-I- Simulator.evaluate(): Argument is " + arg);
        }
        if (arg instanceof SimulatorInterruptEvent) {
            this.interruptSimulation();
        } else {
            this.message("-W- Simulator.evaluate(): Don't know how to handle this: " + arg);
        }
    }

    private void interruptSimulation() {
        block3: {
            if (this.state != 2) {
                this.message("-W- cannot interrupt: not RUNNING...");
                return;
            }
            this.shouldStop = true;
            this.state = 3;
            if (this.controlPanel == null) break block3;
            this.controlPanel.updateVisual();
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
    }

    public String toString() {
        String s = "SimKernel[" + this.simulatorID + "]'" + this.name + "'";
        return s;
    }

    public String getToolTip(Point mouse_pos, long millis) {
        return this.getClass().getName() + "\n" + "sim.time=" + this.getSimTime() + "\n" + "events: " + this.getNumberOfProcessedEvents() + " processed, " + this.getNumberOfScheduledEvents() + " scheduled.";
    }

    public void message(String msg) {
        System.out.println(msg);
    }

    public String getState() {
        switch (this.state) {
            case 0: {
                return "in state RESET";
            }
            case 1: {
                return "in state ELABORATE";
            }
            case 2: {
                return "in state RUNNING";
            }
            case 13: {
                return "in state SINGLESTEP";
            }
            case 3: {
                return "in state PAUSED";
            }
        }
        return "in illegal state: " + this.state;
    }

    public void dbg(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }

    public static void usage() {
        System.err.println("Usage: java hades.simulator.SimKernel <n-events>");
        System.err.println("Example: java hades.simulator.SimKernel 10");
        System.err.println("For a better test try:\njava hades.simulator.SimControlPanel");
    }

    public static void main(String[] argv) {
        int n = 0;
        if (argv.length < 1) {
            SimKernel.usage();
            return;
        }
        n = Integer.parseInt(argv[0]);
        System.out.println("SimKernel self test started...");
        SimKernel SK = new SimKernel();
        SK.setName("Sample event list");
        System.out.println(SK.toString());
        System.out.println("...inserting " + n + " node(s)...");
        SimObject SO = new SimObject();
        int i = 0;
        while (i < n) {
            double t = (int)(10000.0 * Math.random());
            SimEvent SE = new SimEvent(SO, t, null);
            SK.scheduleEvent(SE);
            System.out.println("   " + SE);
            ++i;
        }
        System.out.println("...running the actual simulation...");
        SK.runForever();
        System.out.println("...ok.");
    }
}

