/*
 * Decompiled with CFR 0.152.
 */
package hades.simulator;

import hades.simulator.SimEvent;

public class SimEventRecycler {
    private static String name = "SimEventRecycler";
    private static int STACK_SIZE = 500;
    private static SimEvent[] recycleStack = new SimEvent[STACK_SIZE];
    private static int recyclePointer = 0;
    boolean enable_recycling = true;
    public long n_created = 0L;
    public long n_recycled = 0L;
    public long n_available = 0L;

    public void recycleNode(SimEvent victim) {
        if (this.enable_recycling && this.n_available < (long)STACK_SIZE) {
            SimEventRecycler.recycleStack[SimEventRecycler.recyclePointer++] = victim;
            ++this.n_available;
        }
    }

    public boolean hasRecycledNodes() {
        return this.n_available > 0L;
    }

    public SimEvent getRecycledSimEvent() {
        if (this.enable_recycling && this.n_available > 0L) {
            SimEvent recycleNode = recycleStack[--recyclePointer];
            recycleNode.target = null;
            --this.n_available;
            ++this.n_recycled;
            ++this.n_created;
            return recycleNode;
        }
        ++this.n_created;
        return null;
    }

    public String printStatus() {
        return this.toString() + "created= " + this.n_created + " recycled= " + this.n_recycled + " available= " + this.n_available;
    }

    public String toString() {
        return name;
    }
}

