/*
 * Decompiled with CFR 0.152.
 */
package hades.simulator;

import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.utils.TimeFormatter;
import jfig.utils.ExceptionTracer;

public class RealTimeSimKernel
extends SimKernel
implements Runnable {
    static boolean debug = false;
    static boolean ddebug = false;
    static String versionString = "HADES real time simulation kernel (v0.4)";
    double realTime;
    double lastSyncTime;
    double eventTime;
    long t0;
    long t1;
    int n_resync_iterations = this.delta_resync_iterations = 250;
    int delta_resync_iterations;
    int global_errors = 0;
    public static int t_sleep = 25;

    public void runForever() {
        if (debug) {
            this.message("RealTimeSimKernel.runForever()...");
        }
        if (this.state == 0) {
            this.initializeSimulator();
            this.elaborateComponents();
        } else if (this.state == 2) {
            this.message("-W- SimKernel: simulation is still running.");
            return;
        }
        this.endTime = Double.MAX_VALUE;
        this.continueSimulation();
    }

    public void initializeSimulator() {
        super.initializeSimulator();
        this.n_iterations = 0;
        this.t0 = System.currentTimeMillis();
        this.simTime = 0.0;
        this.lastSyncTime = this.realTime = 0.0;
        this.global_errors = 0;
    }

    public void addPendingEvent(SimEvent se, Port target) {
        if (debug) {
            System.err.println("\n\nRTSK.addPendingEvent: " + se + " " + target);
        }
        se.setTargetPort(target);
        target.getHandler().evaluate(se);
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void resync() {
        if (ddebug) {
            System.out.println("#RealTimeSimKernel.resync(): ");
            this.printStatus();
        }
        long bytesTotal = Runtime.getRuntime().totalMemory();
        long bytesFree = Runtime.getRuntime().freeMemory();
        if (bytesTotal > 15000000L && bytesFree < 300000L) {
            this.message("starting emergency garbage collect...");
            System.gc();
            this.printStatus();
        }
        this.n_resync_iterations = this.n_iterations + this.delta_resync_iterations;
        this.lastSyncTime = this.realTime;
        this.t1 = System.currentTimeMillis();
        this.realTime = 0.001 * (double)(this.t1 - this.t0);
    }

    public void printStatus() {
        this.message(" ");
        this.message("---> " + this.toString() + " status: ");
        this.message("---> Time : simTime= " + TimeFormatter.format(this.getSimTime()) + " realTime= " + TimeFormatter.format(this.realTime) + "\n" + "---> Events: sched=" + this.n_scheduled + " procd= " + this.n_processed + " iters= " + this.n_iterations + " ev/sec= " + (int)((double)this.n_processed / this.realTime));
        this.message("---> Recyling:  total= " + SimEvent.getNumberOfSimEvents() + " recyd= " + SimEvent.getNumberOfRecycledSimEvents() + " avail= " + SimEvent.getNumberOfAvailableRecycledSimEvents());
        this.message("---> " + this.eventList.printStatus());
        long bytesTotal = Runtime.getRuntime().totalMemory();
        long bytesFree = Runtime.getRuntime().freeMemory();
        this.message("---> Memory = " + bytesFree + " of " + bytesTotal + " free...");
    }

    public void sleep() {
        if (ddebug) {
            System.out.println("---> Simulator.sleep()...");
        }
        try {
            Thread.sleep(t_sleep);
            this.realTime += 0.001 * (double)t_sleep;
        }
        catch (InterruptedException e) {
            this.message("-E- RealTimeSimKernel: " + e);
            ExceptionTracer.trace(e);
        }
    }

    public String toString() {
        String s = "RealTimeSimKernel'" + this.name + "'";
        return s;
    }
}

