/*
 * Decompiled with CFR 0.152.
 */
package hades.simulator;

import hades.simulator.DeleteAllEventsFromSourceCommand;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.SimulatorCommand;
import hades.simulator.SimulatorInterruptEvent;
import hades.simulator.SimulatorScheduleCommand;
import hades.simulator.SimulatorSingleStepCommand;
import hades.utils.TimeFormatter;
import jfig.utils.ExceptionTracer;

public class InteractiveSimKernel
extends SimKernel
implements Runnable {
    public long t_sleep = 100L;
    public long t_resync = 100L;
    static String versionString = "HADES interactive simulation kernel (v0.03)";
    double realTime;
    double lastSyncTime;
    double eventTime;
    long t0;
    long t1;
    int n_resync_iterations = this.delta_resync_iterations = 250;
    int delta_resync_iterations;
    int global_errors = 0;
    public static final int STOP = 16;
    public static final int SINGLE_STEP = 8;
    public static final int PAUSE = 4;
    public static final int RUNNING = 1;
    public static final int VIRGIN = 0;
    int simulatorState = 0;
    int PENDING_ARRAY_SIZE = 100;
    int pendingArrayIndex = 0;
    int n_pending = 0;
    SimEvent[] pendingEventArray = new SimEvent[this.PENDING_ARRAY_SIZE];
    Port[] pendingEventTargetArray = new Port[this.PENDING_ARRAY_SIZE];

    public InteractiveSimKernel() {
        this.debug = false;
    }

    public void addPendingEvent(SimEvent event, Port target) {
        if (this.debug) {
            this.msg("-#- addPendingEvent: " + event + "\n target= " + target);
        }
        this.pendingEventArray[this.pendingArrayIndex] = event;
        this.pendingEventTargetArray[this.pendingArrayIndex] = target;
        ++this.pendingArrayIndex;
        if (this.pendingArrayIndex > this.n_pending) {
            this.n_pending = this.pendingArrayIndex;
        }
        if (this.pendingArrayIndex >= this.pendingEventArray.length) {
            this.reallocatePendingEventArrays();
        }
    }

    void reallocatePendingEventArrays() {
        int old_size = this.pendingEventArray.length;
        int new_size = 2 * old_size;
        if (this.debug) {
            this.msg("-W- reallocatePendingEventArrays to size: " + new_size);
        }
        SimEvent[] tmpEvents = new SimEvent[new_size];
        Port[] tmpPorts = new Port[new_size];
        int i = 0;
        while (i < old_size) {
            tmpEvents[i] = this.pendingEventArray[i];
            tmpPorts[i] = this.pendingEventTargetArray[i];
            ++i;
        }
        this.pendingEventArray = tmpEvents;
        this.pendingEventTargetArray = tmpPorts;
    }

    void executePendingEvent() {
        if (this.debug) {
            this.msg("-#- executePendingEvent " + this.pendingArrayIndex);
        }
        --this.pendingArrayIndex;
        if (this.pendingArrayIndex < 0) {
            this.pendingArrayIndex = 0;
            return;
        }
        Port target = this.pendingEventTargetArray[this.pendingArrayIndex];
        SimEvent event = this.pendingEventArray[this.pendingArrayIndex];
        event.setTargetPort(target);
        target.getHandler().evaluate(event);
    }

    void executeAllPendingEvents() {
        while (this.pendingArrayIndex > 0) {
            this.executePendingEvent();
        }
    }

    public boolean isStopped() {
        return (this.simulatorState & 0x10) > 0;
    }

    public boolean isSingleStep() {
        return (this.simulatorState & 8) > 0;
    }

    public boolean isPaused() {
        return this.simulatorState < 8 && this.simulatorState >= 4;
    }

    public boolean isRunning() {
        return this.simulatorState == 1;
    }

    public boolean isStarted() {
        return this.simulatorState > 0;
    }

    public boolean isVirgin() {
        return this.simulatorState < 1;
    }

    public String getState() {
        StringBuffer sb = new StringBuffer();
        sb.append("" + this.simulatorState + " ");
        if (this.isStopped()) {
            sb.append("STOP");
        } else if (this.isSingleStep()) {
            sb.append("SINGLE_STEP");
        } else if (this.isPaused()) {
            sb.append("PAUSE");
        } else if (this.isRunning()) {
            sb.append("RUNNING");
        } else if (this.isVirgin()) {
            sb.append("VIRGIN");
        } else {
            sb.append("UNKNOWN!!!");
        }
        return sb.toString();
    }

    public void elaborateComponents() {
        if (this.debug) {
            this.msg("-I- SimKernel.elaborateComponents started...");
        }
        if (this.design != null) {
            this.design.elaborate(null);
        } else {
            this.msg("-W- SimKernel.elaborateComponents: design is null !?");
        }
    }

    public void runForever() {
        if (this.debug) {
            this.msg("InteractiveSimKernel.runForever()...");
        }
        this.msg("-@- new simulatorState: " + this.getState());
        this.checkCreateSimulationThread();
        if (this.isStopped()) {
            this.msg("\n\n-E- internal: already STOPPED, cannot RUN again!");
        } else if (this.isSingleStep()) {
            this.simulatorState -= 8;
            this.simulatorState |= 1;
            this.runner.interrupt();
        } else if (this.isPaused()) {
            this.simulatorState -= 4;
            this.runner.interrupt();
        } else if (this.isRunning()) {
            this.msg("-W- ignored: simulation is already running!");
        } else if (this.simulatorState == 0) {
            this.initializeSimulator();
            this.elaborateComponents();
            this.simulatorState = 1;
        } else {
            this.msg("-E- internal: illegal simulatorState: " + this.getState());
        }
        this.endTime = Double.MAX_VALUE;
        this.updateControlPanel();
        this.msg("-@- new simulatorState: " + this.getState());
    }

    public void runFor(double delta_t) {
        if (this.debug) {
            this.msg("-I- SimKernel.runFor(" + delta_t + ")...");
        }
        double endTime = this.getSimTime() + delta_t;
        if (this.debug) {
            this.message("-I- Simulator: runFor()...");
        }
        if (this.debug) {
            this.message("    sim.time= " + this.simTime + " end time= " + endTime);
        }
        if (this.isStopped()) {
            this.msg("-E- internal: already STOPPED, cannot RUN again!");
        } else if (this.isSingleStep()) {
            this.simulatorState -= 8;
            this.simulatorState |= 1;
            this.scheduleInteractiveEvent(new SimulatorInterruptEvent(this, endTime, (Object)this));
            this.runner.interrupt();
        } else if (this.isPaused()) {
            this.scheduleInteractiveEvent(new SimulatorInterruptEvent(this, endTime, (Object)this));
            this.simulatorState -= 4;
            this.runner.interrupt();
        } else if (this.isRunning()) {
            this.msg("-W- setting new end time, while simulation already running!");
            this.scheduleInteractiveEvent(new SimulatorInterruptEvent(this, endTime, (Object)this));
            this.runner.interrupt();
        } else if (this.simulatorState == 0) {
            this.initializeSimulator();
            this.elaborateComponents();
            this.scheduleInteractiveEvent(new SimulatorInterruptEvent(this, endTime, (Object)this));
        }
        this.updateControlPanel();
    }

    public void checkCreateSimulationThread() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.setPriority(1);
            this.runner.setDaemon(true);
            this.runner.start();
        }
    }

    public void initializeSimulator() {
        super.initializeSimulator();
        this.n_iterations = 0;
        this.n_resync_iterations = this.delta_resync_iterations;
        this.t0 = System.currentTimeMillis();
        this.simTime = 0.0;
        this.lastSyncTime = this.realTime = 0.0;
        this.global_errors = 0;
    }

    public void evaluate(Object arg) {
        if (arg instanceof SimulatorInterruptEvent) {
            this.msg("-@- Got an 'SimulatorInterruptEvent!");
            this.pauseSimulation();
        } else {
            this.msg("-E- Don't know what to do with: " + arg);
        }
    }

    public void run() {
        this.eventList.first();
        while (this.simulatorState < 16 && this.global_errors < 10) {
            try {
                this.simulation();
            }
            catch (Throwable t) {
                if (t instanceof OutOfMemoryError) {
                    this.msg("-E- InteractiveSimKernel: out of memory!" + t);
                    ++this.global_errors;
                    System.gc();
                    this.printStatus();
                    return;
                }
                if (t instanceof ThreadDeath) {
                    this.printStatus();
                    throw (ThreadDeath)t;
                }
                this.msg("-E- InteractiveSimKernel: unexpected exception: " + t);
                this.printStatus();
                ExceptionTracer.trace(t);
                System.err.println("SimEvent is: " + this.eventList.getData());
            }
        }
        if (this.debug) {
            this.msg("-I- InteractiveSimKernel: leaving run()...");
        }
    }

    void simulation() {
        while (this.simulatorState < 16) {
            ++this.n_iterations;
            this.checkInteractiveEvents();
            this.checkResync();
            if (this.isRunning()) {
                this.collectEvents();
                this.executeAllPendingEvents();
                this.processPendingRepaints();
                continue;
            }
            this.sleep(1000L);
        }
    }

    void checkInteractiveEvents() {
        while (!this.commandQueue.isEmpty()) {
            Object o = this.commandQueue.fetch();
            if (o instanceof SimulatorCommand) {
                if (this.debug) {
                    this.msg("-I- executing interactive command: " + o);
                }
                ((SimulatorCommand)o).execute();
                continue;
            }
            this.msg("-E- don't know what to do with interactive command: " + o);
        }
    }

    public void scheduleInteractiveEvent(SimEvent se) {
        if (this.debug) {
            this.msg("-I- scheduleInteractiveEvent: " + se);
        }
        SimulatorScheduleCommand command = new SimulatorScheduleCommand(this, se);
        this.commandQueue.append(command);
    }

    public void deleteAllEventsFromSource(SimObject source) {
        this.commandQueue.append(new DeleteAllEventsFromSourceCommand(this, source));
    }

    public void singleStep() {
        this.msg("\n-#- singleStep: scheduling a SimulatorSingleStepCommand...");
        this.checkCreateSimulationThread();
        SimulatorSingleStepCommand command = new SimulatorSingleStepCommand(this);
        this.commandQueue.append(command);
        this.runner.interrupt();
    }

    public void pauseSimulation() {
        if (this.debug) {
            this.msg("-I- SimKernel.pauseSimulation:" + this.getState());
        }
        if (this.isPaused()) {
            this.msg("-W- Simulator is already in state PAUSE...");
        }
        this.simulatorState |= 4;
        this.updateControlPanel();
    }

    public void stopSimulation() {
        if (this.debug) {
            this.msg("-I- SimKernel.stopSimulation()..." + this.getState());
        }
        this.simulatorState |= 0x10;
        this.updateControlPanel();
    }

    public void updateControlPanel() {
        if (this.controlPanel != null) {
            this.controlPanel.updateVisual();
        }
        try {
            Thread.sleep(150L);
        }
        catch (Exception e) {}
    }

    void checkResync() {
        if (this.n_iterations > this.n_resync_iterations || this.realTime - this.lastSyncTime > 0.5) {
            this.resync();
        }
    }

    void collectEvents() {
        if (this.eventList.isEmpty()) {
            this.sleep(this.t_resync);
            this.simTime = this.realTime;
            return;
        }
        this.eventList.first();
        this.eventTime = this.eventList.getSimTime();
        if (this.eventTime > this.realTime) {
            this.sleep(this.t_resync);
            this.simTime = this.realTime;
            return;
        }
        double t_current = this.eventTime;
        double t_next = 0.0;
        this.simTime = this.eventTime;
        do {
            this.eventList.getData().evaluate();
            this.eventList.deleteFirst();
            ++this.n_processed;
            if (this.eventList.isEmpty()) break;
            this.eventList.first();
            t_next = this.eventList.getSimTime();
            if (!this.debug) continue;
            this.msg("$$$ t_next/t_current: " + t_next + " " + t_current);
        } while (t_next == t_current);
    }

    public void executeSingleStep() {
        if (this.eventList.isEmpty()) {
            this.msg("-W- single step: no event remaining.");
        } else {
            this.eventList.first();
            this.simTime = this.eventList.getSimTime();
            this.msg("-I- executing: " + this.eventList.getData().toShortString());
            this.eventList.getData().evaluate();
            this.eventList.deleteFirst();
            this.executeAllPendingEvents();
            if (!this.eventList.isEmpty()) {
                this.msg("-I- next event: " + this.eventList.getData().toShortString());
            }
        }
    }

    public void resync() {
        if (this.debug) {
            // empty if block
        }
        this.n_resync_iterations = this.n_iterations + this.delta_resync_iterations;
        this.lastSyncTime = this.realTime;
        this.t1 = System.currentTimeMillis();
        this.realTime = 0.001 * (double)(this.t1 - this.t0);
    }

    public void printStatus() {
        this.msg(" ");
        this.msg(this.toString() + " " + this.getState());
        this.msg("  time: simTime= " + TimeFormatter.format(this.simTime) + " realTime= " + TimeFormatter.format(this.realTime));
        this.msg("  events: scheduled=" + this.n_scheduled + " processed= " + this.n_processed + " iterations= " + this.n_iterations);
        this.msg("  pending= " + this.pendingArrayIndex + " /max= " + this.n_pending);
        this.msg("  recycling:  total= " + SimEvent.getNumberOfSimEvents() + " recycled= " + SimEvent.getNumberOfRecycledSimEvents() + " available= " + SimEvent.getNumberOfAvailableRecycledSimEvents());
        this.msg("  " + this.eventList.printStatus());
        this.msg("  memory: free= " + Runtime.getRuntime().freeMemory() + " total=" + Runtime.getRuntime().totalMemory());
    }

    public void sleep(long millis) {
        try {
            Thread.sleep(millis);
            this.realTime += 0.001 * (double)millis;
        }
        catch (InterruptedException e) {
            this.msg("-W- " + this.toString() + " interrupted: " + e);
            ExceptionTracer.trace(e);
        }
    }

    public String toString() {
        return "InteractiveSimKernel'" + this.name + "'";
    }

    public void msg(String s) {
        System.out.println(s);
    }
}

